import org.qg.tools.*

def call(body) {
    
    def config = [:]
    
    def env = body.env
    def workspace = "/home/quant_group/jenkins_home/workspace/${env.JOB_NAME}"
    
    def imageTag
    def _stage = new org.qg.tools.StageBucket()
    def _utils = new org.qg.tools.Utils()
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()
    
    def systemName = config.systemName
    def branchName = "master"
    def harborGroup = "tools"
    def buildNumber = env.BUILD_NUMBER
    def contextDir

    node {        
        try {
            ansiColor('xterm') {
                dir (systemName) {
                    timestamps {
                        stage('Init') {
                            _utils.beautyEcho("Init", "stage")
                        }
        
                        stage('Checkout') {
                            _utils.beautyEcho("Checkout", "stage")
                            switch (systemName) {
                                case "eos":
                                    _stage.checkout_eos(branchName)
                                    break
                                default:
                                    echo "Stage_Checkout: 未知的系统: ${systemName}"
                                    break
                            }
                        }
        
                        stage('Prepare') {
                            _utils.beautyEcho("Prepare", "stage")
                            contextDir = _utils.contextDir(workspace)
                            _stage.before_prepare(contextDir)
                            switch (systemName) {
                                case "eos":
                                    _stage.prepare_eos(contextDir)
                                    break
                                default:
                                    echo "Stage_Prepare: 未知的系统: ${systemName}"
                                    break
                            }
                        }
        
                        stage('Build') {
                            _utils.beautyEcho("Build", "stage")
                            switch (config.buildType) {
                                case "eos":
                                    _stage.build_eos(contextDir)
                                    break                                                
                                default:
                                    echo "Stage_Build: 未知的系统: ${systemName}"
                                    break
                            }
                        }

                        stage('Docker Build And Push') {
                            _utils.beautyEcho("Docker Build And Push", "stage")
                            if (config.buildType == "java") {
            		            _stage.copy_files_java(systemName)
            		        }
                            imageTag = _stage.dockerbuild_and_push(buildNumber, branchName, harborGroup, systemName, contextDir)
                        }

                        stage('Deploy To K8s Cluster') {
                            _utils.beautyEcho("Deploy To K8s Cluster", "stage")
                            def deploy_log = _stage.deploy(namespace, systemName, imageTag, config.tier, isDeploy)
                            _utils.beautyEcho(deploy_log, "info")
                        }
        
                        stage("Clean") {
                            _utils.beautyEcho("Clean", "stage")
                            _stage.clean_images(imageTag)
                        }
                    }
                }
            }   
        } catch (err) {
            ansiColor('xterm') {
                if (imageTag) {
                    _stage.clean_images(imageTag)
                }
                currentBuild.result = 'FAILED'
                _utils.beautyEcho(err, "fail")
                throw err
            }
        }
    }
}