// src/org/foo/Stage.groovy
package org.qg;

def prepare_java(systemName, contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles/templates/java; git pull; cd -"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/java ${contextDir}"
    
    sh "cd /home/quant_group/config_repository/java; git pull; cd -"
    sh "cp -rf /home/quant_group/config_repository/java/${systemName}.properties ${contextDir}/application.properties"
    sh "sed -i \"s/.xyqb.com/-${namespace}.q-gp.com/\" ${contextDir}/application.properties"
}

def prepare_nodejs(systemName, contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles/templates/nodejs; git pull; cd -"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/nodejs/${systemName} ${contextDir}"
}

def prepare_ui(contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles/templates/ui; git pull; cd -"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/ui ${contextDir}"
}

def prepare_python(contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles/templates/python; git pull; cd -"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/python ${contextDir}"
}

def checkout(branchName, gitRepo) {
    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: "git@gitabc.xyqb.com:${gitRepo}.git"
    sh "git pull origin master"
}

def build_java(namespace, systemName, contextDir) {
/*  sh "ansible-playbook /etc/ansible/build.yml -e prefix=${namespace} -e project_name=pre.${systemName} -e workspace=${contextDir} -vv"*/    
    sh '/usr/share/maven/bin/mvn clean package -P test -D maven.test.skip=true'
}

def copy_files_java(systemName, contextDir) {
	    switch (systemName) {
	        case "baitiao-zhitou":
	            jar_path = "xyqb-btzt-internal/target/*.jar"
	            break
	        case "baitiao":
	            jar_path = "baitiao-api/target/*.jar"
	            break
	        default:
	            jar_path = "target/*.jar"
	            break
	    } 
	    
	    sh "cp ${jar_path} ${contextDir}/"
}

def build_nodejs_and_ui(namespace, systemName, contextDir, repoName, branchName) {
    sh "ansible-playbook /etc/ansible/deploy.yml -e project_name=pre.${systemName} -e repo_name=${repoName} -e branch_name=${branchName} -vv"
    /*sh "ansible-playbook /etc/ansible/build.yml -e prefix=${namespace} -e project_name=pre.${systemName} -e workspace=${contextDir} -vv"*/
    
}

def build_python(namespace, systemName, contextDir) {
    sh "cp -rf ${contextDir}/config.ini server/config/release/config.ini"
    sh "cp -rf ${contextDir}/config.ini server/config/beta/config.ini"
    sh 'tar zcf dist.tgz server/'
    sh "mv dist.tgz ${contextDir}"
}

def dockerbuild_and_push(buildNumber, branchName, harborGroup, systemName, contextDir) {
    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
    safeBranchName = branchName.replaceAll(regex,"_")
    safeSystemName = "project"
    imageTag = "192.168.4.36/${harborGroup}/${systemName}:${safeBranchName}-${buildNumber}"

    withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
        withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
            def image = docker.build(imageTag, "--build-arg BUILD_NUMBER=${buildNumber} --build-arg SYSTEM_NAME=${safeSystemName} ${contextDir}")
            image.push()
        }
    }

    echo "=================镜像地址================="
    echo imageTag
    echo "========================================="
    
    return imageTag
}
    
def deploy(namespace, systemName, imageTag, tier, isDeploy) {
    if (isDeploy) {
        echo ("将镜像更新到到Namespace:" + namespace)
        build job: 'deployer.Updater', parameters: [
          string(name: 'namespace', value:"${namespace}"),
          string(name:'name', value: "${systemName}"),
          string(name:'image', value: "${imageTag}"),
          string(name:'tier', value: "${tier}")]
    }else{
        echo "namespace不存在，不执行deploy"
        echo namespace
    }
}

def clean(contextDir, imageTag) {
    sh "docker rmi -f \$(docker images -q ${imageTag})"
    sh "rm -rf ${contextDir}"
}




