// src/org/foo/Stage.groovy
package org.qg;

def _prepare_java(systemName, contextDir) {
    sh "rm -rf ./tmp-docker-build-context"
    sh "cp -r /home/quant_group/qg-dockerfiles/templates/java tmp-docker-build-context"
    sh "cp -r /home/quant_group/config_repository/java/${systemName}.properties ${contextDir}"
}

def _prepare_nodejs(contextDir) {
    sh "cp -r /home/quant_group/qg-dockerfiles/templates/nodejs ${contextDir}"
}

def _prepare_ui(contextDir) {
    sh "cp -r /home/quant_group/qg-dockerfiles/templates/ui ${contextDir}"
}

def _prepare_python(contextDir) {
    sh "cp -r /home/quant_group/qg-dockerfiles/templates/python ${contextDir}"
}

def checkout(branchName, gitRepo) {
    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: "git@gitabc.xyqb.com:${gitRepo}.git"
    sh "git pull origin master"
}

def build(namespace, systemName, contextDir, buildType) {
    switch (buildType) {
        case "java":
            _build_java(namespace, systemName, contextDir)
        case "ui" || "nodejs":
            _build_node(namespace, systemName, contextDir)
        case "python":
            _build_python(namespace, systemName, contextDir)
        default:
            break
    }
}

def _build_java(namespace, systemName, contextDir) {
    sh '/usr/share/maven/bin/mvn clean package -P test -D maven.test.skip=true'
    break
}

def _build_node_and_ui(namespace, systemName, contextDir) {
    sh "ansible-playbook /etc/ansible/build.yml -e prefix=${namespace} -e project_name=pre.${systemName} -e workspace=${contextDir} -vv"
    break
}

def _build_python(namespace, systemName, contextDir) {
    sh "mv ${contextDir}/config.ini config.ini"
    sh "cp -f config.ini server/config/release/config.ini"   
    sh "cp -f config.ini ${configPath}"
    sh 'tar zcf dist.tgz server/'
    break
}

def docker_build_and_push(buildNumber, branchName, harborGroup, systemName, contextDir) {
    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
    safeBranchName = branchName.replaceAll(regex,"_")
    safeSystemName = "project"
    imageTag = "192.168.4.36/${harborGroup}/${systemName}:${safeBranchName}-${buildNumber}"

    withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
        withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
            def image = docker.build(imageTag, "--build-arg BUILD_NUMBER=${buildNumber} --build-arg SYSTEM_NAME=${safeSystemName} ${contextDir}")
            image.push()
        }
    }

    echo "=================镜像地址================="
    echo imageTag
    echo "========================================="
    
    return imageTag
}

def deploy(namespace, systemName, imageTag, tier, isDeploy) {
    if (isDeploy) {
        echo ("将镜像更新到到Namespace:" + namespace)
        build job: 'deployer.Updater', parameters: [
          string(name: 'namespace', value:"${namespace}"),
          string(name:'name', value: "${systemName}"),
          string(name:'image', value: "${imageTag}"),
          string(name:'tier', value: "${tier}")]
    }else{
        echo "namespace不存在，不执行deploy"
        echo namespace
    }
}

def clean(contextDir) {
    sh "rm -rf ./${contextDir}"
}




