// src/org/foo/Stage.groovy
package org.qg.tools;
import org.qg.tools.Utils;
import groovy.json.JsonSlurperClassic;

def _utils(){
    def _utils = new org.qg.tools.Utils();
    return _utils
}

def before_prepare(contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cd /home/quant_group/qg-dockerfiles; git pull; cd -"
}

def prepare_eos(contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/tools/eos ${contextDir}"
}

def checkout_eos(branchName) {
    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: "git@git.quantgroup.cn:QA/eos.git"
}

def build_eos(contextDir) {
    sh "mv run.py ${contextDir}"
	sh "mv requirements.txt ${contextDir}"
    sh 'tar zcf dist.tgz app/'
    sh "mv dist.tgz ${contextDir}"
}

def dockerbuild_and_push(buildNumber, branchName, harborGroup, systemName, contextDir) {
    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
    safeBranchName = branchName.replaceAll(regex,"_")
    safeSystemName = "project"
    
    imageTag = "192.168.4.36/${harborGroup}/${systemName}:${safeBranchName}-${buildNumber}"
    
    withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
        withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
            def image = docker.build(imageTag, "--build-arg SYSTEM_NAME=${systemName} ${contextDir}")
            image.push()
        }
    }

    _utils().beautyEcho("镜像地址:${imageTag}", "info")
    return imageTag
}

def deploy(namespace, systemName, imageTag, tier) {
    def deploy_job_info    
    _utils().beautyEcho("[新集群][deploy]将镜像更新到到Namespace:" + namespace, "info")
	log = update_microservice(namespace, systemName, imageTag, tier)
	return log
}

def clean_images(imageTag) {
    sh "docker rmi -f \$(docker images -q ${imageTag})"
}

@NonCPS
def jsonParse(def json) {
    new groovy.json.JsonSlurperClassic().parseText(json)
}

def update_microservice(namespace, name, image, tier) {
	dest_url = "http://192.168.6.13/api/qahome/update_microservice"
	
    response = httpRequest httpMode:"PUT",
      consoleLogResponseBody:true,
      contentType:"APPLICATION_JSON", 
      requestBody:"""{
        "namespace":"${namespace}",
        "name":"${name}",
		"image":"${image}",
		"tier":"${tier}"
      }""",
      url:dest_url
	
    def res_json = jsonParse(response.content)
    return res_json
}

