
def call(body) {
    
    def config = [:]
    def env = body.env
    
    def repoName = env.repo_name
    t = repoName.split("/")
    def gitGroup = t[0]
    def projectName = t[1]
    
    def branchName = env.branch_name
    def room = env.room
    def hosts = env.hosts
    def action = env.action
    def rollbackToRelease = env.rollback_to_release
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        stage('Clean') {
            deleteDir()
        }
        
        stage('Build') {
            echo config.envType
            sh "ansible-playbook /etc/ansible/build.yml -e project_name=${config.envType}.${projectName} -e repo_name=${repoName} -e branch_name=${branchName} -vv"
        }

        stage('Deploy') {
            /*摘服务，看日志*/
            sh "ansible-playbook /etc/ansible/nginx_remove.yml -e project_name=${config.envType}.${projectName} -e room=${room} -e room_hosts=${hosts} -vv"
            
            
            env.RELEASE_ACTION = input message: '请选择下一步部署动作', ok: '确认',
                    parameters: [choice(name: 'RELEASE_SCOPE', choices: 'Deploy\nRollback', description: '请谨慎选择你要进行的操作')]
                    
            if (env.RELEASE_ACTION == "Deploy") {
                sh "ansible-playbook /etc/ansible/deploy.yml -e project_name=${config.envType}.${projectName}  -e room=${room} -e room_hosts=${hosts} -vv"
            }else{
                sh "ansible-playbook /etc/ansible/nginx_add.yml -e project_name=${config.envType}.${projectName} -e room=${room} -e room_hosts=${hosts} -vv"
            }
            
        }
    }
}