import org.qg.*

def call(body) {
    
    def config = [:]
    
    def env = body.env
    def branchName = env.BRANCH_NAME
    def gitRepo = env.GIT_REPO
    def namespace = env.NAMESPACE
    def isDeploy = env.IS_DEPLOY
    def buildNumber = env.BUILD_NUMBER

    t = gitRepo.split("/")
    def gitGroup = t[0]
    def systemName = t[1]

    def harborGroup = "library"
    def workspace = "/home/quant_group/jenkins_home/workspace/${env.JOB_NAME}"
    
    def imageTag
    def contextDir
    def _stage = new org.qg.StageBucket()
    def _utils = new org.qg.Utils()
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        try {
            stage('Clean') {
                echo "Stage[1] Clean"
                _stage.clean_dir()
            }
            
            stage('Checkout') {
                echo "Stage[2] Checkout"
                _stage.checkout(branchName, gitRepo)
            }
            
            stage('Prepare') {
                echo "Stage[3] prepare"
                echo "buildType is: ${config.buildType}"
                contextDir = _utils.contextDir(workspace)
                switch (config.buildType) {
                    case "java":
                        _stage.prepare_java(systemName, contextDir)
                        break
                    case "ui":
                        _stage.prepare_ui(systemName, contextDir)
                        break
                    case "nodejs":
                        _stage.prepare_nodejs(systemName, contextDir)
                        break
                    case "python":
                        _stage.prepare_python(contextDir)
                        break
                    default:
                        echo "未知的buildType: ${config.buildType}"
                        break
                }
            }
            
            stage('Build') {
                echo "Stage[4] Build"
                switch (config.buildType) {
                    case "java":
                        _stage.build_java(namespace, systemName, contextDir)
                        break
                    case "ui":
                        _stage.build_nodejs_and_ui(namespace, systemName, contextDir, gitRepo, branchName)
                        break                        
                    case  "nodejs":
                        _stage.build_nodejs_and_ui(namespace, systemName, contextDir, gitRepo, branchName)
                        break
                    case "python":
                        _stage.build_python(namespace, systemName, contextDir)
                        break
                    default:
                        echo "未知的buildType: ${config.buildType}"
                        break
                }
            }

            stage('Docker Build And Push') {
                echo "Stage[5] Docker Build And Push"
                if (config.buildType == "java") {
		            _stage.copy_files_java(systemName, contextDir)
		        }
                imageTag = _stage.dockerbuild_and_push(buildNumber, branchName, harborGroup, systemName, contextDir)
            }

            stage('Deploy') {
                _stage.deploy(namespace, systemName, imageTag, config.tier, isDeploy)
            }
            
            stage("Clean") {
                _stage.clean_images(imageTag)
            }
        } catch (err) {
            if (imageTag) {
                _stage.clean_images(imageTag)
            }
            currentBuild.result = 'FAILED'
            throw err
        }
    }
}