


def call(body) {
	
	
		def _stage = new org.qg.docker_new.StageBucket()
		def _utils = new org.qg.docker_new.Utils()
	   
    def config = [:]
    def timeStemp = new Date().format("yyyyMMddHHmmss")
		
    def env = body.env
    def branchName = env.BRANCH_NAME
    def gitRepo = env.GIT_REPO
    def namespace = env.NAMESPACE
    def isDeploy = env.IS_DEPLOY
    def buildNumber = env.BUILD_NUMBER
		def cluster = env.CLUSTER
    
		t = gitRepo.split("/")
    def gitGroup = t[0]
    def systemName = t[1].toLowerCase()
    	
		def contextDir
    def imageTag  
		
    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
		
    k8sSystemName = systemName.replaceAll("_","-")
    safeBranchName = branchName.replaceAll(regex,"_")
		
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {   
			  
			try { 
				echo config.buildType
				stage('prepare') {
					_utils.beautyEcho("Prepare", "stage")
					contextDir = _utils.contextMkdir("${systemName}-${timeStemp}")
					_stage.before_prepare()
				}
									
				pacegeDockerInfo = _stage.getDocketPackageImage(config.buildType)
				
				withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
					
					stage('checkout & build') {
						
						
						docker.image(pacegeDockerInfo["images"]).inside(pacegeDockerInfo["args"]){
							
							project_attr = _stage.project_attr(systemName)
							gitPath = project_attr["gitPath"]
				
							/*checkout code*/
							_utils.beautyEcho("checkout", "stage")
							_stage.checkout(git_path, branchName)
									
									
						  
							/*prepare config*/
							_utils.beautyEcho("prepare config", "stage")
							_stage.prepare_config(systemName, contextDir)
				
							/*build*/
							_utils.beautyEcho("build", "stage")
							buildCmd =  project_attr["buildCmd"]
							sh "${buildCmd}"
					
							/*copy files*/
						  _stage.copy_files(config.buildType,project_attr["jarFilePath"],contextDir)
						}
					}
										
					stage('make docker image') {
					
						imageTag = "192.168.4.36/${harborGroup}/${k8sSystemName}:${safeBranchName}-${timeStemp}"
					  withDockerRegistry([credentialsId: 'harbor-qajenkins', url: "http://192.168.4.36"]) {
						
							def build_schema = "BUILD_TIME: ${timeStemp} ,BUILD_NUMBER: ${buildNumber},SYSTEM_NAME: ${systemName},BRANCH_NAME: ${branchName}, CLUSTER: ${cluster}"
					
							def image = docker.build(imageTag, "--build-arg BUILD_SHCEMA=build_schema ${contextDir}")
			        image.push()
      
			        if (branchName == "master" || branchName == "master--master") {
		            image.push('latest')
			        }
          
				    }
								
					}	
							
				}
								 				
			}catch (err) {

				ansiColor('xterm') {
					currentBuild.result = 'FAILED'
					_utils.beautyEcho(err, "fail")
				}
				throw err
      }finally{				
				sh "rm -rf ${contextDir}"
				_stage.clean_images(imageTag)
			}
    }
}

