import org.qg.*

def call(body) {
    
    print body.env
    def config = [:]
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        branchName = env.BRANCH_NAME
        gitRepo = env.GIT_REPO
        namespace = env.NAMESPACE
        isDeploy = env.IS_DEPLOY
        buildNumber = env.BUILD_NUMBER
        
        try {
            stage ('Clone') {
                print branchName
            }
            stage ('Build') {
                sh "echo 'building ${config.projectName} ...'"
            }
            stage ('Tests') {
                parallel 'static': {
                    sh "echo 'shell scripts to run static tests...'"
                },
                'unit': {
                    sh "echo 'shell scripts to run unit tests...'"
                },
                'integration': {
                    sh "echo 'shell scripts to run integration tests...'"
                }
            }
            stage ('Deploy') {
                sh "echo 'deploying to server ${config.serverDomain}...'"
            }
        } catch (err) {
            currentBuild.result = 'FAILED'
            throw err
        }
    }
}