package org.qg.ci

import groovy.json.JsonOutput

def _utils() {
    return new org.qg.docker_new.Utils();
}

@NonCPS
def jsonParse(def json) {
    new groovy.json.JsonSlurperClassic().parseText(json)
}

def project_attr(systemName) {
    response = httpRequest "http://qaapi.liangkebang.com/proconfig/get_info?system_name=${systemName}"
    def res_json = jsonParse(response.content)
    return res_json["data"]
}

def sonar_job(branchHashCode) {
    response = httpRequest "http://qaapi.liangkebang.com/sonar/getSonarJob?branchHash=${branchHashCode}"
    def res_json = jsonParse(response.content)
    return res_json["data"]
}

def checkout(GIT_REPO, BRANCH_NAME) {
    body = [:]
    def projectAttr = project_attr(GIT_REPO)
    git_path = projectAttr["git_path"]
    git branch: "${BRANCH_NAME}", credentialsId: 'c6be40a7-235a-46db-89b8-61cfcbcbc1c4', url: "${git_path}"
    def branchHashCode = sh(script: 'git log -1 --pretty=%H', returnStdout: true).trim()
    echo "branchHashCode: ${branchHashCode} with 'git log -1 --pretty=%H'"
    body["branchHash"] = branchHashCode
    def gitUserMail = sh(script: 'git log -1 --pretty=%ae', returnStdout: true).trim()
    echo "gitUserMail: ${gitUserMail} with 'git log -1 --pretty=%ae'"
    body["gitUserMail"] = gitUserMail
    return body
}

def sonar_check(GIT_REPO, BRANCH_NAME, FORCE_SCAN, body) {
    def sonarJob = sonar_job(body["branchHash"])
    if (FORCE_SCAN != 'true' && sonarJob && sonarJob["sonarResult"]) {
        body["sonarJob"] = sonarJob
        echo "本次扫描的代码曾经扫描过，扫描结果:${sonarJob["sonarResult"]}"
    } else {
        _utils().beautyEcho("sonar scan +++", "info")
        sonarScanner = "/home/quant_group/jenkins_home/tools/hudson.plugins.sonar.SonarRunnerInstallation/sonar/bin/sonar-scanner"
        currentPath = sh(script: 'pwd', returnStdout: true).trim()
        sh "${sonarScanner} -e \
    -Dsonar.host.url=http://sonar.quantgroups.com   \
    -Dsonar.projectVersion=${BRANCH_NAME} \
    -Dsonar.projectKey=${GIT_REPO} \
    -Dsonar.java.binaries=. \
    -Dsonar.sources=. \
    -Dsonar.mybatis.skip=true \
    -Dsonar.java.source=1.8 \
    -Dsonar.java.target=1.8 \
    -Dsonar.projectBaseDir=${currentPath}"
        sleep 3
        sonarInfo = sh(script: 'cat .sonar/report-task.txt |awk \'{printf $0 "&"}\'', returnStdout: true).trim()
        items = sonarInfo.split("&")

        def content = [:]
        for (def item : items) {
            itemSplit = item.split("=", 2)
            content[itemSplit[0]] = itemSplit[1]
        }

        body["content"] = content
        body["duration"] = currentBuild.duration
    }
    return body
}

def call_back(body, callbackHost, dingRobotAddr, GIT_TRIGGER_USER, FORCE_SCAN) {
    body["dingRobotAddr"] = dingRobotAddr
    body["projectName"] = GIT_REPO
    body["branchName"] = BRANCH_NAME
    body["gitUser"] = GIT_TRIGGER_USER
    body["mail"] = FORCE_SCAN
    body["buildId"] = currentBuild.number
    body["buildJob"] = env.JOB_NAME
    body["absoluteUrl"] = currentBuild.absoluteUrl
    def bodyJson = JsonOutput.toJson(body)
    echo bodyJson

    response = httpRequest httpMode: "POST",
            consoleLogResponseBody: true,
            contentType: "APPLICATION_JSON",
            requestBody: "${bodyJson}",
            url: callbackHost
}
