import org.qg.*

def call(body) {
    
    def config = [:]
    
    def env = body.env
    def branchName = env.BRANCH_NAME
    def gitRepo = env.GIT_REPO
    def namespace = env.NAMESPACE
    def isDeploy = env.IS_DEPLOY
    def buildNumber = env.BUILD_NUMBER

    t = gitRepo.split("/")
    def gitGroup = t[0]
    def systemName = t[1]

    def harborGroup = "library"
    def workspace = "/home/quant_group/jenkins_home/workspace/${env.JOB_NAME}"
    
    def imageTag
    def contextDir
    def _stage = new org.qg.StageBucket()
    def _utils = new org.qg.Utils()
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        try {
            stage('Clean') {
                _utils.beautyEcho(1, 'Clean')
                _stage.clean_dir()
            }
            
            stage('Checkout') {
                _utils.beautyEcho(2, 'Checkout')
                _stage.checkout(branchName, gitRepo)
            }
            
            stage('Prepare') {
                _utils.beautyEcho(3, 'Prepare')
                contextDir = _utils.contextDir(workspace)
                switch (config.buildType) {
                    case "java":
                        _stage.prepare_java()
                        break
                    case "ui":
                        _stage.prepare_ui(systemName, contextDir)
                        break
                    case "nodejs":
                        _stage.prepare_nodejs(systemName, contextDir)
                        break
                    case "python":
                        _stage.prepare_python(contextDir)
                        break
                    default:
                        echo "未知的buildType: ${config.buildType}"
                        break
                }
            }
            
            stage('Build') {
                _utils.beautyEcho(4, 'Build')             
                switch (config.buildType) {
                    case "java":
                        _stage.build_java(namespace, systemName, contextDir)
                        break
                    case "ui":
                        _stage.build_ui(namespace, systemName, contextDir, gitRepo, branchName, workspace)
                        break                        
                    case  "nodejs":
                        _stage.build_nodejs(namespace, systemName, contextDir, gitRepo, branchName, workspace)
                        break
                    case "python":
                        _stage.build_python(namespace, systemName, contextDir)
                        break
                    default:
                        echo "未知的buildType: ${config.buildType}"
                        break
                }
            }

            stage('Docker Build And Push') {
                _utils.beautyEcho(5, 'Docker Build And Push')   
                if (config.buildType == "java") {
		            _stage.copy_files_java(systemName, contextDir)
		        }
                imageTag = _stage.dockerbuild_and_push(buildNumber, branchName, harborGroup, systemName, contextDir)
            }

            stage('Deploy') {
                _utils.beautyEcho(6, 'Docker Build And Push')  
                _stage.deploy(namespace, systemName, imageTag, config.tier, isDeploy)
            }
            
            stage("Clean") {
                _utils.beautyEcho(7, 'Clean')  
                _stage.clean_images(imageTag)
            }
        } catch (err) {
            if (imageTag) {
                _stage.clean_images(imageTag)
            }
            currentBuild.result = 'FAILED'
            throw err
        }
    }
}