// src/org/foo/Stage.groovy
package org.qg.docker_new;
import org.qg.docker_new.Utils;
import groovy.json.JsonSlurperClassic;

def _utils() { 
	return new org.qg.docker_new.Utils();
}

def debug() {
    _utils().beautyEcho("debug", "info")
}

def contextMkdir(key) {
    uuid = UUID.randomUUID().toString()
    contextDir = "/home/quant_group/package/${key}"
	sh "mkdir -p ${contextDir}"
    return contextDir
}

def imageTag(harborGroup,k8sSystemName,safeBranchName,tagName){
	
	def imageTag4_4=[:] 

	imageTag4_4["harborHost"]="http://192.168.4.4"
	imageTag4_4["imageTag"] = "192.168.4.4/${harborGroup}/${k8sSystemName}:${safeBranchName}-${tagName}"
	
	return [ imageTag4_4 ]
}

def init_dependency() {    
    sh "cd /home/quant_group/qg-dockerfiles; git pull; cd -"
    sh "cd /home/quant_group/config_repository; git pull origin master; cd -"
}

def init_image_dependency(buildType,originSystemName,contextDir){
	switch (buildType){
		case  "lua-ui":
			sh "cp -rf /home/quant_group/qg-dockerfiles/templates/lua-ui/* ${contextDir}"
			sh "cp -rf /home/quant_group/config_repository/lua-ui/lua/*.lua ${contextDir}"
			
		    def isVhFileExist = fileExists "/home/quant_group/config_repository/lua-ui/nginx/${originSystemName}.vh.conf"
		    if (isVhFileExist) {
		        sh "cp -rf /home/quant_group/config_repository/lua-ui/nginx/${originSystemName}.vh.conf ${contextDir}"
		    }else{
		        sh "cp -rf /home/quant_group/config_repository/lua-ui/nginx/default.vh.conf ${contextDir}"
		    }
			
			break
		default: 
			break
	
	}

}

def prepare_config(buildType,systemName, contextDir) {
	_utils().beautyEcho("Prepare Config +++ type:${buildType} systemName:${systemName}", "info")
	switch (buildType) {
		case "java":
			prepare_java(systemName, contextDir)
			break
		case "nodejs":
			prepare_nodejs(systemName, contextDir)
			break
		case "python":
			prepare_python(systemName, contextDir) 
			break
		case "lua-ui":
			prepare_luaui(systemName, contextDir)
			break
		default:
			_utils().beautyEcho("未知的buildType: ${buildType}","fail")
			break
	}
}

def prepare_java(systemName, contextDir) {
	sh "cp -rf /home/quant_group/qg-dockerfiles/templates/java/* ${contextDir}"
	
	def existProperties = fileExists "/home/quant_group/config_repository/java/${systemName}.properties"
	if(existProperties){
		sh "cp -rf /home/quant_group/config_repository/java/${systemName}.properties ${contextDir}/application.properties"
	} else {
		sh "touch ${contextDir}/application.properties"
	}
	
}

def prepare_nodejs(systemName, contextDir) {
	sh "cp -rf /home/quant_group/qg-dockerfiles/templates/nodejs/* ${contextDir}"
	sh "cp -rf /home/quant_group/config_repository/nodejs/${systemName}.js ${systemName}.env.config"	
	sh "cp -rf /home/quant_group/config_repository/lua-ui/npmrc/common-npmrc /root/.npmrc"
	
	
}

def prepare_luaui(systemName, contextDir) {	
	sh "cp -rf /home/quant_group/config_repository/lua-ui/config/${systemName}.js ${systemName}.env.config"	
	sh "cp -rf /home/quant_group/config_repository/lua-ui/npmrc/common-npmrc /root/.npmrc"
		
}

def prepare_python(systemName, contextDir) {
    sh "rm -rf ${contextDir}"
    sh "cp -rf /home/quant_group/qg-dockerfiles/templates/python ${contextDir}"
    sh "cp -rf /home/quant_group/config_repository/python/${systemName}.ini ${contextDir}/config.ini"
}

def checkout(buildType,systemName, branchName) {
	_utils().beautyEcho("CheckOut +++ type:${buildType} systemName:${systemName} branchName:${branchName}", "info")
	switch(buildType){
		case "java":
			checkout_java(systemName, branchName)
			break                  
		case  "nodejs":
			checkout_nodejs(systemName, branchName)
			break
		case "python":
			checkout_python(systemName, branchName)
			break
		case "lua-ui":
			checkout_luaui(systemName, branchName)
			break                                
		default:
			echo "未知的buildType: ${buildType}"
			break
	}
	
	def brahHashCode = sh (script: 'git log -1 --pretty=%H',returnStdout: true).trim()
	brahHashCode = brahHashCode.substring(0,16)
	echo "brahHashCode:${brahHashCode}   with 'git log -1 --pretty=%H'"
	return brahHashCode
	
}

def checkout_java(systemName, branchName) {
	def projectAttr = project_attr(systemName)
	def gitPath =projectAttr["gitPath"]
	def configPath = projectAttr["configPath"]
	git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
	
	if(systemName =="credit_league"){
		sh "cp -rf /home/quant_group/config_repository/java/${systemName}.properties ${configPath}/application.properties"
	}
}

def checkout_python(systemName, branchName) {
	def projectAttr = project_attr(systemName)
	def gitPath =projectAttr["gitPath"]
	git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
}

def checkout_nodejs(systemName, branchName) {
		
	def npmrcPath = "/home/quant_group/config_repository/lua-ui/npmrc/${systemName}-npmrc"
	def specialNpmrc = new File( npmrcPath )
	
	if(specialNpmrc.exists()){
			
		sh "cp -rf ${npmrcPath} .npmrc"	
	}
	
	
	
	def projectAttr = project_attr(systemName)
	def gitPath =projectAttr["gitPath"]
	
	currentPath = sh (script: 'pwd',returnStdout: true).trim()		
	def folder = new File( "${currentPath}/.git/hooks" )
    echo "${currentPath}/.git/hooks" 
	if( !folder.exists()){
		echo ">>>>>>>>> first git clone"
	    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
	    def bowerFile = fileExists './bower.json'
	    if (bowerFile) {
	        sh "bower install --allow-root"
	    }
	   
	} else {
		echo ">>>>>>>>>  not first git clone"
	    sh "cp -rf /home/quant_group/config_repository/lua-ui/hook/post-checkout .git/hooks/"
	    sh "chmod +x .git/hooks/post-checkout"
	    git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
		    
	}
	 sh "npm install"
    
}

def checkout_luaui(systemName, branchName) {
	currentPath = sh (script: 'pwd',returnStdout: true).trim()	
	echo "- ${currentPath} -"
	sh "whoami"
	echo "----------------------------"
	def npmrcPath = "/home/quant_group/config_repository/lua-ui/npmrc/${systemName}-npmrc"
	def specialNpmrc = new File( npmrcPath )
	if(specialNpmrc.exists()){
		sh "cp -rf ${npmrcPath} .npmrc"	
	}
	
	
   
	_utils().beautyEcho("ui project : ${systemName}"  , "info")
	projectAttr = project_attr(systemName)
	gitPath = projectAttr["gitPath"]
		
	//0 if project is simple ui not run npm install
	
	def hookfolder = new File( "${currentPath}/.git/hooks" )
	def packejson = new File( "${currentPath}/package.json" )
	
	if(!hookfolder.exists()){
		echo ">>>>>>> first checkout project ${systemName}"
		
		
		git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
		
		def bowerResult = ext_bower_install()
		def npmResult = ext_npm_intall()
		def resultNum = bowerResult +npmResult
		
		if(resultNum ==0){
			echo ">>>>>>> is simple ui project"
			sh "mkdir dist"
			return
		} else {
			echo ">>>>>>> is node ui project"
			def bowerFile = fileExists './bower.json'
			if (bowerFile) {
			    sh "bower install --allow-root"
			}
			
		}				
		
	}else{
		
		if(!packejson.exists()){
			echo ">>>>>>> is simple ui project"
			git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
			sh "mkdir dist"
			return
		} else{
			echo ">>>>>>> is node ui project"
			sh "cp -rf /home/quant_group/config_repository/lua-ui/hook/post-checkout .git/hooks/"
			sh "chmod +x .git/hooks/post-checkout"
			
			git branch: branchName, credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: gitPath
		}
			
	}
	sh "npm install" 
	
		   
}

def ext_bower_install(){
	def bowerFile = fileExists './bower.json'
	if(bowerFile){
		 sh "bower install --allow-root"
		 return 1
	}
	return 0
}
def ext_npm_intall(){
	def packageFile = fileExists './package.json'
	if(packageFile){
		 sh "npm install"
		 return 1
	}
	return 0
}

def build(buildType,systemName, branchName,contextDir){
	
	_utils().beautyEcho("Build +++ type:${buildType} systemName:${systemName}", "info")
	switch(buildType){
    case "java":
        build_java(systemName, branchName,contextDir)
        break                  
    case  "nodejs":
		sh "which node"
		sh "node -v"
		sh "npm -v"
        build_nodejs( systemName, branchName,contextDir)
        break
    case "python":
        build_python( systemName, branchName,contextDir)
        break
    case "lua-ui":
		sh "which node"
		sh "node -v"
		sh "npm -v"
        build_luaui( systemName, branchName,contextDir)
        break                                
    default:
        echo "未知的buildType: ${buildType}"
        break
		}
		
		
}

def build_java(systemName, branchName,contextDir) {
	def projectAttr = project_attr(systemName)
		
	buildCmd = projectAttr["buildCmd"]
	jarFilePath = projectAttr["jarFilePath"]

	sh buildCmd
	sh "mv ${jarFilePath}/*.jar ${contextDir}/app.jar"
}

def build_nodejs( systemName, branchName,contextDir) {    
    def projectAttr = project_attr(systemName)

    configPath = projectAttr["configPath"]
    buildCmd = projectAttr["buildCmd"]
    configName = systemName
        
    sh "mv -f ./${systemName}.env.config ${configPath}"
    sh "tar zcf ${contextDir}/dist.tgz ./* "

}

def build_python( systemName, branchName,contextDir) {
    sh "cp -rf ${contextDir}/config.ini server/config/release/config.ini"
    sh "cp -rf ${contextDir}/config.ini server/config/beta/config.ini"
    sh "tar zcf ${contextDir}/dist.tgz server/"
    
/*	    sh "mv dist.tgz ${contextDir}"*/

}

def build_luaui( systemName, branchName,contextDir) {   
	 
	def projectAttr = project_attr(systemName)
	configPath = projectAttr["configPath"]
	buildCmd = projectAttr["buildCmd"]
	configName = systemName
	
	currentPath = sh (script: 'pwd',returnStdout: true).trim()	
		
	
	if(systemName=='xjd-ui' && branchName == 'apollo'){
		sh "npm run build"
	} else {
		sh "mv -f ./${systemName}.env.config ${configPath}"
		sh buildCmd
	}	
	
	
	sh "tar zcf ${systemName}.tgz dist/"
	sh "mv ${systemName}.tgz ${contextDir}"
     
}

@NonCPS
def jsonParse(def json) {
    new groovy.json.JsonSlurperClassic().parseText(json)
}

def project_attr(systemName) {
    response = httpRequest "http://192.168.4.3:10088/config_server/get_project_attr/${systemName}"
    def res_json = jsonParse(response.content)
    return res_json
}

def update_microservice(namespace, name, image, tier) {
	dest_url = "http://eos.quantgroups.com/api/qahome/update_microservice"
	
    response = httpRequest httpMode:"PUT",
      consoleLogResponseBody:true,
      contentType:"APPLICATION_JSON", 
      requestBody:"""{
        "namespace":"${namespace}",
        "name":"${name}",
		"image":"${image}",
		"tier":"${tier}"
      }""",
      url:dest_url
	
    def res_json = jsonParse(response.content)
    return res_json
}

def set_image_info(microservice_name, git_commit_hash, image) {
	dest_url = "http://eos.quantgroups.com/api/etcd/set_image_info"
	
    response = httpRequest httpMode:"POST",
      consoleLogResponseBody:true,
      contentType:"APPLICATION_JSON", 
      requestBody:"""{
        "microservice_name":"${microservice_name}",
        "git_commit_hash":"${git_commit_hash}",
		"image": "${image}"
      }""",
      url:dest_url
	
    def res_json = jsonParse(response.content)
    return res_json
}


def slaveImageRespority(buildEnv){
	//envType java8 java9 node7 node8
	
	switch(buildEnv){
		case "java8":
			return "192.168.4.4/baseimg/jenkins-java-slave:latest"
			break
		case "java9":
			return null 
			break
		case "node7":
	    	return "192.168.4.4/baseimg/jenkins-node7-slave:latest"
			break
		case "node8":
			return "192.168.4.4/baseimg/jenkins-node8-slave:latest"
			break
		default :
			return "192.168.4.4/baseimg/jenkins-slave:latest"
		}
	
}

def slaveImageArgs(buildType){
	def args = ""
	args += "-v /home/quant_group/qg-dockerfiles:/home/quant_group/qg-dockerfiles "
	args += "-v /home/quant_group/config_repository:/home/quant_group/config_repository "
	args += "-v /home/quant_group/package/:/home/quant_group/package/ "
	switch (buildType) {
		case "java":
			args += "-v /root/.m2:/root/.m2 "			
			break
			
		case "nodejs":
			args += "-v /root/.nvm/versions/node/v8.9.1/bin:/usr/local/node-v8.9.1-linux-x64/bin "
			args += "-v /root/.npm:/root/.npm:rw "
			args += "-v /root/.cache:/root/.cache:rw "
			args += "-v /root/.node-gyp:/root/.node-gyp:rw "
			break			
		case "python":
			break
			
		case "lua-ui":
			args += "-v /root/.nvm/versions/node/v8.9.1/bin:/usr/local/node-v8.9.1-linux-x64/bin "
			args += "-v /root/.npm:/root/.npm:rw "
			args += "-v /root/.cache:/root/.cache:rw "
			args += "-v /root/.node-gyp:/root/.node-gyp:rw "			
			break
			
		default:			
			break
	}
	
	
	return args
	
}

def getDocketPackageImage(buildType,buildEnv){
	echo "getDocketPackageImage :${buildType}"

	def packageImageInfo=[:] 
	
	packageImageInfo["image"] = slaveImageRespority(buildEnv)
	packageImageInfo["args"] = slaveImageArgs(buildType)
	
	_utils().beautyEcho("image :"+ packageImageInfo["image"], "info")
	_utils().beautyEcho("args :"+ packageImageInfo["args"], "info")
	return packageImageInfo
}

def check_and_build(buildType,systemName,branchName,contextDir){
	
	def branchHashCode = null
	
	def buildEnv =""
	switch(buildType){
		case "java":
			buildEnv ="java8"
			break
		case "lua-ui":
		//"xjd-ui","paycenter-ui"
			buildEnv = "node8"
			if(systemName in ["xyqb-ui"]){
				buildEnv ="node7"
			}
			break
		case "nodejs":
			buildEnv = "node8"			
			break
		default :
			buildEnv ="java8"
	}
	
	def pacegeDockerInfo = getDocketPackageImage(buildType,buildEnv)
	
		
	if (buildType in ["nodejs","lua-ui"]){
		branchHashCode = cpb(buildType,systemName,branchName,contextDir)
		 
	} else {	
		docker.image(pacegeDockerInfo["image"]).inside(pacegeDockerInfo["args"]){
			branchHashCode = cpb(buildType,systemName,branchName,contextDir)
		}
	}
	
	return branchHashCode
}


def cpb(buildType,systemName,branchName,contextDir){
	/*checkout code*/
	
	stage('Checkout') {
		branchHashCode = checkout(buildType, systemName, branchName)
	}
	/*prepare config*/
	stage('Prepare') {
		if(systemName=='xjd-ui' && branchName == 'apollo'){
			_utils().beautyEcho("xjd-ui : apollo  not exec prepare_config", "info")
		} else{
			prepare_config(buildType, systemName, contextDir)
		}
		
	}
	/*build*/
	stage('Build'){
		build(buildType, systemName, branchName,contextDir)
	}
	
	return branchHashCode

}

def dockerbuild_and_push(imageTagInfo,buildNumber,systemName,branchName,cluster,timeStemp,contextDir,branchHashCode){
	//systemName == originSystemName
	def harbor_host = imageTagInfo["harborHost"]
	def imageTag = imageTagInfo["imageTag"]

	stage('Docker Build And Push') {
		withDockerRegistry([credentialsId: 'harbor-qajenkins', url: harbor_host]) {
			def build_schema = "BUILD_TIME:${timeStemp}@BUILD_NUMBER:${buildNumber}@SYSTEM_NAME:${systemName}@BRANCH_NAME:${branchName}@CLUSTER:${cluster}"
			echo build_schema
			def args = ""
			args += "--build-arg BUILD_TIME=${timeStemp} "
			args += "--build-arg BUILD_NUMBER=${buildNumber} "
			args += "--build-arg SYSTEM_NAME=${systemName} "
			args += "--build-arg BRANCH_NAME=${branchName} "
			args += "--build-arg SAFE_SYSTEM_NAME=${systemName} "
			args += "--build-arg BUILD_SCHEMA=${build_schema} "
			def image = docker.build(imageTag, "${args} ${contextDir}")
		    image.push()

		    if (branchName == "master" || branchName == "master--master") {
		      image.push('latest')
		    }
		
			_utils().beautyEcho("镜像地址:${imageTag}", "info")
		}
	}
	/* 设置etcd镜像信息 */
	set_image_info(systemName, branchHashCode, imageTag)
}

def deploy(namespace, systemName, imageTag, tier, isDeploy) {
	stage('Deploy To K8s Cluster'){
	_utils().beautyEcho("Deploy To K8s Cluster image: ${imageTag} to:${namespace}", "info")	
	def deploy_job_info
    	
	    if (isDeploy=="true") {
		    _utils().beautyEcho("[新集群][deployV2]将镜像更新到到Namespace:" + namespace, "info")
			update_microservice(namespace, systemName, imageTag, tier)
		
	    }else{
		      _utils().beautyEcho( "isDeploy == false，不执行deploy","info")
	    }
	}
}


def clean_images(imageTag,contextDir) {
	sh "rm -rf ${contextDir}"
	if (imageTag){
		sh "docker rmi -f \$(docker images -q ${imageTag})"
		
	}
}

