package org.qg.ci;
import org.qg.docker_new.Utils;
import groovy.json.JsonOutput
import groovy.json.JsonSlurperClassic;

def _utils() { 
  return new org.qg.docker_new.Utils();
}

@NonCPS
def jsonParse(def json) {
  new groovy.json.JsonSlurperClassic().parseText(json)
}

def project_attr(systemName) {
  response = httpRequest "http://qaapi.liangkebang.com/proconfig/get_info?system_name=${systemName}"
  def res_json = jsonParse(response.content)
  return res_json["data"]
}

def sonar_job(branchHashCode) {
  response = httpRequest "http://qaapi.liangkebang.com/sonar/getSonarJob?branchHash=${branchHashCode}"
  def res_json = jsonParse(response.content)
  return res_json["data"]
}

def checkout(GIT_REPO,BRANCH_NAME){
  def projectAttr = project_attr(GIT_REPO)
  git_path = projectAttr["git_path"]
  git branch: "${BRANCH_NAME}", credentialsId: 'e1ccb1ac-1282-4fb4-b766-530ca1a2a2db', url: "${git_path}"
}

def sonar_check(GIT_REPO,BRANCH_NAME,FORCE_SCAN){
  body =[:]
  def branchHashCode = sh (script: 'git log -1 --pretty=%H',returnStdout: true).trim()
  echo "branchHashCode: ${branchHashCode} with 'git log -1 --pretty=%H'"
  def sonarJob = sonar_job(branchHashCode)
  if (FORCE_SCAN != 'true' && sonarJob && sonarJob["sonarResult"]) {
    body["sonarJob"] = sonarJob
    echo "本次扫描的代码曾经扫描过，扫描结果:${sonarJob["sonarResult"]}"
  } else {
    _utils().beautyEcho("sonar scan +++", "info")
    sonarScanner = "/home/quant_group/jenkins_home/tools/hudson.plugins.sonar.SonarRunnerInstallation/sonar/bin/sonar-scanner"
    currentPath = sh (script: 'pwd',returnStdout: true).trim()
    sh "${sonarScanner} -e \
    -Dsonar.host.url=http://sonar.quantgroups.com   \
    -Dsonar.projectVersion=${BRANCH_NAME} \
    -Dsonar.projectKey=${GIT_REPO} \
    -Dsonar.java.binaries=. \
    -Dsonar.sources=. \
    -Dsonar.java.source=1.8 \
    -Dsonar.java.target=1.8 \
    -Dsonar.projectBaseDir=${currentPath}"
    sleep 3
    sonarInfo = sh (script: 'cat .sonar/report-task.txt |awk \'{printf $0 "&"}\'',returnStdout: true).trim()
    items = sonarInfo.split("&")
    
    def content=[:]
    for (def item : items){
      itemSplit = item.split("=",2)
      content[itemSplit[0]] =itemSplit[1]
    }
    
    body["content"] = content
    body["branchHash"] = branchHashCode
    body["duration"] = currentBuild.duration
  }
  return body
}

def call_back(body,callbackHost,dingRobotAddr){
  body["dingRobotAddr"] = dingRobotAddr
  body["project"] = GIT_REPO
  body["branch"] = BRANCH_NAME
  body["buildId"] = currentBuild.number
  body["buildJob"] = env.JOB_NAME
  def bodyJson = JsonOutput.toJson(body)
  echo bodyJson

  response = httpRequest httpMode:"POST",
    consoleLogResponseBody:true,
    contentType:"APPLICATION_JSON", 
    requestBody:"${bodyJson}",
    url:callbackHost
}

def callback_error(error,callbackHost,dingRobotAddr) {
  body =[:]
  body["error"] = error.message
  body["absoluteUrl"] = currentBuild.absoluteUrl

  call_back(body,callbackHost,dingRobotAddr)
}
