// src/org/foo/Stage.groovy
package org.qg.docker_new;
import org.qg.docker_new.Utils;
import groovy.json.JsonOutput
import groovy.json.JsonSlurperClassic;

def _sonarStage() {
  return new org.qg.ci.SonarStageBucketTke();
}

def _utils() {
  return new org.qg.docker_new.Utils();
}

def debug() {
  _utils().beautyEcho("debug", "info")
}

def contextMkdir(key) {
  uuid = UUID.randomUUID().toString()
  contextDir = "/home/quant_group/package/${key}"
  sh "mkdir -p ${contextDir}"
  return contextDir
}

def imageTag(harborGroup,k8sSystemName,safeBranchName,tagName){
  def imageTag4_4=[:]
  imageTag4_4["harborHost"]="http://192.168.4.4"
  imageTag4_4["imageTag"] = "${harborGroup}/${k8sSystemName}:${safeBranchName}-${tagName}"
  imageTag4_4["imageTagNew"] = "ccr.ccs.tencentyun.com/qa-test/${k8sSystemName}:${safeBranchName}-${tagName}"
  return imageTag4_4
}

def init_dependency() {
  sh "cd /home/quant_group/qg-dockerfiles; git pull; cd -"
  sh "cd /home/quant_group/config_repository; git pull origin master; cd -"
}

def init_image_dependency(buildType,originSystemName,contextDir){
  switch (buildType){
    case  "lua-ui":
      sh "cp -rf /home/quant_group/qg-dockerfiles/tke/ui/* ${contextDir}"
      def isVhFileExist = fileExists "/home/quant_group/config_repository/lua-ui/nginx/${originSystemName}.vh.conf"
      if (isVhFileExist) {
        sh "cp -rf /home/quant_group/config_repository/lua-ui/nginx/${originSystemName}.vh.conf ${contextDir}"
      } else {
        sh "cp -rf /home/quant_group/config_repository/lua-ui/nginx/default.vh.conf ${contextDir}"
      }
      break
    default:
      break
  }
}

def ext_bower_install(){
  def bowerFile = fileExists './bower.json'
  if(bowerFile){
    sh "bower install --allow-root"
    return 1
  }
  return 0
}

def ext_npm_intall(){
  def packageFile = fileExists './package.json'
  if(packageFile){
    // sh "npm install"
    return 1
  }
  return 0
}

@NonCPS
def jsonParse(def json) {
  new groovy.json.JsonSlurperClassic().parseText(json)
}

def project_attr(systemName) {
  response = httpRequest "http://qaapi.liangkebang.com/proconfig/get_info?system_name=${systemName}"
  def res_json = jsonParse(response.content)
  return res_json["data"]
}

def sonar_job(branchHashCode) {
  response = httpRequest "http://qaapi.liangkebang.com/sonar/getSonarJob?branchHash=${branchHashCode}"
  def res_json = jsonParse(response.content)
  return res_json["data"]
}

def pipeline_job(branchHashCode) {
  response = httpRequest "http://qaapi.liangkebang.com/pipeline/getBuildInfoByHooks?buildId=${currentBuild.number}&buildJob=${env.JOB_NAME}"
  def res_json = jsonParse(response.content)
  return res_json["data"]
}

def update_microservice(namespace, name, image, tier, domain, cluster) {
  dest_url = "http://qaapi.liangkebang.com/k8s/service/modifyImage"

  response = httpRequest httpMode:"POST",
  consoleLogResponseBody:true,
  contentType:"APPLICATION_JSON",
  customHeaders: [[name:'cluster', value:"${cluster}"]],
  requestBody:"""{
    "namespace":"${namespace}",
    "serviceName":"${name}",
    "image":"${image}",
    "label":"${tier}",
    "type":"${tier}",
    "domain":"${domain}",
    "debug":0
    }""",
    url:dest_url

  def res_json = jsonParse(response.content)
  return res_json
}

// for test
def update_microservice_qke(namespace, name, image, tier, domain, cluster) {
  dest_url = "http://qaapi.liangkebang.com/k8s/service/modifyImage"

  response = httpRequest httpMode:"POST",
  consoleLogResponseBody:true,
  contentType:"APPLICATION_JSON",
  customHeaders: [[name:'cluster', value:"${cluster}"]],
  requestBody:"""{
    "namespace":"${namespace}",
    "serviceName":"${name}",
    "image":"${image}",
    "label":"${tier}",
    "type":"${tier}",
    "domain":"${domain}",
    "debug":0
    }""",
    url:dest_url

  def res_json = jsonParse(response.content)
  return res_json
}

def set_image_info(microservice_name, git_commit_hash, image) {
  dest_url = "http://eos.quantgroups.com/api/etcd/set_image_info"

  response = httpRequest httpMode:"POST",
  consoleLogResponseBody:true,
  contentType:"APPLICATION_JSON",
  requestBody:"""{
    "microservice_name":"${microservice_name}",
    "git_commit_hash":"${git_commit_hash}",
    "image": "${image}"
  }""",
  url:dest_url

  def res_json = jsonParse(response.content)
  return res_json
}

def slaveImageRespority(buildEnv){
  //envType java8 java9 node7 node8

  switch(buildEnv){
    case "java8":
      // return "192.168.4.4/baseimg/jenkins-java-slave:latest"
      return "192.168.4.4/baseimg/jenkins-java-slave-new:latest"
      break
    case "java9":
      return null
      break
    case "node7":
      return "192.168.4.4/baseimg/jenkins-node7-slave:latest"
      break
    case "node8":
      return "192.168.4.4/baseimg/jenkins-node8-slave:latest"
      break
    case "node12":
      return "ccr.ccs.tencentyun.com/qg-qa/node12:latest"
      break
    default :
      return "192.168.4.4/baseimg/jenkins-slave:latest"
  }
}

def slaveImageArgs(buildType){
  def args = ""
  args += "-v /home/quant_group/qg-dockerfiles:/home/quant_group/qg-dockerfiles "
  args += "-v /home/quant_group/config_repository:/home/quant_group/config_repository "
  args += "-v /home/quant_group/package/:/home/quant_group/package/ "
  switch (buildType) {
    case "java":
    args += "-v /root/.m2:/root/.m2 "
  break

  case "nodejs":
    args += "-v /root/.nvm/versions/node/v8.9.1/bin:/usr/local/node-v8.9.1-linux-x64/bin "
    args += "-v /root/.npm:/root/.npm:rw "
    args += "-v /root/.cache:/root/.cache:rw "
    args += "-v /root/.node-gyp:/root/.node-gyp:rw "
    break
  case "python":
    break
  case "lua-ui":
    args += "-v /root/.nvm/versions/node/v8.9.1/bin:/usr/local/node-v8.9.1-linux-x64/bin "
    args += "-v /root/.npm:/root/.npm:rw "
    args += "-v /root/.cache:/root/.cache:rw "
    args += "-v /root/.node-gyp:/root/.node-gyp:rw "
  break

  default:
    break
  }

  return args
}

def getDocketPackageImage(buildType,buildEnv){
  echo "getDocketPackageImage :${buildType}"

  def packageImageInfo=[:]

  packageImageInfo["image"] = slaveImageRespority(buildEnv)
  packageImageInfo["args"] = slaveImageArgs(buildType)

  _utils().beautyEcho("image :"+ packageImageInfo["image"], "info")
  _utils().beautyEcho("args :"+ packageImageInfo["args"], "info")
  return packageImageInfo
}

def check_and_build(buildType,systemName,branchName,contextDir){
  def branchHashCode = null
  def buildEnv =""
  switch(buildType){
    case "java":
      buildEnv ="java8"
      break
    case "python":
      buildEnv ="python"
      break
    case "lua-ui":
      buildEnv = "node8"
      if(systemName in ["xyqb-ui"]){
        buildEnv ="node7"
      }
      break
    case "nodejs":
      buildEnv = "node8"
      break
    case "ui":
      buildEnv = "node12"
      break
    default :
      buildEnv ="java8"
  }

  def pacegeDockerInfo = getDocketPackageImage(buildType,buildEnv)
  if (buildType in ["nodejs","lua-ui"]){
    branchHashCode = cpb(buildType,systemName,branchName,contextDir)
  } else {
    docker.image(pacegeDockerInfo["image"]).inside(pacegeDockerInfo["args"]){
      branchHashCode = cpb(buildType,systemName,branchName,contextDir)
    }
  }
  return branchHashCode
}

def cpb(buildType,systemName,branchName,contextDir){
  /*checkout code*/
  stage('Checkout') {
    branchHashCode = checkout(buildType, systemName, branchName)
  }
  /*prepare config*/
  stage('Prepare') {
    if(systemName=='xjd-ui' && branchName == 'apollo'){
      _utils().beautyEcho("xjd-ui : apollo  not exec prepare_config", "info")
    } else{
       prepare_config(buildType, systemName, contextDir)
    }
  }

  /*build*/
  stage('Build'){
    build(buildType, systemName, branchName,contextDir)
  }
  return branchHashCode
}

def checkout(buildType,systemName, branchName) {
  _utils().beautyEcho("CheckOut +++ type:${buildType} systemName:${systemName} branchName:${branchName}", "info")
  switch(buildType){
    case "java":
      checkout_java(systemName, branchName)
      break
    case  "nodejs":
      checkout_nodejs(systemName, branchName)
      break
    case "python":
      checkout_python(systemName, branchName)
      break
    case "lua-ui":
      checkout_luaui(systemName, branchName)
      break
    case "ui":
      checkout_luaui(systemName, branchName)
      break
    default:
      echo "未知的buildType: ${buildType}"
      break
  }

  def branchHashCode = sh (script: 'git log -1 --pretty=%H',returnStdout: true).trim()
  echo "branchHashCode : ${branchHashCode} with 'git log -1 --pretty=%H'"
  return branchHashCode
}

def checkout_java(systemName, branchName) {
  def projectAttr = project_attr(systemName)
  def gitPath =projectAttr["git_path"]
  def configPath = projectAttr["config_path"]
  git branch: branchName, credentialsId: 'c6be40a7-235a-46db-89b8-61cfcbcbc1c4', url: gitPath
}

def checkout_python(systemName, branchName) {
  def projectAttr = project_attr(systemName)
  def gitPath =projectAttr["git_path"]
  git branch: branchName, credentialsId: 'c6be40a7-235a-46db-89b8-61cfcbcbc1c4', url: gitPath
}

def checkout_nodejs(systemName, branchName) {
  sh "cp -rf /home/quant_group/qg-dockerfiles/tke/ui/npmrc/common-npmrc /root/.npmrc"

  def projectAttr = project_attr(systemName)
  def gitPath =projectAttr["git_path"]

  currentPath = sh (script: 'pwd',returnStdout: true).trim()
  def folder = new File( "${currentPath}/.git/hooks" )
  echo "${currentPath}/.git/hooks"
  if( !folder.exists()){
    echo ">>>>>>>>> first git clone"
    git branch: branchName, credentialsId: 'c6be40a7-235a-46db-89b8-61cfcbcbc1c4', url: gitPath
    def bowerFile = fileExists './bower.json'
    if (bowerFile) {
     sh "bower install --allow-root"
    }

  } else {
    echo ">>>>>>>>>  not first git clone"
    // sh "cp -rf /home/quant_group/config_repository/lua-ui/hook/post-checkout .git/hooks/"
    // sh "chmod +x .git/hooks/post-checkout"
    git branch: branchName, credentialsId: 'c6be40a7-235a-46db-89b8-61cfcbcbc1c4', url: gitPath
  }
  // sh "npm install"
}

 def checkout_luaui(systemName, branchName) {
   currentPath = sh (script: 'pwd',returnStdout: true).trim()
   echo "- ${currentPath} -"
   sh "whoami"
  // def npmrcPath = "/home/quant_group/config_repository/lua-ui/npmrc/${systemName}-npmrc"
  // def specialNpmrc = new File( npmrcPath )
  // if(specialNpmrc.exists()){
  //  sh "cp -rf ${npmrcPath} .npmrc"
  // }

  _utils().beautyEcho("ui project : ${systemName}"  , "info")
  projectAttr = project_attr(systemName)
  gitPath = projectAttr["git_path"]

  //0 if project is simple ui not run npm install

  def hookfolder = new File( "${currentPath}/.git/hooks" )
  def packejson = new File( "${currentPath}/package.json" )

  sh "cp -rf /home/quant_group/qg-dockerfiles/tke/ui/npmrc/common-npmrc /root/.npmrc"

  if(!hookfolder.exists()){
    echo ">>>>>>> first checkout project ${systemName}"
    git branch: branchName, credentialsId: 'c6be40a7-235a-46db-89b8-61cfcbcbc1c4', url: gitPath

    def bowerResult = ext_bower_install()
    def npmResult = ext_npm_intall()
    def resultNum = bowerResult +npmResult

    if(resultNum ==0){
      echo ">>>>>>> is simple ui project"
      def dist = fileExists './dist'
      if(!dist){
        sh "mkdir dist"
      }
      return
      } else {
       echo ">>>>>>> is node ui project"
       def bowerFile = fileExists './bower.json'
       sh "npm install"
       if (bowerFile) {
         sh "bower install --allow-root"
       }
     }

     }else{
      if(!packejson.exists()){
       echo ">>>>>>> is simple ui project"
       git branch: branchName, credentialsId: 'c6be40a7-235a-46db-89b8-61cfcbcbc1c4', url: gitPath
       def dist = fileExists './dist'
       if(!dist){
        sh "mkdir dist"
      }
      return
      } else{
       echo ">>>>>>> is node ui project"
      // sh "cp -rf /home/quant_group/config_repository/lua-ui/hook/post-checkout .git/hooks/"
      // sh "chmod +x .git/hooks/post-checkout"

      git branch: branchName, credentialsId: 'c6be40a7-235a-46db-89b8-61cfcbcbc1c4', url: gitPath
      sh "npm install"
    }
  }
}

def prepare_config(buildType,systemName, contextDir) {
  _utils().beautyEcho("Prepare Config +++ type:${buildType} systemName:${systemName}", "info")
  switch (buildType) {
    case "java":
      prepare_java(systemName, contextDir)
      break
    case "nodejs":
      prepare_nodejs(systemName, contextDir)
      break
    case "python":
      prepare_python(systemName, contextDir)
      break
    case ["lua-ui", "ui"]:
      prepare_luaui(systemName, contextDir)
      break
    default:
      _utils().beautyEcho("未知的buildType: ${buildType}","fail")
      break
  }
}

def prepare_java(systemName, contextDir) {
  sh "cp -rf /home/quant_group/qg-dockerfiles/tke/java/* ${contextDir}"

  def existProperties = fileExists "/home/quant_group/config_repository/tke/java/${systemName}.properties"

  echo "------ java properties exist :$existProperties ------"
  if(existProperties){
    sh "cp -rf /home/quant_group/config_repository/tke/java/${systemName}.properties ${contextDir}/application.properties"
  } else {
    sh "cp -rf /home/quant_group/config_repository/tke/java/null.properties ${contextDir}/application.properties"
  }
}

def prepare_nodejs(systemName, contextDir) {
  sh "cp -rf /home/quant_group/qg-dockerfiles/tke/nodejs/* ${contextDir}"
  sh "cp -rf /home/quant_group/config_repository/tke/nodejs/${systemName}.js ${systemName}.env.config"
  sh "cp -rf /home/quant_group/qg-dockerfiles/tke/ui/npmrc/common-npmrc ${contextDir}/.npmrc"
  // sh "cp -rf /home/quant_group/qg-dockerfiles/tke/ui/npmrc/common-npmrc /root/.npmrc"
}

def prepare_luaui(systemName, contextDir) {
  sh "cp -rf /home/quant_group/qg-dockerfiles/tke/ui/* ${contextDir}"
  sh "cp -rf /home/quant_group/qg-dockerfiles/tke/ui/npmrc/common-npmrc /root/.npmrc"
}

def prepare_python(systemName, contextDir) {
    //  sh "rm -rf ${contextDir}"
  sh "cp -rf /home/quant_group/qg-dockerfiles/tke/python/* ${contextDir}"
  sh "cp -rf /home/quant_group/config_repository/python/${systemName}.ini ${contextDir}/config.ini"
}

def build(buildType,systemName, branchName,contextDir){
 sh 'echo $PATH'
  _utils().beautyEcho("Build +++ type:${buildType} systemName:${systemName}", "info")
  switch(buildType){
    case "java":
      build_java(systemName, branchName,contextDir)
      break
    case  "nodejs":
      sh "which node"
      sh "node -v"
      sh "npm -v"
      build_nodejs( systemName, branchName,contextDir)
      break
    case "python":
      build_python( systemName, branchName,contextDir)
      break
    case "lua-ui":
      sh "which node"
      sh "node -v"
      sh "npm -v"
      build_luaui( systemName, branchName,contextDir)
      break
    case "ui":
      sh "which node"
      sh "node -v"
      sh "npm -v"
      build_luaui( systemName, branchName,contextDir)
      break
    default:
      echo "未知的buildType: ${buildType}"
      break
  }
}

def build_java(systemName, branchName,contextDir) {
  def projectAttr = project_attr(systemName)

  buildCmd = projectAttr["build_command"]
  jarFilePath = projectAttr["jar_path"]

  sh "mkdir ${contextDir}/lib ${contextDir}/config;touch ${contextDir}/lib/lib.txt;touch ${contextDir}/config/config.txt"
  sh 'mvn -v'
  sh 'env'
  sh buildCmd
  // sh "mv ${jarFilePath}/*.jar ${contextDir}/app.jar"
  sh "ls ${jarFilePath}/ | grep '.jar' | grep -v '-javadoc' | grep -v '-sources' | xargs -I '{}' mv ${jarFilePath}/{}.jar ${contextDir}/app.jar"
 


  currentPath = sh (script: 'pwd',returnStdout: true).trim()
  def libfolder = new File( "${currentPath}/target/lib" )
  echo "${currentPath}/target/lib  is exist :  ${libfolder.exists()}"
  if (libfolder.exists()){
    sh "mv ${jarFilePath}/lib/* ${contextDir}/lib"
  }

  def configfolder = new File( "${currentPath}/target/config" )
  echo "${currentPath}/target/config  is exist :  ${configfolder.exists()}"
  if (configfolder.exists()){
    sh "mv ${jarFilePath}/config/* ${contextDir}/config"
  }
}

def build_nodejs( systemName, branchName,contextDir) {
  def projectAttr = project_attr(systemName)

  configPath = projectAttr["config_path"]
  buildCmd = projectAttr["build_command"]
  configName = systemName

  sh "mv -f ./${systemName}.env.config ${configPath}"
  if (buildCmd) {
    sh buildCmd
  }
  sh "tar zcf ${contextDir}/dist.tgz ./* "
  sh "cp -rf package.json ${contextDir}"

}

def build_python( systemName, branchName,contextDir) {
  // sh "cp -rf ${contextDir}/config.ini server/config/release/config.ini"
  // sh "cp -rf ${contextDir}/config.ini server/config/beta/config.ini"

  def projectAttr = project_attr(systemName)
  configPath = projectAttr["config_path"]
  sh "cp -rf ${contextDir}/config.ini ${configPath}"
  sh "tar zcf ${contextDir}/dist.tgz ./*"

  // sh "mv dist.tgz ${contextDir}"
}

def build_luaui( systemName, branchName,contextDir) {

  def projectAttr = project_attr(systemName)
  configPath = projectAttr["config_path"]
  buildCmd = projectAttr["build_command"]
  configName = systemName

  currentPath = sh (script: 'pwd',returnStdout: true).trim()

  if(systemName=='xjd-ui' && branchName == 'apollo'){
    sh "npm run build"
    } else {
    // sh "mv -f ./${systemName}.env.config ${configPath}"
    sh buildCmd
  }

  sh "tar zcf ${systemName}.tgz dist/"
  sh "mv ${systemName}.tgz ${contextDir}"
}


def dockerbuild_and_push(imageTagInfo,buildNumber,systemName,branchName,timeStemp,contextDir){
  def harbor_host = imageTagInfo["harborHost"]
  def imageTagNew = imageTagInfo["imageTagNew"]

  stage('Docker Build And Push') {
    withDockerRegistry([credentialsId: 'harbor-qajenkins', url: harbor_host]) {
      def build_schema = "BUILD_TIME:${timeStemp}@BUILD_NUMBER:${buildNumber}@SYSTEM_NAME:${systemName}@BRANCH_NAME:${branchName}"
      echo build_schema
      def args = ""
      args += "--build-arg BUILD_TIME=${timeStemp} "
      args += "--build-arg BUILD_NUMBER=${buildNumber} "
      args += "--build-arg SYSTEM_NAME=${systemName} "
      args += "--build-arg BRANCH_NAME=${branchName} "
      args += "--build-arg SAFE_SYSTEM_NAME=${systemName} "
      args += "--build-arg BUILD_SCHEMA=${build_schema} "

      def imageNew
      if(systemName=="smart-recruitment" || systemName=="smart-recruitment-spyder"){
        imageNew = docker.build(imageTagNew, "${args} -f ${contextDir}/smart.Dockerfile ${contextDir}")
      } else {
        imageNew = docker.build(imageTagNew, "${args} ${contextDir}")
      }
      imageNew.push()

      if (branchName == "master" || branchName == "master--master") {
        imageNew.push('latest')
      }

      _utils().beautyEcho("镜像地址:${imageTagNew}", "info")
    }
  }
}

def deploy(namespace, systemName, imageTag, tier, isDeploy, cluster) {
  stage('Deploy To K8s Cluster'){
    _utils().beautyEcho("Deploy To K8S Cluster image: ${imageTag} to:${namespace}", "info")

    if (isDeploy=="true") {
      def projectAttr = project_attr(systemName)
      def host = projectAttr["host_name"]
      def hostArray = host.split("\\.")
      imageTag = imageTag.replaceAll("ccr.ccs.tencentyun.com/","")
      _utils().beautyEcho("[新集群][deployV2]将镜像更新到到Namespace:" + namespace, "info")
      // update_microservice(namespace, systemName, imageTag, tier, hostArray[0], cluster)
      // for test
      if(cluster=='qke'){
        update_microservice_qke(namespace, systemName, imageTag, tier, hostArray[0], cluster)
      }else{
        update_microservice(namespace, systemName, imageTag, tier, hostArray[0], 'qa')
      }
    } else {
      _utils().beautyEcho( "isDeploy == false，不执行deploy","info")
    }
  }
}

def ding_talk_error(pipesCallback,flag,dingRobotAddr,projectName,branchName,msg,sonarJob) {
  // 如果不是sonar exit
  if(msg != 'script returned exit code 111'){
    body =[:]
    body["flag"] = flag
    body["dingRobotAddr"] = dingRobotAddr
    body["projectName"] = projectName
    body["branchName"] = branchName
    body["msg"] = msg
    body["sonarJob"] = sonarJob

    send_req(body,pipesCallback)
  }
}

def ding_talk_suc(pipesCallback,flag,dingRobotAddr,projectName,image,cluster,tier) {
  image = image.replaceAll("ccr.ccs.tencentyun.com/","")
  def projectAttr = project_attr(projectName)
  def host = projectAttr["host_name"]
  def hostArray = host.split("\\.")

  body =[:]
  body["flag"] = flag
  body["dingRobotAddr"] = dingRobotAddr
  body["domain"] = hostArray[0]
  body["image"] = image
  body["cluster"] = cluster
  body["tier"] = tier

  send_req(body,pipesCallback)
}

def send_req(body,pipesCallback){
  body["buildId"] = currentBuild.number
  body["buildJob"] = env.JOB_NAME
  body["absoluteUrl"] = currentBuild.absoluteUrl
  bodyJson = JsonOutput.toJson(body)

  response = httpRequest httpMode:"POST",
  consoleLogResponseBody:true,
  contentType:"APPLICATION_JSON",
  // customHeaders: [[name:'cluster', value:"${cluster}"]],
  requestBody:"${bodyJson}",
  url:pipesCallback
}

def get_sonar_check(systemName,branchName,pipesCallback,sonarCallback,dingRobotAddr,branchHashCode) {
  def projectAttr = project_attr(systemName)
  if(projectAttr["sonar"]){
    if(projectAttr["type"] == 'java'){
      _utils().beautyEcho("sonar check +++", "info")
      def sonarJob
      def pipelineJob = pipeline_job()
      if(!pipelineJob){
        echo "手动触发的job"
        sonarJob = sonar_job(branchHashCode)
        if(!sonarJob || sonarJob["buildResult"] == 'error'){
          // 手动触发一次sonar
          def data=[:]
          data["branchHash"] = branchHashCode
          data = _sonarStage().sonar_check(systemName,branchName,'false',data)
          _sonarStage().call_back(data,sonarCallback,dingRobotAddr,'','noMail')
        }
      }

      // 等待200s，cash-loan-flow的sonar需要三分半
      for (int i=0; i<40; i++){
        sonarJob = sonar_job(branchHashCode)
        echo "sonarJob : ${sonarJob}"
        if(sonarJob && sonarJob["sonarResult"]){
          if (sonarJob["sonarResult"] != 'OK'){
            echo ">>>>>>> sonar check fail : ${sonarJob["sonarResult"]}"
            _utils().beautyEcho("没有通过Sonar质量阀，退出Jenkins build", "fail")
            ding_talk_error(pipesCallback,"notOK",dingRobotAddr,systemName,branchName,"没有通过Sonar质量阀，退出流水线",sonarJob)
            sh 'exit 111'
          } else {
            echo ">>>>>>> sonar check pass"
            break
          }
        }
        echo "等待sonar扫描执行结果，一般服务在1分钟内，个别大服务需要等待3分钟左右，比如cash-loan-flow、clotho等"
        sleep 5
      }
      if(!sonarJob["sonarResult"]){
        echo ">>>>>>> sonar check fail : ${sonarJob}"
        _utils().beautyEcho("获取sonar分析结果超时，退出Jenkins build", "fail")
        ding_talk_error(pipesCallback,"timeout",dingRobotAddr,systemName,branchName,"获取sonar分析结果超时，退出流水线",sonarJob)
        sh 'exit 111'
      }
    }
    if(projectAttr["type"] == 'node' || projectAttr["type"] == 'ui'){
      _utils().beautyEcho("lint check +++", "info")
      sh "npm install"
      sh "npm run lint"
    }
  }else{
    echo "不执行代码扫描"
  }
}

def clean_images(imageTag,contextDir) {
  sh "rm -rf ${contextDir}"
  if(imageTag){
    sh "docker rmi -f \$(docker images -q ${imageTag})"
  }
}
