


def call(body) {
	
	ansiColor('xterm') {
		
			def harborGroup = "library"
			def _stage = new org.qg.docker_new.StageBucket()
			def _utils = new org.qg.docker_new.Utils()
	   
	    def config = [:]
	    def timeStemp = new Date().format("yyyyMMddHHmmss")
		
	    def env = body.env
	    def branchName = env.BRANCH_NAME
	    def gitRepo = env.GIT_REPO
	    def namespace = env.NAMESPACE
	    def isDeploy = env.IS_DEPLOY
	    def buildNumber = env.BUILD_NUMBER
			def cluster = env.CLUSTER
    
			t = gitRepo.split("/")
	    def gitGroup = t[0]
	    def systemName = t[1].toLowerCase()
    	
			def contextDir
	    def imageTag  
		
	    regex = "[`,./;\\[\\]&<>?:\"()|-]+"
		
	    k8sSystemName = systemName.replaceAll("_","-")
	    safeBranchName = branchName.replaceAll(regex,"_")
		
	    body.resolveStrategy = Closure.DELEGATE_FIRST
	    body.delegate = config
	    body()

	    node {   
			  
				try { 
					echo config.buildType
					/*  1 */
					stage('Init') {
						_utils.beautyEcho("Init", "stage")
						contextDir = _stage.contextMkdir("${systemName}-${timeStemp}")
						_stage.before_prepare()
					}
									
					
				  /*  2 */
					withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
						_utils.beautyEcho("checkout & build", "stage")
						
					  
				    arrSystem = systemName.split("--")
				    for (systemNameSimple in arrSystem) {
							dir(systemNameSimple){
								_stage.check_and_build(config.buildType, systemNameSimple, branchName, contextDir)
							}
						}
						_utils.beautyEcho("build over", "info")	
						
						
					}
					
					/*  3 */
					withDockerServer([uri: "tcp://192.168.4.96:2375/"]) {
						_utils.beautyEcho("make docker image", "stage")		
						imageTag = _stage.imageTag(harborGroup,k8sSystemName,safeBranchName,timeStemp)	
						_stage.dockerbuild_and_push(imageTag,buildNumber,systemName,branchName,cluster,timeStemp)											
					
						_utils.beautyEcho("Deploy To K8s Cluster image: ${imageTag} to:${namespace}", "stage")											
						_stage.deploy(namespace, systemName, imageTag, config.tier, isDeploy)
																				
						
						
					}
					
					/*  4 */
					stage('Clean'){
						_utils.beautyEcho("Clear Cache Tmp", "stage")											
						_stage.clean_images(imageTag,contextDir)																		
					}
								 				
				} catch (err) {
					_utils.beautyEcho(err, "fail")
					_stage.clean_images(imageTag,contextDir)					
					throw err			
	      }
	    }
		}
}




