
def call(body) {
    
    def config = [:]
    def env = body.env
    
    def repo_name = env.repo_name
    def branch_name = env.branch_name
    def room = env.room
    def hosts = env.hosts
    def action = env.action
    def rollback_to_release = env.rollback_to_release
    
    body.resolveStrategy = Closure.DELEGATE_FIRST
    body.delegate = config
    body()

    node {
        try {
            stage('Clean') {
                deleteDir()
            }
            
            stage('Build') {
                echo repo_name
                echo branch_name
                echo room
                echo hosts
                echo action
                echo rollback_to_release
            }

            stage('Deploy') {
                echo "deploy"
            }
        } catch (err) {
            if (imageTag) {
                _stage.clean_images(imageTag)
            }
            currentBuild.result = 'FAILED'
            throw err
        }
    }
}