# -*- coding:utf-8 -*-
import time
from handler.Base_Handler import BaseHandler
from features import loanPost_Features
from utils import JsonUtil
from service.Sql_server import *
from features.Base_Features import BaseFeatures as BF



class loanPostFeatures(BaseHandler): #催收模型特征_v1 接口
    def post(self):

        try:
            if self._loanId == None:
                self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Params_Error,
                                               JsonUtil.Constants.Msg_Params_Error.format('loan_id',self._loanId)))
                self.flush()
                self.finish()
            else:
                df_user = get_sql_user_id(self._uuid)

                if df_user.empty == False:
                    self._user_id = int(df_user['user_id'].values[0])
                else :
                    self.write(JsonUtil.build_json_feature(businessType=int(self._business_type), orderId=self._orderId,
                                                           loanId=int(self._loanId),
                                                           userUuid = self._uuid,term_no = int(self._termNo),
                                                           massage = "没有找到对应的用户ID",
                                                           code=JsonUtil.Constants.Code_Error_Value))
                    self.flush()
                BF.set_private_var(codes = self._codes,
                                   business_type = self._business_type,
                                   uuid=self._uuid,
                                   user_id = self._user_id,
                                   loanId = self._loanId,
                                   orderId = self._orderId,
                                   apply_time = self._apply_time,
                                   termNo = self._termNo
)

                BF.get_subclasses('features.calc_loanPostFeatures',self.mapping.mapping_all)

                self.write(JsonUtil.build_json_feature(mssage="",
                                                       businessType=int(self._business_type),
                                                       orderId=self._orderId,
                                                       loanId=int(self._loanId),
                                                       userUuid = self._uuid,
                                                       user_id=self._user_id,
                                                       term_no = int(self._termNo),
                                                       features=BF._result,
                                                       flag=True,
                                                       code=JsonUtil.Constants.Code_Success))


                self.flush()
                self.finish()


        except Exception as e:
            # == 报异常，查询失败
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Error, JsonUtil.Constants.Msg_Error))
            self.flush()
        pass
