# -*- coding:utf-8 -*-
import time
from handler.Base_Handler import BaseHandler
from features import complex_order_Features
from utils import JsonUtil
from service.Sql_server import *

class ComplexOrder(BaseHandler): # 多订单的新特征接口
    def get(self):
        try:
            _business_type = self.get_argument('business_type', default=1)
            _uuid = self.get_argument('user_uuid', default=None)
            _orderId = self.get_argument('order_id', default=None)
            _loanId = self.get_argument('loan_id', default=None)
            df_user = get_sql_user_id(_uuid)
            if df_user.empty == False:
                self._user_id = int(df_user['user_id'].values[0])
            else :
                self.write(JsonUtil.build_json_feature(businessType=int(self._business_type), orderId=self._orderId,
                                                       loanId=int(self._loanId),
                                                       userUuid = self._uuid,term_no = int(self._termNo),
                                                       massage = "没有找到对应的用户ID",
                                                       code=JsonUtil.Constants.Code_Error_Value))
                self.flush()


            columns = {}
            for key,value in self.mapping.Mapping_Complex_order.items():
                columns[key] = value[1]

            _result = complex_order_Features.f_complexOrder(self._user_id, columns)
            _result = self.mapping._set_Mapping_rename(self.mapping.Mapping_Complex_order,_result)

            self.write(JsonUtil.build_json_feature(businessType=int(_business_type), orderId=_orderId,
                                                   loanId=_loanId,userUuid = _uuid,user_id=self._user_id,
                                                   features=_result, flag=True,code=JsonUtil.Constants.Code_Success))

            self.flush()
            self.finish()

        except ValueError as e:
            # == 数据类型或者字段缺少导致
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Param_Error, JsonUtil.Constants.Msg_Param_Error))
            self.flush()
        except Exception as e:
        # == 报异常，查询失败
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Error, JsonUtil.Constants.Msg_Error))
            self.flush()
        pass



# class ComplexOrder(BaseHandler):
#     def post(self):
#         self.df = get_sql_user_in_loan(self._user_id)
#
#     pass





