# -*- coding:utf-8 -*-
from _decimal import Decimal

import pendulum

from features.Base_Features import BaseFeatures as BF
from service.addresss_book_sql import *
import datetime
from service.Sql_vcc import *
import json
import time
from pandas import DataFrame
import datetime
from datetime import timedelta



class __INIT__(BF):
    def __init__(self):
        # time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d '),'%Y-%m-%d ')
        BF._apply_at = time_now
        """vcc申请交易的时间"""
        if self.orderId:
            _df = get_orderid_trade(self.orderId)
            if _df.empty == False:
                BF._apply_at = datetime.datetime.strptime((_df['trade_time'].astype(str).values[0]).split(' ')[0],'%Y-%m-%d')
        BF.get_time_credit_quta = time_credit_quta(self.uuid)
class 已占用额度():
    """vcc_user_credit_quota_info#used"""
    def feature(self):
        _已占用额度 = -9999999
        get_quota_usage = quota_usage(self.uuid,self._apply_at)
        if get_quota_usage.empty == False:
            quota_usage_trans_amount_now = get_quota_usage['transAmountNow'].values[0]
            _已占用额度 = quota_usage_trans_amount_now
        self._result['已占用额度']['value'] = _已占用额度
        return self._result


class 额度使用率():
    """vcc_user_credit_quota_info#usedRate"""
    def feature(self):
        _额度使用率 = -9999999
        get_quota_usage = quota_usage(self.uuid,self._apply_at)
        if get_quota_usage.empty == False:
            quota_usage_trans_amount_now = get_quota_usage['transAmountNow'].values[0]
            quota_usage_now_real_amount = get_quota_usage['nowRealAmount'].values[0]
            if quota_usage_now_real_amount ==0:
                _额度使用率 = -9999999
            else:
                result = Decimal(quota_usage_trans_amount_now / quota_usage_now_real_amount).quantize(Decimal("0.000000000"))
                _额度使用率 = get_round(float(result), 4)
        self._result['额度使用率']['value'] = _额度使用率
        return self._result

class vcc历史最大逾期天数():
    """max_over_due_days#count"""
    def feature(self):
        _vcc历史最大逾期天数 = -9999999
        get_quota_usage = historical_overdue(self.user_id,self._apply_at)
        if get_quota_usage.empty == False:
            get_quota_usage['paidOffDate'] = get_quota_usage['paidOffDate'].apply(lambda x: str(x).replace('/', '-'))
            get_quota_usage['planDate'] = get_quota_usage['planDate'].apply(lambda x: str(x).replace('/', '-'))
            loan_list = []
            for index, row in get_quota_usage.iterrows():
                if (row['paidOffDate'] == 'nan') or (row['paidOffDate'] > str(self._apply_at)):
                    result = (self._apply_at - datetime.datetime.strptime(row['planDate'], '%Y-%m-%d')).days
                    loan_list.append(result)
                else:
                    result = (datetime.datetime.strptime(row['paidOffDate'], '%Y-%m-%d') - datetime.datetime.strptime(row['planDate'], '%Y-%m-%d')).days
                    loan_list.append(result)
            if max(loan_list) < 0:
                _vcc历史最大逾期天数 = 0
            else:
                _vcc历史最大逾期天数 = max(loan_list)
        self._result['vcc历史最大逾期天数']['value'] = _vcc历史最大逾期天数
        return self._result

class 授信前七天交易额占初始额度比例():
    """vcc_trans_amount_info#transAmountRate7"""
    def feature(self):
        _授信前七天交易额占初始额度比例 = -9999999
        get_time_credit = self.get_time_credit_quta
        if get_time_credit.empty == False:
            get_time_credit_value = get_time_credit['apply_time'].values[0]
            str_time = pendulum.parse(str(get_time_credit_value)).to_datetime_string()
            str_time_zero = str_time.split(' ')[0]+ " 00:00:00"
            # str_time_zero = str_time
            cradit_days_7 = datetime.datetime.strptime(str_time_zero,'%Y-%m-%d %H:%M:%S') + timedelta(days =7)
            get_time_credit_info = time_credit_info(self.user_id,str_time_zero,cradit_days_7)
            if get_time_credit_info.empty == False:
                get_time_credit_info_value = get_time_credit_info['trans_amount'].sum()
                get_view_activation = view_activation(self.uuid,str_time_zero)['target_activated_amount'].values[0]
                if get_view_activation ==0:
                    _授信前七天交易额占初始额度比例 = -9999999
                else:
                    result = Decimal(get_time_credit_info_value/get_view_activation).quantize(Decimal("0.000000000"))

                    _授信前七天交易额占初始额度比例 = get_round(float(result), 4)
        self._result['授信前七天交易额占初始额度比例']['value'] = _授信前七天交易额占初始额度比例
        return self._result

class 授信前七天交易总金额():
    """vcc_trans_amount_info#transAmount7"""
    def feature(self):
        _授信前七天交易总金额 = -9999999
        get_time_credit = self.get_time_credit_quta
        if get_time_credit.empty == False:
            get_time_credit_value = get_time_credit['apply_time'].values[0]
            str_time = pendulum.parse(str(get_time_credit_value)).to_datetime_string()
            str_time_zero = str_time.split(' ')[0]+ " 00:00:00"
            cradit_days_7 = datetime.datetime.strptime(str_time_zero,'%Y-%m-%d %H:%M:%S') + timedelta(days =7)
            get_time_credit_info = time_credit_info(self.user_id,str_time_zero,cradit_days_7)
            if get_time_credit_info.empty == False:
                result = get_time_credit_info['trans_amount'].sum()
                _授信前七天交易总金额 = result
        self._result['授信前七天交易总金额']['value'] = _授信前七天交易总金额
        return self._result


class 授信前三天交易额占初始额度比例():
    """vcc_trans_amount_info#transAmountRate3"""
    def feature(self):
        _授信前三天交易额占初始额度比例 = -9999999
        get_time_credit = self.get_time_credit_quta
        if get_time_credit.empty == False:
            get_time_credit_value = get_time_credit['apply_time'].values[0]
            str_time = pendulum.parse(str(get_time_credit_value)).to_datetime_string()
            str_time_zero = str_time.split(' ')[0] + " 00:00:00"
            cradit_days_3 = datetime.datetime.strptime(str_time_zero,'%Y-%m-%d %H:%M:%S') + timedelta(days =3)
            get_time_credit_info = time_credit_info(self.user_id,str_time_zero,cradit_days_3)
            get_view_activation = view_activation(self.uuid,str_time_zero)
            if (get_view_activation.empty ==False) and (get_time_credit_info.empty==False):
                get_view_activation_value = get_view_activation['target_activated_amount'].values[0]
                get_time_credit_info_value = get_time_credit_info['trans_amount'].sum()
                if get_view_activation_value ==0:
                    _授信前三天交易额占初始额度比例 = -9999999
                else:
                    result = Decimal(get_time_credit_info_value / get_view_activation_value).quantize(Decimal("0.000000000"))
                    _授信前三天交易额占初始额度比例 = get_round(float(result), 4)
        self._result['授信前三天交易额占初始额度比例']['value'] = _授信前三天交易额占初始额度比例
        return self._result


class 授信当天交易总金额占初始额度比():
    """vcc_trans_amount_info#transAmountRate1"""
    def feature(self):
        _授信当天交易总金额占初始额度比 = -9999999
        get_time_credit = self.get_time_credit_quta
        if get_time_credit.empty == False:
            get_time_credit_value = get_time_credit['apply_time'].values[0]
            str_time = pendulum.parse(str(get_time_credit_value)).to_datetime_string()
            str_time_zero = str_time.split(' ')[0] + " 00:00:00"
            cradit_days_1 = datetime.datetime.strptime(str_time_zero,'%Y-%m-%d %H:%M:%S') + timedelta(days=1)
            get_time_credit_info = time_credit_info(self.user_id,str_time_zero,cradit_days_1)
            get_view_activation = view_activation(self.uuid,str_time_zero)
            if (get_view_activation.empty == False) and (get_time_credit_info.empty==False):
                get_time_credit_info_value = get_time_credit_info['trans_amount'].sum()
                get_view_activation_value = get_view_activation['target_activated_amount'].values[0]
                if get_view_activation_value ==0:
                    _授信当天交易总金额占初始额度比 = -9999999
                else:
                    result = Decimal(get_time_credit_info_value / get_view_activation_value).quantize(Decimal("0.000000000"))
                    _授信当天交易总金额占初始额度比 = get_round(float(result), 4)

        self._result['授信当天交易总金额占初始额度比']['value'] = _授信当天交易总金额占初始额度比
        return self._result


class 首次交易当天交易的金额():
    """first_trans_day_trans_amount#amount 需求确定一下记录是否为bug"""
    def feature(self):
        _首次交易当天交易的金额 = -9999999
        get_first_transaction_time = first_transaction(self.user_id,self._apply_at)
        if get_first_transaction_time.empty ==False:
            get_first_transaction_value =get_first_transaction_time['fristBusinessDate'].values[0]
            get_first_transaction_mount = first_transaction_mount(self.user_id,get_first_transaction_value)
        if get_first_transaction_mount.empty==False:
            result = get_first_transaction_mount['today_amount'].values[0]
            if result ==None:
                _首次交易当天交易的金额 = -9999999
            else:
                _首次交易当天交易的金额 = get_round(result, 2)
        self._result['首次交易当天交易的金额']['value'] = _首次交易当天交易的金额
        return self._result


class 近15天平均交易额():
    """avg_trans_amount#15days"""
    def feature(self):
        _近15天平均交易额 = -9999999
        start_time = self._apply_at - timedelta(days =15)
        get_trans_amount_info = trans_amount_info(self.user_id,start_time,self._apply_at)
        if get_trans_amount_info.empty==False:
            get_trans_amount_info_sum = get_trans_amount_info['trans_amount'].sum()
            result = Decimal(get_trans_amount_info_sum / len(get_trans_amount_info)).quantize(Decimal("0.000000000"))
            _近15天平均交易额 = get_round(float(result), 2)
        self._result['近15天平均交易额']['value'] = _近15天平均交易额
        return self._result


class 近一个月提前还款的金额():
    """prepayment#month"""
    def feature(self):
        _近一个月提前还款的金额 = -9999999
        start_time = self._apply_at - timedelta(days =30)
        get_one_month_amount = one_month_amount(self.user_id,start_time,self._apply_at)
        if get_one_month_amount.empty==False:
            result = get_one_month_amount['trans_amount'].sum()
            _近一个月提前还款的金额 = get_round(result, 2)
        self._result['近一个月提前还款的金额']['value'] = _近一个月提前还款的金额
        return self._result


class 近一个月分期交易笔数占所有交易笔数的比例():
    """term_trans_rate#month"""
    def feature(self):
        _近一个月分期交易笔数占所有交易笔数的比例 = -9999999
        start_time = self._apply_at - timedelta(days =30)
        get_one_month_term = one_month_term(self.user_id,start_time,self._apply_at)
        get_all_month_term = all_month_term(self.user_id)
        if get_one_month_term.empty==False:
            term_count = get_one_month_term[get_one_month_term['term']!=1]
            result = (len(term_count)/len(get_all_month_term))
            _近一个月分期交易笔数占所有交易笔数的比例 = get_round(result, 2)
        self._result['近一个月分期交易笔数占所有交易笔数的比例']['value'] = _近一个月分期交易笔数占所有交易笔数的比例
        return self._result


class 历史上100的整数倍的整笔交易总额占所有交易额度比例():
    """times100_trans_amount_info#rate"""
    def feature(self):
        _历史上100的整数倍的整笔交易总额占所有交易额度比例 = -9999999
        get_historical_trans_amount = historical_trans_amount(self.user_id,self._apply_at)
        if get_historical_trans_amount.empty==False:
            # get_historical_trans_amount['trans_amount'].apply(lambda x: tran_list.append(x) if x % 100 ==0 else 5)
            # term_count = get_one_month_term[['term']!=1]
            tran_list = [x for x in get_historical_trans_amount['trans_amount'] if x % 100 ==0]
            result = (sum(tran_list) / get_historical_trans_amount['trans_amount'].sum())
            _历史上100的整数倍的整笔交易总额占所有交易额度比例 = get_round(result, 2)
        self._result['历史上100的整数倍的整笔交易总额占所有交易额度比例']['value'] = _历史上100的整数倍的整笔交易总额占所有交易额度比例
        return self._result


class 历史上100的整数倍的整笔交易金额():
    """times100_trans_amount_info#amount"""
    def feature(self):
        _历史上100的整数倍的整笔交易金额 = -9999999
        get_historical_trans_amount = historical_trans_amount(self.user_id,self._apply_at)
        if get_historical_trans_amount.empty==False:
            tran_list = [x for x in get_historical_trans_amount['trans_amount'] if x % 100 ==0]
            result = sum(tran_list)
            _历史上100的整数倍的整笔交易金额 = get_round(result, 2)
        self._result['历史上100的整数倍的整笔交易金额']['value'] = _历史上100的整数倍的整笔交易金额
        return self._result


class 历史扣款失败的笔数():
    """deduct_failed_trans#count"""
    def feature(self):
        _历史扣款失败的笔数 = -9999999
        get_history_fail_count = history_fail_count(self.user_id,self._apply_at)
        if get_history_fail_count.empty==False:
            result = get_history_fail_count['count'].values[0]
            _历史扣款失败的笔数 = result
        self._result['历史扣款失败的笔数']['value'] = _历史扣款失败的笔数
        return self._result


class 近一月主动还款成功次数():
    """repayment_trans_info#count"""
    def feature(self):
        _近一月主动还款成功次数 = 0
        start_time = self._apply_at - timedelta(days =30)
        get_successful_active_month = successful_active_month(self.user_id,start_time,self._apply_at)
        if get_successful_active_month.empty==False:
            result = get_successful_active_month['count'].values[0]
            _近一月主动还款成功次数 = result
        self._result['近一月主动还款成功次数']['value'] = _近一月主动还款成功次数
        return self._result


class 近三天交易次数():
    """trans_count#3days 近三天交易次数"""
    def feature(self):
        _近三天交易次数 = 0
        start_time = self._apply_at - timedelta(days=3)
        get_near_loan_count = near_3loan_count(self.user_id,start_time,self._apply_at)
        if get_near_loan_count.empty==False:
            result = get_near_loan_count['count'].values[0]
            _近三天交易次数 = result
        self._result['近三天交易次数']['value'] = _近三天交易次数
        return self._result


class 近七天交易额的最大值():
    """max_trans_amount#7days 近七天交易额的最大值"""
    def feature(self):
        _近七天交易额的最大值 = -9999999
        start_time = self._apply_at - timedelta(days=7)
        get_near_7loan_count = near_7loan_count(self.user_id,start_time,self._apply_at)
        if get_near_7loan_count.empty==False:
            result = get_near_7loan_count['maxTransAmount'].values[0]
            if result ==None:
                _近七天交易额的最大值 = -9999999
            else:
                _近七天交易额的最大值 = result
        self._result['近七天交易额的最大值']['value'] = _近七天交易额的最大值
        return self._result


class vcc贷前审核模型分():
    """vcc_model_score#score   vcc贷前审核模型分"""
    def feature(self):
        _vcc贷前审核模型分 = -9999999
        get_feature_vcc_score = feature_vcc_score(self.uuid)
        if get_feature_vcc_score.empty==False:
            result = get_feature_vcc_score['score'].values[0]
            if result ==None:
                _vcc贷前审核模型分 = -9999999
            else:
                _vcc贷前审核模型分 = int(result)
        self._result['vcc贷前审核模型分']['value'] = _vcc贷前审核模型分
        return self._result