# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service.Sql_contactsOperator import *
import datetime
import json
import time
from service.Sql_contactsOperator import *
import datetime
import math
from service.Sql_contactsOperator import *
from features.Base_Features import BaseFeatures as BF

class __INIT__(BF):
    """紧急联系人运营商特征"""
    def __init__(self):
        # BF.apply_time = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF.apply_time = datetime.datetime.strptime('2019-09-19 14:00:00','%Y-%m-%d %H:%M:%S')
        if self.orderId :
            _df = getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF.apply_time = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')
        BF.user_phone = getSql_userPhone(str(tuple([self.user_id])).replace(',)',')'))['phone_no'].tolist()

        BF.df_userContactsAll = get_userContacts(str(tuple(self.user_phone)).replace(',)',')'))

        # BF.df_userOneContactsAll = pd.DataFrame() # 一度联系人
        BF.df_userTwoContacts = pd.DataFrame() # 二度联系人
        BF.receiverPhone = None

        #一度联系人
        BF.df_userOneContacts30 = pd.DataFrame()
        BF.df_userOneContacts90 = pd.DataFrame()
        BF.df_userOneContacts150 = pd.DataFrame()
        BF.df_userOneContacts180 = pd.DataFrame()
        BF.df_userOneContacts300 = pd.DataFrame()

        # 一度联系人注册用户
        BF.df_userOneContactsRegister180 = pd.DataFrame()
        BF.df_userOneContactsRegister300 = pd.DataFrame()

        # 一度联系人手机号列表
        BF.receiverPhone30 = None
        BF.receiverPhone90 = None
        BF.receiverPhone150 = None
        BF.receiverPhone180 = None
        BF.receiverPhone300 = None

        # 二度联系人
        BF.df_userTwoContacts30 = pd.DataFrame()
        BF.df_userTwoContacts90 = pd.DataFrame()
        BF.df_userTwoContacts150 = pd.DataFrame()
        BF.df_userTwoContacts180 = pd.DataFrame()
        BF.df_userTwoContacts300 = pd.DataFrame()

def get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(df_userContactsAll,
                                                   df_userOneContacts,
                                                   df_userOneContactsRegister,
                                                   df_userTwoContacts,
                                                   receiverPhone,
                                                   user_phone,apply_time,timesTampFDays = None,applyTimeFDays=None,ContactsNum = 2):
    """
        描述 : 近N天1度联系人在近N天内
        params: df_userContactsAll 所有联系人,在初始化文件中进行获取,
        df_userOneContacts 一度联系人 默认传入一个空的DataFrame,
        df_userTwoContacts 二度联系人 默认传入一个空的DataFrame,
        receiverPhone 一度联系人手机号,默认传入 None,
        apply_time 申请时间
        user_phone 当前用户手机号
        timesTampFDays 授权时间往前推多少天
        applyTimeFDays 申请时间往前推多少天
        ContactsNum 1 一度联系人,2 二度联系人
    """

    if df_userContactsAll.empty == False:
        if df_userOneContacts.columns.empty:
            df_userOneContacts = get_userContactsFilter(1,df_userContactsAll,apply_time,timesTampFDays = timesTampFDays,applyTimeFDays=applyTimeFDays,userPhone = user_phone)

            # 测试代码后期注释
            df_userOneContacts = df_userOneContacts.loc[(df_userOneContacts['timestamp'] >= datetime.datetime.strptime('2019-01-01 00:00:00','%Y-%m-%d %H:%M:%S'))
                                                        & (df_userOneContacts['timestamp'] < datetime.datetime.strptime('2019-06-28 00:00:00','%Y-%m-%d %H:%M:%S'))]

            if receiverPhone==None:
                receiverPhone_temp = get_PhoneNo(df_userOneContacts['receiverPhone'])
                if receiverPhone_temp:
                    receiverPhone = str(tuple(set(receiverPhone_temp))).replace(',)',')') if receiverPhone_temp else [] # 匹配手机号
                    df_userOneContactsRegister = getSql_phoneForUserId(receiverPhone) #获取一度联系人的在册用户
                    df_userOneContactsRegister.drop_duplicates(keep='first',inplace=True)
                    # 测试代码后期注释
                    df_userOneContactsRegister = df_userOneContactsRegister.loc[df_userOneContactsRegister['created_at'] < '2019-07-25 00:00:00']


        if ContactsNum == 2: # 获取二度联系人
            if df_userOneContactsRegister.empty == False:
                if df_userTwoContacts.columns.empty:
                    df_userTwoContacts = get_userContacts(str(tuple(df_userOneContactsRegister['phone_no'])).replace(',)',')')) # 获取二度联系人
                    # 测试代码后期注释
                    df_userTwoContacts.loc[(df_userTwoContacts['timestamp'] >= datetime.datetime.strptime('2019-01-01 00:00:00','%Y-%m-%d %H:%M:%S'))
                                           & (df_userTwoContacts['timestamp'] < datetime.datetime.strptime('2019-06-28 00:00:00','%Y-%m-%d %H:%M:%S'))]
    return df_userOneContacts,df_userOneContactsRegister,receiverPhone,df_userTwoContacts

class 获取一度联系人总数():
    """测试使用"""
    def feature(self):
        _获取一度联系人总数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,\
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                self.df_userOneContacts300,
                                                                                self.df_userOneContactsRegister300,
                                                                                self.df_userTwoContacts300,
                                                                                self.receiverPhone300,
                                                                                self.user_phone,
                                                                                self.apply_time,
                                                                                timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                )
        if self.df_userOneContacts300.empty == False:
            _获取一度联系人总数 = len(set(self.df_userOneContacts300['receiverPhone'].tolist()))
        self._result['获取一度联系人总数']['value'] = _获取一度联系人总数
        return self._result

class 获取一度联系人在册用户数():
    """测试使用"""
    def feature(self):
        _获取一度联系人在册用户数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300, \
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )
        if self.df_userOneContactsRegister300.empty == False:
            _获取一度联系人在册用户数 = len(set(self.df_userOneContactsRegister300['user_id']))
        self._result['获取一度联系人在册用户数']['value'] = _获取一度联系人在册用户数
        return self._result

class 获取一度联系人通话总次数():
    """测试使用"""
    def feature(self):
        _获取一度联系人通话总次数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300, \
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )
        if self.df_userOneContacts300.empty == False:
            _获取一度联系人通话总次数 = len(self.df_userOneContacts300)
        self._result['获取一度联系人通话总次数']['value'] = _获取一度联系人通话总次数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中命中QG黑名单的个数():
    """degree_one_contact_in_black_m5	近150天1度联系人在近300天内的2度联系人中命中QG黑名单的个数 """
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中命中QG黑名单的个数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )





        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            _df_qgblack = getSql_relation_in_qgblack(self.receiverPhone300.replace('"', ''),self.apply_time)
            _df_qgblack = _df_qgblack.drop_duplicates('phone',keep='first')
            _近150天1度联系人在近300天内的2度联系人中命中QG黑名单的个数 = _df_qgblack['phone'].count()

        self._result['近150天1度联系人在近300天内的2度联系人中命中QG黑名单的个数']['value'] = _近150天1度联系人在近300天内的2度联系人中命中QG黑名单的个数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有在逾的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanOverdueUserCount	近150天1度联系人在近300天内的2度联系人中在QG有在逾的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有在逾的人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300 :
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self.apply_time
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:
                            _df_loan['progress'] = 16
                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _df_loan = _df_loan.loc[(_df_loan['passdue_day']>0)]
                            _近150天1度联系人在近300天内的2度联系人中在QG有在逾的人数 = len(list(set(_df_loan['user_id'])))
        self._result['近150天1度联系人在近300天内的2度联系人中在QG有在逾的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有在逾的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过15天的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanGtD15Count	近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过15天的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过15天的人数 = -9999999

        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )

        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))

                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self.apply_time
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:

                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过15天的人数 = len(list(set(_df_loan.loc[(_df_loan['passdue_day']>15)]['user_id'])))
            else:
                _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过15天的人数 = 888888

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过15天的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过15天的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过30天的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanGtD30Count	近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过30天的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过30天的人数 = -9999999

        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300 :
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))

                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self.apply_time
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:

                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过30天的人数 = len(list(set(_df_loan.loc[(_df_loan['passdue_day']>30)]['user_id'])))
        self._result['近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过30天的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过30天的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过60天的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanGtD60Count	近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过60天的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过60天的人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if  df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                _df_loan['observationTime'] = self.apply_time
                _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                if _df_loan.empty == False:

                    _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                    _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                    _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                    _df_loan['passdue_day'] = 0

                    _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                    _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                    _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                    _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')
                    _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                    _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                    _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                    _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                    _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                    _loan_id = list(set(_loan_id))
                    if _loan_id:
                        _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                    else:_df_loan['progress'] = 16

                    _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                    if _df_loan.empty == False:
                        _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过60天的人数 = len(list(set(_df_loan.loc[(_df_loan['passdue_day']>60)]['user_id'])))

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过60天的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过60天的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过90天的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanGtD90Count	近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过90天的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过90天的人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))

                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self.apply_time
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:

                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过90天的人数 = len(list(set(_df_loan.loc[(_df_loan['passdue_day']>90)]['user_id'])))

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过90天的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有最大在逾天数超过90天的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG的最大在逾逾期天数之和():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanTotalOverdueDays	近150天1度联系人在近300天内的2度联系人中在QG的最大在逾逾期天数之和"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG的最大在逾逾期天数之和 = -9999999

        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self.apply_time
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:
                            _df_loan['progress'] = 16
                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _df_loan_g = _df_loan.groupby(['user_id']).agg({'passdue_day':'max'}).reset_index()
                            _近150天1度联系人在近300天内的2度联系人中在QG的最大在逾逾期天数之和 = _df_loan_g['passdue_day'].sum()
        self._result['近150天1度联系人在近300天内的2度联系人中在QG的最大在逾逾期天数之和']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG的最大在逾逾期天数之和
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有过注册的人数():
    """m5_contact_register#cnt	近150天1度联系人在近300天内的2度联系人中在QG有过注册的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有过注册的人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300 :
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                _近150天1度联系人在近300天内的2度联系人中在QG有过注册的人数 = 0
                df = df_user.loc[df_user['created_at'] <self.apply_time]
                _近150天1度联系人在近300天内的2度联系人中在QG有过注册的人数 = df['user_id'].count()

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有过注册的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有过注册的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的订单数():
    """m5_contact_apply_click#orderCnt	近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的订单数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的订单数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:

                _近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的订单数 = 0
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userQuotaRecord(str(tuple(user_id)).replace(',)',')'))

                if df_userApply.empty==False:
                    df_userApply = df_userApply.loc[df_userApply['created_at'] < self.apply_time]
                    if df_userApply.empty == False:
                        _近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的订单数 = df_userApply.loc[df_userApply['created_at'] < self._apply_at]['user_id'].count()
        self._result['近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的订单数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的订单数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的人数():
    """m5_contact_apply_click#userCnt	近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            _近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的人数 = 0
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userQuotaRecord(str(tuple(user_id)).replace(',)',')'))

                if df_userApply.empty == False:
                    df_userApply = df_userApply.loc[df_userApply['created_at'] < self.apply_time]
                    _近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的人数 = len(list(set(df_userApply['user_id'])))

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有过点击申请的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的订单数():
    """m5_contact_apply_submit#orderCnt	近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的订单数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的订单数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的订单数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userApplySubmit(str(tuple(user_id)).replace(',)',')'))
                if df_userApply.empty == False:
                    df_userApply = df_userApply.loc[df_userApply['submit_time'] < self.apply_time]
                    _近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的订单数 =df_userApply['user_id'].count()
        self._result['近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的订单数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的订单数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的人数():
    """m5_contact_apply_submit#userCnt	近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userApplySubmit(str(tuple(user_id)).replace(',)',')'))
                if df_userApply.empty == False:
                    df_userApply = df_userApply.loc[df_userApply['submit_time'] < self.apply_time]
                    _近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的人数 = len(list(set(df_userApply['user_id'])))

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有过提交申请的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG的首次提交申请人数():
    """m5_contact_apply_submit#firstCnt	近150天1度联系人在近300天内的2度联系人中在QG的首次提交申请人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG的首次提交申请人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300 :
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG的首次提交申请人数 =0
            if df_user.empty == False:

                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userApplySubmit(str(tuple(user_id)).replace(',)',')'))

                if df_userApply.empty == False:

                    df_userApply = df_userApply.loc[df_userApply['submit_time'] < self.apply_time]

                    if df_userApply.empty == False:
                        _count = 0
                        _json = json.loads(df_userApply['user_id'].value_counts().to_json())
                        for k,v in _json.items():
                            if v == 1:
                              _count += 1
                        _近150天1度联系人在近300天内的2度联系人中在QG的首次提交申请人数 = _count

        self._result['近150天1度联系人在近300天内的2度联系人中在QG的首次提交申请人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG的首次提交申请人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG的注册到首次提交申请的平均秒数():
    """m5_contact_first_submit_spent_avg    近150天1度联系人在近300天内的2度联系人中在QG的注册到首次提交申请的平均秒数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG的注册到首次提交申请的平均秒数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userApplySubmit(str(tuple(user_id)).replace(',)',')'))

                if df_userApply.empty == False:
                    df_userApply = df_userApply.loc[df_userApply['submit_time'] < self.apply_time]
                    if df_userApply.empty == False:
                        df_userApply_g = df_userApply.groupby(['user_id']).agg({'register_time':'min','submit_time':'min'}).reset_index()
                        df_mer = pd.merge(df_userApply_g,df_user,how='left',on=['user_id'])
                        df_mer['submit_time'] = df_mer['submit_time'].apply(lambda x : time.mktime(x.timetuple()))
                        df_mer['register_time'] = df_mer['register_time'].apply(lambda x : time.mktime(x.timetuple()))
                        df_mer['seconds'] = df_mer['submit_time'] - df_mer['register_time']
                        _近150天1度联系人在近300天内的2度联系人中在QG的注册到首次提交申请的平均秒数 = round(df_mer['seconds'].mean(),6)

        self._result['近150天1度联系人在近300天内的2度联系人中在QG的注册到首次提交申请的平均秒数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG的注册到首次提交申请的平均秒数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有通过的订单数(): #????
    """m5_contact_apply_result#permitOrderCnt	近150天1度联系人在近300天内的2度联系人中在QG有通过的订单数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有通过的订单数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            _近150天1度联系人在近300天内的2度联系人中在QG有通过的订单数 = 0
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply = getSql_userApplyQuota_QG(str(tuple(user_id)).replace(',)',')'))
                if df_apply.empty == False:
                    df_apply = df_apply.loc[(df_apply['created_at'] < self.apply_time) & (df_apply['apply_status']==2) ]
                    _近150天1度联系人在近300天内的2度联系人中在QG有通过的订单数 = df_apply['apply_status'].count()

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有通过的订单数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有通过的订单数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有通过的人数():
    """m5_contact_apply_result#permitUserCnt	近150天1度联系人在近300天内的2度联系人中在QG有通过的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有通过的人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            _近150天1度联系人在近300天内的2度联系人中在QG有通过的人数 = 0
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply = getSql_userApplyQuota_QG(str(tuple(user_id)).replace(',)',')'))
                if df_apply.empty == False:
                    df_apply = df_apply.loc[(df_apply['created_at'] < self.apply_time) & (df_apply['apply_status']==2)]
                    if df_apply.empty == False:
                        _近150天1度联系人在近300天内的2度联系人中在QG有通过的人数 =  len(list(set(df_apply['user_id'].tolist())))


        self._result['近150天1度联系人在近300天内的2度联系人中在QG有通过的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有通过的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有过被拒的人数():
    """m5_contact_apply_result#refuseUserCnt	近150天1度联系人在近300天内的2度联系人中在QG有过被拒的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有过被拒的人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG有过被拒的人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply = getSql_userApplyQuota_QG(str(tuple(user_id)).replace(',)',')'))
                if df_apply.empty == False:
                    df_apply = df_apply.loc[(df_apply['created_at'] < self.apply_time) & (df_apply['apply_status']==1)]
                    if df_apply.empty == False:
                        _近150天1度联系人在近300天内的2度联系人中在QG有过被拒的人数 = len(list(set(df_apply['user_id'])))

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有过被拒的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有过被拒的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有申请提现的订单数():
    """m5_contact_withdraw_apply#orderCnt	近150天1度联系人在近300天内的2度联系人中在QG有申请提现的订单数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有申请提现的订单数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG有申请提现的订单数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_loan = getSql_loan_detailQG(str(tuple(user_id)).replace(',)',')'))
                if df_loan.empty == False:
                    df_loan = df_loan.loc[(df_loan['created_at'] < self.apply_time )]
                    df_loan = df_loan.loc[(df_loan.duplicated('loan_id',keep='first')==False)]
                    _近150天1度联系人在近300天内的2度联系人中在QG有申请提现的订单数 = df_loan['loan_id'].count()

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有申请提现的订单数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有申请提现的订单数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG有申请提现的人数():
    """m5_contact_withdraw_apply#userCnt	近150天1度联系人在近300天内的2度联系人中在QG有申请提现的人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG有申请提现的人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG有申请提现的人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_loan = getSql_loan_detailQG(str(tuple(user_id)).replace(',)',')'))
                df_loan = df_loan.loc[(df_loan['created_at'] < self.apply_time)]

                if df_loan.empty ==False:
                    _近150天1度联系人在近300天内的2度联系人中在QG有申请提现的人数 = len(set(df_loan['user_id']))

        self._result['近150天1度联系人在近300天内的2度联系人中在QG有申请提现的人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG有申请提现的人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG的通过到申请提现的平均秒数():
    """m5_contact_loan_spent_avg	近150天1度联系人在近300天内的2度联系人中在QG的通过到申请提现的平均秒数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG的通过到申请提现的平均秒数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_ApplyAndloan(str(tuple(user_id)).replace(',)',')'))
                if df_apply_loan.empty == False:

                    df_apply_loan = df_apply_loan.loc[df_apply_loan['withdraw_apply_time'] < self.apply_time]
                    if df_apply_loan.empty == False:
                        df_apply_loan['withdraw_apply_time_new'] = df_apply_loan['withdraw_apply_time'].apply(lambda x : time.mktime(x.timetuple()))
                        df_apply_loan['permit_time_new'] = df_apply_loan['permit_time'].apply(lambda x : time.mktime(x.timetuple()))
                        df_apply_loan['seconds'] = (df_apply_loan['withdraw_apply_time_new'] - df_apply_loan['permit_time_new'])
                        _近150天1度联系人在近300天内的2度联系人中在QG的通过到申请提现的平均秒数 = round(df_apply_loan['seconds'].mean(),6)

        self._result['近150天1度联系人在近300天内的2度联系人中在QG的通过到申请提现的平均秒数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG的通过到申请提现的平均秒数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG的放款订单数():
    """m5_contact_loan_info#orderCnt	近150天1度联系人在近300天内的2度联系人中在QG的放款订单数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG的放款订单数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG的放款订单数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))
                df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self.apply_time]
                _近150天1度联系人在近300天内的2度联系人中在QG的放款订单数 = df_apply_loan['loan_application_history_id'].count()
        self._result['近150天1度联系人在近300天内的2度联系人中在QG的放款订单数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG的放款订单数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG的放款人数():
    """m5_contact_loan_info#userCnt	近150天1度联系人在近300天内的2度联系人中在QG的放款人数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG的放款人数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG的放款人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))
                if df_apply_loan.empty == False:
                    df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self.apply_time]
                    _近150天1度联系人在近300天内的2度联系人中在QG的放款人数 = len(list(set(df_apply_loan['user_id'])))

        self._result['近150天1度联系人在近300天内的2度联系人中在QG的放款人数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG的放款人数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG的总放款本金():
    """m5_contact_loan_info#amountSum	近150天1度联系人在近300天内的2度联系人中在QG的总放款本金"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG的总放款本金 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG的总放款本金 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))
                if df_apply_loan.empty == False:
                    df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self.apply_time]
                    _近150天1度联系人在近300天内的2度联系人中在QG的总放款本金 = int(df_apply_loan['contract_loan_amount'].sum())
        self._result['近150天1度联系人在近300天内的2度联系人中在QG的总放款本金']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG的总放款本金
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG的总放款分期数():
    """m5_contact_loan_info#termSum	近150天1度联系人在近300天内的2度联系人中在QG的总放款分期数"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG的总放款分期数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            _近150天1度联系人在近300天内的2度联系人中在QG的总放款分期数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))
                if df_apply_loan.empty == False:
                    df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self.apply_time]
                    _近150天1度联系人在近300天内的2度联系人中在QG的总放款分期数 = int(df_apply_loan['contract_term'].sum())

        self._result['近150天1度联系人在近300天内的2度联系人中在QG的总放款分期数']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG的总放款分期数
        return self._result

class 近150天1度联系人在近300天内的2度联系人中在QG的件均月利率():
    """m5_contact_loan_info#monthInterestAvg	近150天1度联系人在近300天内的2度联系人中在QG的件均月利率"""
    def feature(self):
        _近150天1度联系人在近300天内的2度联系人中在QG的件均月利率 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=2
                                                                                                          )


        if self.df_userTwoContacts300.empty == False and self.receiverPhone300:
            df_user = getSql_phoneForUserId(self.receiverPhone300.replace('"', ''))
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))

                if df_apply_loan.empty == False:
                    df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self.apply_time]
                    if df_apply_loan.empty == False:
                        _近150天1度联系人在近300天内的2度联系人中在QG的件均月利率 = round(df_apply_loan['monthly_interest_rate'].mean(),6)
        self._result['近150天1度联系人在近300天内的2度联系人中在QG的件均月利率']['value'] = _近150天1度联系人在近300天内的2度联系人中在QG的件均月利率
        return self._result