from features.Base_Features import BaseFeatures as BF
from service.Sql_server import *
from functools import reduce
import datetime
from dateutil.relativedelta import relativedelta

class __INIT__(BF):

    def __init__(self):
        BF.df_loan = get_sql_user_in_loan(self.user_id)
        BF.df_loan.sort_values('loan_id',inplace = True)
        pass
###多订单一期
class current_loan_order_nums():
    """当前在贷订单数"""
    def feature(self):
        df_loan = self.df_loan
        _current_loan_order_nums = -9999999
        if df_loan.empty == False:
            _current_loan_order_nums = len(df_loan.loc[df_loan.duplicated('loan_id',keep='first')== False])
        self._result["current_loan_order_nums"]['value'] = _current_loan_order_nums
        return self._result

class current_loan_term_nums():
    """当前在贷总期数"""
    def feature(self):
        df_loan = self.df_loan
        _current_loan_term_nums = -9999999
        if df_loan.empty == False:
            _current_loan_term_nums = df_loan.loc[df_loan['is_zaidai'] == 1]['is_zaidai'].count()
        self._result["current_loan_term_nums"]['value'] = int(_current_loan_term_nums)
        return self._result

class current_loan_max_term():
    """uncompleted_loan_max_term_nums  当前在贷最大期数"""
    def feature(self):
        df_loan = self.df_loan
        _current_loan_max_term = -9999999
        if df_loan.empty == False:
            _current_loan_max_term = df_loan.groupby('loan_id')[['is_zaidai']].agg(lambda x: reduce(lambda x,y: x+y,x)).reset_index()['is_zaidai'].max()
        self._result["current_loan_max_term"]['value'] = int(_current_loan_max_term)
        return self._result


class current_loan_max_duedays():
    """# 在贷订单的最大的逾期天数 : 已放款未到期订单中，最大的逾期天数，包括已还和未还"""
    def feature(self):
        _current_loan_max_duedays = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            _current_loan_max_duedays = df_loan['passdue_day'].max()
        self._result["current_loan_max_duedays"]['value'] = int(_current_loan_max_duedays)
        return self._result

class current_loan_max_duepp():
    """在贷订单的最大的逾期本金 : 已放款未到期订单中，最大的逾期本金，包括已还和未还"""
    def feature(self):
        _current_loan_max_duepp = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:

            if df_loan.loc[(df_loan['passdue_day'] > 0)].empty:
                _current_loan_max_duepp = 0
            else:
                _current_loan_max_duepp = df_loan.loc[(df_loan['passdue_day'] > 0)]['principal'].max(axis=0)
        self._result["current_loan_max_duepp"]['value'] = float(_current_loan_max_duepp)
        return self._result

class current_loan_avg_repay():
    """在贷平均每期还款金额 : 未到期的已放款的订单中,分子是 在贷期数的应还总额，分母是 在贷期数个数"""
    def feature(self):
        _current_loan_avg_repay = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            x,y = str(float(df_loan.loc[df_loan['repayment_status']!=3]['required_repayment'].sum()/df_loan.loc[df_loan['repayment_status']!=3]['term_no'].count())).split('.')
            _current_loan_avg_repay = float(x+'.'+y[:6])
        self._result["current_loan_avg_repay"]['value'] = _current_loan_avg_repay
        return self._result

class current_loan_max_repay():
    """在贷最大的应还金额 : 未到期的已放款订单中，每一期在贷期数的对应的应还金额中，取最大值"""
    def feature(self):
        _current_loan_max_repay = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
           _current_loan_max_repay = df_loan.loc[df_loan['repayment_status']!=3]['required_repayment'].max()
        self._result["current_loan_max_repay"]['value'] = _current_loan_max_repay
        return self._result


class current_loan_min_repay():
    """在贷最小的应还金额 : 未到期的已放款订单中，每一期在贷期数的对应的应还金额中，取最小值"""
    def feature(self):
        _current_loan_min_repay= -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            _current_loan_min_repay = df_loan.loc[df_loan['repayment_status']!=3]['required_repayment'].min()
        self._result["current_loan_min_repay"]['value'] = _current_loan_min_repay
        return self._result

class current_loan_sum_repay():
    """
        在贷应还总金额 : 未到期的已放款的订单中，剩余应还总金额
        current_uncompleted_term_repay_info#sumRepay	current_loan_sum_repay
    """
    def feature(self):
        _current_loan_sum_repay = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            _current_loan_sum_repay = float(df_loan.loc[df_loan['repayment_status']!=3]['required_repayment'].sum())
        self._result["current_loan_sum_repay"]['value'] = _current_loan_sum_repay
        return self._result


class current_loan_repay_rate():
    """应还金额在贷率 : 在贷订单的剩余期数的应还总额/在贷订单的总的期数的应还总额"""
    def feature(self):
        _current_loan_repay_rate = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            x,y = str(float(df_loan.loc[df_loan['repayment_status']!=3]['required_repayment'].sum()/df_loan['required_repayment'].sum())).split('.')
            _current_loan_repay_rate = float(x+'.'+y[:6])
        self._result["current_loan_repay_rate"]['value'] = _current_loan_repay_rate
        return self._result

class current_loan_avg_repaypp():
    """在贷平均每期还款本金 : 在贷应还总本金/在贷期数个数"""
    def feature(self):
        _current_loan_avg_repaypp= -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            principal = float(df_loan.loc[df_loan['repayment_status']!=3]['principal'].sum())
            userId_count = float(df_loan.loc[df_loan['repayment_status']!=3]['user_id'].count())
            if principal > 0 and userId_count>0:
                x,y = str(float(principal/userId_count)).split('.')
                _current_loan_avg_repaypp = float(x+'.'+y[:6])
            else:
                _current_loan_avg_repaypp = 0
        self._result["current_loan_avg_repaypp"]['value'] = _current_loan_avg_repaypp
        return self._result


class current_loan_max_repaypp():
    """在贷最大的应还本金 : 未到期的已放款订单中，每一期在贷期数的对应的应还本金中，取最大值"""
    def feature(self):
        _current_loan_max_repaypp = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            _current_loan_max_repaypp = float(df_loan.loc[df_loan['repayment_status']!=3]['principal'].max())
        self._result["current_loan_max_repaypp"]['value'] = _current_loan_max_repaypp
        return self._result


class current_loan_min_repaypp():
    """在贷最小的应还本金 : 未到期的已放款订单中，每一期在贷期数的对应的应还本金中，取最小值"""
    def feature(self):
        current_loan_min_repaypp = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            current_loan_min_repaypp = float(df_loan.loc[df_loan['repayment_status']!=3]['principal'].min())
        self._result["current_loan_min_repaypp"]['value'] = current_loan_min_repaypp
        return self._result

class current_loan_sum_repaypp():
    """在贷应还总本金 : 未到期的已放款的订单中，剩余应还总本金"""
    def feature(self):
        _current_loan_sum_repaypp = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            _current_loan_sum_repaypp = float(df_loan.loc[df_loan['repayment_status']!=3]['principal'].sum())
        self._result["current_loan_sum_repaypp"]['value'] = _current_loan_sum_repaypp
        return self._result

class current_loan_repaypp_rate():
    """应还本金在贷率 : 在贷订单的剩余期数的应还本金/在贷订单的总的期数的应还本金"""
    def feature(self):
        _current_loan_repaypp_rate= -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            x,y = str(float(df_loan.loc[df_loan['repayment_status']!=3]['principal'].sum()/df_loan['principal'].sum())).split('.')
            _current_loan_repaypp_rate = float(x+'.'+y[:6])
        self._result["current_loan_repaypp_rate"]['value'] = _current_loan_repaypp_rate
        return self._result

class days_from_lastdue():
    """最近一次逾期的距今的天数 : 已放款未到期订单中，最近一次逾期的距今的天数"""
    def feature(self):
        _days_from_lastdue = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            if df_loan.loc[df_loan['passdue_day'] > 0].empty:
                _days_from_lastdue = 0
            else:
                passdue_day_max = datetime.datetime.strptime(str(df_loan.loc[df_loan['passdue_day'] > 0]['deadline'].max()).split(' ')[0],"%Y-%m-%d")
                _days_from_lastdue = (datetime.datetime.now() - passdue_day_max).days
        self._result["days_from_lastdue"]['value'] =_days_from_lastdue
        return self._result

class days_from_lastrepaid():
    """最近一次的还款距今的天数 :  已放款未到期订单中，最近一次的还款时间"""
    def feature(self):
        _days_from_lastrepaid= -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            df_loan_status = df_loan.loc[(df_loan['repayment_status'] == 3)]
            if df_loan_status.empty ==False:
                record_last_day = datetime.datetime.strptime(str(df_loan_status['repaid_at'].max()).split(' ')[0],"%Y-%m-%d")
                _days_from_lastrepaid = int((datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d '),'%Y-%m-%d ') -record_last_day).days)
        self._result["days_from_lastrepaid"]['value'] = _days_from_lastrepaid
        return self._result

class current_loan_0duedays_rate():
    """在贷逾期0天以上的占比 : 已放款未到期的订单中，分子是到期期数的，逾期>0天的期数个数 分母是 到期期数的个数"""
    def feature(self):
        _current_loan_0duedays_rate = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            if (df_loan.loc[datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d') > pd.to_datetime(df_loan['deadline'],format='%Y-%m-%d')]['plan_id'].count() > 0)  &( df_loan.loc[df_loan['passdue_day'] > 0 ]['passdue_day'].count() > 0):
                x,y = str(float(df_loan.loc[df_loan['passdue_day'] > 0 ]['passdue_day'].count() / df_loan.loc[datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d') > pd.to_datetime(df_loan['deadline'],format='%Y-%m-%d')]['plan_id'].count())).split('.')
                _current_loan_0duedays_rate = float(x+'.'+y[:6])
            else : _current_loan_0duedays_rate = float(0)
        self._result["current_loan_0duedays_rate"]['value'] = _current_loan_0duedays_rate
        return self._result


class current_loan_5duedays_rate():
    """在贷逾期5天以上的占比 : 已放款未到期的订单中，分子是到期期数的，逾期>=5天的期数个数 分母是 到期期数的个数"""
    def feature(self):
        _current_loan_5duedays_rate = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            deadlineDay_cnt = int(df_loan.loc[datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d') > pd.to_datetime(df_loan['deadline'],format='%Y-%m-%d')]['plan_id'].count())
            passdueDay_cnt = int(df_loan.loc[df_loan['passdue_day'] > 5 ]['passdue_day'].count())
            if deadlineDay_cnt>0 and passdueDay_cnt > 0 :
                x,y = str(float(passdueDay_cnt/deadlineDay_cnt)).split('.')
                _current_loan_5duedays_rate = float(x+'.'+y[:6])
            else:
                _current_loan_5duedays_rate = 0
        self._result["current_loan_5duedays_rate"]['value'] = _current_loan_5duedays_rate
        return self._result

class current_loan_orderdue_nums():
    """在贷订单逾期订单数 : 已放款未到期的订单中，还款发生逾期的订单数"""
    def feature(self):
        _current_loan_orderdue_nums = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            _current_loan_orderdue_nums = len(list(set(df_loan.loc[df_loan['passdue_day'] > 0 ]['loan_id'].tolist())))
        self._result["current_loan_orderdue_nums"]['value'] = int(_current_loan_orderdue_nums)
        return self._result

class current_loan_orderdue_rate():
    """在贷订单逾期订单占比 : 分子是 在贷订单中发生逾期的订单数，分母是在贷订单数"""
    def feature(self):
        _current_loan_orderdue_rate = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            len_loan_passdue_day = len(list(set(df_loan.loc[df_loan['passdue_day']>0]['loan_id'].tolist())))
            len_loan = len(list(set(df_loan['loan_id'].tolist())))
            if len_loan > 0 and len_loan_passdue_day > 0 :
                x,y = str(float(len_loan_passdue_day/len_loan)).split('.')
                _current_loan_orderdue_rate = float(x+'.'+y[:6])
            else:
                _current_loan_orderdue_rate = 0
        self._result["current_loan_orderdue_rate"]['value'] = _current_loan_orderdue_rate
        return self._result


class current_loan_apply_cnt():
    """在贷申请次数 : 已放款未到期的订单中，距上一次成功放款后，到本次申请的申请次数,不包括本次申请"""
    def feature(self):
        _current_loan_apply_cnt = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            df_temp = df_loan.loc[(df_loan['loan_id'] == df_loan['loan_id'].max())
                             &(df_loan.duplicated('loan_id',keep='first') == False)]
            user_id = df_temp['user_id'].values[0]
            loan_created_at = df_temp['loan_created_at'].astype(str).values[0]
            df_apply_quota_record = get_sql_apply_quota_record(user_id,loan_created_at)
            _current_loan_apply_cnt = len(df_apply_quota_record)
        self._result["current_loan_apply_cnt"]['value'] = int(_current_loan_apply_cnt)
        return self._result

class current_loan_refuse_cnt():
    """在贷拒绝次数 : 已放款未到期的订单中，距上一次成功放款后，到本次申请被拒绝的申请次数，不包括本次申请"""
    def feature(self):
        _current_loan_refuse_cnt = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            df_temp = df_loan.loc[(df_loan['loan_id'] == df_loan['loan_id'].max())
                                  &(df_loan.duplicated('loan_id',keep='first') == False)]
            user_id = df_temp['user_id'].values[0]
            loan_created_at = df_temp['loan_created_at'].astype(str).values[0]
            df_apply_quota_record = get_sql_apply_quota_record(user_id,loan_created_at)
            current_loan_apply_cnt = len(df_apply_quota_record)
            if current_loan_apply_cnt > 0 :
                df_apply_quota_record_status = df_apply_quota_record.loc[df_apply_quota_record['apply_status'] == 2]
                if len(df_apply_quota_record_status)> 0:
                    _current_loan_refuse_cnt = df_apply_quota_record_status['uuid'].count()
            else:
                _current_loan_refuse_cnt = 0

        self._result["current_loan_refuse_cnt"]['value'] = int(_current_loan_refuse_cnt)
        return self._result

class current_loan_refuse_rate():
    """在贷拒绝率 : 分子是 在贷拒绝次数，分母是在贷申请次数"""
    def feature(self):
        _current_loan_refuse_rate = -9999999
        df_loan = self.df_loan
        if df_loan.empty == False:
            df_temp = df_loan.loc[(df_loan['loan_id'] == df_loan['loan_id'].max())
                                  &(df_loan.duplicated('loan_id',keep='first') == False)]
            user_id = df_temp['user_id'].values[0]
            loan_created_at = df_temp['loan_created_at'].astype(str).values[0]
            df_apply_quota_record = get_sql_apply_quota_record(user_id,loan_created_at)
            current_loan_apply_cnt = len(df_apply_quota_record)
            if current_loan_apply_cnt > 0 :
                if df_apply_quota_record.loc[df_apply_quota_record['apply_status'] == 2 ].empty ==True:
                    current_loan_refuse_cnt = 0
                else:
                    current_loan_refuse_cnt = df_apply_quota_record.loc[df_apply_quota_record['apply_status'] == 2 ]['uuid'].count()
            else:
                current_loan_refuse_cnt = 0
            if current_loan_apply_cnt > 0 & current_loan_refuse_cnt > 0:
                _current_loan_refuse_rate = current_loan_apply_cnt/current_loan_refuse_cnt
            else:
                _current_loan_refuse_rate = 0
        self._result["current_loan_refuse_rate"]['value'] = int(_current_loan_refuse_rate)
        return self._result









