# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service import Sql_contactsOperator
from service.Sql_complexOrder import *
import datetime,time
import pandas as pd
from datetime import timedelta

class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF.df_loan_all = getSql_loanAll_v5(str(tuple([self.user_id])).replace(',)',')'))
        BF._apply_at = time_now
        BF.df_apply_order = pd.DataFrame()
        BF.df_loan_rollBack = pd.DataFrame()
        BF.df_loan_rollBack_deadline_applytime = pd.DataFrame()
        BF.df_loan_rollBack_term = pd.DataFrame()

        BF._df_apply = Sql_contactsOperator.getSql_userApplyQuotaRecord(str(tuple([self.user_id])).replace(',)',')'))
        if BF._df_apply.empty == False:
            BF._df_apply.sort_values('apply_time',inplace=True)
            BF._df_apply.reset_index(drop=True,inplace=True)
            if self.orderId:
                BF.df_apply_order = BF._df_apply.loc[BF._df_apply['order_no'] == self.orderId]
                if BF.df_apply_order.empty == False:
                    BF._apply_at = datetime.datetime.strptime(BF.df_apply_order['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')

            """上几笔订单中最后还款期限 小于 申请时间的期数"""
            BF.df_loan_rollBack_deadline_applytime = BF.df_loan_all[BF.df_loan_all['deadline'] < BF._apply_at]
            if BF.df_loan_all.empty == False:
                BF.df_loan_all.sort_values('apply_time',inplace=True)
                BF.df_loan_all.reset_index(drop=True,inplace=True)
                BF.df_loan_rollBack = get_Loan_rollBack_v5(BF.df_loan_all,BF._apply_at,passdueDay_Negative=True)

            if BF.df_loan_rollBack_deadline_applytime.empty ==False:
                """进行历史数据状态的回溯 以及逾期天数"""
                BF.df_loan_rollBack_term = get_Loan_rollBack_v5(BF.df_loan_rollBack_deadline_applytime,BF._apply_at,passdueDay_Negative=True)


def get_loanSettleFrom(df_loan_rollBack):
    """上一笔（已结清）和（在逾再贷）款的订单"""
    df_loan_result = pd.DataFrame()
    if df_loan_rollBack.empty == False:
        # df_loan_rollBack = df_loan_rollBack[df_loan_rollBack["progress"] == 16]
        # if df_loan_rollBack.empty == False:
        df_loan_result = df_loan_rollBack[df_loan_rollBack['loan_id'] == df_loan_rollBack['loan_id'].max()]
    return df_loan_result



class 上一笔逾期天数小于0的期数个数():
    """lastest_loan_overdue_info#overduedaysLt0Cnt"""
    def feature(self):
        _上一笔逾期天数小于0的期数个数 = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack)
        if df_loan_result.empty == False:
            _df_loan_rollBack_less_zero =df_loan_result[df_loan_result['passdue_day'] < 0]['term_no'].count()
            _上一笔逾期天数小于0的期数个数 = _df_loan_rollBack_less_zero
        self._result["上一笔逾期天数小于0的期数个数"]["value"] = _上一笔逾期天数小于0的期数个数
        return self._result

class 上一笔逾期天数大于0的期数个数():
    """lastest_loan_overdue_info#overdueDaysGt0cnt"""
    def feature(self):
        _上一笔逾期天数大于0的期数个数 = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack)
        if df_loan_result.empty == False:
            _df_loan_rollBack_than_zero =df_loan_result[df_loan_result['passdue_day'] > 0]['term_no'].count()
            _上一笔逾期天数大于0的期数个数 = _df_loan_rollBack_than_zero
        self._result["上一笔逾期天数大于0的期数个数"]["value"] = _上一笔逾期天数大于0的期数个数
        return self._result



class 上一笔到期期数():
    """lastest_loan_overdue_info#overDeadlineTermCnt"""
    def feature(self):
        _上一笔到期期数 = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack)
        if df_loan_result.empty == False:
            df_loan_result['apply_at'] = self._apply_at
            df_loan_result['apply_at'] = df_loan_result['apply_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
            # _df_loan_rollBack_stop =df_loan_result[df_loan_result['deadline'] < self._apply_at]['term_no'].count()
            _df_loan_rollBack_stop = df_loan_result[df_loan_result['deadline'] <= df_loan_result['apply_at']]['term_no'].count()
            # _df_loan_rollBack_stop = df_loan_result[(df_loan_result['deadline_new'] < self._apply_at) | (df_loan_result['repaid_at_real'] < self._apply_at)]['term_no'].count()

            _上一笔到期期数 = _df_loan_rollBack_stop
        self._result["上一笔到期期数"]["value"] = _上一笔到期期数
        return self._result



class 上一笔未逾期已还期数():
    """lastest_loan_overdue_info#beforehandRepayCnt  需要确定一下"""
    def feature(self):
        _上一笔未逾期已还期数 = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack)
        if df_loan_result.empty == False:
            _df_loan_rollBack_over =df_loan_result[(df_loan_result['passdue_day'] <= 0) & (df_loan_result['repaid_at'] !='2000-01-01 00:00:00')]['term_no'].count()
            _上一笔未逾期已还期数 = _df_loan_rollBack_over
        self._result["上一笔未逾期已还期数"]["value"] = _上一笔未逾期已还期数
        return self._result


class 用户总共逾期天数在负三和一区间的次数():
    """用户总共-3<=passdue_day<=1的次数 user_repayment_plan_info#overDeadlineTermOverdue31Cnt"""
    def feature(self):
        _用户总共逾期天数在负三和一区间的次数 = 0
        df_loan_result = self.df_loan_rollBack_term
        if df_loan_result.empty == False:
            _df_loan_rollBack_Section = df_loan_result[(df_loan_result['passdue_day'] <= 1) & (-3 <= df_loan_result['passdue_day'] )]['term_no'].count()
            _用户总共逾期天数在负三和一区间的次数 = _df_loan_rollBack_Section
        self._result["用户总共逾期天数在负三和一区间的次数"]["value"] = _用户总共逾期天数在负三和一区间的次数
        return self._result

class 上一笔订单倒数第二期逾期天数():
    """lastest_over_deadline_loan_repay_info#secondLastTermOverdueDays"""
    def feature(self):
        _上一笔订单倒数第二期逾期天数 = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack_term)
        if len(df_loan_result) ==1:
            _上一笔订单倒数第二期逾期天数 = -9999999
        elif len(df_loan_result) >=2:
            df_loan_tail2 = df_loan_result.tail(2)['passdue_day'].values[0]
            _上一笔订单倒数第二期逾期天数 = df_loan_tail2
        self._result["上一笔订单倒数第二期逾期天数"]["value"] = _上一笔订单倒数第二期逾期天数
        return self._result


class 上一笔订单最近一期逾期天数():
    """lastest_over_deadline_loan_repay_info#firstLastTermOverdueDays"""
    def feature(self):
        _上一笔订单最近一期逾期天数 = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack_term)

        if df_loan_result.empty ==False:
            df_loan_tail2 = df_loan_result.tail(1)['passdue_day'].values[0]
            _上一笔订单最近一期逾期天数 = df_loan_tail2
        self._result["上一笔订单最近一期逾期天数"]["value"] = _上一笔订单最近一期逾期天数
        return self._result


class 上一笔订单passdue_day小于等于负一的次数():
    """lastest_over_deadline_loan_repay_info#overdueDaysLtNegative1"""
    def feature(self):
        _上一笔订单passdue_day小于等于负一的次数 = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack_term)

        if df_loan_result.empty ==False:
            df_loan_less1 = df_loan_result[df_loan_result['passdue_day'] <=-1]['term_no'].count()
            _上一笔订单passdue_day小于等于负一的次数 = df_loan_less1
        self._result["上一笔订单passdue_day小于等于负一的次数"]["value"] = _上一笔订单passdue_day小于等于负一的次数
        return self._result


class 用户总共被拒次数():
    """用户总共被拒次数 user_apply_record_info#applyRefusedCnt """
    def feature(self):
        _用户总共被拒次数 = -9999999
        v5_refuse_new = double_loan_v5_refuse_new(self.user_id,self._apply_at)
        v5_refuse_new = v5_refuse_new[v5_refuse_new['applyStatus'] ==1]
        v5_refuse_old = double_loan_v5_refuse_old(self.user_id,self._apply_at)
        v5_refuse_old = v5_refuse_old[v5_refuse_old['apply_status'] == 1]
        result = len(v5_refuse_new) + len(v5_refuse_old)
        _用户总共被拒次数 = result
        self._result["用户总共被拒次数"]["value"] = _用户总共被拒次数
        return self._result

class 近12个月被拒次数():
    """近12个月被拒次数 user_apply_record_info#latestYearApplyRefusedCnt """
    def feature(self):
        _近12个月被拒次数 = -9999999
        v5_refuse_new = double_loan_v5_refuse_new(self.user_id,self._apply_at)
        month_12_v5 = self._apply_at - timedelta(days=360)
        v5_refuse_new_time = pd.DataFrame()
        v5_refuse_old_time = pd.DataFrame()
        if v5_refuse_new.empty ==False:
            v5_refuse_new_time = v5_refuse_new[(v5_refuse_new['applyTime'] > month_12_v5) &(v5_refuse_new['applyStatus'] ==1)]
        v5_refuse_old = double_loan_v5_refuse_old(self.user_id,self._apply_at)
        if v5_refuse_old.empty == False:
            v5_refuse_old_time = v5_refuse_old[(v5_refuse_old['apply_time'] > month_12_v5) & (v5_refuse_old['apply_status'] == 1)]
        result = len(v5_refuse_new_time) + len(v5_refuse_old_time)
        _近12个月被拒次数 = result
        self._result["近12个月被拒次数"]["value"] = _近12个月被拒次数
        return self._result

class 最后一次还款时间距本次申请的间隔天数():
    """最后一次还款时间距本次申请的间隔天数 diff_apply_to_last_repay_days_v2 """
    def feature(self):
        _最后一次还款时间距本次申请的间隔天数 = -9999999
        df_loan_result = self.df_loan_all
        if df_loan_result.empty == False:
            """待确定"""
            df_loan_result = df_loan_result[self._apply_at >= df_loan_result["repaid_at_real"]]
            df_loan_result['repaid_at_real'] = df_loan_result['repaid_at_real'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
            df_loan_result['apply_at'] = self._apply_at
            df_loan_result['apply_at'] = df_loan_result['apply_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
            _df_loan_time_diff_value = (df_loan_result['apply_at'].max() - df_loan_result["repaid_at_real"].max()).days
            _最后一次还款时间距本次申请的间隔天数 = abs(_df_loan_time_diff_value)
        self._result["最后一次还款时间距本次申请的间隔天数"]["value"] = _最后一次还款时间距本次申请的间隔天数
        return self._result




class 历史还款期数个数():
    """历史还款期数个数 user_repayment_plan_info#completeRepayCnt """
    def feature(self):
        _历史还款期数个数 = -9999999
        all_df_apply = self.df_loan_rollBack
        if all_df_apply.empty == False:
            all_df_apply_count = all_df_apply[all_df_apply['repayment_status'] == 3]['term_no'].count()
            _历史还款期数个数 = all_df_apply_count
        self._result["历史还款期数个数"]["value"] = _历史还款期数个数
        return self._result



class 用户所有还款总和():
    """用户所有还款总和 repay_amt_sum_v2"""
    def feature(self):
        _用户所有还款总和 = -9999999
        all_df_apply = self.df_loan_rollBack
        if all_df_apply.empty == False:
            all_df_apply_count = all_df_apply[all_df_apply['repayment_status'] == 3]['current_repayment'].sum()
            _用户所有还款总和 = round(all_df_apply_count,2)
        self._result["用户所有还款总和"]["value"] = _用户所有还款总和
        return self._result



class 上一次拒绝申请距当前申请天数():
    """user_apply_record_info#diffLatestApplyRefusedDays"""
    def feature(self):
        _上一次拒绝申请距当前申请天数 = -9999999
        get_new_apptime_resufe = new_apptime_resufe(self.user_id,self._apply_at).rename(columns={'applyTime':'apply_time'})
        get_new_apptime_resufe = get_new_apptime_resufe[get_new_apptime_resufe['applyStatus'] == 1][['apply_time']]
        get_old_apptime_resufe = old_apptime_resufe(self.user_id,self._apply_at)
        get_old_apptime_resufe = get_old_apptime_resufe[get_old_apptime_resufe['apply_status'] == 1][['apply_time']]
        resufe_all =pd.concat([get_new_apptime_resufe,get_old_apptime_resufe])
        if resufe_all.empty ==False:
            resufe_all['apply_time'] = resufe_all['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
            resufe_all['apply_at'] = self._apply_at
            resufe_all['apply_at'] = resufe_all['apply_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
            resufe_all_end = (resufe_all['apply_at'].max() - resufe_all['apply_time'].max()).days

            _上一次拒绝申请距当前申请天数 = abs(resufe_all_end)
        self._result["上一次拒绝申请距当前申请天数"]["value"] = _上一次拒绝申请距当前申请天数
        return self._result
