# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service import Sql_contactsOperator
from service.Sql_complexOrder import *
import datetime,time
import pandas as pd
from datetime import timedelta

class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF.df_loan_all = getSql_loanAll_v5(str(tuple([self.user_id])).replace(',)',')'))
        BF._apply_at = time_now
        BF.df_apply_order = pd.DataFrame()
        BF.df_loan_rollBack = pd.DataFrame()
        BF._df_apply = Sql_contactsOperator.getSql_userApplyQuotaRecord(str(tuple([self.user_id])).replace(',)',')'))
        if BF._df_apply.empty == False:
            BF._df_apply.sort_values('apply_time',inplace=True)
            BF._df_apply.reset_index(drop=True,inplace=True)
            if self.orderId:
                BF.df_apply_order = BF._df_apply.loc[BF._df_apply['order_no'] == self.orderId]
                if BF.df_apply_order.empty == False:
                    BF._apply_at = datetime.datetime.strptime(BF.df_apply_order['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')

            if BF.df_loan_all.empty == False:
                BF.df_loan_all.sort_values('apply_time',inplace=True)
                BF.df_loan_all.reset_index(drop=True,inplace=True)
                BF.df_loan_rollBack = get_Loan_rollBack_v5(BF.df_loan_all,BF._apply_at,passdueDay_Negative=True)


def get_loanSettleFrom(df_loan_rollBack):
    """上几笔的订单"""
    df_loan_result = pd.DataFrame()
    if df_loan_rollBack.empty == False:
        # df_loan_rollBack = df_loan_rollBack[df_loan_rollBack["progress"] == 16]
        # if df_loan_rollBack.empty == False:
        df_loan_result = df_loan_rollBack[df_loan_rollBack['loan_id'] == df_loan_rollBack['loan_id'].max()]
    return df_loan_result



class 历史分期中最大逾期天数可正可负():
    """delq_days_max_days_v3"""
    def feature(self):
        _历史分期中最大逾期天数可正可负 = -9999999
        df_loan_result = self.df_loan_rollBack
        if df_loan_result.empty == False:
            _result =df_loan_result['passdue_day'].max()
            _历史分期中最大逾期天数可正可负 = _result
        self._result["历史分期中最大逾期天数可正可负"]["value"] = _历史分期中最大逾期天数可正可负
        return self._result


class 订单的申请次数():
    """history_apply_cnt_v5"""
    def feature(self):
        _订单的申请次数 = -9999999
        get_new_loan_v4_apply = new_loan_v4_apply(self.user_id,self._apply_at)['count'].values[0]
        get_xiaoniu_loan_v4_apply = xiaoniu_loan_v4_apply(self.user_id,self._apply_at)['count'].values[0]
        get_old_loan_v4_apply = old_loan_v4_apply(self.user_id)['count'].values[0]
        _result = get_new_loan_v4_apply - get_xiaoniu_loan_v4_apply + get_old_loan_v4_apply
        _订单的申请次数 = _result
        self._result["订单的申请次数"]["value"] = _订单的申请次数
        return self._result


class 逾期金额比率():
    """overdue_amount_ratio_v2"""
    def feature(self):
        _逾期金额比率 = -9999999
        df_loan_result = self.df_loan_rollBack
        if df_loan_result.empty == False:
            df_loan_result_all = df_loan_result['monthly_repayment'].sum()
            df_loan_result_passdue_day =df_loan_result[df_loan_result['passdue_day'] >0]['monthly_repayment'].sum()
            _result = round(df_loan_result_passdue_day / df_loan_result_all,2)
            _逾期金额比率 = _result
        self._result["逾期金额比率"]["value"] = _逾期金额比率
        return self._result


class 各笔订单最大的不逾期期数比():
    """overdue_days_dis_cont_ratio_v2#overdueDaysGt0DisCont 会有少许精度问题--防止四舍六入五平分"""
    def feature(self):
        _各笔订单最大的不逾期期数比 = -9999999
        df_loan_result = self.df_loan_rollBack
        sum_list = []
        if df_loan_result.empty == False:
            _passdue_day_list = list(set(df_loan_result[df_loan_result['passdue_day'] <= 0]['loan_id'].tolist()))
            df_loan_id = df_loan_result[df_loan_result['loan_id'].isin(_passdue_day_list)]
            for k,v in df_loan_id.groupby(['loan_id']):
                v['term_count'] = len(v)
                v['max_term'] = str(v[v['passdue_day'] >0]['term_no'].max()).replace('nan','0')
                v['result'] =  v['term_count'].values[0] - int(v['max_term'].values[0])
                sum_list.append(v['result'].values[0])
            _result = sum(sum_list) / len(df_loan_result)

            _各笔订单最大的不逾期期数比 =round(_result,2)
        self._result["各笔订单最大的不逾期期数比"]["value"] = _各笔订单最大的不逾期期数比
        return self._result

