#unittest测试框架
import unittest
import sys,os
from HTMLTestRunner_new import HTMLTestRunner
import config.settings as setting
import functools

import inspect


class Test(unittest.TestCase):

    #用于测试用例执行前的初始化工作
    def setUp(self):
        pass

        #用于测试用例执行之后的善后工作
    def tearDown(self):
        pass

    @classmethod
    def set_instance_method(cls, func):
        # 动态添加类方法
        @functools.wraps(func)
        def dummy(self, *args, **kwargs):
            func(*args, **kwargs)
        setattr(cls, func.__name__, dummy)

    @staticmethod
    def runner(funname):
        global filename
        suite=unittest.TestSuite()
        if isinstance(funname,list):
            for fname in funname:
                suite.addTest(Test(fname))
            filename = setting.FILE_PATH+'/report/'+'result.html'
            with open(filename,'wb') as fp:
                # #定义测试报告
                runner=HTMLTestRunner(stream=fp,title='测试报告',description='用例执行情况：',verbosity=2)
                runner.run(suite)
                fp.close()#关闭报告文件
        else:
            print('testcase type error')

if __name__ == '__main__':
    test = Test()
    test.runner()





