import cpca
import pandas as pd
from config.concat_sql import *
import re
import requests
from utils import tools
import datetime
from functools import reduce
from dateutil.relativedelta import relativedelta
import time
import numpy as np
from datetime import timedelta

# 用户申请表
def get_sql_apply_quota_record(user_id,apply_time):
    """ 用户申请放款历史 """
    sql_online_apply_quota_record = """
    select * from apply_quota_record where user_id = {0} and apply_time > '{1}';
    """
    _df = pd.read_sql(sql_online_apply_quota_record.format(user_id,apply_time),con=con_tuomin_xyqb)
    return _df


#现金分期贷款记录表
def get_sql_loan_refused(user_id):
    """ 申请被拒绝:老现金申请,现金申请拒绝,现金分期额度拒绝,资金方拒绝 """
    _sql = """

        select * from (
            select
            DATE(sub.updated_at) as apply_created_at,
            DATE(sub.created_at) as refused_time ,
            loan.business_type,
            loan.id as loan_id,
            lae.order_no as order_no,
            u.uuid as uuid ,u.id as user_id,
            '老现金申请' as status,
            case when loan.progress IN (6, 8, 17, 19) then 1
            else 0 end as is_status
            FROM loan_submit_info as sub
            JOIN loan_application_history loan ON sub.loan_id = loan.id
            LEFT JOIN loan_account_ext as lae ON loan.id = lae.loan_id
            left join user as u on u.id = loan.user_id
            WHERE u.id = {0}  -- AND loan.progress IN (6, 8, 17, 19)
            AND loan.business_type = 0 AND lae.loan_id IS NULL
            union
            select
            DATE(sub.updated_at)  as apply_created_at,
            DATE(sub.created_at) refused_time ,
            loan.business_type,
            loan.id as loan_id,
            lae.order_no as order_no,
            u.uuid as uuid ,u.id as user_id,
            '现金申请' as status,
            case when loan.progress IN (6, 8, 17, 19) then 1
            else 0 end as is_status
            FROM loan_submit_info as sub
            JOIN loan_application_history loan ON sub.loan_id = loan.id
            LEFT JOIN loan_account_ext lae ON loan.id = lae.loan_id
            left join user as u on u.id = loan.user_id
            WHERE  u.id = {0}
            -- AND loan.progress IN (6, 8, 17, 19)
            AND loan.business_type in (0,2,4,6)
            AND lae.loan_id IS NOT NULL
            UNION
            select
            DATE(aqr.created_at) as apply_created_at,
            DATE(aqr.risk_notify_time) as refused_time,
            loan.business_type,
            loan.id as loan_id,
            lae.order_no as order_no,
            u.uuid as uuid ,u.id as user_id,
            '现金分期额度' as status,
            case when aqr.apply_status = 1 then 1
            else 0 end as is_status
            from apply_quota_record as aqr
            left join loan_account_ext as lae on lae.order_no = aqr.order_no
            left join loan_application_history as loan on lae.loan_id = loan.id
            left join user as u on u.id = aqr.user_id
            where u.id = {0} -- aqr.apply_status = 1
            UNION
            select
            DATE(aqr.created_at) as apply_created_at,
            DATE(afrr.updated_at) as refused_time,
            loan.business_type,
            loan.id as loan_id ,
            lae.order_no as order_no,
            u.uuid as uuid ,u.id as user_id,
            '资金方' as status,
            case
                when afrr.apply_status = 3 then 1
                else 0
            end as is_status
            FROM apply_funding_risk_record as afrr
            left join assets_order as ao on afrr.assets_order_id = ao.id
            left join apply_quota_record as aqr on aqr.id = ao.out_trade_no
            left join loan_account_ext as lae on lae.order_no = aqr.order_no
            left join loan_application_history as loan on lae.loan_id = loan.id
            left join user as u on u.id = afrr.user_id
            WHERE  u.id = {0}
            -- and loan.business_type in (0,2,4,6)

            ) as a1
        order by a1.refused_time
    """
    _df = pd.read_sql(_sql.format(user_id),con_tuomin_xyqb)
    return _df


def get_sql_apply(user_id):
    """ 用户申请次数 apply_status 2 通过, 1 拒绝"""
    _sql = """
        SELECT
            user_id,
            if(ls.created_at is not null, ls.created_at, l.created_at) apply_time,
            if(l.progress in (6, 8, 19), 1, 2) apply_status
        FROM
            loan_application_history l
            LEFT JOIN loan_account_ext e
            ON e.loan_id = l.id
            left join loan_submit_info ls on ls.loan_id = l.id
        WHERE l.user_id = {0}
            AND l.business_type IN (0, 2, 4)
            AND e.loan_id IS NULL
        union all
        SELECT
            user_id,
            apply_time,
            apply_status
        FROM
            apply_quota_record
        WHERE user_id = {0}
            order by apply_time;
        """
    _df = pd.read_sql(_sql.format(user_id),con_tuomin_xyqb)
    return _df

def getSql_relation_in_qgblack(phone,created_at):
    """关系联系人在QG黑名单中的个数"""
    _sql = """
        SELECT id,phone,createDate
        FROM blacklist3_i_black_type_list_new
        WHERE phone in {0} and createDate < '{1}'
    """.format(phone,created_at)

    _df = pd.read_sql(_sql,con_realtime)
    return _df

#近30天通讯录黑名单
def get_lxr_list_hmd(uuid=None,order_no=None):

    params = {'user_uuid':str(uuid) , 'codes': 'user_contact_book_info#d30_contact_nums',
              "order_id":str(order_no),"business_type":0}
    headers = {
        'rc_auth_key': 'rc_offline',
        'rc_auth_secret': "9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    _df = pd.DataFrame()
    try:
        _url = "http://172.20.1.131:23010/calc/features"
        _request = requests.get(_url, params=params, headers=headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:
        # if _response['data']['features']['user_contact_book_info#d7_contact_nums']['value'] == -9999999:
        #     return -9999999
        # if _response['data']['features']['user_contact_book_info#d7_contact_nums']['value'] == list([]):
        #     return _df
        ll_phone = pd.DataFrame(_response['data']['features']['user_contact_book_info#d7_contact_nums']['value'])

        if ll_phone.empty == True:
            return _df
        if len(ll_phone) > 0:
            l_phone =ll_phone[0].tolist()
            # 找到接口的时间戳进行转换并且减去7天得到的结果
            l_time = _response["data"]["subInfo"]["snapshotTime"]
            timeArray = time.localtime(int((l_time / 1000)))
            created_at = time.strftime("%Y-%m-%d %H:%M:%S", timeArray)
            l_phone = [str(i).replace(" ","").replace("-","") for i in l_phone]
            l_phone = [i for i in l_phone if re.match(r'^(1[3546789]\d{9})$', str(i))]
            if len(l_phone) == 0:
                return _df
            _sql = """
                SELECT id,phone,createDate
                FROM blacklist3_i_black_type_list_new
                WHERE phone in {0} and createDate < '{1}'
            """.format(str(tuple(l_phone)).replace(',)',')'), created_at)
            _df = pd.read_sql(_sql, con_realtime)
            if _df.empty == True:
                return 0
            return _df
        else:
            return _df

    return _df


#紧急联系人黑名单
# def jinji_lianxi(id,creat_time):
#     """紧急联系人黑名单"""
#     _sql = """SELECT
# 	DISTINCT(c.mobile)
#     phoneNo, u2.id userId
#     FROM xyqb_i_user u JOIN xyqb_i_user_contact c
#     ON u.id = c.user_id
#     LEFT JOIN xyqb_i_user u2
#     on u2.phone_no = c.mobile
# 		where u2.id = "{0}" and c.created_at< "{1}" """.format(id,creat_time)
#     _df = pd.read_sql(_sql,con_realtime)
#     return _df

def getSql_relation_in_qgblack(phone,created_at):
    """关系联系人在QG黑名单中的个数"""
    _sql = """
        SELECT id,phone,createDate
        FROM blacklist3_i_black_type_list_new
        WHERE phone in {0} and createDate < '{1}'
    """.format(phone,created_at)

    _df = pd.read_sql(_sql,con_realtime)
    return _df

#用户注册信息
def user_register(uuid):

    _sql = """
        select id as user_id,uuid,phone_no,created_at from xyqb_i_user WHERE uuid ='{0}'
    """.format(uuid)
    _df = pd.read_sql(_sql,con_realtime)
    return _df


import time
#近一个月通讯录
def get30day_addressbook(uuid=None,order_no=None):
    params = {'user_uuid':str(uuid) , 'codes': 'user_contact_book_info#d30_contact_nums',
              "order_id":str(order_no),"business_type":0}
    headers = {
        'rc_auth_key': 'rc_offline',
        'rc_auth_secret': "9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    _df = pd.DataFrame()
    try:
        _url = "http://172.20.1.131:23010/calc/features"
        _request = requests.get(_url, params=params, headers=headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:
        ll_phone = pd.DataFrame(_response['data']['features']['user_contact_book_info#d30_contact_nums']['value'])

        if ll_phone.empty == True:
            return _df
        if len(ll_phone) > 0:
            l_phone =ll_phone[0].tolist()
            # 找到接口的时间戳进行转换并且减去7天得到的结果
            l_time = _response["data"]["subInfo"]["snapshotTime"]
            timeArray = time.localtime(int((l_time / 1000)))
            created_at = time.strftime("%Y-%m-%d %H:%M:%S", timeArray)
            l_phone = [str(i).replace(" ","").replace("-","") for i in l_phone]
            l_phone = [i for i in l_phone if re.match(r'^(1[3546789]\d{9})$', str(i))]
            if len(l_phone) == 0:
                return _df
            _sql = """
                SELECT id,phone,createDate
                FROM blacklist3_i_black_type_list_new
                WHERE phone in {0} and createDate < '{1}'
            """.format(str(tuple(l_phone)).replace(',)',')'), created_at)
            _df = pd.read_sql(_sql, con_realtime)
            if _df.empty == True:
                return 0
            return _df
        else:
            return _df

    return _df


# get_lxr_list_hmd_one(uuid="f195fe5599894dcebc9057a46af387c6",order_no=None)
#获取用户详情，身份证号
def get_idcard_detail(uuid):
    _sql = """ SELECT ud.* FROM xyqb_user_i_user u,xyqb_user_i_user_detail ud WHERE u.id = ud.user_id
      AND u.uuid ='{0}'Order by u.id desc limit 1""".format(uuid)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

#身份证号码黑名单标志
def iddetail_blakclist_logo(id_no,createDate):
    _sql = """SELECT COUNT(DISTINCT idcard) count FROM black_type_idcard_new  where idcard = "{0}"  and createDate < "{1}" """.format(id_no,createDate)
    _df = pd.read_sql(_sql,con_blacklist3_read)
    return _df

#身份证归属地（省）黑名单标志
def sheng_hmd(city_code,create_time):
    _sql = """select count(DISTINCT city_code) count from c_black_id_no where city_code = {0}
                and type = 1 and is_enable = 1 and create_time < "{1}" """.format(city_code,create_time)
    _df = pd.read_sql(_sql,con_realtime_hmd)
    return _df
#身份证归属地（市）黑名单标志
def shi_hmd(city_code,create_time):
    _sql = """select count(DISTINCT city_code) count from c_black_id_no where city_code = {0}
                and type = 2 and is_enable = 1 and create_time < "{1}" """.format(city_code,create_time)
    _df = pd.read_sql(_sql,con_realtime_hmd)
    return _df

#身份证归属地（区）黑名单标志
def qu_hmd(city_code,create_time):
    _sql = """select count(DISTINCT city_code) count from c_black_id_no where city_code = {0}
                and type = 3 and is_enable = 1 and create_time < "{1}" """.format(city_code,create_time)
    _df = pd.read_sql(_sql,con_realtime_hmd)
    return _df


#查手机号归属地黑名单
def phone_Location_Attribution_black(phone_num_pre_seven,created_at):
# def cx_phone_hmd(phone_num_pre_seven,created_at):
    _sql = """select count(DISTINCT phone_num_pre_seven) count from phone_num_pre_seven
     where phone_num_pre_seven =  "{0}" and is_enable = 1 and created_at < "{1}" """.format(phone_num_pre_seven,created_at)
    _df = pd.read_sql(_sql,con_realtime_hmd)
    return _df

#近一个月通话记录成功爬取标志
def day30_Call_record_spider(userId):
    _sql = """
    select update_at,login_name loginName,user_source userSource,app_id appId ,auth_status authStatus 
    from user_auth_info_c where user_source in ("YIDONG","LIANTONG","DIANXIN") and user_id = '{0}' ORDER BY update_at desc
    """.format(userId)

    _df = pd.read_sql(_sql,con_day30_sql)
    return _df





#民族编码
def Nation(uuid=None,order_no=None):
    """近七天联系人信息"""
    params = {'user_uuid': str(uuid), 'codes': 'user_ocr_info#nation',
              "order_id": str(order_no), "business_type": 0}
    headers = {
        'rc_auth_key': 'rc_offline',
        'rc_auth_secret': "9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    try:
        _url = "http://172.20.1.131:23010/calc/features"
        _request = requests.get(_url, params=params, headers=headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:
        if (_response['data']['features']['user_ocr_info#nation']['value']) == -9999999:
            return pd.DataFrame()
        else:
            ll_phone_t = _response['data']['features']['user_ocr_info#nation']['value']

            ll_phone = pd.DataFrame({"民族": [ll_phone_t]})
            return ll_phone

    return pd.DataFrame()


#手机号对应身份证号
def phone_id(phone_no,created_at):
    _sql = """SELECT count(DISTINCT id_no) from xyqb_i_user_detail where phone_no = "{0}"and created_at < "{1}";""".format(phone_no,created_at)
    _df = pd.read_sql(_sql,con_realtime)
    return _df
#身份证对应手机号
def id_phone(id_no,created_at):
    _sql = """SELECT count(DISTINCT phone_no) from xyqb_i_user_detail where id_no = "{0}" and created_at < "{1}";""" .format(id_no,created_at)
    _df = pd.read_sql(_sql,con_realtime)
    return _df



def getSql_loanAll_one_vcc(user_id):
    """获取用户所有放款订单明细"""
    _sql = """
        select
         IFNULL(aqr.order_no ,'') order_no
        ,loan.user_id,loan.id as loan_id,loan.progress,fest.contract_loan_amount,fest.loan_paid_at
        ,case when loan.created_at >='2018-05-08' then aqr.apply_from
            when loan.created_at < '2018-05-08' then loan.created_from
            else null
            end as applied_from
        ,if (sub.created_at is not null, sub.created_at ,loan.created_at) apply_time
        ,plan.id as plan_id,plan.term_no, plan.repayment_status, plan.deadline as deadline,DATE_ADD(plan.deadline,INTERVAL 1 second) as deadline_new
        ,plan.repaid_at
        from loan_application_manifest_history as fest
        left join loan_application_history as loan on fest.loan_application_history_id = loan.id
        left join loan_submit_info as sub on sub.loan_id = loan.id
        left join repay as plan on plan.loan_application_history_id = loan.id
        left join repayment_record as record on record.repayment_plan_id = plan.id
        left join loan_account_ext as lae on lae.loan_id = loan.id
        left join apply_quota_record as aqr on aqr.order_no = lae.order_no
        where
        loan.user_id in {}
        and loan.progress in (15,16,65)
        and fest.transaction_status in (2,5)
        order by loan.id,plan.id
    """.format(user_id)

    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df



#手机号过滤
def df_filter(df):
    df["receiverPhone"] = df["receiverPhone"].map(lambda x: x if re.match(r'^(1[3546789]\d{9})$', str(x)) else np.nan)
    df = df.dropna(subset=["receiverPhone"])
    return df


#紧急联系人

def emergency_contact(user_id,creat_time):
#     _sql = """select c.*
# FROM user u
# JOIN contact c ON u.id = c.user_id
# WHERE c.user_id = "{0}"
# """.format(user_id)

    _sql = """select * from (select c.*
FROM user u 
JOIN contact c ON u.id = c.user_id
WHERE c.user_id = "{0}")as t WHERE t.created_at < "{1}" """.format(user_id,creat_time)

    _df = pd.read_sql(_sql, con_urgent_people)
    return _df
#紧急联系人黑名单
def emergency_contact_blacklist(phone,createDate):
    _sql = """select * from blacklist3_i_black_type_list_new where phone in {0}  and createDate < "{1}" """.format(phone,createDate)
    _df = pd.read_sql(_sql, con_realtime)
    return _df


#用户注册渠道
def register(uuid):
    _sql = """select id as user_id,uuid,registered_from,phone_no,created_at from xyqb_i_user WHERE uuid = "{0}" """.format(uuid)
    _df = pd.read_sql(_sql,con_realtime)
    return _df



#一线二线城市的标志调用hbase的接口
def city_sign(uuid=None,order_no=None):
    """一线二线城市的标志调用hbase的接口"""

    params = {'user_uuid':str(uuid) , 'codes': 'user_ocr_info#address',
              "order_id":str(order_no),"business_type":0}
    headers = {
        'rc_auth_key': 'rc_offline',
        'rc_auth_secret': "9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    try:
        _url = "http://172.20.1.131:23010/calc/features"
        _request = requests.get(_url, params=params, headers=headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)

    if _response['data']['features']['user_ocr_info#address']['value'] == -9999999:
        return list([])
    elif _response['data']['features']['user_ocr_info#address']['value'] == '':
        return list([])
    c_list = []
    first_city = ["北京市","上海市","广州市","深圳市"]
    second_city = ["成都市", "杭州市", "重庆市", "武汉市", "苏州市", "西安市", "天津市", "南京市", "郑州市", "长沙市", "沈阳市", "青岛市", "宁波市", "东莞市", "无锡市"]
    if _response:
        ll_city = [_response['data']['features']['user_ocr_info#address']['value']][0]
        # fitle_ll_city = (ll_city).replace("[", "").replace("]", "")
        re_city = re.search(".*市", (ll_city))
        if re_city:
            sd = re.search(".*市", str(ll_city)).group(0)
            for citry in first_city:
                df = sd.find(str(citry))
                # print(df)
                if df != -1:
                    return 1
            for ciry in second_city:
                df = sd.find(str(ciry))
                if df != -1:
                    return 2
            first_city.extend(second_city)

            for city_q in first_city:
                df = sd.find(str(city_q))
                # print(df)
                c_list.append(df)
                # if df == -1:
                #     return 3
            if sum(c_list) == -19:
                return 3



            # df = sd.find(str([k for k in first_city]))
            # print(df)
        else:
            return 3

    return list([])

# city_sign(uuid="8e899339-642d-4240-846d-75c475488cfa")
#     re.search(".*市",ll_city)

#身份证是否过期
def card_expires(uuid=None,order_no=None):
    params = {'user_uuid': str(uuid), 'codes': 'user_ocr_info#validDateEnd',
              "order_id": str(order_no), "business_type": 0,'ignore_cache':True}
    headers = {
        'rc_auth_key': 'rc_offline',
        'rc_auth_secret': "9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    try:
        _url = "http://172.20.1.184:23010/calc/features"
        _request = requests.get(_url, params=params, headers=headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:
        if _response['data']['features']['user_ocr_info#validDateEnd']['value'] == -9999999:
            return list([])
        # if _response['data']['features']['user_ocr_info#validDateEnd']['value'] == "?":
        #     return list([])
        ll_idcard = _response['data']['features']['user_ocr_info#validDateEnd']['value']

        if ll_idcard:
            if (ll_idcard =='长期') or (ll_idcard =='长期有效'):
                return 20301230
            elif isinstance(ll_idcard.replace(".",""),str):
                return int(ll_idcard.replace(".",""))




    return list([])
# card_expires(uuid="8e899339-642d-4240-846d-75c475488cfa")





def get_successful_user_loan_orders(user_id,created_time):
    """获取用户成功放款订单（按照放款时间降序排列）"""
    _sql = """SELECT m.* FROM loan_application_history l JOIN
loan_application_manifest_history m ON l.id = m.loan_application_history_id
WHERE l.user_id in {0} AND l.progress IN (15,16,65)
AND l.business_type IN ( 0, 2, 4, 6 )
and m.loan_paid_at <"{1}" order by m.loan_paid_at desc""".format(user_id,created_time)


    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def id_is_whitelist(phone_num_pre_seven,created_at):
    """查身份证是否在白名单"""
    _sql = """select count(DISTINCT cert_number) count from
     white_list where cert_number = "{0}" and is_enable = 1 and created_at < "{1}" """.format(phone_num_pre_seven,created_at)
    _df = pd.read_sql(_sql, con_realtime_hmd)
    return _df


# def get_AddresSplit(addres='山东省威海环翠区青岛北路89号'):
#     p = re.compile(r'省|直辖市|市|回族自治区|维吾尔自治区|壮族自治区|特别行政区|自治区|区|自治州|地区|县|盟|自治县')
#     addres = re.split(p,addres)
#     return addres
def id_refuse_days(user_id):
    """同一身份证用户上次申请拒绝距今天数"""
    _Sql = """select * from risk_record where apply_status =1 and user_id = "{0}" """.format(user_id)
    _df = pd.read_sql(_Sql,con_vccthree_vcc_talos)
    return _df

def id_user_credited(validity_date,user_id):
    """同一身份证用户是否已授信"""
    _Sql = """select * from acs_limit where limit_amount > 0  and validity_date >"{0}"  and user_id = "{1}" """.format(validity_date,user_id)
    _df = pd.read_sql(_Sql,con_vccthree_acsdb)
    return _df

def day_incoming_parts(Same_day_first,Same_day_next):
    """当日客户数"""
    _Sql = """select count(distinct user_id) count, apply_status applyStatus from risk_record
     where created_at >= "{0}" and created_at < "{1}" group by apply_status;""".format(Same_day_first,Same_day_next)
    _df = pd.read_sql(_Sql,con_vccthree_vcc_talos)
    return _df

def day_amount_credit(Same_day_first,Same_day_next):
    """当日授信总额度"""
    _Sql = """select sum(limit_amount) totalCount from acs_limit_record where limit_record_type = 'New'
     and limit_amount > 0 and create_time >= "{0}"and create_time < "{1}";""".format(Same_day_first,Same_day_next)
    _df = pd.read_sql(_Sql,con_vccthree_acsdb)
    return _df

def sale_phone_white(phone_no):
    """营销手机号白名单"""
    _sql = """  select * from white_list_phone_no where phone_no = {0} and is_enable = 1 """.format(phone_no)
    _df = pd.read_sql(_sql, con_realtime_hmd)
    return _df





def gratia_payment_amount():
    """惠金所当日放款额"""
    _sql = """select sum(contract_loan_amount) amount from loan_application_manifest_history 
    where loan_paid_at>=CURDATE() and transaction_status in (2,5)
    and funding_corp_id=950  and user_id = 430"""
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df


def amount_of_merchant(store_id,start_time,end_time):
    _sql = """select amount as amount, trade_type as tradeType,trade_time as tradeTime from  trade_record
     where inner_merchant_no = '{0}' and status = 1 and trade_time >= '{1}' and trade_time < '{2}'; """.format(store_id,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_talos)
    return _df

def userid_of_merchant(store_id,start_time,end_time):
    _sql = """ select user_id as userId, trade_time as tradeTime from trade_record 
    where inner_merchant_no = '{0}' and trade_type = 3 and status = 1 and trade_time >= '{1}' and trade_time < '{2}'; """.format(store_id,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_talos)
    return _df

def store_amount(uuid):
    """商户额度"""
    _sql = """ select activated_amount,user_id from user_quota_record where uuid = '{0}';""".format(uuid)
    _df = pd.read_sql(_sql, con_vcc_quota)
    return _df

def uuid_store_amount(store_id,uuid,start_time,end_time):
    _sql = """select amount as amount, trade_type as tradeType from  trade_record
     where inner_merchant_no = '{0}' and uuid = '{1}'and status = 1 and trade_time >= '{2}' and trade_time < '{3}'; """.format(store_id,uuid,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_talos)
    return _df

def on_uuid_store(uuid,store_id,order_id):
    _sql = """select amount from trade_record 
    where uuid = '{0}' and inner_merchant_no = '{1}' and order_id = '{2}' and trade_type = 3 and status = 1""".format(uuid,store_id,order_id)
    _df = pd.read_sql(_sql, con_vcc_talos)
    return _df

def store_type(store_id):
    _sql = """select risk_flag as type from inner_merchant_info where inner_merchant_no = '{0}';""".format(store_id)
    _df = pd.read_sql(_sql, con_vcc_talos)
    return _df

def get_orderid_trade(orderid):
    _sql= """select trade_time from trade_record  where order_id = '{0}'""".format(orderid)
    _df = pd.read_sql(_sql, con_vcc_talos)
    return _df



def time_restart_zero(data_time):
    time_zero = datetime.datetime.strptime(datetime.datetime.strftime(data_time, '%Y-%m-%d 00:00:00'), '%Y-%m-%d 00:00:00')
    return time_zero

def iftime_order_snapshot(apply_time):
    today = time_restart_zero(apply_time)
    tomorrow = apply_time
    yesterday = today - timedelta(days=1)

    this_week_start = time_restart_zero(apply_time - timedelta(days=apply_time.weekday()))
    this_week_end = apply_time

    last_week_start = this_week_start - timedelta(days=7)
    last_week_end = this_week_start

    this_month_start = datetime.datetime(apply_time.year, apply_time.month, 1)
    this_month_end = apply_time

    last_month_up = this_month_start - timedelta(days=1)
    last_month_start = datetime.datetime(last_month_up.year, last_month_up.month, 1)
    last_month_end = this_month_start

    return today,tomorrow,yesterday,this_week_start,this_week_end,last_week_start,last_week_end\
    ,this_month_start,this_month_end,last_month_start,last_month_end


def getSql_userPhone(uuid):
    """获取用户手机号"""
    _sql = """
     select phone_no
        from xyqb_i_user 
        where uuid = '{0}'
    """.format(uuid)  # type: str
    _df = pd.read_sql(_sql,con_realtime)
    return _df

def vcc_phone_user(phone):
    _sql = """select isp, city from dict_phone where phone= '{0}';""".format(phone)
    _df = pd.read_sql(_sql, con_vcc_transfer)
    return _df

def vcc_user_info(uuid):
    _sql = """  select card_type as cardType, job_code as jobCode, income_code as incomeCode from
     account a left join account_other_info b on a.user_id=b.user_id where a.uuid= '{0}';""".format(uuid)
    _df = pd.read_sql(_sql, con_vcc_talos)
    return _df

def vcc_credit_phone(userid,phone):
    _sql = """select
     case when count(1)>0
     then 1 when count(1)=0
     then 0
     else '-9999999'
     end as as_type from payment_center.bank_card where uid='{0}' and preserve_phone_no='{1}';""".format(userid,phone)
    _df = pd.read_sql(_sql, con_vcc_transfer_pay)
    return _df



#身份证是否过期
def vcc_idcard_expires(uuid=None,order_no=None):
    params = {'uuid': str(uuid),"order_id": str(order_no)}
    _response = None
    try:
        _url = "http://operator.liangkebang.com/auth-center/ex/getIdCardInfo.json"
        _request = requests.post(_url, data=params)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:
        if _response['data']['valid_date_end'] == -9999999:
            return list([])
        # if _response['data']['features']['user_ocr_info#validDateEnd']['value'] == "?":
        #     return list([])
        ll_idcard = _response['data']['valid_date_end']

        if ll_idcard:
            if (ll_idcard =='长期') or (ll_idcard =='长期有效'):
                return '20301230'
            elif isinstance(ll_idcard.replace(".",""),str):
                return (ll_idcard.replace(".",""))


def quota_usage(uuid,applyTime):
    """额度使用"""
    _sql = """select target_used_amount as transAmountNow, target_activated_amount as nowRealAmount 
    from user_quota_log where uuid = '{0}' and created_at < '{1}' order by created_at desc limit 1""".format(uuid,applyTime)
    _df = pd.read_sql(_sql, con_vcc_quota)
    return _df

def historical_overdue(user_id,applyTime):
    """vcc历史最大逾期"""
    _sql = """select paid_off_date as paidOffDate, plan_date as planDate from acs_plan
    where user_id = '{0}' and plan_status!='Refund' and plan_status!='Renew' and plan_date < '{1}'""".format(user_id,applyTime)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df

def time_credit(uuid,applyTime):
    """授信时间"""
    _sql = """select created_at as creditAt from biz_audit_log where uuid = '{0}' and created_at < '{1}' order by created_at desc limit 1""".format(uuid,applyTime)
    _df = pd.read_sql(_sql, con_vcc_workflow)
    return _df

def time_credit_quta(uuid):
    """重新获取授信时间"""
    _sql = """select apply_time from risk_record where apply_status =2 and uuid ='{0}'  order by apply_time desc limit 1""".format(uuid)
    _df = pd.read_sql(_sql,con=con_vcc_talos)
    return _df

def time_credit_info(user_id,start_time,end_time):
    _sql = """select * from acs_trans where user_id = '{0}'  and trans_type IN ('Shop','Loan') and trans_status = 'Complete' and trans_time >= '{1}'  and trans_time <= '{2}'""".format(user_id,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df

def view_activation(uuid,created_at):
    """查看激活额度"""
    _sql = """select * from user_quota_log where uuid = '{0}' and created_at >= '{1}' order by created_at asc limit 1""".format(uuid,created_at)
    _df = pd.read_sql(_sql, con_vcc_quota)
    return _df


def first_transaction(user_id,applyTime):
    """首次交易时间"""
    _sql = """select min(business_date) as fristBusinessDate from acs_trans
    where user_id = '{0}' and  trans_type IN ('Shop','Loan') AND trans_status = 'Complete' and trans_time < '{1}';""".format(user_id,applyTime)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df

def first_transaction_mount(user_id,fristBusinessDate):
    """首次交易当天的交易金额"""
    _sql = """select sum(trans_amount) as today_amount  from acs_trans
     where user_id = '{0}' and  trans_type IN ('Shop','Loan') AND trans_status = 'Complete' and business_date = '{1}';""".format(user_id,fristBusinessDate)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df


def trans_amount_info(user_id,start_time,end_time):
    """交易金额"""
    _sql = """select * from acs_trans 
    where user_id = '{0}'  and trans_type IN ('Shop','Loan') and trans_status = 'Complete' and trans_time >= '{1}' and trans_time <= '{2}' """.format(user_id,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df

def one_month_amount(user_id,start_time,end_time):
    """近一个月提前还款的金额"""
    _sql = """select trans_amount from acs_trans where user_id = '{0}'
    and trans_type = 'Repay' AND trans_status = 'Complete' and business_date<date(bill_no) and business_date >= '{1}' and business_date <= '{2}'""".format(user_id,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df


def one_month_term(user_id,start_time,end_time):
    """"""
    _sql = """select * from acs_trans where user_id = '{0}' and trans_type IN ( 'Shop', 'Loan' )
    AND trans_status = 'Complete' and business_date >= '{1}' and business_date <= '{2}'""".format(user_id,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df

def all_month_term(user_id):
    """获取所有的交易笔数"""
    _sql = """select * from acs_trans where user_id = '{0}' and trans_type IN ( 'Shop', 'Loan' )
    AND trans_status = 'Complete' """.format(user_id)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df



def historical_trans_amount(user_id,applyTime):
    """历史交易金额"""
    _sql = """SELECT * FROM acs_trans WHERE user_id = '{0}' and trans_type IN ( 'Shop', 'Loan' ) 
    AND trans_status = 'Complete'  and business_date <= '{1}';""".format(user_id,applyTime)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df


def history_fail_count(user_id,applyTime):
    _sql = """SELECT count(*) as count FROM acs_trans WHERE user_id = '{0}'
    and trans_type not in ('Shop','Loan') and trans_type='Deduct' AND trans_status != 'Complete' and business_date <= '{1}';""".format(user_id,applyTime)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df

def successful_active_month(user_id,start_time,end_time):
    _sql = """SELECT count(*) as count FROM acs_trans WHERE user_id = '{0}' and trans_type NOT IN ( 'Shop', 'Loan' ) 
    and trans_type = 'Repay'  and trans_status = 'Complete' and business_date >= '{1}' and business_date <= '{2}';""".format(user_id,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df


def near_3loan_count(user_id,start_time,end_time):
    """近三天交易次数"""
    _sql = """SELECT count(*) as count FROM acs_trans WHERE user_id = '{0}' and trans_type IN ('Shop','Loan') 
    AND trans_status = 'Complete' and business_date >= '{1}' and business_date <= '{2}';""".format(user_id,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df

def near_7loan_count(user_id,start_time,end_time):
    """"""
    _sql="""SELECT max(trans_amount) as maxTransAmount FROM acs_trans WHERE user_id = '{0}' and trans_type IN ('Shop','Loan') 
    AND  trans_status = 'Complete'  and business_date >= '{1}' and business_date <= '{2}';""".format(user_id,start_time,end_time)
    _df = pd.read_sql(_sql, con_vcc_device_info)
    return _df


def get_round(fnum,num):
    """使用mysql 函数四舍五入"""
    _sql="""select ROUND({0}, {1}) as result ; """.format(fnum,num)
    _value = pd.read_sql(_sql, con_vcc_device_info)['result'].values[0]
    return _value


def feature_vcc_score(uuid):
    _sql = """select model_score score from vcc_model_score_recall where uuid = '{0}' """.format(uuid)
    _df = pd.read_sql(_sql, con_vcc_score)
    return _df
