# -*- coding:utf-8 -*-
import pandas as pd
from config.concat_sql import *

def get_sql_user_id(uuid):
    """通过uuid 获取用户user_id"""
    sql_get_user_id = """
      select id as user_id, uuid from user where uuid = '{0}'
    """
    _df = pd.read_sql(sql_get_user_id.format(uuid),con=con_tuomin_xyqb)
    return _df

def get_sql_user_in_loan(user_id):
    """用户在贷"""
    _sql = """
    select
    loan.id loan_id,loan.user_id,loan.created_at as loan_created_at
    ,fest.contract_loan_amount
    ,plan.id plan_id,plan.required_repayment,plan.term_no,plan.repayment_status,plan.deadline,plan.repaid_at
    ,sum(record.principal) as principal,sum(record.interest) as interest ,sum(record.service_fee) as service_fee
    ,case
        when plan.repayment_status <> 3 then 1
        else 0 end as is_zaidai
    ,case
        WHEN plan.repayment_status = 3 THEN DATEDIFF(plan.repaid_at,DATE_SUB(plan.deadline, interval 1 second))
        when plan.repayment_status <> 3 and plan.deadline < CURDATE() then DATEDIFF(CURDATE(),DATE_SUB(plan.deadline, interval 1 second))
        else 0 end as passdue_day
    from loan_application_history as loan
    left join loan_application_manifest_history as fest on loan.id = fest.loan_application_history_id
    left join repay as plan on plan.loan_application_history_id = loan.id
    left join repayment_record as record on record.repayment_plan_id = plan.id
    where loan.progress in (15,65)
    and loan.is_active = 1
    and loan.user_id = {0}
    GROUP BY record.repayment_plan_id
    ;
    """
    _df = pd.read_sql(_sql.format(user_id),con=con_tuomin_xyqb)
    return _df


def get_sql_apply_quota_record(user_id,apply_time):
    """ 用户申请放款历史 """
    sql_online_apply_quota_record = """
    select * from apply_quota_record where user_id = {0} and apply_time > '{1}';
    """
    _df = pd.read_sql(sql_online_apply_quota_record.format(user_id,apply_time),con=con_tuomin_xyqb)
    return _df

# ====================

def get_sql_user_loan_all(user_id):
    _sql = """
        select
        t1.*,
        if(t1.passdue_day > 0,1,0) as is_overdue
        from (
            select
             IFNULL(aqr.order_no ,'') order_no
            ,loan.user_id,loan.id as loan_id,loan.progress,fest.contract_loan_amount
            ,case when loan.created_at >='2018-05-08' then aqr.apply_from
                when loan.created_at < '2018-05-08' then loan.created_from
                else null
                end as applied_from

            ,if (sub.created_at is not null, sub.created_at ,loan.created_at) apply_time
            ,plan.id as plan_id,plan.term_no, plan.repayment_status, plan.deadline as deadline,DATE_ADD(plan.deadline,INTERVAL 1 second) as deadline_new
            ,plan.repaid_at,plan.current_repayment,plan.required_repayment,record.principal,record.interest,record.service_fee
            ,case
                WHEN plan.repayment_status = 3 THEN DATEDIFF(plan.repaid_at,DATE_SUB(plan.deadline, interval 1 second))
                when plan.repayment_status <> 3 and plan.deadline < CURDATE() then DATEDIFF(CURDATE(),DATE_SUB(plan.deadline, interval 1 second))
                when plan.id is null then null
                else 0 end as passdue_day
            ,loan.updated_at
            from loan_application_manifest_history as fest
            left join loan_application_history as loan on fest.loan_application_history_id = loan.id
            left join loan_submit_info as sub on sub.loan_id = loan.id
            left join repay as plan on plan.loan_application_history_id = loan.id
            left join repayment_record as record on record.repayment_plan_id = plan.id
            left join loan_account_ext as lae on lae.loan_id = loan.id
	        left join apply_quota_record as aqr on aqr.order_no = lae.order_no
            where
            loan.user_id in {0}
            and fest.transaction_status in (2,5)
            order by loan.id,plan.id
        ) as t1
    """
    # -- ,case when sub.channel_id is null then loan.created_from else sub.channel_id end as applied_from
    _df = pd.read_sql(sql=_sql.format(user_id),con=con_tuomin_xyqb)
    return _df



def get_sql_apply(user_id):
    """ 用户申请次数 apply_status 2 通过, 1 拒绝"""
    _sql = """
        SELECT
            user_id,
            if(ls.created_at is not null, ls.created_at, l.created_at) apply_time,
            if(l.progress in (6, 8, 19), 1, 2) apply_status
        FROM
            loan_application_history l
            LEFT JOIN loan_account_ext e
            ON e.loan_id = l.id
            left join loan_submit_info ls on ls.loan_id = l.id
        WHERE l.user_id = {0}
            AND l.business_type IN (0, 2, 4)
            AND e.loan_id IS NULL
        union all
        SELECT
            user_id,
            apply_time,
            case when apply_status = 1 then 1
            else 2 end as apply_status
        FROM
            apply_quota_record
        WHERE user_id = {0}
            order by apply_time;
        """
    _df = pd.read_sql(_sql.format(user_id),con_tuomin_xyqb)
    return _df


def get_sql_loan_refuse_cnt_old(user_id):
# 一单一审放款拒绝
#     _sql = """
#       SELECT COUNT(1) count FROM loan_application_history l LEFT JOIN loan_account_ext e ON e.loan_id = l.id
#       WHERE l.user_id = {0}
#       and l.business_type IN (0,2,4,6)
#       AND l.progress IN (6,8,19) AND e.loan_id IS NULL
#
#       """
    _sql = """SELECT COUNT(1) count FROM loan_application_history l JOIN
    loan_account_ext e ON e.loan_id = l.id WHERE l.user_id = {0}
    and l.business_type IN (0,2,4,6)
    AND l.progress = 8 """
    _df = pd.read_sql(_sql.format(user_id),con_tuomin_xyqb)
    return _df

def get_sql_loan_refuse_cnt_new(user_id,apply_time=None):
    # 循环额度申请拒绝
    _sql = """
          SELECT COUNT(1) count FROM apply_quota_record
          WHERE user_id = {0}
          AND apply_status = 1"""
    if apply_time:
        _sql = _sql+ """AND apply_time <= '{1}'"""

    _df = pd.read_sql(_sql.format(user_id,apply_time),con_tuomin_xyqb)
    return _df

def get_sql_loan_refused(user_id):
    """ 申请被拒绝:老现金申请,现金申请拒绝,现金分期额度拒绝,资金方拒绝 """
    _sql = """

        select * from (
            select
            DATE(sub.updated_at) as apply_created_at,
            DATE(sub.created_at) as refused_time ,
            loan.business_type,
            loan.id as loan_id,
            lae.order_no as order_no,
            u.uuid as uuid ,u.id as user_id,
            '老现金申请' as status,
            case when loan.progress IN (6, 8, 17, 19) then 1
            else 0 end as is_status
            FROM loan_submit_info as sub
            JOIN loan_application_history loan ON sub.loan_id = loan.id
            LEFT JOIN loan_account_ext as lae ON loan.id = lae.loan_id
            left join user as u on u.id = loan.user_id
            WHERE u.id = {0}  -- AND loan.progress IN (6, 8, 17, 19)
            AND loan.business_type = 0 AND lae.loan_id IS NULL
            union
            select
            DATE(sub.updated_at)  as apply_created_at,
            DATE(sub.created_at) refused_time ,
            loan.business_type,
            loan.id as loan_id,
            lae.order_no as order_no,
            u.uuid as uuid ,u.id as user_id,
            '现金申请' as status,
            case when loan.progress IN (6, 8, 17, 19) then 1
            else 0 end as is_status
            FROM loan_submit_info as sub
            JOIN loan_application_history loan ON sub.loan_id = loan.id
            LEFT JOIN loan_account_ext lae ON loan.id = lae.loan_id
            left join user as u on u.id = loan.user_id
            WHERE  u.id = {0}
            -- AND loan.progress IN (6, 8, 17, 19)
            AND loan.business_type in (0,2,4,6)
            AND lae.loan_id IS NOT NULL
            UNION
            select
            DATE(aqr.created_at) as apply_created_at,
            DATE(aqr.risk_notify_time) as refused_time,
            loan.business_type,
            loan.id as loan_id,
            lae.order_no as order_no,
            u.uuid as uuid ,u.id as user_id,
            '现金分期额度' as status,
            case when aqr.apply_status = 1 then 1
            else 0 end as is_status
            from apply_quota_record as aqr
            left join loan_account_ext as lae on lae.order_no = aqr.order_no
            left join loan_application_history as loan on lae.loan_id = loan.id
            left join user as u on u.id = aqr.user_id
            where u.id = {0} -- aqr.apply_status = 1
            UNION
            select
            DATE(aqr.created_at) as apply_created_at,
            DATE(afrr.updated_at) as refused_time,
            loan.business_type,
            loan.id as loan_id ,
            lae.order_no as order_no,
            u.uuid as uuid ,u.id as user_id,
            '资金方' as status,
            case
                when afrr.apply_status = 3 then 1
                else 0
            end as is_status
            FROM apply_funding_risk_record as afrr
            left join assets_order as ao on afrr.assets_order_id = ao.id
            left join apply_quota_record as aqr on aqr.id = ao.out_trade_no
            left join loan_account_ext as lae on lae.order_no = aqr.order_no
            left join loan_application_history as loan on lae.loan_id = loan.id
            left join user as u on u.id = afrr.user_id
            WHERE  u.id = {0}
            -- and loan.business_type in (0,2,4,6)

            ) as a1
        order by a1.refused_time
    """
    _df = pd.read_sql(_sql.format(user_id),con_tuomin_xyqb)
    return _df

# def getSql_user