import pandas as pd
from config.concat_sql import *


def getSql_userContactAll(user_id,apply_time):
    """获取用户所有联系人"""
    _sql = """
        SELECT DISTINCT(c.phone_no) contact_phone_no, u.phone_no,u.id user_id ,c.created_at
        FROM xyqb_i_user u
        JOIN xyqb_user_i_contact c ON u.id = c.user_id
        where u.id = {0}
        and c.created_at < '{1}'
    """.format(user_id,apply_time)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

def getSql_userApplyisContact(phone_no,apply_time):
    """通过用户手机号,查询其他把该用户填写为联系人的那些用户"""
    _sql = """
        SELECT DISTINCT
            (u.id) user_id,
            u.phone_no phone_no,
            c.created_at
        FROM
            xyqb_user_i_contact c
        LEFT JOIN xyqb_i_user u ON u.id = c.user_id
        WHERE
            c.phone_no in {0}
        AND c.created_at < '{1}';

    """.format(phone_no,apply_time)
    _df = pd.read_sql(_sql,con_realtime)
    return _df


# def getSql_userContactis_OtherUserContactis(user_id,apply_time):
#     """用户联系人是其他用户的联系人（不包括当前用户)"""
#     _sql = """
#         SELECT
#             DISTINCT (contact2.user_id) as user_id,
#             user.phone_no as phone_no,
#             user.created_at as user_created_at,
#             contact.created_at as current_contact_created_at,
#             contact2.created_at as otherusercontact_created_at
#         FROM xyqb_user_i_contact as contact
#         LEFT JOIN xyqb_user_i_contact as contact2 on contact.phone_no = contact2.phone_no
#         LEFT JOIN xyqb_user_i_user as user on user.id = contact2.user_id
#         WHERE contact.user_id = {0}
#         AND contact2.user_id != {0}
#         AND contact.created_at < '{1}'
#         AND contact2.created_at < '{1}'
#     """.format(user_id,apply_time)
#     _df = pd.read_sql(_sql,con = con_realtime)
#     return _df

def getSql_userContactis_OtherUserContactis(user_id,apply_time,contact_phone):
    """用户联系人是其他用户的联系人（不包括当前用户)"""
    _sql = """
    select * from (
        SELECT
            contact2.user_id user_id,
            user.phone_no as phone_no,
            user.created_at as user_created_at,
            contact.created_at as current_contact_created_at,
            contact2.created_at as otherusercontact_created_at,
            contact.phone_no as contact_phone_no
        FROM xyqb_user_i_contact as contact
        LEFT JOIN xyqb_user_i_contact as contact2 on contact.phone_no = contact2.phone_no
        LEFT JOIN xyqb_user_i_user as user on user.id = contact2.user_id
        where contact.user_id = {0}
        and contact2.user_id != {0}
        AND contact.created_at < '{1}'
        AND contact2.created_at < '{1}'
        and contact.phone_no in {2}
        )as t1
        where t1.phone_no != t1.contact_phone_no
    """.format(user_id,apply_time,contact_phone)
    _df = pd.read_sql(_sql,con = con_realtime)
    return _df

def getSql_ContactGetUser(user_phone,created_at):
    """查询手机号获取用户信息"""
    _sql = """

        select id as user_id,phone_no,created_at
        from xyqb_i_user
        where phone_no in {0}
        and created_at < '{1}'
    """.format(user_phone,created_at)
    # and c.created_at < '{1}';

    _df = pd.read_sql(_sql,con_realtime)
    return _df
