import pandas as pd
from config.concat_sql import *

def getSql_userApplyQuotaRecord_apply_from(user_id):
   """通过用户ID 查询用户的历史提交申请次数,包括新的申请提交方式和老的申请提交方式 ,apply_status 1 拒绝,0 通过, 对渠道不做限制"""
   _sql = """
      SELECT
      l.user_id,
      l.id loan_id,
      e.order_no,
      if(ls.created_at is not null,
         ls.created_at,
         l.created_at) as apply_time,
      if(l.progress in (6, 8, 19), 1, 0) apply_status,
      l.created_from as apply_from
      FROM  loan_application_history l
      LEFT JOIN loan_account_ext e  ON e.loan_id = l.id
      left join loan_submit_info ls on ls.loan_id = l.id
      WHERE l.user_id in {0}
      AND e.loan_id IS NULL
      union
      select
      aqr.user_id ,
      lae.loan_id,
      aqr.order_no,
      aqr.apply_time,
      case when aqr.apply_status = 1 then 1
            else 0 end as apply_status,
      aqr.apply_from
      from apply_quota_record as aqr
      left join loan_account_ext as lae on lae.order_no = aqr.order_no
      where aqr.user_id in {0}
   """.format(user_id)
   _df = pd.read_sql(_sql,con = con_tuomin_xyqb)
   return _df

def getSql_RevealTheBottomChannel(user_id,apply_time):
   """获取用户所有兜底渠道订单"""
   _sql = """
      SELECT m.*
      FROM loan_application_history l
      JOIN loan_application_manifest_history m ON l.id = m.loan_application_history_id
      WHERE l.user_id in {0}
      AND l.progress IN (15,16,65)
      AND l.business_type = 9
      and m.loan_paid_at < '{1}'
      order by m.loan_paid_at desc
   """.format(user_id,apply_time)
   _df = pd.read_sql(_sql,con = con_tuomin_xyqb)
   return _df


def getSql_loanAll(user_id):
   """获取用户所有放款订单明细 business_type 9 兜底"""
   _sql = """
        select
         IFNULL(aqr.order_no ,'') order_no,loan.business_type
        ,loan.user_id,loan.id as loan_id,loan.progress,fest.contract_loan_amount,fest.loan_paid_at,fest.monthly_interest_rate
        ,case when loan.created_at >='2018-05-08' then aqr.apply_from
            when loan.created_at < '2018-05-08' then loan.created_from
            else null
            end as applied_from
        ,if (sub.created_at is not null, sub.created_at ,loan.created_at) apply_time
        ,plan.id as plan_id,plan.term_no, plan.repayment_status, plan.deadline as deadline,DATE_ADD(plan.deadline,INTERVAL 1 second) as deadline_new
        ,plan.repaid_at
        ,plan.current_repayment,plan.required_repayment
        from loan_application_manifest_history as fest
        left join loan_application_history as loan on fest.loan_application_history_id = loan.id
        left join loan_submit_info as sub on sub.loan_id = loan.id
        left join repay as plan on plan.loan_application_history_id = loan.id
        left join repayment_record as record on record.repayment_plan_id = plan.id
        left join loan_account_ext as lae on lae.loan_id = loan.id
        left join apply_quota_record as aqr on aqr.order_no = lae.order_no
        where
        loan.user_id in {}
        and loan.progress in (15,16,65)
        and fest.transaction_status in (2,5)
        and loan.business_type in (0,2,4,6,9)
        order by loan.id,plan.id
    """.format(user_id)
   _df = pd.read_sql(_sql,con_tuomin_xyqb)
   return _df