
# -*- coding:utf-8 -*-
from config import read_properties
from config import settings
from features import CONFIG_FEATURES
import pandas as pd
import re
class Mapping():
    """Mapping 操作"""


    subclasses = pd.DataFrame(CONFIG_FEATURES.subclasses)
    subclasses['package_filename'] = subclasses['package'] +'.'+ subclasses['filename']

    def __init__(self):
        """初始化mapping文档"""
        print('初始化 Mapping ......')

        _dataPath = read_properties.get_config().get_by_name('path','data_path')
        self._reportPath = read_properties.get_config().get_by_name('path','report_path')
        #
        # _columns_Basics = pd.read_excel(settings.FILE_PATH+_dataPath+'feature_基础特征.xlsx',sheet_name='字段对应关系')
        # self.Mapping_Basics = self._get_needs(_columns_Basics)
        #
        # _columns_Complex_order = pd.read_excel(settings.FILE_PATH+_dataPath+'feature_多订单的新特征.xlsx',sheet_name='字段对应关系')
        # self.Mapping_Complex_order = self._get_needs(_columns_Complex_order)
        #
        # _columns_Collection = pd.read_excel(settings.FILE_PATH+_dataPath+'feature_催收模型特征_v1.xlsx',sheet_name='字段对应关系')
        # self.Mapping_Collection = self._get_needs(_columns_Collection)

        self._columns = pd.read_excel(settings.FILE_PATH+_dataPath+'feature_mapping.xlsx',sheet_name='字段对应关系')
        self.mapping_all = self._get_needs(self._columns)


        print('完成初始化 Mapping ......')

    @classmethod
    def _get_subclasses(self):
        return self.subclasses

    @classmethod
    def _get_needs(self,df):
        """根据mapping 文档:
        1. 筛选需要测试的特征
        2. 拼装特征信息
        :return mapping 拼装信息
        """
        df = df.loc[df['是否回归测试'] == 1]
        df = df.fillna('')

        if df.empty:
            return "没有可测试的字段"

        if 'package_filename' not in df.columns.tolist():
            df['package_filename'] = ''
        if '特征组合' not in df.columns.tolist():
            df['特征组合'] = 400

        df.loc[(df['特征组合']=='')|(df['特征组合']==400),'特征组合'] = 400

        df['特征组合_list'] = df['特征组合'].apply(lambda x : self.get_split(x))

        name = df['特征平台特征字段名称'].tolist()
        rename = df['需求字段名'].tolist()

        df = df.apply(lambda x : self._set_rename_El(x,dict(zip(name,rename))) ,axis = 1)


        _needs_name = df['需求字段名'].tolist()
        _needs_desc = df['字段含义'].tolist()
        _features_name = df['特征平台特征字段名称'].tolist()
        _package_filename = df['package_filename'].tolist()
        _features = df['特征组合'].tolist()
        _features_list = df['特征组合_list'].tolist()
        _needs = {}
        df = df[['需求字段名','字段含义','特征平台特征字段名称','package_filename','特征组合','特征组合_list']]
        for i in range(len(_needs_name)):
            _needs[_needs_name[i]] = [_features_name[i],_needs_desc[i],_package_filename[i],_features[i],_features_list[i]]
        return df

    @classmethod
    def _set_rename_El(self,x,rename):

        if x['特征组合']!=400:
            for i in range(len(x['特征组合_list'])):
                x['特征组合_list'][i] = x['特征组合_list'][i].strip()
                if str(x['特征组合_list'][i]) in list(rename.keys()):
                    x['特征组合'] = x['特征组合'].replace(x['特征组合_list'][i],rename[x['特征组合_list'][i]])
                    x['特征组合_list'][i] = rename[x['特征组合_list'][i]]
                else:
                    x['特征组合_list'] = 400
        return x

    @classmethod
    def get_split(self,text):
        result_list = []
        if text != 400:
            pattern = r',|\.|/|;|\'|`|\[|\]|<|>|\?|:|"|\{|\}|\~|!|@|\$|%|\^|&|\(|\)|-|=|\+|，|。|、|；|‘|’|【|】|·|！|…|（|）'
            result_list = re.split(pattern, text)

        return result_list

    @classmethod
    def _set_Mapping_rename(self,mapping,_result,codes):
        """
        mapping : mapping 文件
        result : 接口返回的dict
        描述:修改需求字段名称,改变为特征计算字段名称
        """
        _result = self._get_El(_result)
        _k = []
        _v = []
        for k ,v in _result.items():
            _result[v['codes']] = _result.pop(k)
        for k,v in _result.items():
            _k.append(k)
            _v.append(v['codes'])

        for i,j in zip(_k,_v):
            _result[j] = _result.pop(i)

        result = {}
        for c in codes:
            if c in _result.keys():
                _r = _result.get(c)
                result.update({c:{'class':_r['class'],'desc':_r['desc'],'featrueEL':_r['featrueEL'],'value':_r['value']}})
        return result


    @classmethod
    def _get_El(self,_result):
        def set_el(result_key,_result):
            result_key = list(set(result_key))
            for k , v in _result.items():
                if v['value']!= None:
                    if isinstance(v['value'],dict):
                        exec('{} = {}'.format(k, v['value']))
                    elif isinstance(v['value'],str):
                        exec("{} = '{}'".format(k, v['value']))
                    else:
                        exec('{} = {}'.format(k, round(v['value']),6))
                    if k in result_key:
                        result_key.remove(k)
            result_key_t = result_key
            for key in result_key_t:
                featrueELL = _result[key]['featrueELL']
                istrue = True
                for i in range(len(featrueELL)):
                    if _result[featrueELL[i]]['value'] == None:
                        result_key.append(featrueELL[i])
                        istrue = False
                    else:
                        if featrueELL[i] in result_key:
                            # print(featrueELL[i])
                            result_key.remove(featrueELL[i])
                if istrue:
                    isEl = True
                    for el in _result[key]['featrueELL']:
                        if eval(el) != -9999999 and eval(el) != '-9999999' and eval(el) != '数据不存在':
                            isEl = True
                        else:
                            isEl = False
                    if isEl:
                        try :
                            _result[key]['value'] = round(eval(_result[key]['featrueEL']),6)
                        except ZeroDivisionError as z:
                            _result[key]['value'] = 0
                    else:
                        _result[key]['value'] = -9999999
                    exec('{} = {}'.format(key, round(_result[key]['value']),6))

            if result_key:
                set_el(result_key,_result)
            return _result
        result_key = []
        for k , value in _result.items():
            if value['value'] == None:
                result_key.append(k)
        _result = set_el(result_key,_result)

        return _result
