import time
from handler.Base_Handler import BaseHandler


from utils import JsonUtil
from handler.Features_old import *



class Trans_V2_Read(BaseHandler):
    def get(self):

        try:
            _business_type = self.get_argument('business_type', default=1)
            _uuid = self.get_argument('uuid', default=None)
            _orderId = self.get_argument('order_id', default=None)
            _loanId = self.get_argument('loanId', default=None)
            if _uuid == None:
                self.write(JsonUtil.build_json_with_data(data=None))
                self.flush()
                self.finish()
            _result = trans_v2_read(_uuid)
            self.write(JsonUtil.build_json_feature(businessType=int(_business_type), orderId=_orderId, loanId=_loanId,uuid = _uuid,
                                                   features=_result, flag=True))
            self.flush()
            self.finish()

        except ValueError as e:
            # == 数据类型或者字段缺少导致
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Param_Error, JsonUtil.Constants.Msg_Param_Error))
            self.flush()
        except Exception as e:
            # == 报异常，查询失败
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Error, JsonUtil.Constants.Msg_Error))
            self.flush()

    pass


def trans_v2_read(uuid):
    ret_j = {}

    ret_j["cell_zhujiaoRatio_3mon_v2"] = cell_zhujiaoRatio_3mon_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_meanMonCallno_v2"] = cell_meanMonCallno_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_meanMonCallLong_v2"] = cell_meanMonCallLong_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_relateCellRatio_v2"] = cell_relateCellRatio_v2(unicom_call_info, uuid)[uuid]
    ret_j["tel_cntMonth_v2"] = tel_cntMonth_v2(phone_bill_info, uuid)[uuid]
    ret_j["tel_meanCPay_v2"] = tel_meanCPay_v2(phone_bill_info, uuid)[uuid]
    ret_j["tel_minCPay_v2"] = tel_minCPay_v2(phone_bill_info, uuid)[uuid]
    #
    ret_j["flow_meanFlow_v2"] = flow_meanFlow_v2(unicom_flow_info, uuid)[uuid]
    ret_j["cell_callno_v2"] = cell_callno_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_callno_1mon_v2"] = cell_callno_1mon_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_callno_3mon_v2"] = cell_callno_3mon_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_localcallRatio_v2"] = cell_localcallRatio_v2(unicom_call_info, uuid)[uuid]
    #
    v = cell_callLong_1mon_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_callLong_1mon_v2"] = int(v)

    v = cell_callLong_3mon_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_callLong_3mon_v2"] = int(v)

    ret_j["cell_cntRelate_v2"] = cell_cntRelate_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_cnRelate_1mon_v2"] = cell_cnRelate_1mon_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_cnRelate_3mon_v2"] = cell_cnRelate_3mon_v2(unicom_call_info, uuid)[uuid]
    ret_j["cell_cellRatio_1mon_v2"] = cell_cellRatio_1mon_v2(unicom_call_info, uuid)[uuid]
    ret_j["last_contact_time_v2"] = cell_cellRatio_1mon_v2(unicom_call_info, uuid)[uuid]
    #
    v = mobileLocationNum_v2(unicom_call_info, uuid)[uuid]
    ret_j["mobileLocationNum_v2"] = int(v)
    #
    ret_j["callRecordIntervalMore60DaysRate_v2"] = callRecordIntervalMore60DaysRate_v2(unicom_call_info, uuid)[uuid]
    ret_j["callRecordInterval_v2"] = callRecordInterval_v2(unicom_call_info, uuid)[uuid]

    v = fst_zj_num_v2(unicom_call_info, uuid)[uuid]
    ret_j["fst_zj_num_v2"] = int(v)

    v = fst_contact_num_v2(unicom_call_info, uuid)[uuid]
    ret_j["fst_contact_num_v2"] = int(v)
    #
    v = sec_contact_num_v2(unicom_call_info, uuid)[uuid]
    ret_j["sec_contact_num_v2"] = int(v)
    #
    v = tenth_contact_num_v2(unicom_call_info, uuid)[uuid]
    ret_j["tenth_contact_num_v2"] = int(v)
    #
    ret_j["max_contact_itv_3_v2"] = max_contact_itv_3_v2(unicom_call_info, uuid)[uuid]
    ret_j["min_contact_itv_10_v2"] = min_contact_itv_10_v2(unicom_call_info, uuid)[uuid]
    ret_j["top5PhoneApplyNum_v2"] = top5PhoneApplyNum_v2(unicom_call_info, uuid)[uuid]
    ret_j["cont_nuser_rank10_v2"] = cont_nuser_rank10_v2(unicom_call_info, uuid)[uuid]
    ret_j["cont_nuser_zj_v2"] = cont_nuser_zj_v2(unicom_call_info, uuid)[uuid]
    ret_j["cont_nuser_cnt3_v2"] = cont_nuser_cnt3_v2(unicom_call_info, uuid)[uuid]
    ret_j["cont_nuser_day30_v2"] = cont_nuser_day30_v2(unicom_call_info, uuid)[uuid]
    ret_j["cont_day_max_v2"] = cont_day_max_v2(unicom_call_info, uuid)[uuid]
    #
    v = cont_dur_max_v2(unicom_call_info, uuid)[uuid]
    ret_j["cont_dur_max_v2"] = int(v)

    # 废弃
    # ret_j["last_apply_loan_success"] = last_apply_loan_success(new_audit,uuid)[uuid]
    # ret_j["last_loan_amount"] = last_loan_amount(new_audit,uuid)[uuid]
    # ret_j["last_loan_overdue_days"] = last_loan_overdue_days(new_audit,uuid)[uuid]

    return ret_j

