# -*- coding:utf-8 -*-

import tornado.web
from service.Mapping import Mapping
from utils import JsonUtil
from service.Sql_server import *
from features.Base_Features import BaseFeatures

class BaseHandler(tornado.web.RequestHandler):
    # 初始化映射关系
    mapping = Mapping()
    def prepare(self):
        self.set_header('Content-Type', "application/json; charset=UTF-8")
        self._business_type = self.get_argument('business_type', default=1)
        self._uuid = self.get_argument('user_uuid', default=None)
        self._orderId = self.get_argument('order_id', default=None)
        self._loanId = self.get_argument('loan_id', default=None)
        self._termNo = self.get_argument('term_no', default=None)
        self._apply_time = self.get_argument('apply_time', default=None)
        self._channel_no = self.get_argument('channel_no', default=None)
        self._store_id = self.get_argument('store_id', default=None)
        self._snapshot_time = self.get_argument('snapshot_time', default=None)
        self._trade_no = self.get_argument('trade_no',default=None)
        self._codes = self.get_arguments('codes')
        if self._business_type:
            self._business_type = int(self._business_type)
        if self._loanId:
            self._loanId = int(self._loanId)
        if self._termNo:
            self._termNo = int(self._termNo)

        if not self._uuid:
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Params_Error,
                                           JsonUtil.Constants.Msg_Params_Error.format('user_uuid',self._uuid)))
        else:
            df_user_id = get_sql_user_id(self._uuid)
            if df_user_id.empty:
                self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Params_Error,
                                               JsonUtil.Constants.Msg_Params_Error.format('user_uuid',self._uuid)))
                self.flush()
                self.finish()
            else:
                self._user_id = int(df_user_id.user_id.values[0])

        if not self._codes:
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Params_Error,
                                           JsonUtil.Constants.Msg_Params_Error.format('codes',self._codes)))
            self.flush()
            self.finish()












