# -*- coding:utf-8 -*-
from service.Sql_server import *
from collections import defaultdict
from dateutil.relativedelta import relativedelta

import datetime

def f_loanPostFeatures(_df,loanId='',termNo='',user_id=None,orderId=None):
    if loanId == '' or termNo == '':
        return None

    loanId = int(loanId)
    termNo = int(termNo)

    _result = defaultdict(dict)

    _df['deadline_new'] = _df['deadline_new'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d'))
    _df['deadline'] = _df['deadline'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d'))
    _df['repaid_at'] = _df['repaid_at'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d'))
    _df['repaid_at'] = pd.to_datetime(_df['repaid_at'])
    _df['deadline_new'] = pd.to_datetime(_df['deadline_new'])
    _df['deadline'] = pd.to_datetime(_df['deadline'])
    _df['updated_at'] = pd.to_datetime(_df['updated_at'])

    df_current_loan = _df.loc[(_df['loan_id'] == loanId)&(_df['term_no'] == termNo)]
    planId = df_current_loan['plan_id'].values[0]
    deadLine = df_current_loan['deadline_new'].tolist()[0]

    _df.loc[(_df['repayment_status']==3)&(_df['repaid_at'] < deadLine),'passdue_day'] = (_df['repaid_at'] - _df['deadline']).dt.days
    _df.loc[(_df['repayment_status']==3)&(_df['repaid_at'] > deadLine)&(_df['deadline'] < deadLine),'passdue_day'] = (deadLine - _df['deadline']).dt.days
    _df.loc[(_df['repayment_status']!=3)&(_df['repaid_at'] > deadLine)&(_df['deadline'] < deadLine),'passdue_day'] = (deadLine - _df['deadline']).dt.days

    _df.loc[_df['passdue_day']>0,'is_overdue'] = 1
    _df.loc[_df['repaid_at'] > deadLine,'repayment_status'] = 0

    _df_one = _df.loc[(_df['plan_id'] <= planId)
                      &(( _df['updated_at'] < deadLine)
                        & ( _df['progress'] == 16))] # 截取

    _df_two = _df.loc[(_df['loan_id'].isin([loanId]))&(_df['plan_id'] <= planId)] # 截取

    _df = pd.concat([_df_one,_df_two],axis=0)

    # _df.loc[_df['repaid_at'] > deadLine,'passdue_day'] = 0
    # _df.loc[_df['repaid_at'] > deadLine,'passdue_day'] = 0

    # deadLine = df_current_loan['deadline'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00')).values[0]
    # _df = _df.loc[_df['plan_id'] <= planId]



    # 历史最大逾期天数:逾期天数：还款日-deadline，负数表示未逾期；如果没有历史订单（首申首贷和复申首贷的第一期），则为-9999999

    df_temp = _df.loc[(_df['loan_id'] == loanId) | (_df['progress']== 16)]

    if df_temp.empty:
        max_delq_days = -9999999
    else:
        max_delq_days = df_temp['passdue_day'].max()
    _result["max_delq_days"]["value"] = int(max_delq_days)

    # 申请渠道 :申请渠道号
    df_temp = df_current_loan.loc[(df_current_loan.loan_id == loanId)
                                  & (df_current_loan.duplicated('loan_id',keep='first') == False)]
    if df_temp.empty:
        applied_from = -9999999
    else:
        applied_from  = df_temp['applied_from'].values[0]
    _result["applied_from"]["value"] = int(applied_from)

    # 现金贷合同金额 : 指本次借款
    df_temp = df_current_loan.loc[(df_current_loan.duplicated('loan_id',keep='first') == False)]
    if df_temp.empty:
        contract_loan_amt = -9999999
    else:
        contract_loan_amt = df_temp['contract_loan_amount'].values[0]
    _result["contract_loan_amt"]["value"] = float(contract_loan_amt)

    # 上次订单	上次提现最大逾期天数
    df_temp = _df.loc[(_df.loan_id < loanId)]
    if df_temp.empty:
        lstLoan_delq_day_max = -9999999
    else:
        lstLoan_delq_day_max = _df.loc[_df['loan_id'] == df_temp['loan_id'].max()]['passdue_day'].max()
    _result["lstLoan_delq_day_max"]["value"] = lstLoan_delq_day_max


    # 最近一次还款距今天数 :当前时间-最近一次还款时间，取天数；如无最近还款，则为-9999999
    # df_current_loan = _df.loc[( _df.loan_id == loanId)
    #                           &(_df['term_no'] == termNo)
    #                           ]
    # deadline = df_current_loan['deadline'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00')).values[0]
    df_temp = _df.loc[(_df.repayment_status == 3)
                     &(_df['plan_id'] < planId)]

    if df_temp.empty:
        rct_pmt_days = -9999999
    else:
        # df_temp = df_temp.loc[df_temp['plan_id']==df_temp['plan_id'].max()]
        # repaid_at = df_temp['repaid_at'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'))
        rct_pmt_days = min(list(map(lambda x:(deadLine - x).days,df_temp['repaid_at'].tolist())))
    _result["rct_pmt_days"]["value"] = rct_pmt_days


    # 账龄:当前时间-首次申请时间，取天数
    # df_current_loan = _df.loc[(_df['loan_id'] == loanId)&(_df['term_no'] == termNo)]
    # deadLine = datetime.datetime.strptime(df_current_loan['deadline'].astype(str).values[0],'%Y-%m-%d')
    _df_apply = get_sql_apply(user_id)
    _df_apply = _df_apply.loc[_df_apply['apply_time'] <= deadLine]
    # time_now = _df.loc[(_df['loan_id']== loanId) & (_df['term_no']== termNo)]['deadline'].astype(str).values[0]
        # datetime.datetime.strptime(datetime.datetime.now().strftime("%Y-%m-%d"),"%Y-%m-%d")
    apply_time = datetime.datetime.strptime(_df_apply['apply_time'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d')).min(),'%Y-%m-%d')
    age_account = (deadLine - apply_time).days
    _result["age_account"]["value"] = age_account


    # 到期期数中提前和正常还款的占比:（到期的提前还款+到期的正常还款）/所有到期期数；pmt_itv_ratio_trend
    # 如果没有历史订单（首申首贷和复申首贷的第一期），则为-9999999



    _df_plan_all = _df.loc[(_df['loan_id']==loanId) & (_df['deadline']< deadLine)]

    _repay_all = _df_plan_all['plan_id'].count()
    _repay_pass = _df_plan_all.loc[(_df_plan_all['passdue_day']<=0)
                                   &(_df_plan_all['repayment_status'] ==3)]['plan_id'].count()

    if _repay_pass >0 :
        x,y = str(float(_repay_pass/_repay_all)).split('.')
        pmt_itv_ratio_trend = float(x+'.'+y[:6])
    else:
        pmt_itv_ratio_trend = 0
    _result["pmt_itv_ratio_trend"]["value"] = pmt_itv_ratio_trend

    # 首次提现最大逾期天数	逾期天数：还款日-deadline，负数表示未逾期；如果没有首次提现（首申首贷和复申首贷），则为-9999999
    df_temp = _df.loc[_df['loan_id'] == _df['loan_id'].min()]
    if df_temp.empty:
        fstLoan_delq_day = -9999999
    else:
        # if loanId == df_temp['loan_id'].min() and termNo < df_temp['term_no'].min():
        #     fstLoan_delq_day = max((df_temp['deadline_new'] - df_temp['deadline']).dt.days)
        # else:
        fstLoan_delq_day = df_temp['passdue_day'].max()
    _result["fstLoan_delq_day"]["value"] = fstLoan_delq_day

    # 最后一次还款逾期天数	逾期天数：还款日-deadline，负数表示未逾期；如无历史还款，则为-9999999
    df_temp = _df.loc[(_df['loan_id'] <= loanId)
                      & (_df['repayment_status'] == 3)
                      & (_df['repaid_at'] <= deadLine)]
    if df_temp.empty:
        lstRepay_delq_day =  -9999999
    else:
        lstRepay_delq_day = df_temp.loc[df_temp['plan_id'] == df_temp['plan_id'].max()]['passdue_day'].values[0]
    _result["lstRepay_delq_day"]["value"] = lstRepay_delq_day


    # 逾期总金额/总额度	指本次借款，逾期总金额是指只要发生过逾期，该期的本金（principal）就计算在内，包括逾期已还
    contract_loan_amount =df_current_loan['contract_loan_amount'].sum()# _df.loc[(_df['loan_id'] == loanId)]['principal'].mean()
    passdue_amount = _df.loc[(_df['loan_id'] == loanId) & (_df['is_overdue'] == 1)]['principal'].sum()
    if contract_loan_amount > 0 and passdue_amount>0:
        x,y = str(float(passdue_amount/contract_loan_amount)).split('.')
        delq_amt_sum_r = float(x+'.'+y[:6])
    else:
        delq_amt_sum_r =0
    _result["delq_amt_sum_r"]["value"] = delq_amt_sum_r


    # monthly_pmt 每期应还本金、利息、服务费之和	当期的本金、利息和服务费之和
    df_temp = df_current_loan
    monthly_pmt =  df_temp['principal'] + df_temp['interest'] + df_temp['service_fee']
    _result["monthly_pmt"]["value"] = monthly_pmt.values[0]


    # 现金分期 申请次数	包括一单一审和循环额度
    _result['apply_cnt_all']["value"] = len(_df_apply)


    # 近6个月贷款还款金额总和	还款时间在最近6个月内的还款金额（current_repayment）求和
    from6month = datetime.datetime.strftime(deadLine - relativedelta(months=+6),'%Y-%m-%d 00:00:00')

    exc_current = _df.loc[((_df['repaid_at']>=from6month)
                            & (_df['repaid_at'] <=deadLine))
                          & (_df['repayment_status'] == 3)]

    if exc_current.empty:
        repay_amt_sum_rct_6mon = 0
    else:
        repay_amt_sum_rct_6mon = exc_current['current_repayment'].sum()

    _result["repay_amt_sum_rct_6mon"]["value"] = repay_amt_sum_rct_6mon

    # 最近两期逾期趋势	上一期逾期天数-上上一期逾期天数；如果无历史期数，为-9999999；
    # 如历史只有一期，取这一期的逾期天数；否则计算最近两期逾期天数差
    #  ==============
    df_temp = _df.sort_values('plan_id',ascending=False).fillna(0)
    _planID = df_temp.loc[(df_temp['loan_id']==loanId) & (df_temp['term_no'] == termNo)].plan_id.values[0]
    df_temp = df_temp.loc[df_temp['plan_id'] < _planID].iloc[:2]
    if df_temp.empty:
        lst2_delq_trend = -9999999
    else:
        if len(df_temp) >=2:
            _next_one = df_temp.iloc[0]['passdue_day']
            _next_two = df_temp.iloc[1]['passdue_day']
            lst2_delq_trend = int(_next_one - _next_two)
        else:
            lst2_delq_trend = df_temp.iloc[0]['passdue_day']
    _result["lst2_delq_trend"]["value"] = lst2_delq_trend

    # 上次提现首期逾期天数	如无上次提现，为-9999999；否则取上次提现的首期逾期天数
    df_temp = _df.loc[_df['loan_id'] < loanId]
    if df_temp.empty:
        lstLoan_fstTerm_delq_day = -9999999
    else:
        lstLoan_fstTerm_delq_day = df_temp.loc[(df_temp.loan_id == df_temp.loan_id.max()) & (df_temp.term_no == 1)]['passdue_day'].values[0]
    _result["lstLoan_fstTerm_delq_day"]["value"] = lstLoan_fstTerm_delq_day

    # 用户现金贷额度申请被拒绝次数	包括一单一审和循环额度(包含提现被拒 apply_quota_record = 1
    # 和 loan_application_manifest_history proguress in (6, 8, 19) )

    if _df_apply.empty:
        decline_cnt_all = 0
    else:
        if len(_df_apply.loc[_df_apply['apply_status'] == 1]) > 0:
            decline_cnt_all = _df_apply.loc[_df_apply['apply_status'] == 1]['apply_status'].sum()
        else:
            decline_cnt_all = 0

    _result["decline_cnt_all"]["value"] = decline_cnt_all



    # ind_curr_max_sumDelqAmt_rct_3mon 当前累计逾期金额是否为近3个月内最高:计算当前累积逾期金额（发生过逾期的期数的应还金额（required_repayment）求和）
    # 和近3个月累积逾期金额（deadline在近3个月内），判断两者是否相等，返回1或0

    from3month = datetime.datetime.strftime(deadLine - relativedelta(months=+3),'%Y-%m-%d')
    df_passdueall_amount = _df.loc[(_df['is_overdue'] == 1)]


    df_from3month_amount = _df[((_df['deadline'] >= from3month)
                               & (_df['is_overdue']== 1))]
    if df_passdueall_amount.empty and df_from3month_amount.empty:
        ind_curr_max_sumDelqAmt_rct_3mon = 1

    else:
        passdue_amount = float(df_passdueall_amount['required_repayment'].sum())
        from3month_amount = float(df_from3month_amount['required_repayment'].sum())
        if passdue_amount - from3month_amount > 0.00:
            ind_curr_max_sumDelqAmt_rct_3mon = 0
        else:
            ind_curr_max_sumDelqAmt_rct_3mon = 1
    _result["ind_curr_max_sumDelqAmt_rct_3mon"]["value"] = ind_curr_max_sumDelqAmt_rct_3mon


    # 当前累计逾期金额是否为近6个月内最高	计算当前累积逾期金额（发生过逾期的期数的应还金额（required_repayment）求和）
    # 和近6个月累积逾期金额（deadline在近6个月内），判断两者是否相等，返回1或0

    from6month = datetime.datetime.strftime(deadLine - relativedelta(months=+6),'%Y-%m-%d')
    df_passdue_amount_all = _df.loc[(_df['is_overdue'] == 1)
                                    &(_df['deadline'] <= deadLine)]


    df_from6month_amount = _df[(_df['deadline'] >= from6month)
                                & (_df['deadline'] <= deadLine)
                               & (_df['is_overdue'] == 1)]
    if df_passdue_amount_all.empty or df_from6month_amount.empty:
        ind_curr_max_sumDelqAmt_rct_6mon = 1
    else:
        passdue_amount = float(df_passdue_amount_all['required_repayment'].sum())
        from6month_amount = float(df_from6month_amount['required_repayment'].sum())
        if abs(passdue_amount - from6month_amount) > 0.00:
            ind_curr_max_sumDelqAmt_rct_6mon = 0
        else:
            ind_curr_max_sumDelqAmt_rct_6mon = 1
    _result["ind_curr_max_sumDelqAmt_rct_6mon"]["value"] = ind_curr_max_sumDelqAmt_rct_6mon


    return dict(_result)








