# -*- coding:utf-8 -*-
from features.Base_Features import BaseFeatures as BF
from service.Sql_server import *
import datetime
from service.Sql_collection import *
from dateutil.relativedelta import relativedelta
from service.Sql_complexOrder import *

class __INIT__(BF):
    def __init__(self):

        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF._apply_at = time_now
        BF._apply_df = pd.DataFrame()
        df_get_order = get_order_id(self.loanId)
        BF.order_id = df_get_order['order_no'].values[0]
        BF._df= self.get_init(BF.user_id,BF.loanId,BF.termNo)


    def get_init(self,user_id,loanId = '',termNo = ''):
        df_empty = pd.DataFrame()
        if loanId == '' or termNo == '':
            return None
        df = getSql_loanAll(str(tuple([self.user_id])).replace(',)', ')'))
        if df.empty == False:
            deadline_current = df.loc[(df['loan_id'] == self.loanId) & (df['term_no'] == self.termNo)]['deadline']
            if len(deadline_current) != 0:
                deadline_current_time = deadline_current.values[0]
                df = get_Loan_rollBack(df,deadline_current_time,passdueDay_Negative=True)
                return df
            else:
                return df_empty
        else:
            return df_empty


class 用户申请时改订单的申请类型状态值():
    """申请类型： 用户申请时改订单的申请类型状态值   current_loan_post_user_loan_type"""
    def feature(self):
        _用户申请时改订单的申请类型状态值 = -9999999
        df_temp_v4 = get_Application_type(self.order_id,'user_loan_type_v4')
        df_temp_v5 = get_Application_type(self.order_id, 'user_loan_type_v5')
        if df_temp_v4.empty ==False:
            df_temp_v4 = df_temp_v4.sort_values(['value'])
            applied_from  = df_temp_v4['value'].values[0]
            _用户申请时改订单的申请类型状态值 = applied_from
        if df_temp_v5.empty ==False:
            df_temp_v5 = df_temp_v5.sort_values(['value'])
            applied_from  = df_temp_v5['value'].values[0]
            _用户申请时改订单的申请类型状态值 = applied_from
        self._result["用户申请时改订单的申请类型状态值"]["value"] = _用户申请时改订单的申请类型状态值
        return self._result


class 历史最大逾期天数v2():
    """历史最大逾期天数  current_loan_post_term_delq_days"""
    def feature(self):
        _历史最大逾期天数v2 = -9999999
        if self._df.empty == False:
            self._df['deadline'] = self._df['deadline'].apply(lambda x: str(x))
            df_histroy = self._df.loc[(self._df['loan_id'] < self.loanId)&(self._df['progress']== 16)]
            df_current = self._df.loc[(self._df['loan_id'] == self.loanId) & (self._df['term_no']< self.termNo)]
            df_concat = pd.concat([df_histroy,df_current],axis=0)
            deadline_current = self._df.loc[(self._df['loan_id'] == self.loanId) & (self._df['term_no'] == self.termNo)]['deadline'].values[0]
            df_concat = df_concat.loc[(df_concat['deadline'] < deadline_current)]
            if df_concat.empty ==False:
                max_delq_days = df_concat['passdue_day'].max()
                _历史最大逾期天数v2 = max_delq_days
        self._result["历史最大逾期天数v2"]["value"] = _历史最大逾期天数v2
        return self._result

class 当前订单月还款额():
    """当前订单月还款额   current_loan_post_loan_info#monthlyRepayment"""
    def feature(self):
        _当前订单月还款额 = -9999999
        df_temp = get_order_monthly_payment(self.loanId)
        if df_temp.empty ==False:
            monthly_payment = df_temp['monthly_repayment'].sum()
            _当前订单月还款额 = monthly_payment
        self._result["当前订单月还款额"]["value"] = _当前订单月还款额
        return self._result


class 到期期数非本期中提前还款的占比():
    """到期期数非本期中提前还款的占比  current_loan_post_advance_repay_rate"""
    def feature(self):
        _到期期数非本期中提前还款的占比 = -9999999
        if self._df.empty == False:
            self._df['deadline'] = self._df['deadline'].apply(lambda x: str(x))
            df_histroy = self._df.loc[(self._df['loan_id'] < self.loanId)&(self._df['progress']== 16)]
            df_current = self._df.loc[(self._df['loan_id'] == self.loanId) & (self._df['term_no']< self.termNo)]
            df_concat = pd.concat([df_histroy,df_current],axis=0)
            deadline_current = self._df.loc[(self._df['loan_id'] == self.loanId) & (self._df['term_no'] == self.termNo)]['deadline'].values[0]
            df_concat = df_concat.loc[(df_concat['deadline'] < deadline_current) ]
            if df_concat.empty ==False:
                df_temp_first = df_concat[df_concat['passdue_day'] < 0]
                monthly_payment = len(df_temp_first) / len(df_concat)
                _到期期数非本期中提前还款的占比 = round(monthly_payment,6)
        self._result["到期期数非本期中提前还款的占比"]["value"] = _到期期数非本期中提前还款的占比
        return self._result





