# -*- coding:utf-8 -*-
from features.Base_Features import BaseFeatures as BF
from service.Sql_server import *
import datetime
from dateutil.relativedelta import relativedelta


class __INIT__(BF):
    def __init__(self):

        BF._df,BF.df_current_loan,BF.planId,BF.deadLine = self.get_init(BF.user_id,BF.loanId,BF.termNo) # 给父类变量进行复制
        BF.df_apply = get_sql_apply(self.user_id) # 获取用户申请次数
        BF.df_apply = BF.df_apply .loc[BF.df_apply['apply_time'] <= BF.deadLine]
        pass

    def get_init(self,user_id,loanId = '',termNo = ''):
        if loanId == '' or termNo == '':
            return None
        df = get_sql_user_loan_all(str(tuple([user_id])).replace(',)',')'))
        df['deadline_new'] = df['deadline_new'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d'))
        df['deadline'] = df['deadline'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d'))
        df['repaid_at'] = df['repaid_at'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d'))
        df['repaid_at'] = pd.to_datetime(df['repaid_at'])
        df['deadline_new'] = pd.to_datetime(df['deadline_new'])
        df['deadline'] = pd.to_datetime(df['deadline'])
        df['updated_at'] = pd.to_datetime(df['updated_at'])

        df_current_loan = df.loc[(df['loan_id'] == loanId)&(df['term_no'] == termNo)]
        planId = df_current_loan['plan_id'].values[0]
        deadLine = df_current_loan['deadline_new'].tolist()[0]

        df.loc[(df['repayment_status']==3)&(df['repaid_at'] < deadLine),'passdue_day'] = (df['repaid_at'] - df['deadline']).dt.days
        df.loc[(df['repayment_status']==3)&(df['repaid_at'] > deadLine)&(df['deadline'] < deadLine),'passdue_day'] = (deadLine - df['deadline']).dt.days
        df.loc[(df['repayment_status']!=3)&(df['repaid_at'] > deadLine)&(df['deadline'] < deadLine),'passdue_day'] = (deadLine - df['deadline']).dt.days

        df.loc[df['passdue_day']>0,'is_overdue'] = 1
        df.loc[df['repaid_at'] > deadLine,'repayment_status'] = 0

        df_one = df.loc[(df['plan_id'] <= planId)
                        &(( df['updated_at'] < deadLine)
                          & ( df['progress'] == 16))] # 截取

        df_two = df.loc[(df['loan_id'].isin([loanId]))&(df['plan_id'] <= planId)] # 截取
        df = pd.concat([df_one,df_two],axis=0)
        return df,df_current_loan,planId,deadLine


class max_delq_days():
    """历史最大逾期天数:逾期天数：还款日-deadline，负数表示未逾期；如果没有历史订单（首申首贷和复申首贷的第一期），则为-9999999"""
    def feature(self):
        df_temp = self._df.loc[(self._df['loan_id'] == self.loanId) | (self._df['progress']== 16)]
        if df_temp.empty:
            max_delq_days = -9999999
        else:
            max_delq_days = df_temp['passdue_day'].max()
        self._result["max_delq_days"]["value"] = max_delq_days
        return self._result

class applied_from():
    """申请渠道 :申请渠道号"""
    def feature(self):
        df_temp = self.df_current_loan.loc[(self.df_current_loan.loan_id == self.loanId)
                                      & (self.df_current_loan.duplicated('loan_id',keep='first') == False)]
        if df_temp.empty:
            applied_from = -9999999
        else:
            applied_from  = df_temp['applied_from'].values[0]
        self._result["applied_from"]["value"] = int(applied_from)
        return self._result

class contract_loan_amt():
    """现金贷合同金额 : 指本次借款"""
    def feature(self):
        df_temp = self.df_current_loan.loc[(self.df_current_loan.duplicated('loan_id',keep='first') == False)]
        if df_temp.empty:
            contract_loan_amt = -9999999
        else:
            contract_loan_amt = df_temp['contract_loan_amount'].values[0]

        self._result["contract_loan_amt"]["value"] = float(contract_loan_amt)
        return self._result

class lstLoan_delq_day_max():
    """上次订单	上次提现最大逾期天数"""
    def feature(self):

        df_temp = self._df.loc[(self._df['loan_id'] < self.loanId)]
        if df_temp.empty:
            lstLoan_delq_day_max = -9999999
        else:
            lstLoan_delq_day_max = self._df.loc[self._df['loan_id'] == df_temp['loan_id'].max()]['passdue_day'].max()
        self._result["lstLoan_delq_day_max"]["value"] = lstLoan_delq_day_max
        return self._result

class rct_pmt_days():
    """最近一次还款距今天数 :当前时间-最近一次还款时间，取天数；如无最近还款，则为-9999999"""
    def feature(self):

        df_temp = self._df.loc[(self._df['repayment_status'] == 3)
                      &(self._df['plan_id'] < self.planId)]
        if df_temp.empty:
            rct_pmt_days = -9999999
        else:
            # df_temp = df_temp.loc[df_temp['plan_id']==df_temp['plan_id'].max()]
            # repaid_at = df_temp['repaid_at'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'))
            rct_pmt_days = min(list(map(lambda x:(self.deadLine - x).days,df_temp['repaid_at'].tolist())))
        self._result["rct_pmt_days"]["value"] = rct_pmt_days
        return self._result

class age_account():
    """账龄:当前时间-首次申请时间，取天数"""

    def feature(self):

        apply_time = datetime.datetime.strptime(self.df_apply['apply_time'].apply(lambda x : datetime.datetime.strftime(x,'%Y-%m-%d')).min(),'%Y-%m-%d')
        age_account = (self.deadLine - apply_time).days
        self._result["age_account"]["value"] = age_account
        return self._result

class pmt_itv_ratio_trend():
    """（到期的提前还款+到期的正常还款）/所有到期期数；如果没有历史订单（首申首贷和复申首贷的第一期），则为-9999999"""

    def feature(self):
        _df_plan_all = self._df.loc[(self._df['loan_id']==self.loanId) & (self._df['deadline']< self.deadLine)]

        _repay_all = _df_plan_all['plan_id'].count()
        _repay_pass = _df_plan_all.loc[(_df_plan_all['passdue_day']<=0)
                                       &(_df_plan_all['repayment_status'] ==3)]['plan_id'].count()

        if _repay_pass >0 :
            x,y = str(float(_repay_pass/_repay_all)).split('.')
            pmt_itv_ratio_trend = float(x+'.'+y[:6])
        else:
            pmt_itv_ratio_trend = 0
        self._result["pmt_itv_ratio_trend"]["value"] = pmt_itv_ratio_trend

        return self._result


class fstLoan_delq_day():
    """首次提现最大逾期天数	逾期天数：还款日-deadline，负数表示未逾期；如果没有首次提现（首申首贷和复申首贷），则为-9999999"""
    def feature(self):
        df_temp = self._df.loc[self._df['loan_id'] == self._df['loan_id'].min()]
        if df_temp.empty:
            fstLoan_delq_day = -9999999
        else:
            # if loanId == df_temp['loan_id'].min() and termNo < df_temp['term_no'].min():
            #     fstLoan_delq_day = max((df_temp['deadline_new'] - df_temp['deadline']).dt.days)
            # else:
            fstLoan_delq_day = df_temp['passdue_day'].max()
        self._result["fstLoan_delq_day"]["value"] = fstLoan_delq_day
        return self._result

class lstRepay_delq_day():
    """最后一次还款逾期天数	逾期天数：还款日-deadline，负数表示未逾期；如无历史还款，则为-9999999"""
    def feature(self):


        df_temp = self._df.loc[(self._df['loan_id'] <= self.loanId)
                          & (self._df['repayment_status'] == 3)
                          & (self._df['repaid_at'] <= self.deadLine)]
        if df_temp.empty:
            lstRepay_delq_day =  -9999999
        else:
            lstRepay_delq_day = df_temp.loc[df_temp['plan_id'] == df_temp['plan_id'].max()]['passdue_day'].values[0]
        self._result["lstRepay_delq_day"]["value"] = lstRepay_delq_day
        return self._result


class delq_amt_sum_r():
    """逾期总金额/总额度	指本次借款，逾期总金额是指只要发生过逾期，该期的本金（principal）就计算在内，包括逾期已还"""

    def feature(self):
        contract_loan_amount =self.df_current_loan['contract_loan_amount'].sum()# _df.loc[(_df['loan_id'] == loanId)]['principal'].mean()
        passdue_amount = self._df.loc[(self._df['loan_id'] == self.loanId) & (self._df['is_overdue'] == 1)]['principal'].sum()
        if contract_loan_amount > 0 and passdue_amount>0:
            x,y = str(float(passdue_amount/contract_loan_amount)).split('.')
            delq_amt_sum_r = float(x+'.'+y[:6])
        else:
            delq_amt_sum_r =0
        self._result["delq_amt_sum_r"]["value"] = delq_amt_sum_r
        return self._result


class monthly_pmt():
    """每期应还本金、利息、服务费之和 - 当期的本金、利息和服务费之和"""
    def feature(self):
        df_temp = self.df_current_loan
        monthly_pmt =  df_temp['principal'] + df_temp['interest'] + df_temp['service_fee']
        self._result["monthly_pmt"]["value"] = monthly_pmt.values[0]
        return self._result


class apply_cnt_all():
    """现金分期 申请次数	包括一单一审和循环额度"""
    def feature(self):

        self._result['apply_cnt_all']["value"] = len(self.df_apply)
        return self._result


class repay_amt_sum_rct_6mon():
    """近6个月贷款还款金额总和"""
    def feature(self):

        from6month = datetime.datetime.strftime(self.deadLine - relativedelta(months=+6),'%Y-%m-%d 00:00:00')

        exc_current = self._df.loc[((self._df['repaid_at']>=from6month)
                               & (self._df['repaid_at'] <=self.deadLine))
                              & (self._df['repayment_status'] == 3)]

        if exc_current.empty:
            repay_amt_sum_rct_6mon = 0
        else:
            repay_amt_sum_rct_6mon = exc_current['current_repayment'].sum()

        self._result["repay_amt_sum_rct_6mon"]["value"] = repay_amt_sum_rct_6mon
        return self._result

class lst2_delq_trend():
    """最近两期逾期趋势"""

    # # 上一期逾期天数-上上一期逾期天数；如果无历史期数，为-9999999；
    # # 如历史只有一期，取这一期的逾期天数；否则计算最近两期逾期天数差
    def feature(self):
        df_temp = self._df.sort_values('plan_id',ascending=False).fillna(0)
        _planID = df_temp.loc[(df_temp['loan_id']==self.loanId) & (df_temp['term_no'] == self.termNo)]['plan_id'].values[0]
        df_temp = df_temp.loc[df_temp['plan_id'] < _planID].iloc[:2]
        if df_temp.empty:
            lst2_delq_trend = -9999999
        else:
            if len(df_temp) >=2:
                _next_one = df_temp.iloc[0]['passdue_day']
                _next_two = df_temp.iloc[1]['passdue_day']
                lst2_delq_trend = int(_next_one - _next_two)
            else:
                lst2_delq_trend = df_temp.iloc[0]['passdue_day']
        self._result["lst2_delq_trend"]["value"] = lst2_delq_trend
        return self._result



class lstLoan_fstTerm_delq_day():
    def feature(self):

        # # 上次提现首期逾期天数	如无上次提现，为-9999999；否则取上次提现的首期逾期天数
        df_temp = self._df.loc[self._df['loan_id'] < self.loanId]
        if df_temp.empty:
            lstLoan_fstTerm_delq_day = -9999999
        else:
            lstLoan_fstTerm_delq_day = df_temp.loc[(df_temp.loan_id == df_temp.loan_id.max()) & (df_temp.term_no == 1)]['passdue_day'].values[0]
        self._result["lstLoan_fstTerm_delq_day"]["value"] = lstLoan_fstTerm_delq_day
        return self._result

class decline_cnt_all():
    """用户现金贷额度申请被拒绝次数"""
    # 用户现金贷额度申请被拒绝次数	包括一单一审和循环额度(包含提现被拒 apply_quota_record = 1
    # 和 loan_application_manifest_history proguress in (6, 8, 19) )
    def feature(self):

        if self.df_apply.empty:
            decline_cnt_all = 0
        else:
            if len(self.df_apply.loc[self.df_apply['apply_status'] == 1]) > 0:
                decline_cnt_all = self.df_apply.loc[self.df_apply['apply_status'] == 1]['apply_status'].sum()
            else:
                decline_cnt_all = 0

        self._result["decline_cnt_all"]["value"] = decline_cnt_all
        return self._result

class ind_curr_max_sumDelqAmt_rct_3mon():
    """当前累计逾期金额是否为近3个月内最高"""
    def feature(self):

    # # ind_curr_max_sumDelqAmt_rct_3mon 当前累计逾期金额是否为近3个月内最高:计算当前累积逾期金额（发生过逾期的期数的应还金额（required_repayment）求和）
    # # 和近3个月累积逾期金额（deadline在近3个月内），判断两者是否相等，返回1或0
    #
        from3month = datetime.datetime.strftime(self.deadLine - relativedelta(months=+3),'%Y-%m-%d')
        df_passdueall_amount = self._df.loc[(self._df['is_overdue'] == 1)]


        df_from3month_amount = self._df[((self._df['deadline'] >= from3month)
                                    & (self._df['is_overdue']== 1))]
        if df_passdueall_amount.empty and df_from3month_amount.empty:
            ind_curr_max_sumDelqAmt_rct_3mon = 1

        else:
            passdue_amount = float(df_passdueall_amount['required_repayment'].sum())
            from3month_amount = float(df_from3month_amount['required_repayment'].sum())
            if passdue_amount - from3month_amount > 0.00:
                ind_curr_max_sumDelqAmt_rct_3mon = 0
            else:
                ind_curr_max_sumDelqAmt_rct_3mon = 1
        self._result["ind_curr_max_sumDelqAmt_rct_3mon"]["value"] = ind_curr_max_sumDelqAmt_rct_3mon
        return self._result


class ind_curr_max_sumDelqAmt_rct_3mon():
    """当前累计逾期金额是否为近3个月内最高"""
    def feature(self):

        # # ind_curr_max_sumDelqAmt_rct_3mon 当前累计逾期金额是否为近3个月内最高:计算当前累积逾期金额（发生过逾期的期数的应还金额（required_repayment）求和）
        # # 和近3个月累积逾期金额（deadline在近3个月内），判断两者是否相等，返回1或0
        #
        from3month = datetime.datetime.strftime(self.deadLine - relativedelta(months=+3),'%Y-%m-%d')
        df_passdueall_amount = self._df.loc[(self._df['is_overdue'] == 1)]


        df_from3month_amount = self._df[((self._df['deadline'] >= from3month)
                                         & (self._df['is_overdue']== 1))]
        if df_passdueall_amount.empty and df_from3month_amount.empty:
            ind_curr_max_sumDelqAmt_rct_3mon = 1

        else:
            passdue_amount = float(df_passdueall_amount['required_repayment'].sum())
            from3month_amount = float(df_from3month_amount['required_repayment'].sum())
            if passdue_amount - from3month_amount > 0.00:
                ind_curr_max_sumDelqAmt_rct_3mon = 0
            else:
                ind_curr_max_sumDelqAmt_rct_3mon = 1
        self._result["ind_curr_max_sumDelqAmt_rct_3mon"]["value"] = ind_curr_max_sumDelqAmt_rct_3mon
        return self._result


class ind_curr_max_sumDelqAmt_rct_6mon():
    """当前累计逾期金额是否为近6个月内最高"""

    def feature(self):
         # # 当前累计逾期金额是否为近6个月内最高	计算当前累积逾期金额（发生过逾期的期数的应还金额（required_repayment）求和）
        # # 和近6个月累积逾期金额（deadline在近6个月内），判断两者是否相等，返回1或0

        from6month = datetime.datetime.strftime(self.deadLine - relativedelta(months=+6),'%Y-%m-%d')
        df_passdue_amount_all = self._df.loc[(self._df['is_overdue'] == 1)
                                             &(self._df['deadline'] <= self.deadLine)]


        df_from6month_amount = self._df[(self._df['deadline'] >= from6month)
                                        & (self._df['deadline'] <= self.deadLine)
                                        & (self._df['is_overdue'] == 1)]
        if df_passdue_amount_all.empty or df_from6month_amount.empty:
            ind_curr_max_sumDelqAmt_rct_6mon = 1
        else:
            passdue_amount = float(df_passdue_amount_all['required_repayment'].sum())
            from6month_amount = float(df_from6month_amount['required_repayment'].sum())
            if abs(passdue_amount - from6month_amount) > 0.00:
                ind_curr_max_sumDelqAmt_rct_6mon = 0
            else:
                ind_curr_max_sumDelqAmt_rct_6mon = 1
        self._result["ind_curr_max_sumDelqAmt_rct_6mon"]["value"] = ind_curr_max_sumDelqAmt_rct_6mon
        return self._result




