# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service.addresss_book_sql import *
import datetime
from service.Sql_vcc import *
import json
import time
from pandas import DataFrame
import numpy as np
from service.Sql_cheat import *
import datetime
from datetime import timedelta



class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF._apply_at = time_now
        c_list = []
        BF._apply_df = pd.DataFrame()
        if self.orderId:
            _df = get_orderid_trade(self.orderId)
            if _df.empty == False:
                BF._apply_at = datetime.datetime.strptime((_df['trade_time'].astype(str).values[0]),'%Y-%m-%d %H:%M:%S')
        start_time = '2019-07-16 00:00:00'
        BF.get_decive_info = decive_info(self.uuid, start_time, BF._apply_at)
        if BF.get_decive_info.empty ==False:
            BF.get_decive_info['body'].apply(lambda x: c_list.append(pd.DataFrame(json.loads(x), index=[0])))
            BF._apply_df = pd.concat(c_list).reset_index() # .reset_index(drop=True).sort_index()
def encode_json_manufacturer(get_decive_info,end_time,start_time):
    """进行逐行json 转换成df"""
    _apply_df = pd.DataFrame()
    t_list = []
    get_decive_info = get_decive_info[(get_decive_info['log_time'] < start_time) & (get_decive_info['log_time'] >= end_time)]
    if get_decive_info.empty == False:
        get_decive_info['body'].apply(lambda x: t_list.append(pd.DataFrame(json.loads(x), index=[0])))
        _apply_df = pd.concat(t_list).reset_index()

    return _apply_df


class 调取时间点前最后一次使用的手机品牌():
    """ device_info#manufacturer 调取时间点前最后一次使用的手机品牌"""
    def feature(self):
        _调取时间点前最后一次使用的手机品牌 = '-9999999'
        if self._apply_df.empty == False:
            if "$manufacturer" in self._apply_df.columns.tolist():
                apply_df = self._apply_df
                last_user = apply_df['$manufacturer'].dropna().tail(1).values[0]
                _调取时间点前最后一次使用的手机品牌 = str(last_user).lower()
        self._result['调取时间点前最后一次使用的手机品牌']['value'] = _调取时间点前最后一次使用的手机品牌
        return self._result



class 调取时间点前最后一次使用的手机型号():
    """device_info#model  调取时间点前最后一次使用的手机型号"""
    def feature(self):
        _调取时间点前最后一次使用的手机型号 = '-9999999'
        if self._apply_df.empty == False:
            if "$model" in self._apply_df.columns.tolist():
                apply_df = self._apply_df
                last_user = apply_df['$model'].dropna().tail(1).values[0]
                _调取时间点前最后一次使用的手机型号 = str(last_user).lower()
        self._result['调取时间点前最后一次使用的手机型号']['value'] = _调取时间点前最后一次使用的手机型号
        return self._result


class 调取时间点前所有使用的手机品牌去重后的个数():
    """ device_info#manufacturerCount 调取时间点前所有使用的手机品牌去重后的个数"""
    def feature(self):
        _调取时间点前所有使用的手机品牌去重后的个数 = 0
        if self._apply_df.empty == False:
            if "$manufacturer" in self._apply_df.columns.tolist():
                self._apply_df = self._apply_df.dropna(subset=["$manufacturer"])
                self._apply_df['$manufacturer'] = self._apply_df['$manufacturer'].apply(lambda x: str(x).lower())
                apply_df = self._apply_df.drop_duplicates(subset=['$manufacturer'])['$manufacturer'].dropna()
                last_user_count = apply_df.count()
                _调取时间点前所有使用的手机品牌去重后的个数 = last_user_count
        self._result['调取时间点前所有使用的手机品牌去重后的个数']['value'] = _调取时间点前所有使用的手机品牌去重后的个数
        return self._result



class 调取时间点前所有使用的手机型号去重后的个数():
    """ device_info#modelCount 调取时间点前所有使用的手机型号去重后的个数"""
    def feature(self):
        _调取时间点前所有使用的手机型号去重后的个数 = 0
        if self._apply_df.empty == False:
            if "$model" in self._apply_df.columns.tolist():
                self._apply_df = self._apply_df.dropna(subset = ["$model"])
                self._apply_df['$model'] = self._apply_df['$model'].apply(lambda x: str(x).lower())
                apply_df = self._apply_df.drop_duplicates(subset=['$model'])['$model'].dropna()

                last_user_count = apply_df.count()
                _调取时间点前所有使用的手机型号去重后的个数 = last_user_count
        self._result['调取时间点前所有使用的手机型号去重后的个数']['value'] = _调取时间点前所有使用的手机型号去重后的个数
        return self._result


class 调取出账日前30天内的手机品牌去重后的个数():
    """ device_info_before_bill_date#manufacturerCount  调取出账日前30天内的手机品牌去重后的个数"""
    def feature(self):
        _调取出账日前30天内的手机品牌去重后的个数 = 0
        get_vcc_data_payment = vcc_data_payment(self.user_id,self._apply_at)
        get_decive_info = self.get_decive_info
        if get_vcc_data_payment.empty ==True:
            # time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
            time_now = self._apply_at
            if (time_now.day >= 1) and (time_now.day <= 15):
                start_time = str(time_now)[0:7] + '-01' + ' 00:00:00'
            elif (time_now.day >= 16) and (time_now.day <= 31):
                start_time = str(time_now)[0:7] + '-11' + ' 00:00:00'
            end_time = datetime.datetime.strptime(start_time, '%Y-%m-%d %H:%M:%S') - datetime.timedelta(days=30)
            _apply_df = encode_json_manufacturer(get_decive_info, end_time, start_time)
            if _apply_df.empty ==False:
                if "$manufacturer" in _apply_df.columns.tolist():
                    _apply_df = _apply_df.dropna(subset=["$manufacturer"])
                    _apply_df['$manufacturer'] = _apply_df['$manufacturer'].apply(lambda x : str(x).lower())
                    apply_df = _apply_df.drop_duplicates(subset=['$manufacturer'])['$manufacturer'].dropna()
                    last_user_count = apply_df.count()
                else:
                    last_user_count = 0
            elif _apply_df.empty == True:
                last_user_count = 0

        elif get_vcc_data_payment.empty == False:
            start_time = str(get_vcc_data_payment['bill_date'].values[0]) + ' 00:00:00'
            end_time = datetime.datetime.strptime(start_time, '%Y-%m-%d %H:%M:%S') - datetime.timedelta(days=30)
            _apply_df =encode_json_manufacturer(get_decive_info,end_time,start_time)
            if _apply_df.empty ==False:
                if "$manufacturer" in _apply_df.columns.tolist():
                    _apply_df = _apply_df.dropna(subset=["$manufacturer"])
                    _apply_df['$manufacturer'] = _apply_df['$manufacturer'].apply(lambda x: str(x).lower())
                    apply_df = _apply_df.drop_duplicates(subset=['$manufacturer'])['$manufacturer'].dropna()
                    last_user_count = apply_df.count()
                else:
                    last_user_count = 0
            elif _apply_df.empty == True:
                last_user_count = 0
        _调取出账日前30天内的手机品牌去重后的个数 = last_user_count
        self._result['调取出账日前30天内的手机品牌去重后的个数']['value'] = _调取出账日前30天内的手机品牌去重后的个数
        return self._result


class 调取出账日前30天内的手机型号去重后的个数():
    """device_info_before_bill_date#modelCount  调取出账日前30天内的手机品牌去重后的个数"""
    def feature(self):
        _调取出账日前30天内的手机型号去重后的个数 = 0
        get_vcc_data_payment = vcc_data_payment(self.user_id, self._apply_at)
        get_decive_info = self.get_decive_info
        if get_vcc_data_payment.empty == True:
            time_now = self._apply_at
            if (time_now.day >= 1) and (time_now.day <= 15):
                start_time = str(time_now)[0:7] + '-01' + ' 00:00:00'
            elif (time_now.day >= 16) and (time_now.day <= 31):
                start_time = str(time_now)[0:7] + '-11' + ' 00:00:00'
            end_time = datetime.datetime.strptime(start_time, '%Y-%m-%d %H:%M:%S') - datetime.timedelta(days=30)
            _apply_df = encode_json_manufacturer(get_decive_info, end_time, start_time)
            if _apply_df.empty == False:
                if "$model" in _apply_df.columns.tolist():
                    _apply_df = _apply_df.dropna(subset=["$model"])
                    _apply_df['$model'] = _apply_df['$model'].apply(lambda x: str(x).lower())
                    apply_df = _apply_df.drop_duplicates(subset=['$model'])['$model'].dropna()
                    last_user_count = apply_df.count()
                else:
                    last_user_count = 0
            elif _apply_df.empty == True:
                last_user_count = 0

        elif get_vcc_data_payment.empty == False:
            start_time = str(get_vcc_data_payment['bill_date'].values[0]) + ' 00:00:00'
            end_time = datetime.datetime.strptime(start_time, '%Y-%m-%d %H:%M:%S') - datetime.timedelta(days=30)
            _apply_df = encode_json_manufacturer(get_decive_info, end_time, start_time)
            if _apply_df.empty == False:
                if "$model" in _apply_df.columns.tolist():
                    _apply_df = _apply_df.dropna(subset=["$model"])
                    _apply_df['$model'] = _apply_df['$model'].apply(lambda x: str(x).lower())
                    apply_df = _apply_df.drop_duplicates(subset=['$model'])['$model'].dropna()
                    last_user_count = apply_df.count()
                else:
                    last_user_count = 0
            elif _apply_df.empty == True:
                last_user_count = 0
        _调取出账日前30天内的手机型号去重后的个数 = last_user_count
        self._result['调取出账日前30天内的手机型号去重后的个数']['value'] = _调取出账日前30天内的手机型号去重后的个数
        return self._result


