# -*- coding:utf-8 -*-
import datetime
from service.Sql_contactsOperator import *
from features.Base_Features import BaseFeatures as BF

class __INIT__(BF):
    """紧急联系人运营商特征"""
    def __init__(self):
        # BF.apply_time = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF.apply_time = datetime.datetime.strptime('2019-09-19 14:00:00','%Y-%m-%d %H:%M:%S')
        if self.orderId :
            _df = getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF.apply_time = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')
        BF.user_phone = getSql_userPhone(str(tuple([self.user_id])).replace(',)',')'))['phone_no'].tolist()

        BF.df_userContactsAll = get_userContacts(str(tuple(self.user_phone)).replace(',)',')'))

        # BF.df_userOneContactsAll = pd.DataFrame() # 一度联系人
        BF.df_userTwoContacts = pd.DataFrame() # 二度联系人
        BF.receiverPhone = None

        #一度联系人
        BF.df_userOneContacts30 = pd.DataFrame()
        BF.df_userOneContacts90 = pd.DataFrame()
        BF.df_userOneContacts150 = pd.DataFrame()
        BF.df_userOneContacts300 = pd.DataFrame()

        # 一度联系人注册用户
        BF.df_userOneContactsRegister300 = pd.DataFrame()

        # 一度联系人手机号列表
        BF.receiverPhone30 = None
        BF.receiverPhone90 = None
        BF.receiverPhone150 = None
        BF.receiverPhone300 = None

        # 二度联系人
        BF.df_userTwoContacts30 = pd.DataFrame()
        BF.df_userTwoContacts90 = pd.DataFrame()
        BF.df_userTwoContacts150 = pd.DataFrame()
        BF.df_userTwoContacts300 = pd.DataFrame()

def get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(df_userContactsAll,
                                                   df_userOneContacts,
                                                   df_userOneContactsRegister,
                                                   df_userTwoContacts,
                                                   receiverPhone,
                                                   user_phone,apply_time,timesTampFDays = None,applyTimeFDays=None,ContactsNum = 2):
    """
        描述 : 近N天1度联系人在近N天内
        params: df_userContactsAll 所有联系人,在初始化文件中进行获取,
        df_userOneContacts 一度联系人 默认传入一个空的DataFrame,
        df_userTwoContacts 二度联系人 默认传入一个空的DataFrame,
        receiverPhone 一度联系人手机号,默认传入 None,
        apply_time 申请时间
        user_phone 当前用户手机号
        timesTampFDays 授权时间往前推多少天
        applyTimeFDays 申请时间往前推多少天
        ContactsNum 1 一度联系人,2 二度联系人
    """

    if df_userContactsAll.empty == False:
        if df_userOneContacts.columns.empty:
            df_userOneContacts = get_userContactsFilter(1,df_userContactsAll,apply_time,timesTampFDays = timesTampFDays,applyTimeFDays=applyTimeFDays,userPhone = user_phone)

            # 测试代码后期注释
            df_userOneContacts = df_userOneContacts.loc[(df_userOneContacts['timestamp'] >= datetime.datetime.strptime('2019-01-01 00:00:00','%Y-%m-%d %H:%M:%S'))
                                                        & (df_userOneContacts['timestamp'] < datetime.datetime.strptime('2019-06-28 00:00:00','%Y-%m-%d %H:%M:%S'))]

            if receiverPhone==None:
                receiverPhone_temp = get_PhoneNo(df_userOneContacts['receiverPhone'])
                if receiverPhone_temp:
                    receiverPhone = str(tuple(set(receiverPhone_temp))).replace(',)',')') if receiverPhone_temp else [] # 匹配手机号
                    df_userOneContactsRegister = getSql_phoneForUserId(receiverPhone) #获取一度联系人的在册用户
                    df_userOneContactsRegister.drop_duplicates(keep='first',inplace=True)
                    # 测试代码后期注释
                    df_userOneContactsRegister = df_userOneContactsRegister.loc[df_userOneContactsRegister['created_at'] < '2019-07-25 00:00:00']


        if ContactsNum == 2: # 获取二度联系人
            if df_userOneContactsRegister.empty == False:
                if df_userTwoContacts.columns.empty:
                    df_userTwoContacts = get_userContacts(str(tuple(df_userOneContactsRegister['phone_no'])).replace(',)',')')) # 获取二度联系人
                    # 测试代码后期注释
                    df_userTwoContacts.loc[(df_userTwoContacts['timestamp'] >= datetime.datetime.strptime('2019-01-01 00:00:00','%Y-%m-%d %H:%M:%S'))
                                           & (df_userTwoContacts['timestamp'] < datetime.datetime.strptime('2019-06-28 00:00:00','%Y-%m-%d %H:%M:%S'))]
    return df_userOneContacts,df_userOneContactsRegister,receiverPhone,df_userTwoContacts

class 获取一度联系人总数():
    """测试使用"""
    def feature(self):
        _获取一度联系人总数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,\
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                self.df_userOneContacts300,
                                                                                self.df_userOneContactsRegister300,
                                                                                self.df_userTwoContacts300,
                                                                                self.receiverPhone300,
                                                                                self.user_phone,
                                                                                self.apply_time,
                                                                                timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                )
        if self.df_userOneContacts300.empty == False:
            _获取一度联系人总数 = len(set(self.df_userOneContacts300['receiverPhone'].tolist()))
        self._result['获取一度联系人总数']['value'] = _获取一度联系人总数
        return self._result

class 获取一度联系人在册用户数():
    """测试使用"""
    def feature(self):
        _获取一度联系人在册用户数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300, \
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )
        if self.df_userOneContactsRegister300.empty == False:
            _获取一度联系人在册用户数 = len(set(self.df_userOneContactsRegister300['user_id']))
        self._result['获取一度联系人在册用户数']['value'] = _获取一度联系人在册用户数
        return self._result

class 获取一度联系人通话总次数():
    """测试使用"""
    def feature(self):
        _获取一度联系人通话总次数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300, \
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )
        if self.df_userOneContacts300.empty == False:
            _获取一度联系人通话总次数 = len(self.df_userOneContacts300)
        self._result['获取一度联系人通话总次数']['value'] = _获取一度联系人通话总次数
        return self._result


class 近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数():
    """"""
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数  = -9999999
        self._result['近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数']['value'] = -9999999

        self.df_userOneContacts300,self.df_userOneContactsRegister300, \
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300
                                                                                                          )
        if self.df_userTwoContacts300.empty == False:
            # 二度联系人通话记录详情
            df_CallRecord = get_userContactsFilter(2,self.df_userTwoContacts300,self.apply_time,timesTampFDays=180,applyTimeFDays = 300,
                                                   userPhone=self.user_phone,OneContactsCall = self.df_userOneContacts300['receiverPhone'])

        else:
            self._result['近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数
        return self._result


# class 近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数():
#     """"""
#     def feature(self):
#         _近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数 = -9999999
#         # 二度联系人通话记录详情
#         df_CallRecord = get_userContactsFilter(2,self.df_userTwoContacts,self.apply_time,timesTampFDays=180,applyTimeFDays = 300,
#                                userPhone=self.user_phone,OneContactsCall = self.df_userOneContactsAll['receiverPhone'])
#         if df_CallRecord.empty == False:
#             cTime_max = df_CallRecord['cTime'].max()
#             _近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数 = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S')  - datetime.datetime.strptime(cTime_max,'%Y-%m-%d %H:%M:%S')).days
#         self._result['近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人最近一次通话距本次申请的天数
#         return self._result

class 近150天1度联系人在近300天内与2度联系人最早一次通话距本次申请的天数():
    """"""
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人最早一次通话距本次申请的天数 = -9999999
        # 二度联系人通话记录详情
        df_CallRecord = get_userContactsFilter(2,self.df_userTwoContacts,self.apply_time,timesTampFDays=180,applyTimeFDays = 300,
                               userPhone=self.user_phone,OneContactsCall = self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            cTime_min = df_CallRecord['cTime'].min()
            _近150天1度联系人在近300天内与2度联系人最早一次通话距本次申请的天数 = (datetime.datetime.strptime(self.apply_time,'%Y-%m-%d %H:%M:%S')  - datetime.datetime.strptime(cTime_min,'%Y-%m-%d %H:%M:%S')).days
        self._result['近150天1度联系人在近300天内与2度联系人最早一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人最早一次通话距本次申请的天数
        return self._result


class 近150天1度联系人在近300天内与2度联系人有通话记录的总天数():
    """"""
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人有通话记录的总天数 = -9999999
        # 二度联系人通话记录详情
        df_CallRecord = get_userContactsFilter(2,self.df_userTwoContacts,self.apply_time,timesTampFDays=180,applyTimeFDays = 300,
                               userPhone=self.user_phone,OneContactsCall = self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord["cTime"] = pd.to_datetime(df_CallRecord['cTime']).dt.date
            df_CallRecord_count = df_CallRecord.drop_duplicates(['cTime'])['cTime'].count()
        _近150天1度联系人在近300天内与2度联系人有通话记录的总天数 = df_CallRecord_count
        self._result['近150天1度联系人在近300天内与2度联系人有通话记录的总天数']['value'] = _近150天1度联系人在近300天内与2度联系人有通话记录的总天数
        return self._result




class 近150天1度联系人在近300天内与2度联系人的总通话次数():
    """"""
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人的总通话次数 = -9999999
        # 二度联系人通话记录详情
        df_CallRecord = get_userContactsFilter(2,self.df_userTwoContacts,self.apply_time,timesTampFDays=180,applyTimeFDays = 300,
                               userPhone=self.user_phone,OneContactsCall = self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            receiverPhone_count = df_CallRecord['receiverPhone'].count()
            _近150天1度联系人在近300天内与2度联系人的总通话次数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人的总通话次数']['value'] = _近150天1度联系人在近300天内与2度联系人的总通话次数
        return self._result

class 近150天1度联系人在近300天内与2度联系人的总通话号码个数():
    """"""
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人的总通话号码个数 = -9999999
        # 二度联系人通话记录详情
        df_CallRecord = get_userContactsFilter(2,self.df_userTwoContacts,self.apply_time,timesTampFDays=180,applyTimeFDays = 300,
                               userPhone=self.user_phone,OneContactsCall = self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            receiverPhone_count = df_CallRecord.drop_duplicates(['receiverPhone'])['receiverPhone'].count()
            _近150天1度联系人在近300天内与2度联系人的总通话号码个数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人的总通话号码个数']['value'] = _近150天1度联系人在近300天内与2度联系人的总通话号码个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人的总通话秒数():
    """"""
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人的总通话秒数 = -9999999
        df_CallRecord = get_userContactsFilter(2,self.df_userTwoContacts,self.apply_time,timesTampFDays=180,applyTimeFDays = 300,
                               userPhone=self.user_phone,OneContactsCall = self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord_Caller_sum = df_CallRecord['tradeTime'].astype(int).sum()
            _近150天1度联系人在近300天内与2度联系人的总通话秒数 = df_CallRecord_Caller_sum
        self._result['近150天1度联系人在近300天内与2度联系人的总通话秒数']['value'] = _近150天1度联系人在近300天内与2度联系人的总通话秒数
        return self._result

class 近150天1度联系人在近300天内与2度联系人的总通话城市个数():
    """"""
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人的总通话城市个数 = -9999999
        df_CallRecord = get_userContactsFilter(2,self.df_userTwoContacts,self.apply_time,timesTampFDays=180,applyTimeFDays = 300,
                               userPhone=self.user_phone,OneContactsCall = self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord_city = df_CallRecord.drop_duplicates(['tradeAddr'])['tradeAddr'].count()
            _近150天1度联系人在近300天内与2度联系人的总通话城市个数 = df_CallRecord_city
        self._result['近150天1度联系人在近300天内与2度联系人的总通话城市个数']['value'] = _近150天1度联系人在近300天内与2度联系人的总通话城市个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top1的最近一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top1的最近一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2,self.df_userTwoContacts,self.apply_time,timesTampFDays=180,applyTimeFDays = 300,
                               userPhone=self.user_phone,OneContactsCall = self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            call_record = []
            for g, value in df_CallRecord.groupby(['receiverPhone']):
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone': df['receiverPhone'].values[0],
                                    'count': df['phone'].count(),
                                    'tradeTime': df['tradeTime'].sum(),
                                    'lastTime': df['cTime'].max()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record = df_call_record.loc[df_call_record['count'] == df_call_record['count'].max()]
            df_call_record['lastTime'] = df_call_record['lastTime'].astype(str)
            call_record_value = df_call_record['lastTime'].values[0]
            call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(call_record_value,'%Y-%m-%d %H:%M:%S')).days
            _近150天1度联系人在近300天内与2度联系人通话次数top1的最近一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top1的最近一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top1的最近一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top1的最早一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top1的最早一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            call_record = []
            for g, value in df_CallRecord.groupby(['receiverPhone']):
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone': df['receiverPhone'].values[0],
                                    'count': df['phone'].count(),
                                    'tradeTime': df['tradeTime'].sum(),
                                    'lastTime': df['cTime'].min()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record = df_call_record.loc[df_call_record['count'] == df_call_record['count'].max()]
            df_call_record['lastTime'] = df_call_record['lastTime'].astype(str)
            call_record_value = df_call_record['lastTime'].values[0]
            call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(call_record_value, '%Y-%m-%d %H:%M:%S')).days
            _近150天1度联系人在近300天内与2度联系人通话次数top1的最早一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top1的最早一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top1的最早一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top1的有通话记录的总天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top1的有通话记录的总天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:1]['index'].values[0]
            df_CallRecord_top1 = df_CallRecord[df_CallRecord['receiverPhone'] == telephone_many_value]
            df_CallRecord_top1["cTime"] = pd.to_datetime(df_CallRecord_top1['cTime']).dt.date
            df_CallRecord_count = df_CallRecord_top1.drop_duplicates(['cTime'])['cTime'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top1的有通话记录的总天数 = df_CallRecord_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top1的有通话记录的总天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top1的有通话记录的总天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top1的总通话次数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话次数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:1]['index'].values[0]
            df_CallRecord_top1 = df_CallRecord[df_CallRecord['receiverPhone'] == telephone_many_value]
            receiverPhone_count = df_CallRecord_top1['receiverPhone'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话次数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top1的总通话次数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话次数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top1的总通话号码个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话号码个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:1]['index'].values[0]
            df_CallRecord_top1 = df_CallRecord[df_CallRecord['receiverPhone'] == telephone_many_value]
            receiverPhone_count = df_CallRecord_top1.drop_duplicates(['receiverPhone'])['receiverPhone'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话号码个数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top1的总通话号码个数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话号码个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top1的总通话秒数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话秒数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:1]['index'].values[0]
            df_CallRecord_top1 = df_CallRecord[df_CallRecord['receiverPhone'] == telephone_many_value]
            receiverPhone_sum = df_CallRecord_top1['tradeTime'].astype(int).sum()
            _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话秒数 = receiverPhone_sum
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top1的总通话秒数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话秒数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top1的总通话城市个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话城市个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:1]['index'].values[0]
            df_CallRecord_top1 = df_CallRecord[df_CallRecord['receiverPhone'] == telephone_many_value]
            df_CallRecord_city = df_CallRecord_top1.drop_duplicates(['tradeAddr'])['tradeAddr'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话城市个数 = df_CallRecord_city
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top1的总通话城市个数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top1的总通话城市个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top3的最近一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top3的最近一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:3]['index'].to_list()
            df_CallRecord_top3 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_top3_max = df_CallRecord_top3['cTime'].max()
            call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_top3_max), '%Y-%m-%d %H:%M:%S')).days

            _近150天1度联系人在近300天内与2度联系人通话次数top3的最近一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top3的最近一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top3的最近一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top3的最早一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top3的最早一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:3]['index'].to_list()
            df_CallRecord_top3 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_top3_min = df_CallRecord_top3['cTime'].min()
            call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_top3_min), '%Y-%m-%d %H:%M:%S')).days

            _近150天1度联系人在近300天内与2度联系人通话次数top3的最早一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top3的最早一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top3的最早一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top3有通话记录的总天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top3有通话记录的总天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:3]['index'].to_list()
            df_CallRecord_top3 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_top3["cTime"] = pd.to_datetime(df_CallRecord_top3['cTime']).dt.date
            df_CallRecord_count = df_CallRecord_top3.drop_duplicates(['cTime'])['cTime'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top3有通话记录的总天数 = df_CallRecord_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top3有通话记录的总天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top3有通话记录的总天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top3的总通话次数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话次数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:3]['index'].to_list()
            df_CallRecord_top3 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            receiverPhone_count = df_CallRecord_top3['receiverPhone'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话次数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top3的总通话次数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话次数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top3的总通话号码个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话号码个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:3]['index'].to_list()
            df_CallRecord_top3 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            receiverPhone_count = df_CallRecord_top3.drop_duplicates(['receiverPhone'])['receiverPhone'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话号码个数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top3的总通话号码个数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话号码个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top3的总通话秒数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话秒数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:3]['index'].to_list()
            df_CallRecord_top3 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            receiverPhone_sum = df_CallRecord_top3['tradeTime'].astype(int).sum()
            _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话秒数 = receiverPhone_sum
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top3的总通话秒数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话秒数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top3的总通话城市个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话城市个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:3]['index'].to_list()
            df_CallRecord_top3 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_city = df_CallRecord_top3.drop_duplicates(['tradeAddr'])['tradeAddr'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话城市个数 = df_CallRecord_city
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top3的总通话城市个数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top3的总通话城市个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top5的最近一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top5的最近一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:5]['index'].to_list()
            df_CallRecord_top5 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_top5_max = df_CallRecord_top5['cTime'].max()
            call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_top5_max), '%Y-%m-%d %H:%M:%S')).days
            _近150天1度联系人在近300天内与2度联系人通话次数top5的最近一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top5的最近一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top5的最近一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top5的最早一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top5的最早一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:5]['index'].to_list()
            df_CallRecord_top5 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_top5_min = df_CallRecord_top5['cTime'].min()
            call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_top5_min), '%Y-%m-%d %H:%M:%S')).days
            _近150天1度联系人在近300天内与2度联系人通话次数top5的最早一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top5的最早一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top5的最早一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top5有通话记录的总天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top5有通话记录的总天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:5]['index'].to_list()
            df_CallRecord_top5 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_top5["cTime"] = pd.to_datetime(df_CallRecord_top5['cTime']).dt.date
            df_CallRecord_count = df_CallRecord_top5.drop_duplicates(['cTime'])['cTime'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top5有通话记录的总天数 = df_CallRecord_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top5有通话记录的总天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top5有通话记录的总天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top5的总通话次数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话次数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:5]['index'].to_list()
            df_CallRecord_top5 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            receiverPhone_count = df_CallRecord_top5['receiverPhone'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话次数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top5的总通话次数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话次数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top5的总通话号码个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话号码个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:5]['index'].to_list()
            df_CallRecord_top5 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            receiverPhone_count = df_CallRecord_top5.drop_duplicates(['receiverPhone'])['receiverPhone'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话号码个数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top5的总通话号码个数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话号码个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top5的总通话秒数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话秒数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:5]['index'].to_list()
            df_CallRecord_top5 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            receiverPhone_sum = df_CallRecord_top5['tradeTime'].astype(int).sum()
            _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话秒数 = receiverPhone_sum
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top5的总通话秒数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话秒数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top5的总通话城市个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话城市个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:5]['index'].to_list()
            df_CallRecord_top5 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_city = df_CallRecord_top5.drop_duplicates(['tradeAddr'])['tradeAddr'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话城市个数 = df_CallRecord_city
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top5的总通话城市个数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top5的总通话城市个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top10的最近一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top10的最近一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:10]['index'].to_list()
            df_CallRecord_top10 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_top10_max = df_CallRecord_top10['cTime'].max()
            call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_top10_max), '%Y-%m-%d %H:%M:%S')).days
            _近150天1度联系人在近300天内与2度联系人通话次数top10的最近一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top10的最近一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top10的最近一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top10的最早一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top10的最早一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:10]['index'].to_list()
            df_CallRecord_top10 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_top10_min = df_CallRecord_top10['cTime'].min()
            call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_top10_min), '%Y-%m-%d %H:%M:%S')).days
            _近150天1度联系人在近300天内与2度联系人通话次数top10的最早一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top10的最早一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top10的最早一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top10有通话记录的总天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top10有通话记录的总天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:10]['index'].to_list()
            df_CallRecord_top10 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_top10["cTime"] = pd.to_datetime(df_CallRecord_top10['cTime']).dt.date
            df_CallRecord_count = df_CallRecord_top10.drop_duplicates(['cTime'])['cTime'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top10有通话记录的总天数 = df_CallRecord_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top10有通话记录的总天数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top10有通话记录的总天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top10的总通话次数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话次数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:10]['index'].to_list()
            df_CallRecord_top10 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            receiverPhone_sum = df_CallRecord_top10['tradeTime'].astype(int).sum()
            _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话次数 = receiverPhone_sum
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top10的总通话次数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话次数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top10的总通话号码个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话号码个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:10]['index'].to_list()
            df_CallRecord_top10 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            receiverPhone_count = df_CallRecord_top10.drop_duplicates(['receiverPhone'])['receiverPhone'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话号码个数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top10的总通话号码个数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话号码个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top10的总通话秒数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话秒数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:10]['index'].to_list()
            df_CallRecord_top10 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            receiverPhone_sum = df_CallRecord_top10['tradeTime'].astype(int).sum()
            _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话秒数 = receiverPhone_sum
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top10的总通话秒数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话秒数
        return self._result

class 近150天1度联系人在近300天内与2度联系人通话次数top10的总通话城市个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话城市个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_telephone_index = df_CallRecord['receiverPhone'].value_counts().reset_index()
            telephone_many_value = df_telephone_index.iloc[0:10]['index'].to_list()
            df_CallRecord_top10 = df_CallRecord[df_CallRecord['receiverPhone'].isin(telephone_many_value)]
            df_CallRecord_city = df_CallRecord_top10.drop_duplicates(['tradeAddr'])['tradeAddr'].count()
            _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话城市个数 = df_CallRecord_city
        self._result['近150天1度联系人在近300天内与2度联系人通话次数top10的总通话城市个数']['value'] = _近150天1度联系人在近300天内与2度联系人通话次数top10的总通话城市个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人凌晨1至6点的最近一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人凌晨1至6点的最近一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord['cTime'] = pd.to_datetime(df_CallRecord['cTime'])
            df_CallRecord['hour_time'] = pd.to_datetime(df_CallRecord['cTime']).dt.hour
            df_CallRecord_1_6 = df_CallRecord[((df_CallRecord["hour_time"] >= 1) & (df_CallRecord["hour_time"] < 6))]
            if df_CallRecord_1_6.empty ==False:
                df_CallRecord_max = df_CallRecord_1_6['cTime'].max()
                call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_max), '%Y-%m-%d %H:%M:%S')).days
                _近150天1度联系人在近300天内与2度联系人凌晨1至6点的最近一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人凌晨1至6点的最近一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人凌晨1至6点的最近一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人凌晨1至6点的最早一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人凌晨1至6点的最早一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord['cTime'] = pd.to_datetime(df_CallRecord['cTime'])
            df_CallRecord['hour_time'] = pd.to_datetime(df_CallRecord['cTime']).dt.hour
            df_CallRecord_1_6 = df_CallRecord[((df_CallRecord["hour_time"] >= 1) & (df_CallRecord["hour_time"] < 6))]
            if df_CallRecord_1_6.empty ==False:
                df_CallRecord_min = df_CallRecord_1_6['cTime'].min()
                call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_min), '%Y-%m-%d %H:%M:%S')).days
                _近150天1度联系人在近300天内与2度联系人凌晨1至6点的最早一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人凌晨1至6点的最早一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人凌晨1至6点的最早一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人凌晨1至6点的有通话记录的总天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人凌晨1至6点的有通话记录的总天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord['cTime'] = pd.to_datetime(df_CallRecord['cTime'])
            df_CallRecord['hour_time'] = pd.to_datetime(df_CallRecord['cTime']).dt.hour
            df_CallRecord_1_6 = df_CallRecord[((df_CallRecord["hour_time"] >= 1) & (df_CallRecord["hour_time"] < 6))]
            if df_CallRecord_1_6.empty ==False:
                df_CallRecord_1_6["cTime"] = pd.to_datetime(df_CallRecord_1_6['cTime']).dt.date
                df_CallRecord_count = df_CallRecord_1_6.drop_duplicates(['cTime'])['cTime'].count()
                _近150天1度联系人在近300天内与2度联系人凌晨1至6点的有通话记录的总天数 = df_CallRecord_count
        self._result['近150天1度联系人在近300天内与2度联系人凌晨1至6点的有通话记录的总天数']['value'] = _近150天1度联系人在近300天内与2度联系人凌晨1至6点的有通话记录的总天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话次数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话次数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord['cTime'] = pd.to_datetime(df_CallRecord['cTime'])
            df_CallRecord['hour_time'] = pd.to_datetime(df_CallRecord['cTime']).dt.hour
            df_CallRecord_1_6 = df_CallRecord[((df_CallRecord["hour_time"] >= 1) & (df_CallRecord["hour_time"] < 6))]
            if df_CallRecord_1_6.empty ==False:
                receiverPhone_sum = df_CallRecord_1_6['tradeTime'].astype(int).sum()
                _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话次数 = receiverPhone_sum
        self._result['近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话次数']['value'] = _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话次数
        return self._result

class 近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话号码个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话号码个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord['cTime'] = pd.to_datetime(df_CallRecord['cTime'])
            df_CallRecord['hour_time'] = pd.to_datetime(df_CallRecord['cTime']).dt.hour
            df_CallRecord_1_6 = df_CallRecord[((df_CallRecord["hour_time"] >= 1) & (df_CallRecord["hour_time"] < 6))]
            if df_CallRecord_1_6.empty ==False:
                receiverPhone_count = df_CallRecord_1_6.drop_duplicates(['receiverPhone'])['receiverPhone'].count()
                _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话号码个数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话号码个数']['value'] = _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话号码个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话秒数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话秒数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord['cTime'] = pd.to_datetime(df_CallRecord['cTime'])
            df_CallRecord['hour_time'] = pd.to_datetime(df_CallRecord['cTime']).dt.hour
            df_CallRecord_1_6 = df_CallRecord[((df_CallRecord["hour_time"] >= 1) & (df_CallRecord["hour_time"] < 6))]
            if df_CallRecord_1_6.empty ==False:
                receiverPhone_sum = df_CallRecord_1_6['tradeTime'].astype(int).sum()
                _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话秒数 = receiverPhone_sum
        self._result['近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话秒数']['value'] = _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话秒数
        return self._result

class 近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话城市个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话城市个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            df_CallRecord['cTime'] = pd.to_datetime(df_CallRecord['cTime'])
            df_CallRecord['hour_time'] = pd.to_datetime(df_CallRecord['cTime']).dt.hour
            df_CallRecord_1_6 = df_CallRecord[((df_CallRecord["hour_time"] >= 1) & (df_CallRecord["hour_time"] < 6))]
            if df_CallRecord_1_6.empty ==False:
                df_CallRecord_city = df_CallRecord_1_6.drop_duplicates(['tradeAddr'])['tradeAddr'].count()
                _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话城市个数 = df_CallRecord_city
        self._result['近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话城市个数']['value'] = _近150天1度联系人在近300天内与2度联系人凌晨1至6点的总通话城市个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人中手机号的最近一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人中手机号的最近一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            l_phone = df_CallRecord['receiverPhone'].tolist()
            l_set_phone = list(set(get_PhoneNo(l_phone)))
            df_CallRecord_phone = df_CallRecord[df_CallRecord['receiverPhone'].isin(l_set_phone)]
            if df_CallRecord_phone.empty ==False:
                df_CallRecord_max = df_CallRecord_phone['cTime'].max()
                call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_max), '%Y-%m-%d %H:%M:%S')).days
                _近150天1度联系人在近300天内与2度联系人中手机号的最近一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人中手机号的最近一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人中手机号的最近一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人中手机号的最早一次通话距本次申请的天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人中手机号的最早一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            l_phone = df_CallRecord['receiverPhone'].tolist()
            l_set_phone = list(set(get_PhoneNo(l_phone)))
            df_CallRecord_phone = df_CallRecord[df_CallRecord['receiverPhone'].isin(l_set_phone)]
            if df_CallRecord_phone.empty ==False:
                df_CallRecord_min = df_CallRecord_phone['cTime'].min()
                call_record_day = (datetime.datetime.strptime(str(self.apply_time),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(df_CallRecord_min), '%Y-%m-%d %H:%M:%S')).days
                _近150天1度联系人在近300天内与2度联系人中手机号的最早一次通话距本次申请的天数 = call_record_day
        self._result['近150天1度联系人在近300天内与2度联系人中手机号的最早一次通话距本次申请的天数']['value'] = _近150天1度联系人在近300天内与2度联系人中手机号的最早一次通话距本次申请的天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人中手机号的有通话记录的总天数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人中手机号的最早一次通话距本次申请的天数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            l_phone = df_CallRecord['receiverPhone'].tolist()
            l_set_phone = list(set(get_PhoneNo(l_phone)))
            df_CallRecord_phone = df_CallRecord[df_CallRecord['receiverPhone'].isin(l_set_phone)]
            if df_CallRecord_phone.empty ==False:
                df_CallRecord_phone["cTime"] = pd.to_datetime(df_CallRecord_phone['cTime']).dt.date
                df_CallRecord_count = df_CallRecord_phone.drop_duplicates(['cTime'])['cTime'].count()
                _近150天1度联系人在近300天内与2度联系人中手机号的有通话记录的总天数 = df_CallRecord_count
        self._result['近150天1度联系人在近300天内与2度联系人中手机号的有通话记录的总天数']['value'] = _近150天1度联系人在近300天内与2度联系人中手机号的有通话记录的总天数
        return self._result

class 近150天1度联系人在近300天内与2度联系人中手机号的总通话次数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人中手机号的总通话次数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            l_phone = df_CallRecord['receiverPhone'].tolist()
            l_set_phone = list(set(get_PhoneNo(l_phone)))
            df_CallRecord_phone = df_CallRecord[df_CallRecord['receiverPhone'].isin(l_set_phone)]
            if df_CallRecord_phone.empty ==False:
                receiverPhone_count = df_CallRecord_phone['receiverPhone'].count()
                _近150天1度联系人在近300天内与2度联系人中手机号的总通话次数 =receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人中手机号的总通话次数']['value'] = _近150天1度联系人在近300天内与2度联系人中手机号的总通话次数
        return self._result

class 近150天1度联系人在近300天内与2度联系人中手机号的总通话号码个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人中手机号的总通话号码个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            l_phone = df_CallRecord['receiverPhone'].tolist()
            l_set_phone = list(set(get_PhoneNo(l_phone)))
            df_CallRecord_phone = df_CallRecord[df_CallRecord['receiverPhone'].isin(l_set_phone)]
            if df_CallRecord_phone.empty ==False:
                receiverPhone_count = df_CallRecord_phone.drop_duplicates(['receiverPhone'])['receiverPhone'].count()
                _近150天1度联系人在近300天内与2度联系人中手机号的总通话号码个数 = receiverPhone_count
        self._result['近150天1度联系人在近300天内与2度联系人中手机号的总通话号码个数']['value'] = _近150天1度联系人在近300天内与2度联系人中手机号的总通话号码个数
        return self._result

class 近150天1度联系人在近300天内与2度联系人中手机号的总通话秒数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人中手机号的总通话秒数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            l_phone = df_CallRecord['receiverPhone'].tolist()
            l_set_phone = list(set(get_PhoneNo(l_phone)))
            df_CallRecord_phone = df_CallRecord[df_CallRecord['receiverPhone'].isin(l_set_phone)]
            if df_CallRecord_phone.empty ==False:
                receiverPhone_sum = df_CallRecord_phone['tradeTime'].astype(int).sum()
                _近150天1度联系人在近300天内与2度联系人中手机号的总通话秒数 = receiverPhone_sum
        self._result['近150天1度联系人在近300天内与2度联系人中手机号的总通话秒数']['value'] = _近150天1度联系人在近300天内与2度联系人中手机号的总通话秒数
        return self._result

class 近150天1度联系人在近300天内与2度联系人中手机号的总通话城市个数():
    def feature(self):
        _近150天1度联系人在近300天内与2度联系人中手机号的总通话城市个数 = -9999999
        df_CallRecord = get_userContactsFilter(2, self.df_userTwoContacts, self.apply_time, timesTampFDays=180,
                                               applyTimeFDays=300,
                                               userPhone=self.user_phone,
                                               OneContactsCall=self.df_userOneContactsAll['receiverPhone'])
        if df_CallRecord.empty == False:
            l_phone = df_CallRecord['receiverPhone'].tolist()
            l_set_phone = list(set(get_PhoneNo(l_phone)))
            df_CallRecord_phone = df_CallRecord[df_CallRecord['receiverPhone'].isin(l_set_phone)]
            if df_CallRecord_phone.empty ==False:
                df_CallRecord_city = df_CallRecord_phone.drop_duplicates(['tradeAddr'])['tradeAddr'].count()
                _近150天1度联系人在近300天内与2度联系人中手机号的总通话城市个数 = df_CallRecord_city
        self._result['近150天1度联系人在近300天内与2度联系人中手机号的总通话城市个数']['value'] = _近150天1度联系人在近300天内与2度联系人中手机号的总通话城市个数
        return self._result

