# -*- coding:utf-8 -*-
from features.Base_Features import BaseFeatures as BF
from service import Sql_contactsOperator
from service.Sql_complexOrder import *
import pandas as pd
from functools import reduce
import datetime
from dateutil.relativedelta import relativedelta

class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF._apply_at = time_now
        if self.orderId:
            _df = Sql_contactsOperator.getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF._apply_at = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')
        # BF.df_loan_all_v2 = Sql_contactsOperator.getSql_loanAll_diangdanv2(str(tuple([self.user_id])).replace(',)', ')'),str(BF._apply_at))
        BF.df_loan_all = Sql_contactsOperator.getSql_loanAll(str(tuple([self.user_id])).replace(',)', ')'))
        BF.df_loan_rollBack = pd.DataFrame()
        if BF.df_loan_all.empty == False:
            BF.df_loan_rollBack = get_Loan_rollBack(BF.df_loan_all,BF._apply_at)
        pass

class has_loan_nums_2018():
    """user_success_loan_cnt#from2018TillNow  has_loan_nums_2018  用户2018年放款订单数 """
    def feature(self):
        _has_loan_nums_2018 = -9999999
        df_loan_all_v2 = Sql_contactsOperator.getSql_loanAll(str(tuple([self.user_id])).replace(',)', ')'))
        df_loan = df_loan_all_v2
        df_loan['_apply_at'] = self._apply_at
        df_loan = df_loan [df_loan['loan_paid_at'] < df_loan['_apply_at']]
        if df_loan.empty == False:
            # df_loan.dorp_d     apply_time       old loan_paid_at
            df_loan['loan_paid_at_year'] = df_loan['loan_paid_at'].dt.year
            df_loan = df_loan.loc[df_loan['loan_paid_at_year'] >= 2018]
            # df_loan = df_loan.drop_duplicates('loan_id',keep='first')
            # _has_loan_nums_2018 = df_loan['loan_id'].count()
            df_loan = df_loan.drop_duplicates('loan_id',keep='first')
            _has_loan_nums_2018 = df_loan['loan_id'].count()
        self._result['has_loan_nums_2018']['value'] = _has_loan_nums_2018
        return self._result

class has_loan_nums_2019():
    """user_success_loan_cnt#from2019TillNow  has_loan_nums_2019  用户2019年放款订单数 """
    def feature(self):
        _has_loan_nums_2019 = -9999999
        df_loan_all_v2 = Sql_contactsOperator.getSql_loanAll(str(tuple([self.user_id])).replace(',)', ')'))
        df_loan = df_loan_all_v2
        df_loan['_apply_at'] = self._apply_at
        df_loan = df_loan [df_loan['loan_paid_at'] < df_loan['_apply_at']]
        if df_loan.empty == False:
            df_loan['loan_paid_at_year'] = df_loan['loan_paid_at'].dt.year
            df_loan = df_loan.loc[df_loan['loan_paid_at_year'] >= 2019]
            df_loan = df_loan.drop_duplicates('loan_id',keep='first')
            _has_loan_nums_2019 = df_loan['loan_id'].count()
        self._result['has_loan_nums_2019']['value'] = _has_loan_nums_2019
        return self._result

class current_loan_channel():
    """latest_unfinished_loan_info#applyFrom  current_loan_channel 在贷订单进件渠道"""
    def feature(self):
        _current_loan_channel = -9999999
        df_loan = self.df_loan_all
        if df_loan.empty == False:
            if self.df_loan_rollBack.empty == False:
                df_loan_rollBack = self.df_loan_rollBack
                df_loan_new = df_loan_rollBack.loc[df_loan_rollBack['progress'] == 15]
                if df_loan_new.empty == False:
                    loan_id = df_loan_new['loan_id'].max()
                    df_apply = Sql_contactsOperator.getSql_userApplyQuotaRecord(str(tuple([self.user_id])).replace(',)',')'))
                    _current_loan_channel = df_apply.loc[df_apply['loan_id'] == loan_id]['apply_from'].values[0]
        self._result['current_loan_channel']['value'] = _current_loan_channel
        return self._result

class history_max_passdue_days():
    """已结清订单的最大逾期天数 completed_loan_max_overdue_days history_max_passdue_days"""
    def feature(self):
        _history_max_passdue_days = -9999999
        df_loan = self.df_loan_all
        if df_loan.empty == False:
            if self.df_loan_rollBack.empty == False:
                df_loan_rollBack = self.df_loan_rollBack
                df_loan_new = df_loan_rollBack.loc[(df_loan_rollBack['progress'] == 16)& (df_loan_rollBack['passdue_day'] >0)]
                if df_loan_new.empty == False:
                    _history_max_passdue_days = df_loan_new['passdue_day'].max()
        self._result['history_max_passdue_days']['value'] = _history_max_passdue_days
        return self._result

class current_loan_repay_terms_rate():
    """latest_unfinished_loan_info#normalRepaymentRate	current_loan_repay_terms_rate  当前在贷该笔订单还款期数占比"""
    def feature(self):
        _current_loan_repay_terms_rate = -9999999
        df_loan = self.df_loan_all
        if df_loan.empty == False:
            if self.df_loan_rollBack.empty == False:
                df_loan_rollBack = self.df_loan_rollBack
                df_loan_new = df_loan_rollBack.loc[df_loan_rollBack['progress'] == 15]
                if df_loan_new.empty == False:
                    df_loan_new = df_loan_new.loc[df_loan_new['loan_id'] == df_loan_new['loan_id'].max()]
                    plan_count = df_loan_new['plan_id'].count()
                    plan_repay_count = df_loan_new.loc[(df_loan_new['repayment_status']==3) &( df_loan_new['passdue_day']<=0)]['plan_id'].count()
                    if plan_repay_count == 0:
                        _current_loan_repay_terms_rate = 0
                    else:
                        _current_loan_repay_terms_rate = round(plan_repay_count / plan_count,6)
        self._result['current_loan_repay_terms_rate']['value'] = _current_loan_repay_terms_rate
        return self._result

class current_loan_contract_term():
    """latest_unfinished_loan_info#contractTerms current_loan_contract_term 在贷该笔订单的总期数"""
    def feature(self):
        _current_loan_contract_term = -9999999
        df_loan = self.df_loan_all
        if df_loan.empty == False:
            if self.df_loan_rollBack.empty == False:
                df_loan_rollBack = self.df_loan_rollBack
                df_loan_new = df_loan_rollBack.loc[df_loan_rollBack['progress'] == 15]
                if df_loan_new.empty == False:
                    _current_loan_contract_term = df_loan_new[df_loan_new['loan_id'] == df_loan_new['loan_id'].max()]['plan_id'].count()
        self._result['current_loan_contract_term']['value'] = _current_loan_contract_term
        return self._result

class current_loan_monthly_payment():
    """latest_unfinished_loan_info#requiredRepayment	current_loan_monthly_payment  当前在贷该笔订单的月供"""
    def feature(self):
        _current_loan_monthly_payment = -9999999
        df_loan = self.df_loan_all
        if df_loan.empty == False:
            if self.df_loan_rollBack.empty == False:
                df_loan_rollBack = self.df_loan_rollBack
                df_loan_new = df_loan_rollBack.loc[df_loan_rollBack['progress'] == 15]
                if df_loan_new.empty == False:
                    df_loan_new = df_loan_new[(df_loan_new['loan_id'] == df_loan_new['loan_id'].max())]
                    _current_loan_monthly_payment = df_loan_new.loc[df_loan_new['plan_id'] == df_loan_new['plan_id'].max()]['required_repayment'].values[0]
        self._result['current_loan_monthly_payment']['value'] = _current_loan_monthly_payment
        return self._result

