# -*- coding:utf-8 -*-
from features.Base_Features import BaseFeatures as BF
from service import Sql_contactsOperator
from service.Sql_userAddress import *
import pandas as pd
import datetime

class __INIT__(BF):
    """通话地址和居住地址是否一致"""
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00')
        # time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF._apply_at = time_now
        if self.orderId:
            _df = Sql_contactsOperator.getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF._apply_at = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0].split(' ')[0],'%Y-%m-%d')
                # BF._apply_at = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')

        user_phone = str(tuple(Sql_contactsOperator.getSql_userPhone(str(tuple([self.user_id])).replace(',)',')'))['phone_no'].tolist())).replace(',)',')')
        userSource = ''
        df_auth = Sql_contactsOperator.getSql_authorizationPhone(self.uuid,user_phone)
        if df_auth.empty == False:
            df_auth['modifyDate'] = df_auth['modifyDate'].astype(str)
            userSource = df_auth['userSource'].values[0]

        BF._df_telephone = pd.DataFrame()
        call_starttime = BF._apply_at - datetime.timedelta(days=180)
        call_endtime = BF._apply_at

        if userSource == 'YIDONG':
            BF._df_telephone = getSql_mobileCallInfoDataService(user_phone = user_phone ,time_start = call_starttime,time_end = call_endtime)
        elif userSource == 'LIANTONG':
            BF._df_telephone = getSql_unicomCallInfoDataService(user_phone = user_phone ,time_start =call_starttime,time_end = call_endtime)
        elif userSource == 'DIANXIN':
            BF._df_telephone = getSql_telecomCallInfoDataService(user_phone = user_phone ,time_start = call_starttime,time_end = call_endtime)

        # 删除的城市名称中的后缀
        if BF._df_telephone.empty == False:
            BF._df_telephone['tradeAddr'] = BF._df_telephone['tradeAddr'].apply(lambda x : ''.join(get_AddresSplit(str(x))))
            BF._df_telephone['tradeAddr'] = BF._df_telephone['tradeAddr'].apply(lambda x : get_splitSymbol(str(x)))
            BF._df_telephone['cTime'] = BF._df_telephone['cTime'].apply(lambda x : datetime.datetime.strptime(str(x).split(' ')[0],'%Y-%m-%d'))
            # BF._df_telephone['tradeTime'] = BF._df_telephone['tradeTime'].apply(lambda x : int(x) if x else 0)
        # 获取用户地址信息
        BF._userAddress = pd.DataFrame()
        BF._userAddress = getSql_userAddress(self.user_id)
        if BF._userAddress.empty == False:
            # BF._userAddress = BF._userAddress.to_dict(orient='records')[0]
            BF._userAddressDetail = ''.join(get_AddresSplit(BF._userAddress['address_province_city_district'].values[0]))

def get_user_call_detail_addr(df_telephone,apply_at,userAddressDetail,user_call_detail_addr,days):
    df_telephone = df_telephone.loc[df_telephone['cTime'] >= str(datetime.datetime.strptime(str(apply_at).split(' ')[0],'%Y-%m-%d') - datetime.timedelta(days=days))]
    df_telephone = df_telephone.loc[df_telephone['tradeWay'] == '主叫']
    if df_telephone.empty == False:
        df_telephone_g = df_telephone.groupby(['tradeAddr'])
        is_AddrNull = df_telephone.loc[(df_telephone['tradeAddr'].isnull())
                                       | (df_telephone['tradeAddr']== 'None')
                                       | (df_telephone['tradeAddr'] == '')
                                       | (df_telephone['tradeAddr'] == 'null')]['tradeWay'].count()
        _call_l = []
        for key ,value in df_telephone_g:
            if key != None and key != 'None' and key != '' and key != 'null' :
                df_call = pd.DataFrame(value)
                _call_l.append(
                        {
                            'phone':df_call['phone'].values[0],
                            'address':key,
                            'callphoneCount':df_call['tradeWay'].count(),
                            # 'tradeTime':int(df_call['tradeTime'].sum())
                        }
                )
        _df_call = pd.DataFrame(_call_l)
        if _df_call.empty == False:
            _df_call_max = _df_call.loc[_df_call['callphoneCount'] == _df_call['callphoneCount'].max()]
            # address_max = _df_call_max['address'].tolist()
            # _call_max_l = _df_call_max.to_dict(orient='records')
            # for call in _call_max_l:
            #     if call['callphoneCount']>is_AddrNull:
            _df_call_max_new = _df_call_max.loc[_df_call_max['callphoneCount'] >= is_AddrNull]
            if _df_call_max_new.empty == False:
                for address in _df_call_max_new['address'].tolist():
                    if address in userAddressDetail:
                        user_call_detail_addr = 1
                        break
                    else:
                        user_call_detail_addr = 0
            else:
                user_call_detail_addr = -2
            # if _df_call_max['callphoneCount'].count() > is_AddrNull:
            #     for address in address_max:
            #         if address in userAddressDetail:
            #             user_call_detail_addr = 1
            #             break
            #         else:
            #             user_call_detail_addr = 0
            # else:
            #     user_call_detail_addr = -2
        else:
            user_call_detail_addr = -2
    else:
        user_call_detail_addr = -2
    return user_call_detail_addr

class user_call_detail_addr_d180():
    """user_call_detail_addr#m6_addr	user_call_detail_addr_d180	近180天常用通话地址和住址是否一致"""
    def feature(self):
        _user_call_detail_addr_d180 = -9999999
        if self._userAddress['address'].empty: # 用户居住地址为空
            _user_call_detail_addr_d180 = -1
        elif self._df_telephone.empty:
            _user_call_detail_addr_d180 = -2
        else:
            _user_call_detail_addr_d180 = get_user_call_detail_addr(self._df_telephone,self._apply_at,self._userAddressDetail,_user_call_detail_addr_d180,180)
        self._result['user_call_detail_addr_d180']['value'] = _user_call_detail_addr_d180
        return self._result

class user_call_detail_addr_d90():
    """user_call_detail_addr#m3_addr	user_call_detail_addr_d90	近90天常用通话地址和住址是否一致"""
    def feature(self):
        _user_call_detail_addr_d90 = -9999999
        if self._userAddress['address'].empty: # 用户居住地址为空
            _user_call_detail_addr_d90 = -1
        elif self._df_telephone.empty:
            _user_call_detail_addr_d90 = -2
        else:
            _user_call_detail_addr_d90 = get_user_call_detail_addr(self._df_telephone,self._apply_at,self._userAddressDetail,_user_call_detail_addr_d90,90)
        self._result['user_call_detail_addr_d90']['value'] = _user_call_detail_addr_d90
        return self._result


class user_call_detail_addr_d60():
    """user_call_detail_addr#m2_addr	user_call_detail_addr_d60	近60天常用通话地址和住址是否一致"""
    def feature(self):
        _user_call_detail_addr_d60 = -9999999
        if self._userAddress['address'].empty: # 用户居住地址为空
            _user_call_detail_addr_d60 = -1
        elif self._df_telephone.empty:
            _user_call_detail_addr_d60 = -2
        else:
            _user_call_detail_addr_d60 = get_user_call_detail_addr(self._df_telephone,self._apply_at,self._userAddressDetail,_user_call_detail_addr_d60,60)
        self._result['user_call_detail_addr_d60']['value'] = _user_call_detail_addr_d60
        return self._result


class user_call_detail_addr_d30():
    """user_call_detail_addr#m1_addr	user_call_detail_addr_d30	近30天常用通话地址和住址是否一致"""
    def feature(self):
        _user_call_detail_addr_d30 = -9999999
        if self._userAddress['address'].empty: # 用户居住地址为空
            _user_call_detail_addr_d30 = -1
        elif self._df_telephone.empty:
            _user_call_detail_addr_d30 = -2
        else:
            _user_call_detail_addr_d30 = get_user_call_detail_addr(self._df_telephone,self._apply_at,self._userAddressDetail,_user_call_detail_addr_d30,30)
        self._result['user_call_detail_addr_d30']['value'] = _user_call_detail_addr_d30
        return self._result
