# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service.addresss_book_sql import *
import datetime
from service.Sql_vcc import *
from service.Sql_cheat import *
import json
import time
from pandas import DataFrame
import numpy as np

class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF._apply_at = time_now
        BF._apply_df = pd.DataFrame()
        # BF.apply_type_df = pd.DataFrame()
        apply_df = pd.DataFrame()
        if self.orderId:
            _df = getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF._apply_at = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')
        """先判断申请的类别"""
        apply_int_type = get_if_apply_type_sql(self.uuid,self.orderId)
        c_list = []
        """首申=0 复审=1 复贷=2"""
        if apply_int_type == 0:
            apply_df = first_apply_sql(self.uuid).drop_duplicates(['distinct_id','original_ip','event','body','log_time'])
            if apply_df.empty ==False:
                apply_df['body'].apply(lambda x: c_list.append(pd.DataFrame(json.loads(x), index=[0])))
                BF._apply_df = pd.concat(c_list).reset_index()

        elif apply_int_type == 1 or apply_int_type == 2:
            first_time_df = last_apply_time(self.user_id, BF._apply_at)
            if first_time_df.empty ==True:
                first_time = '2019-05-28 00:00:00'
            elif first_time_df.empty ==False:
                first_time = datetime.datetime.strptime(first_time_df['apply_time'].astype(str).values[0], '%Y-%m-%d %H:%M:%S')
            apply_df = second_apply_sql(self.uuid, first_time, BF._apply_at).drop_duplicates(['distinct_id','original_ip','event','body','log_time'])
            if (apply_df.empty == False) and (str(BF._apply_at) > '2019-05-28 00:00:00'):
                apply_df['body'].apply(lambda x: c_list.append(pd.DataFrame(json.loads(x), index=[0])))
                BF._apply_df = pd.concat(c_list).reset_index()#.reset_index(drop=True).sort_index()




class 运营商授权页面服务密码修改次数():
    """app_behavior#operator_auth_error_times   运营商授权页面服务密码修改次数"""
    def feature(self):
        _运营商授权页面服务密码修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "opaf_password_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                count_password = apply_df['opaf_password_change_times'].sum()
                _运营商授权页面服务密码修改次数 = count_password
        self._result['运营商授权页面服务密码修改次数']['value'] = _运营商授权页面服务密码修改次数
        return self._result

class 基本信息页面联系人1姓名输入时长():
    """app_behavior#base_info_contact_one_name_time_sub   基本信息页面联系人1姓名输入时长"""
    def feature(self):
        _基本信息页面联系人1姓名输入时长 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("baf_name1_end_time" and "baf_name1_start_time") in apply_df.columns.tolist():
                apply_df['baf_name1_end_time'] = apply_df['baf_name1_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['baf_name1_start_time'] = apply_df['baf_name1_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                # apply_df['name1_time'] = (apply_df['baf_name1_end_time'] - apply_df['baf_name1_start_time']).apply(lambda x: abs(x))
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['baf_name1_end_time'] != False and x['baf_name1_start_time'] != False:
                        x['all'] = x['baf_name1_end_time'] - x['baf_name1_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _基本信息页面联系人1姓名输入时长 = -9999999
                else:
                    _基本信息页面联系人1姓名输入时长 = max(df_user_list)
        self._result['基本信息页面联系人1姓名输入时长']['value'] = _基本信息页面联系人1姓名输入时长
        return self._result

class 基本信息页面联系人2手机号输入时修改次数():
    """ app_behavior#base_info_contact_two_phone_error_times   基本信息页面联系人2手机号输入时修改次数"""
    def feature(self):
        _基本信息页面联系人2手机号输入时修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_phone2_change_times"  in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                phone2_change_times = apply_df['baf_phone2_change_times'].sum()
                _基本信息页面联系人2手机号输入时修改次数 = phone2_change_times
        self._result['基本信息页面联系人2手机号输入时修改次数']['value'] = _基本信息页面联系人2手机号输入时修改次数
        return self._result

class 基本信息页面联系人2姓名输入时修改次数():
    """app_behavior#base_info_contact_two_name_error_times    基本信息页面联系人2姓名输入时修改次数"""
    def feature(self):
        _基本信息页面联系人2姓名输入时修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_name2_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                name2_change_times = apply_df['baf_name2_change_times'].sum()
                _基本信息页面联系人2姓名输入时修改次数 = name2_change_times
        self._result['基本信息页面联系人2姓名输入时修改次数']['value'] = _基本信息页面联系人2姓名输入时修改次数
        return self._result

class 基本信息页面联系人1姓名输入时修改次数():
    """app_behavior#base_info_contact_one_name_error_times  基本信息页面联系人1姓名输入时修改次数"""
    def feature(self):
        _基本信息页面联系人1姓名输入时修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_name1_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                change_times = apply_df['baf_name1_change_times'].sum()
                _基本信息页面联系人1姓名输入时修改次数 = change_times
        self._result['基本信息页面联系人1姓名输入时修改次数']['value'] = _基本信息页面联系人1姓名输入时修改次数
        return self._result

class 认证支付宝授权页面密码输入时长():
    """app_behavior#credit_auth_valid_zhifubao_code_time   基本信息页面联系人1姓名输入时修改次数"""
    def feature(self):
        _认证支付宝授权页面密码输入时长 = -9999999
        if  self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("zaf_code_end_time"and "zaf_code_start_time") in apply_df.columns.tolist():
                apply_df['zaf_code_end_time']=apply_df['zaf_code_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['zaf_code_start_time'] = apply_df['zaf_code_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['zaf_code_end_time'] != False and x['zaf_code_start_time'] != False:
                        x['all'] = x['zaf_code_end_time'] - x['zaf_code_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _认证支付宝授权页面密码输入时长 = -9999999
                else:
                    _认证支付宝授权页面密码输入时长 = max(df_user_list)
        self._result['认证支付宝授权页面密码输入时长']['value'] = _认证支付宝授权页面密码输入时长
        return self._result

class 基本信息页面详细地址输入时修改次数():
    """app_behavior#base_info_addr_detail_error_times   基本信息页面详细地址输入时修改次数"""
    def feature(self):
        _基本信息页面详细地址输入时修改次数 = -9999999
        if  self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_address_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                address_change_times = apply_df['baf_address_change_times'].sum()
                _基本信息页面详细地址输入时修改次数 = address_change_times
        self._result['基本信息页面详细地址输入时修改次数']['value'] = _基本信息页面详细地址输入时修改次数
        return self._result

class 运营商授权页面服务密码输入时长():
    """ app_behavior#operator_auth_time_sub   运营商授权页面服务密码输入时长"""
    def feature(self):
        _运营商授权页面服务密码输入时长 = -9999999
        if  self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("opaf_password_end_time" and "opaf_password_start_time") in apply_df.columns.tolist():
                apply_df['opaf_password_end_time'] = apply_df['opaf_password_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['opaf_password_start_time'] = apply_df['opaf_password_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['opaf_password_end_time'] != False and x['opaf_password_start_time'] != False:
                        x['all'] = x['opaf_password_end_time'] - x['opaf_password_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                # if df_user_msg['all'].max() == 9999999.0:
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _运营商授权页面服务密码输入时长 = -9999999
                else:
                    _运营商授权页面服务密码输入时长 = max(df_user_list)
        self._result['运营商授权页面服务密码输入时长']['value'] = _运营商授权页面服务密码输入时长
        return self._result

class 基本信息页面收入选择修改次数():
    """app_behavior#base_info_income_error_times    基本信息页面收入选择修改次数"""
    def feature(self):
        _基本信息页面收入选择修改次数 = -9999999
        if  self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_income_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                income_change_times = apply_df['baf_income_change_times'].sum()
                _基本信息页面收入选择修改次数 = income_change_times
        self._result['基本信息页面收入选择修改次数']['value'] = _基本信息页面收入选择修改次数
        return self._result

class 信用授权页面想借多久修改次数():
    """app_behavior#want_lend_many    信用授权页面想借多久修改次数"""
    def feature(self):
        _信用授权页面想借多久修改次数 = -9999999
        if  self._apply_df.empty == False:
            apply_df = self._apply_df
            if "uwc_howtime_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                howtime_times = apply_df['uwc_howtime_times'].sum()
                _信用授权页面想借多久修改次数 = howtime_times
        self._result['信用授权页面想借多久修改次数']['value'] = _信用授权页面想借多久修改次数
        return self._result

class 运营商授权页面服务密码是否存在复制粘贴行为():
    """app_behavior#operator_auth_copy_paste    运营商授权页面服务密码是否存在复制粘贴行为"""
    def feature(self):
        _运营商授权页面服务密码是否存在复制粘贴行为 = -9999999
        if  self._apply_df.empty == False:
            apply_df = self._apply_df
            if "opaf_password_paste" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                password_paste = apply_df['opaf_password_paste'].tolist()
                if True in password_paste:
                    _运营商授权页面服务密码是否存在复制粘贴行为 = 1
                else:
                    _运营商授权页面服务密码是否存在复制粘贴行为 = 0
        self._result['运营商授权页面服务密码是否存在复制粘贴行为']['value'] = _运营商授权页面服务密码是否存在复制粘贴行为
        return self._result

class 注册页面手机号修改次数():
    """app_behavior#regi_phone_update_num    注册页面手机号修改次数"""
    def feature(self):
        _注册页面手机号修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "laf_phone_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                phone_change_times = apply_df['laf_phone_change_times'].sum()
                _注册页面手机号修改次数 = phone_change_times
        self._result['注册页面手机号修改次数']['value'] = _注册页面手机号修改次数
        return self._result

class 基本信息页面联系人2姓名输入时是否存在复制粘贴行为():
    """app_behavior#base_info_contact_two_name_copy_paste    基本信息页面联系人2姓名输入时是否存在复制粘贴行为"""
    def feature(self):
        _基本信息页面联系人2姓名输入时是否存在复制粘贴行为 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_name2_paste" in apply_df.columns.tolist():
                name2_paste = apply_df['baf_name2_paste'].tolist()
                if True in name2_paste:
                    _基本信息页面联系人2姓名输入时是否存在复制粘贴行为 = 1
                else:
                    _基本信息页面联系人2姓名输入时是否存在复制粘贴行为 = 0
        self._result['基本信息页面联系人2姓名输入时是否存在复制粘贴行为']['value'] = _基本信息页面联系人2姓名输入时是否存在复制粘贴行为
        return self._result

class 基本信息页面邮箱输入时修改次数():
    """app_behavior#base_info_email_error_times    基本信息页面邮箱输入时修改次数"""
    def feature(self):
        _基本信息页面邮箱输入时修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_email_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                email_change_times = apply_df['baf_email_change_times'].sum()
                _基本信息页面邮箱输入时修改次数 = email_change_times
        self._result['基本信息页面邮箱输入时修改次数']['value'] = _基本信息页面邮箱输入时修改次数
        return self._result

class 基本信息页面联系人1姓名输入时是否存在复制粘贴行为():
    """app_behavior#base_info_contact_one_name_copy_paste    基本信息页面联系人1姓名输入时是否存在复制粘贴行为"""
    def feature(self):
        _基本信息页面联系人1姓名输入时是否存在复制粘贴行为 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_name1_paste" in apply_df.columns.tolist():
                name1_paste = apply_df['baf_name1_paste'].tolist()
                if True in name1_paste:
                    _基本信息页面联系人1姓名输入时是否存在复制粘贴行为 = 1
                else:
                    _基本信息页面联系人1姓名输入时是否存在复制粘贴行为 = 0
        self._result['基本信息页面联系人1姓名输入时是否存在复制粘贴行为']['value'] = _基本信息页面联系人1姓名输入时是否存在复制粘贴行为
        return self._result

class 基本信息页面邮箱输入时是否存在复制粘贴行为():
    """app_behavior#base_info_email_copy_paste    基本信息页面邮箱输入时是否存在复制粘贴行为"""
    def feature(self):
        _基本信息页面邮箱输入时是否存在复制粘贴行为 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_email_paste" in apply_df.columns.tolist():
                email_paste = apply_df['baf_email_paste'].tolist()
                if True in email_paste:
                    _基本信息页面邮箱输入时是否存在复制粘贴行为 = 1
                else:
                    _基本信息页面邮箱输入时是否存在复制粘贴行为 = 0
        self._result['基本信息页面邮箱输入时是否存在复制粘贴行为']['value'] = _基本信息页面邮箱输入时是否存在复制粘贴行为
        return self._result

class 基本信息页面联系人1手机号输入时修改次数():
    """app_behavior#base_info_contact_one_phone_error_times    基本信息页面联系人1手机号输入时修改次数"""
    def feature(self):
        _基本信息页面联系人1手机号输入时修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_phone1_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                phone1_change_times = apply_df['baf_phone1_change_times'].sum()
                _基本信息页面联系人1手机号输入时修改次数 = phone1_change_times
        self._result['基本信息页面联系人1手机号输入时修改次数']['value'] = _基本信息页面联系人1手机号输入时修改次数
        return self._result

class 基本信息页面联系人2手机号输入时是否存在复制粘贴行为():
    """ app_behavior#base_info_contact_two_phone_copy_paste   基本信息页面联系人2手机号输入时是否存在复制粘贴行为"""
    def feature(self):
        _基本信息页面联系人2手机号输入时是否存在复制粘贴行为 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_phone2_paste" in apply_df.columns.tolist():
                phone2_paste = apply_df['baf_phone2_paste'].tolist()
                if True in phone2_paste:
                    _基本信息页面联系人2手机号输入时是否存在复制粘贴行为 = 1
                else:
                    _基本信息页面联系人2手机号输入时是否存在复制粘贴行为 = 0
        self._result['基本信息页面联系人2手机号输入时是否存在复制粘贴行为']['value'] = _基本信息页面联系人2手机号输入时是否存在复制粘贴行为
        return self._result

class 认证支付宝授权页面密码修改次数():
    """app_behavior#credit_auth_valid_zhifubao_code_error_times    认证支付宝授权页面密码修改次数"""
    def feature(self):
        _认证支付宝授权页面密码修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "zaf_code_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                alipay_code_change_times = apply_df['zaf_code_change_times'].sum()
                _认证支付宝授权页面密码修改次数 = alipay_code_change_times
        self._result['认证支付宝授权页面密码修改次数']['value'] = _认证支付宝授权页面密码修改次数
        return self._result

class 注册页面手机号输入时长():
    """app_behavior#regi_phone_time_sub    注册页面手机号输入时长"""
    def feature(self):
        _注册页面手机号输入时长 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("laf_phone_end_time" and "laf_phone_start_time")in apply_df.columns.tolist():
                apply_df['laf_phone_end_time'] = apply_df['laf_phone_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['laf_phone_start_time'] = apply_df['laf_phone_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['laf_phone_end_time'] != False and x['laf_phone_start_time'] != False:
                        x['all'] = x['laf_phone_end_time'] - x['laf_phone_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _注册页面手机号输入时长 = -9999999
                else:
                    _注册页面手机号输入时长 = max(df_user_list)
        self._result['注册页面手机号输入时长']['value'] = _注册页面手机号输入时长
        return self._result

class 信用授权页面想借多少钱修改次数():
    """app_behavior#want_lend_much   信用授权页面想借多少钱修改次数"""
    def feature(self):
        _信用授权页面想借多少钱修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "uwc_howmany_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                howmany_times = apply_df['uwc_howmany_times'].sum()
                _信用授权页面想借多少钱修改次数 = howmany_times
        self._result['信用授权页面想借多少钱修改次数']['value'] = _信用授权页面想借多少钱修改次数
        return self._result

class 身份信息录入修改次数():
    """app_behavior#idcard_error_times   身份信息录入修改次数"""
    def feature(self):
        _身份信息录入修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "iaf_id_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                id_change_times = apply_df['iaf_id_change_times'].sum()
                _身份信息录入修改次数 = id_change_times
        self._result['身份信息录入修改次数']['value'] = _身份信息录入修改次数
        return self._result

class 基本信息页面所在省市区选择修改次数():
    """app_behavior#base_info_addr_error_times 身份信息录入修改次数"""
    def feature(self):
        _基本信息页面所在省市区选择修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_city_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                id_change_times = apply_df['baf_city_change_times'].sum()
                _基本信息页面所在省市区选择修改次数 = id_change_times
        self._result['基本信息页面所在省市区选择修改次数']['value'] = _基本信息页面所在省市区选择修改次数
        return self._result

class ocr身份证验证次数正反面():
    """app_behavior#ocr_valid_times   ocr身份证验证次数正反面"""
    def feature(self):
        _ocr身份证验证次数正反面 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "oaf_front_click_times" and "oaf_back_click_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                apply_df['oaf_front_click_times'] = apply_df['oaf_front_click_times'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['oaf_back_click_times'] = apply_df['oaf_back_click_times'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['ocr_click_times'] = (apply_df['oaf_front_click_times'].sum() + apply_df['oaf_back_click_times'].sum())
                ocr_click_times = apply_df['ocr_click_times'].max()
                _ocr身份证验证次数正反面 = ocr_click_times
        self._result['ocr身份证验证次数正反面']['value'] = _ocr身份证验证次数正反面
        return self._result

class 基本信息页面联系人1手机号输入时是否存在复制粘贴行为():
    """app_behavior#base_info_contact_one_phone_copy_paste    基本信息页面联系人1手机号输入时是否存在复制粘贴行为"""
    def feature(self):
        _基本信息页面联系人1手机号输入时是否存在复制粘贴行为 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_phone1_paste" in apply_df.columns.tolist():
                phone1_paste = apply_df['baf_phone1_paste'].tolist()
                if True in phone1_paste:
                    _基本信息页面联系人1手机号输入时是否存在复制粘贴行为 = 1
                else:
                    _基本信息页面联系人1手机号输入时是否存在复制粘贴行为 = 0
        self._result['基本信息页面联系人1手机号输入时是否存在复制粘贴行为']['value'] = _基本信息页面联系人1手机号输入时是否存在复制粘贴行为
        return self._result

class 身份信息录入时身份证号是否存在复制粘贴行为():
    """app_behavior#idcard_copy_paste    身份信息录入时身份证号是否存在复制粘贴行为"""
    def feature(self):
        _身份信息录入时身份证号是否存在复制粘贴行为 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "iaf_id_paste" in apply_df.columns.tolist():
                id_paste = apply_df['iaf_id_paste'].tolist()
                if True in id_paste:
                    _身份信息录入时身份证号是否存在复制粘贴行为 = 1
                else:
                    _身份信息录入时身份证号是否存在复制粘贴行为 = 0
        self._result['身份信息录入时身份证号是否存在复制粘贴行为']['value'] = _身份信息录入时身份证号是否存在复制粘贴行为
        return self._result

class 基本信息页面联系人2关系选择修改次数():
    """app_behavior#base_info_contact_two_relation_error_times    基本信息页面联系人2关系选择修改次数"""
    def feature(self):
        _基本信息页面联系人2关系选择修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_relation2_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                id_change_times = apply_df['baf_relation2_change_times'].sum()
                _基本信息页面联系人2关系选择修改次数 = id_change_times
        self._result['基本信息页面联系人2关系选择修改次数']['value'] = _基本信息页面联系人2关系选择修改次数
        return self._result

class 身份信息录入时身份证号输入时长():
    """app_behavior#idcard_valid_time_sub    身份信息录入时身份证号输入时长"""
    def feature(self):
        _身份信息录入时身份证号输入时长 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("iaf_id_end_time" and "iaf_id_start_time") in apply_df.columns.tolist():
                apply_df['iaf_id_end_time'] = apply_df['iaf_id_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['iaf_id_start_time'] = apply_df['iaf_id_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['iaf_id_end_time'] != False and x['iaf_id_start_time'] != False:
                        x['all'] = x['iaf_id_end_time'] - x['iaf_id_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                # if df_user_msg['all'].max() == 9999999.0:
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _身份信息录入时身份证号输入时长 = -9999999
                else:
                    _身份信息录入时身份证号输入时长 = max(df_user_list)
        self._result['身份信息录入时身份证号输入时长']['value'] = _身份信息录入时身份证号输入时长
        return self._result

class 基本信息页面学历选择修改次数():
    """app_behavior#base_info_edu_background_error_times    基本信息页面学历选择修改次数"""
    def feature(self):
        _基本信息页面学历选择修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_education_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                education_change_times = apply_df['baf_education_change_times'].sum()
                _基本信息页面学历选择修改次数 = education_change_times
        self._result['基本信息页面学历选择修改次数']['value'] = _基本信息页面学历选择修改次数
        return self._result

class 基本信息页面联系人2姓名输入时长():
    """app_behavior#base_info_contact_two_name_time_sub    基本信息页面联系人2姓名输入时长"""
    def feature(self):
        _基本信息页面联系人2姓名输入时长 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("baf_name2_end_time" and "baf_name2_start_time") in apply_df.columns.tolist():
                apply_df['baf_name2_end_time'] = apply_df['baf_name2_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['baf_name2_start_time'] = apply_df['baf_name2_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['baf_name2_end_time'] != False and x['baf_name2_start_time'] != False:
                        x['all'] = x['baf_name2_end_time'] - x['baf_name2_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                # if df_user_msg['all'].max() == 9999999.0:
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _基本信息页面联系人2姓名输入时长 = -9999999
                else:
                    _基本信息页面联系人2姓名输入时长 = max(df_user_list)
        self._result['基本信息页面联系人2姓名输入时长']['value'] = _基本信息页面联系人2姓名输入时长
        return self._result

class 基本信息页面联系人1手机号输入时长():
    """app_behavior#base_info_contact_one_phone_time_sub 基本信息页面联系人1手机号输入时长"""
    def feature(self):
        _基本信息页面联系人1手机号输入时长 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("baf_phone1_end_time" and "baf_phone1_start_time") in apply_df.columns.tolist():
                apply_df['baf_phone1_end_time'] = apply_df['baf_phone1_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['baf_phone1_start_time'] = apply_df['baf_phone1_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['baf_phone1_end_time'] != False and x['baf_phone1_start_time'] != False:
                        x['all'] = x['baf_phone1_end_time'] - x['baf_phone1_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                # if df_user_msg['all'].max() == 9999999.0:
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _基本信息页面联系人1手机号输入时长 = -9999999
                else:
                    _基本信息页面联系人1手机号输入时长 = max(df_user_list)
        self._result['基本信息页面联系人1手机号输入时长']['value'] = _基本信息页面联系人1手机号输入时长
        return self._result

class 基本信息页面联系人1关系选择修改次数():
    """app_behavior#base_info_contact_one_relation_error_times    基本信息页面联系人1关系选择修改次数"""
    def feature(self):
        _基本信息页面联系人1关系选择修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_relation1_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                relation1_change_times = apply_df['baf_relation1_change_times'].sum()
                _基本信息页面联系人1关系选择修改次数 = relation1_change_times
        self._result['基本信息页面联系人1关系选择修改次数']['value'] = _基本信息页面联系人1关系选择修改次数
        return self._result

class 基本信息页面联系人2手机号输入时长():
    """app_behavior#base_info_contact_two_phone_time_sub 基本信息页面联系人2手机号输入时长"""
    def feature(self):
        _基本信息页面联系人2手机号输入时长 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("baf_phone2_end_time" and "baf_phone2_start_time") in apply_df.columns.tolist():
                apply_df['baf_phone2_end_time'] = apply_df['baf_phone2_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['baf_phone2_start_time'] = apply_df['baf_phone2_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['baf_phone2_end_time'] != False and x['baf_phone2_start_time'] != False:
                        x['all'] = x['baf_phone2_end_time'] - x['baf_phone2_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                # if df_user_msg['all'].max() == 9999999.0:
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _基本信息页面联系人2手机号输入时长 = -9999999
                else:
                    _基本信息页面联系人2手机号输入时长 = max(df_user_list)
        self._result['基本信息页面联系人2手机号输入时长']['value'] = _基本信息页面联系人2手机号输入时长
        return self._result

class 基本信息页面邮箱输入时长():
    """app_behavior#base_info_email_time_sub 基本信息页面联系人2手机号输入时长"""
    def feature(self):
        _基本信息页面邮箱输入时长 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("baf_email_end_time" and "baf_email_start_time") in apply_df.columns.tolist():
                apply_df['baf_email_end_time'] = apply_df['baf_email_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['baf_email_start_time'] = apply_df['baf_email_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['baf_email_end_time'] != False and x['baf_email_start_time'] != False:
                        x['all'] = x['baf_email_end_time'] - x['baf_email_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                # if df_user_msg['all'].max() == 9999999.0:
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _基本信息页面邮箱输入时长 = -9999999
                else:
                    _基本信息页面邮箱输入时长 = max(df_user_list)
        self._result['基本信息页面邮箱输入时长']['value'] = _基本信息页面邮箱输入时长
        return self._result

class 基本信息页面职业选择修改次数():
    """app_behavior#base_info_job_error_times    基本信息页面职业选择修改次数"""
    def feature(self):
        _基本信息页面职业选择修改次数 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_job_change_times" in apply_df.columns.tolist():
                apply_df = apply_df.fillna(0)
                job_change_times = apply_df['baf_job_change_times'].sum()
                _基本信息页面职业选择修改次数 = job_change_times
        self._result['基本信息页面职业选择修改次数']['value'] = _基本信息页面职业选择修改次数
        return self._result

class 运营商授权页面是否点击过找回服务密码():
    """app_behavior#operator_auth_click_callback    运营商授权页面是否点击过找回服务密码"""
    def feature(self):
        _运营商授权页面是否点击过找回服务密码 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "opaf_findpassword_click" in apply_df.columns.tolist():
                findpassword_click = apply_df['opaf_findpassword_click'].tolist()
                if True in findpassword_click:
                    _运营商授权页面是否点击过找回服务密码 = 1
                else:
                    _运营商授权页面是否点击过找回服务密码 = 0
        self._result['运营商授权页面是否点击过找回服务密码']['value'] = _运营商授权页面是否点击过找回服务密码
        return self._result

class 注册页面手机号是否存在复制粘贴行为():
    """app_behavior#regi_phone_copy_paste    注册页面手机号是否存在复制粘贴行为"""
    def feature(self):
        _注册页面手机号是否存在复制粘贴行为 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "laf_phone_paste" in apply_df.columns.tolist():
                phone_paste = apply_df['laf_phone_paste'].tolist()
                if True in phone_paste:
                    _注册页面手机号是否存在复制粘贴行为 = 1
                else:
                    _注册页面手机号是否存在复制粘贴行为 = 0
        self._result['注册页面手机号是否存在复制粘贴行为']['value'] = _注册页面手机号是否存在复制粘贴行为
        return self._result

class 基本信息页面详细地址输入时是否存在复制粘贴行为():
    """app_behavior#base_info_addr_detail_copy_paste    基本信息页面详细地址输入时是否存在复制粘贴行为"""
    def feature(self):
        _基本信息页面详细地址输入时是否存在复制粘贴行为 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if "baf_address_paste" in apply_df.columns.tolist():
                address_paste = apply_df['baf_address_paste'].tolist()
                if True in address_paste:
                    _基本信息页面详细地址输入时是否存在复制粘贴行为 = 1
                else:
                    _基本信息页面详细地址输入时是否存在复制粘贴行为 = 0
        self._result['基本信息页面详细地址输入时是否存在复制粘贴行为']['value'] = _基本信息页面详细地址输入时是否存在复制粘贴行为
        return self._result

class 基本信息页面详细地址输入时长():
    """ app_behavior#base_info_addr_detail_time_sub 基本信息页面详细地址输入时长"""
    def feature(self):
        _基本信息页面详细地址输入时长 = -9999999
        if self._apply_df.empty == False:
            apply_df = self._apply_df
            if ("baf_address_end_time" and "baf_address_start_time") in apply_df.columns.tolist():
                apply_df['baf_address_end_time'] = apply_df['baf_address_end_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                apply_df['baf_address_start_time'] = apply_df['baf_address_start_time'].apply(lambda x: np.nan if str(x) == '' else x).dropna().astype(int)
                df_user_msg = apply_df.fillna(False)
                df_user_msg['all'] = False
                def _test(x):
                    """判断相减"""
                    if x['baf_address_end_time'] != False and x['baf_address_start_time'] != False:
                        x['all'] = x['baf_address_end_time'] - x['baf_address_start_time']
                    else:
                        x['all'] = -9999999
                    return x['all']
                df_user_msg['all'] = df_user_msg.apply(lambda x: _test(x), axis=1)
                df_user_msg['all'] = df_user_msg['all'].apply(lambda x: abs(x))
                df_user_list = [i for i in df_user_msg['all'].tolist() if i != 9999999.0]
                if len(df_user_list) ==0:
                    _基本信息页面详细地址输入时长 = -9999999
                else:
                    _基本信息页面详细地址输入时长 = max(df_user_list)
        self._result['基本信息页面详细地址输入时长']['value'] = _基本信息页面详细地址输入时长
        return self._result