# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service.addresss_book_sql import *
import datetime
from service.Sql_vcc import *
import json
import time
from pandas import DataFrame
import numpy as np




class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF._created_at = time_now  #获取用户的手机号
        user_detail = getSql_userPhone_one(str(tuple([self.user_id])).replace(',)',')'))
        BF._user_id_one = str(tuple(user_detail['user_id'].tolist())).replace(',)',')')
        BF._creat_at = user_detail
        BF._user_phone = user_detail['phone_no'].values[0]
        BF._apply_at = time_now

        BF.registered_df = register(self.uuid)
        BF.register_white = get_idcard_detail(self.uuid)

        if self.orderId:
            _df = getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF._apply_at = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')





class 用户注册渠道():
    """ user_info#registeredFrom       用户注册渠道"""
    def feature(self):
        _用户注册渠道 = -9999999
        if (self.registered_df).empty == False:
            registered_from = self.registered_df["registered_from"].values[0]
            _用户注册渠道 = registered_from
        self._result['用户注册渠道']['value'] = _用户注册渠道
        return self._result


class 一二线城市标志():
    """ user_ocr_extend_info#cityRanking     一二线城市标志"""
    def feature(self):
        _一二线城市标志 = -9999999
        city= city_sign(self.uuid, self.orderId)
        if isinstance(city,int):
            _一二线城市标志 = city
        self._result['一二线城市标志']['value'] = _一二线城市标志
        return self._result


class 用户在钱包最近一笔贷款本金金额():
    """user_loan_real_loan_amount_info#latestRealLoanAmount    用户在钱包最近一笔贷款本金金额"""
    def feature(self):
        _用户在钱包最近一笔贷款本金金额 = -9999999

        if len(self._user_id_one) > 0:
            df_user = self._user_id_one

            _df_loan = get_successful_user_loan_orders(df_user,self._apply_at)
            if _df_loan.empty == False:

                # _df_loan['loan_paid_at'] = pd.to_datetime(_df_loan['loan_paid_at'])
                # _df_loan = _df_loan.drop_duplicates(["loan_paid_at"])
                # _df_loan = _df_loan.sort_values(by=["loan_paid_at"])
                _用户在钱包最近一笔贷款本金金额 =_df_loan .head(1)["real_loan_amount"].values[0]
        self._result['用户在钱包最近一笔贷款本金金额']['value'] = _用户在钱包最近一笔贷款本金金额
        return self._result

class 用户在钱包历史最大贷款本金金额():
    """user_loan_real_loan_amount_info#maxRealLoanAmount    用户在钱包历史最大贷款本金金额"""
    def feature(self):
        _用户在钱包历史最大贷款本金金额 = -9999999

        if len(self._user_id_one) > 0:
            df_user = self._user_id_one
            _df_loan = get_successful_user_loan_orders(df_user,self._apply_at)
            if _df_loan.empty == False:

                _用户在钱包历史最大贷款本金金额 =max(_df_loan["real_loan_amount"])
        self._result['用户在钱包历史最大贷款本金金额']['value'] = _用户在钱包历史最大贷款本金金额
        return self._result


class 身份证是否过期():
    """user_ocr_extend_info#idCardIsNotValid   身份证是否过期"""
    def feature(self):
        _身份证是否过期 = -9999999
        id_time= int(str(self._apply_at).split()[0].replace("-", ""))
        card_expires_time = card_expires(self.uuid, self.orderId)
        if len(str(card_expires_time)) < 8:
            self._result['身份证是否过期']['value'] = -9999999
            return self._result

        if isinstance(card_expires_time,int):
            if id_time >= card_expires_time:
                _身份证是否过期 = 1
            elif id_time < card_expires_time:
                _身份证是否过期 = 0
        self._result['身份证是否过期']['value'] = _身份证是否过期
        return self._result



class 测试白名单():
    """ user_id_card_in_white_list   测试白名单"""

    def feature(self):
        _测试白名单 = -9999999
        if self.register_white.empty == False:
            get_user_white = self.register_white["id_no"].values[0]
            _df = id_is_whitelist(str(get_user_white), self._apply_at)["count"][0]
            if _df > 0:
                _df_qgblack_1_1 = 1
            else:
                _df_qgblack_1_1 = 0
            _测试白名单 = _df_qgblack_1_1
        self._result['测试白名单']['value'] = _测试白名单
        return self._result




