# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service import Sql_contactsOperator
from service.Sql_complexOrder import *

import pandas as pd
import datetime


class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF.df_loan_all = Sql_contactsOperator.getSql_loanAll(str(tuple([self.user_id])).replace(',)',')'))
        BF._apply_at = time_now
        BF._df_apply_all = Sql_contactsOperator.getSql_userApplyQuotaRecord(str(tuple([self.user_id])).replace(',)',')'))
        if self.orderId:
            # BF._df_apply_all = Sql_contactsOperator.getSql_userApplyQuotaRecord(str(tuple([self.user_id])).replace(',)',')'))
            _df_apply_orderId = BF._df_apply_all.loc[BF._df_apply_all['order_no'] == self.orderId]
            if _df_apply_orderId.empty == False:
                _df_apply_orderId['apply_time'] = _df_apply_orderId['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S'))
                BF._apply_at = _df_apply_orderId['apply_time'].values[0]

        BF.df_loan_rollBack = pd.DataFrame()
        if BF.df_loan_all.empty == False:
            BF.df_loan_rollBack = get_Loan_rollBack(BF.df_loan_all,BF._apply_at)
        pass


class the_date_of_overdue():
    """ the_date_of_overdue   在贷订单中最早的逾期时间"""
    def feature(self):
        _the_date_of_overdue = -9999999
        if self.df_loan_rollBack.empty == False:
            df_loan = self.df_loan_rollBack.loc[self.df_loan_rollBack['progress'] == 15]
            if df_loan.empty == False:
                df_loan_passdue = df_loan.loc[df_loan['passdue_day'] > 0]
                if df_loan_passdue.empty == False:

                    _the_date_of_overdue = str(df_loan_passdue['deadline'].min()).split(' ')[0] + ' 23:59:59'

        self._result['the_date_of_overdue']['value'] = _the_date_of_overdue
        return self._result

class apply_approved_times():
    """ apply_approved_times   申请通过笔数"""
    def feature(self):
        _apply_approved_times = -9999999
        if self._df_apply_all.empty == False:
            df_apply = self._df_apply_all.loc[(self._df_apply_all['apply_status'] == 0)]
            if df_apply.empty == False:
                _apply_approved_times = df_apply.loc[(self._df_apply_all['apply_time'] < self._apply_at)]['user_id'].count()

        self._result['apply_approved_times']['value'] = _apply_approved_times
        return self._result

class total_monthly_interest_rate():
    """ total_monthly_interest_rate   总月利率"""
    def feature(self):
        _total_monthly_interest_rate = -9999999
        if self.df_loan_rollBack.empty == False:
            df_loan = self.df_loan_rollBack
            df_loan_g = df_loan.groupby(['loan_id']).agg({'monthly_interest_rate':'first'}).reset_index()
            _total_monthly_interest_rate = df_loan_g['monthly_interest_rate'].sum()
        self._result['total_monthly_interest_rate']['value'] = _total_monthly_interest_rate

        return self._result


