# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service import Sql_contactsOperator
from service import Sql_complexOrder
import datetime,time
import pandas as pd

class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF.df_loan_all = Sql_contactsOperator.getSql_loanAll(str(tuple([self.user_id])).replace(',)',')'))
        BF._apply_at = time_now
        BF.df_apply_order = pd.DataFrame()
        BF.df_loan_rollBack = pd.DataFrame()

        BF._df_apply = Sql_contactsOperator.getSql_userApplyQuotaRecord(str(tuple([self.user_id])).replace(',)',')'))
        if BF._df_apply.empty == False:
            BF._df_apply.sort_values('apply_time',inplace=True)
            BF._df_apply.reset_index(drop=True,inplace=True)
            if self.orderId:
                BF.df_apply_order = BF._df_apply.loc[BF._df_apply['order_no'] == self.orderId]
                if BF.df_apply_order.empty == False:
                    BF._apply_at = datetime.datetime.strptime(BF.df_apply_order['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')

            if BF.df_loan_all.empty == False:
                BF.df_loan_all.sort_values('apply_time',inplace=True)
                BF.df_loan_all.reset_index(drop=True,inplace=True)
                BF.df_loan_rollBack = Sql_complexOrder.get_Loan_rollBack(BF.df_loan_all,BF._apply_at,passdueDay_Negative=True)

def get_loanSettleFrom(df_loan_rollBack):
    """上一个已结清的订单"""
    df_loan_result = pd.DataFrame()
    if df_loan_rollBack.empty == False:
        df_loan_rollBack = df_loan_rollBack[df_loan_rollBack["progress"] == 16]
        if df_loan_rollBack.empty == False:
            df_loan_result = df_loan_rollBack[df_loan_rollBack['loan_id'] == df_loan_rollBack['loan_id'].max()]
    return df_loan_result

class applied_hour():
    """current_apply_record_info#applyHours	 applied_hour  申请时间（时段np.floor(hour/6)）"""
    def feature(self):
        _applied_hour = -9999999
        if self.df_apply_order.empty == False:
            _applied_hour = int(self.df_apply_order['apply_time'].dt.hour / 6)
        self._result["applied_hour"]["value"] = _applied_hour
        return self._result

class cnt_applied_from():
    """user_apply_record_info#historyApplyFromCnt	cnt_applied_from  历史申请渠道数（包括本次）"""
    def feature(self):
        _cnt_applied_from = -9999999
        _df_apply = self._df_apply.loc[self._df_apply['apply_time'] <= self._apply_at]
        if _df_apply.empty == False:
            _cnt_applied_from = len(set(_df_apply['apply_from']))
        self._result["cnt_applied_from"]["value"] = _cnt_applied_from
        return self._result

class repay_day():
    """user_daily_repayment_amount  repay_day   每天还款金额"""
    def feature(self):
        _repay_day = -9999999
        if self.df_loan_rollBack.empty == False:
            df_loan = self.df_loan_rollBack.loc[self.df_loan_rollBack['progress']==16]
            if df_loan.empty == False:
                loan_repay = []
                for k ,value in df_loan.groupby(['loan_id']):
                    _df = pd.DataFrame(value)
                    loan_repay.append({'loan_id':k,
                                       'contract_loan_amount':_df['contract_loan_amount'].values[0],
                                       'loan_paid_at':_df['loan_paid_at'].tolist()[0],
                                       'repaid_at':_df['repaid_at'].max(),
                                       # 'repay_days': (_df['repaid_at'].max() - _df['loan_paid_at'].tolist()[0]).days
                                       })
                df_loan_repay = pd.DataFrame(loan_repay)
                df_loan_repay['repaid_at'] = df_loan_repay['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                df_loan_repay['loan_paid_at'] = df_loan_repay['loan_paid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                df_loan_repay['repay_days'] = (df_loan_repay['repaid_at'] - df_loan_repay['loan_paid_at']).dt.days
                repay_days = df_loan_repay['repay_days'].sum()
                if repay_days>0:
                    _repay_day = round(df_loan_repay['contract_loan_amount'].sum()/repay_days,6)
                else:
                    _repay_day = round(df_loan_repay['contract_loan_amount'].sum(),6)
        self._result['repay_day']['value'] = _repay_day
        return self._result

class applied_from_same():
    """user_apply_record_info#isSameApplyFrom	applied_from_same   本次与上次申请渠道是否相同"""
    def feature(self):
        _applied_from_same = -9999999
        if self.df_apply_order.empty == False:
            df_apply = self._df_apply
            if df_apply.empty == False:
                apply_from = df_apply.loc[df_apply['apply_time'] <= self._apply_at]['apply_from'].tolist()
                if len(apply_from) > 1:
                    apply_from_end = apply_from[len(apply_from)-1]
                    apply_from_end_two = apply_from[len(apply_from)-2]
                    if apply_from_end == apply_from_end_two :
                        _applied_from_same = 1
                    else:
                        _applied_from_same = 0
        self._result['applied_from_same']['value'] = _applied_from_same
        return self._result

class passdueday_as_before():
    """user_normal_repayment_info#normalRepaymentCnt	passdueday_as_before    按时还款的期数（等于0的）"""
    def feature(self):
        _passdueday_as_before = -9999999
        if self.df_loan_rollBack.empty == False:
            df_loan = self.df_loan_rollBack.loc[self.df_loan_rollBack['progress'] == 16]
            if df_loan.empty == False:
                df_loan_pass = df_loan.loc[df_loan['passdue_day'] == 0]
                _passdueday_as_before = df_loan_pass['plan_id'].count()
        self._result["passdueday_as_before"]["value"] = _passdueday_as_before
        return self._result

class passdueday_tq1_before():
    """user_normal_repayment_info#repayment1DaysInAdvanceCnt	passdueday_tq1_before   历史逾期<=-1的期数"""
    def feature(self):
        _passdueday_tq1_before = -9999999
        if self.df_loan_rollBack.empty == False:
            df_loan = self.df_loan_rollBack.loc[self.df_loan_rollBack['progress'] == 16]
            if df_loan.empty == False:
                df_loan_pass = df_loan.loc[df_loan['passdue_day'] <= -1]
                _passdueday_tq1_before = df_loan_pass['plan_id'].count()
        self._result["passdueday_tq1_before"]["value"] = _passdueday_tq1_before
        return self._result

class passdueday_tq5_before():
    """user_normal_repayment_info#repayment5DaysInAdvanceCnt	passdueday_tq5_before   历史逾期<=-5的期数"""
    def feature(self):
        _passdueday_tq5_before = -9999999
        if self.df_loan_rollBack.empty == False:
            df_loan = self.df_loan_rollBack.loc[self.df_loan_rollBack['progress'] == 16]
            if df_loan.empty == False:
                df_loan_pass = df_loan.loc[df_loan['passdue_day'] <= -5]
                _passdueday_tq5_before = df_loan_pass['plan_id'].count()
        self._result["passdueday_tq5_before"]["value"] = _passdueday_tq5_before
        return self._result

class fst_apply_day_v2():
    """user_apply_record_info#diffFirstApplyDays	fst_apply_day_v2    （本次申请时间-首次申请时间）天数"""
    def feature(self):
        _fst_apply_day_v2 = -9999999
        df_apply_all = self._df_apply

        if df_apply_all['user_id'].count()>1:
            if self.orderId is not None:
                if df_apply_all.loc[df_apply_all['order_no'] == self.orderId].index[0] != 0:
                    df_apply_all['apply_time'] = df_apply_all['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                    apply_time_fist = datetime.datetime.strptime(datetime.datetime.strftime(df_apply_all['apply_time'].min(),'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00')
                    apply_time_current = datetime.datetime.strptime(datetime.datetime.strftime(self._apply_at,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00')
                    if apply_time_fist <= apply_time_current:
                        _fst_apply_day_v2 = (apply_time_current - apply_time_fist).days

            else:
                if df_apply_all.loc[df_apply_all['apply_time'].isin([self._apply_at])].empty == False :
                    df_apply_all['apply_time'] = df_apply_all['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                    apply_time_fist = datetime.datetime.strptime(datetime.datetime.strftime(df_apply_all['apply_time'].min(),'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00')
                    apply_time_current = datetime.datetime.strptime(datetime.datetime.strftime(self._apply_at,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00')
                    if apply_time_fist <= apply_time_current:
                        _fst_apply_day_v2 = (apply_time_current - apply_time_fist).days
        self._result["fst_apply_day_v2"]["value"] = _fst_apply_day_v2
        return self._result

class delq_days_max():
    """delq_days_max_days_v2	delq_days_max   历史最大逾期天数(可正可负)"""
    def feature(self):
        _delq_days_max = -9999999

        if self.df_loan_rollBack.empty == False:
            df_loan = self.df_loan_rollBack  # .loc[self.df_loan_rollBack['progress'] == 16]
            df_loan['observationTime'] = df_loan['observationTime'].apply(
                lambda x: datetime.datetime.strptime(datetime.datetime.strftime(x, '%Y-%m-%d 00:00:00'),
                                                     '%Y-%m-%d 00:00:00'))
            df_loan['loan_paid_at'] = df_loan['loan_paid_at'].apply(
                lambda x: datetime.datetime.strptime(datetime.datetime.strftime(x, '%Y-%m-%d 00:00:00'),
                                                     '%Y-%m-%d 00:00:00'))
            df_loan = df_loan[df_loan['observationTime'] > df_loan['loan_paid_at']]
            if df_loan.empty == False:
                _delq_days_max = df_loan['passdue_day'].max()
        self._result['delq_days_max']['value'] = _delq_days_max
        return self._result


##########################分割线 朝阳  -->> ##################################

class loan_date_longth():
    """user_latest_repayment_info#repayDays     loan_date_longth    上一笔订单贷款周期（结清时间-放款时间天数）"""
    def feature(self):
        _loan_date_longth = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack)
        if df_loan_result.empty == False:
            df_loan_result['loan_paid_at'] = df_loan_result['loan_paid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
            df_loan_result['repaid_at'] = df_loan_result['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
            _loan_date_longth = (df_loan_result["repaid_at"].max() - df_loan_result['loan_paid_at'].values[0]).days
        self._result['loan_date_longth']['value'] = _loan_date_longth
        return self._result

class passdue_day_max():
    """user_latest_repayment_info#maxOverdueDays	passdue_day_max  上一笔订单最大逾期天数（可正可负)"""
    def feature(self):
        _passdue_day_max = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack)
        if df_loan_result.empty == False:
            _passdue_day_max = df_loan_result['passdue_day'].max()
        self._result['passdue_day_max']['value'] = _passdue_day_max
        return self._result

class passdue_day_delay():
    """user_latest_repayment_info#totalOverdueDays	passdue_day_delay   上一笔订单逾期天数（大于等于0）"""
    def feature(self):
        _passdue_day_delay = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack)
        if df_loan_result.empty == False:
            if df_loan_result.empty == False:
                df_loan_result = df_loan_result[df_loan_result['passdue_day'] >=0]
                _passdue_day_delay = df_loan_result['passdue_day'].sum()
        self._result["passdue_day_delay"]["value"] = _passdue_day_delay
        return self._result

class passdue_day_tiqian():  #没有提前还款的返回什么
    """user_latest_repayment_info#totalAdvanceDays	passdue_day_tiqian  上一笔订单提前还款天数（小于0,sum求和）"""
    def feature(self):
        _passdue_day_tiqian = -9999999
        df_loan_result = get_loanSettleFrom(self.df_loan_rollBack)
        if df_loan_result.empty == False:
            df_loan_result = df_loan_result[df_loan_result["passdue_day"] <0]
            _passdue_day_tiqian = df_loan_result["passdue_day"].sum()
        self._result["passdue_day_tiqian"]["value"] = _passdue_day_tiqian
        return self._result

