import pandas as pd
from config.concat_sql import *
import re
import requests
from utils import tools
import datetime
from functools import reduce
from dateutil.relativedelta import relativedelta

#用户手机号用来判断是否是此时数据库中的手机号  用来判断是否注册
def getSql_authorizationPhone_one(uuid,userPhone):
    """用户手机号授权"""
    _sql = """
      select parentId as uuid,createDate,modifyDate,userSource,loginName
      from t_user_auth_info
      where parentId = '{0}' and loginName in {1}
      and userSource in ('YIDONG','LIANTONG','DIANXIN')
    """.format(uuid,userPhone)
    _df = pd.read_sql(_sql,con_lkbadmin)
    return _df

##获取用户手机号
def getSql_userPhone_one(user_id):
    """获取用户手机号"""
    _sql = """
        select id as user_id,uuid,phone_no,created_at
        from xyqb_i_user
        where id in {}
    """.format(user_id)
    _df = pd.read_sql(_sql,con_realtime)
    return _df


##移动数据库
def getSql_mobileCallInfoDataService_one(uuid = None,user_phone = None,contacts_phone = None,time_start = None,time_end = None):
    """ 移动通话记录 """
    # _sql = """
    #   select uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,phone from comservice_i_mobile_call_info
    # """
    _sql = """	select uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_mobile_call_info  force index(index_mobile_call_info_phone)"""
    iswhere = []
    if user_phone:
        iswhere.append(' phone in {0}'.format(user_phone))
    elif contacts_phone:
        iswhere.append(" receiverPhone in {0}".format(contacts_phone))
    elif time_start:
        iswhere.append(" cTime >= '{0}'".format(contacts_phone))
    elif time_end:
        iswhere.append(" cTime <= '{0}'".format(contacts_phone))

    if iswhere:
        for i in range(len(iswhere)):
            if i ==0:
                _sql += ' where ' + iswhere[i]
            else:
                _sql += ' and '+iswhere[i]
    if contacts_phone:
        _sql = """
            select uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_mobile_call_info force index(index_mobile_call_info_phone)
            where phone in ("{0}")
            and receiverPhone in ("{1}")
            and cTime  BETWEEN '{2}' and '{3}'
        """.format(user_phone,contacts_phone,time_start,time_end)
    else:
        _sql = """
            select uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_mobile_call_info force index(index_mobile_call_info_phone)
            where phone in ("{0}")
            and cTime  BETWEEN '{1}' and '{2}'
        """.format(user_phone,time_start,time_end)
    _df = pd.read_sql(_sql,con_comservice)

    return _df

##联通数据库
def getSql_unicomCallInfoDataService_one(uuid = None,user_phone = None,contacts_phone = None,time_start = None,time_end = None):
    """ 联通通话记录 """
    if contacts_phone:
        _sql = """
            select uuid,cTime,tradeAddr,callType as tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_unicom_call_info force index(index_unicom_call_info_phone)
            where phone  in ("{0}")
             and receiverPhone in ("{1}")
            and cTime  BETWEEN '{2}' and '{3}'
        """.format(user_phone,contacts_phone,time_start,time_end)

    else:
        _sql = """
            select uuid,cTime,tradeAddr,callType as tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_unicom_call_info force index(index_unicom_call_info_phone)
            where phone  in ("{0}")
            and cTime  BETWEEN '{1}' and '{2}'
        """.format(user_phone,time_start,time_end)
    _df = pd.read_sql(_sql,con_comservice)
    return _df

#电信数据库
def getSql_telecomCallInfoDataService_one(uuid = None,user_phone = None,contacts_phone = None,time_start = None,time_end = None):
    """ 电信通话记录 """
    if contacts_phone:
        _sql = """
            select uuid,cTime,tradeAddr,callWay as tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_telecom_call_info force index(index_telecom_call_info_phone)
            where phone  in ("{0}")
            and receiverPhone in ("{1}")
            and cTime  BETWEEN '{2}' and '{3}'
        """.format(user_phone,contacts_phone,time_start,time_end)
    else:
        _sql = """
            select uuid,cTime,tradeAddr,callWay as tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_telecom_call_info force index(index_telecom_call_info_phone)
            where phone  in ("{0}")
            and cTime  BETWEEN '{1}' and '{2}'
        """.format(user_phone,time_start,time_end)

    _df = pd.read_sql(_sql,con_comservice)
    return _df

#匹配手机好
def get_PhoneNo_one(l_phone):
    """匹配手机号"""
    # l_phone = [i for i in l_phone if re.match(r'(^|\D)(1[3546789]\d{9})($|\D)',str(i))]
    l_phone = [i for i in l_phone if re.match(r'^(1[3546789]\d{9})$',str(i))]

    return l_phone

#用过用户手机号,查找用户 user_id 进行合并处理
def getSql_phoneForUserId_one(phone):
    """用过用户手机号,查找用户 user_id"""
    _sql = """
        select id as user_id,phone_no,created_at
        from xyqb_i_user
        where phone_no in {0}
    """.format(phone)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

#获取申请额度记录表  返回 applytime  order_no
def getSql_Apply_quota_record(user_id,order_no):
    """获取申请额度记录表"""
    if order_no:
        _sql = """
            select apply_time,order_no,apply_from from apply_quota_record where user_id = {0} and order_no = '{1}'
        """.format(user_id,order_no)
        _df = pd.read_sql(_sql,con_tuomin_xyqb)
        return _df
    return None


#用过用户手机号,查找用户 user_id
def getSql_phoneForUserId(phone):
    """用过用户手机号,查找用户 user_id"""
    _sql = """
        select id as user_id,phone_no,created_at
        from xyqb_i_user
        where phone_no in {0}
    """.format(phone)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

#关系联系人在QG黑名单中的个数
def getSql_relation_in_qgblack_one(phone,created_at):
    """关系联系人在QG黑名单中的个数"""
    _sql = """
        SELECT id,phone,createDate
        FROM blacklist3_i_black_type_list_new
        WHERE phone in {0} and createDate < '{1}'
    """.format(phone,created_at)

    _df = pd.read_sql(_sql,con_realtime)
    return _df


#通讯录联系人调用hbase的接口   '98ba839f-859d-4c65-a54b-7a61933145a7' "SP148282666281673950198752"
def get_lxr_list(uuid=None,order_no=None):
    """近七天联系人信息"""
    params = {'user_uuid':str(uuid) , 'codes': 'user_contact_book_info#d7_contact_nums',
              "order_id":str(order_no),"business_type":0}
    headers = {
        'rc_auth_key': 'rc_offline',
        'rc_auth_secret': "9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    try:
        _url = "http://172.20.1.131:23010/calc/features"
        _request = requests.get(_url, params=params, headers=headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:
        ll_phone = pd.DataFrame(_response['data']['features']['user_contact_book_info#d7_contact_nums']['value'])
        if len(ll_phone) > 0:
            l_phone =ll_phone[0].tolist()
            l_phone = [str(i).replace(" ","").replace("-","") for i in l_phone]
            l_phone = [i for i in l_phone if re.match(r'^(1[3546789]\d{9})$', str(i))]
            return l_phone
    return list([])





import time
def get_lxr_list_hmd(uuid=None,order_no=None):
    """近七天联系人信息"""
    params = {'user_uuid':str(uuid) , 'codes': 'user_contact_book_info#d7_contact_nums',
              "order_id":str(order_no),"business_type":0}
    headers = {
        'rc_auth_key': 'rc_offline',
        'rc_auth_secret': "9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    _df = pd.DataFrame()
    try:
        _url = "http://172.20.1.131:23010/calc/features"
        _request = requests.get(_url, params=params, headers=headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:

        ll_phone = pd.DataFrame(_response['data']['features']['user_contact_book_info#d7_contact_nums']['value'])

        if ll_phone.empty == True:
            return _df
        if len(ll_phone) > 0:
            l_phone =ll_phone[0].tolist()
            # 找到接口的时间戳进行转换并且减去7天得到的结果
            l_time = _response["data"]["subInfo"]["snapshotTime"]
            timeArray = time.localtime(int((l_time / 1000)))
            created_at = time.strftime("%Y-%m-%d %H:%M:%S", timeArray)
            l_phone = [str(i).replace(" ","").replace("-","") for i in l_phone]
            l_phone = [i for i in l_phone if re.match(r'^(1[3546789]\d{9})$', str(i))]
            if len(l_phone) == 0:
                return _df
            _sql = """
                SELECT id,phone,createDate
                FROM blacklist3_i_black_type_list_new
                WHERE phone in {0} and createDate < '{1}'
            """.format(str(tuple(l_phone)).replace(',)',')'), created_at)
            _df = pd.read_sql(_sql, con_realtime)
            if _df.empty == True:
                return 0
            return _df
        else:
            return _df

    return _df

# get_lxr_list_hmd(uuid='f195fe5599894dcebc9057a46af387c6',order_no =None)
#获取用户所有放款订单明细   联系人
def getSql_loanAll_one(user_id):
    """获取用户所有放款订单明细"""
    _sql = """
        select
         IFNULL(aqr.order_no ,'') order_no
        ,loan.user_id,loan.id as loan_id,loan.progress,fest.contract_loan_amount,fest.loan_paid_at
        ,case when loan.created_at >='2018-05-08' then aqr.apply_from
            when loan.created_at < '2018-05-08' then loan.created_from
            else null
            end as applied_from
        ,if (sub.created_at is not null, sub.created_at ,loan.created_at) apply_time
        ,plan.id as plan_id,plan.term_no, plan.repayment_status, plan.deadline as deadline,DATE_ADD(plan.deadline,INTERVAL 1 second) as deadline_new
        ,plan.repaid_at,
        IFNULL( record.principal, plan_detail.principle ) principal,
        IFNULL( record.interest, plan_detail.interest ) interest,
        IFNULL( record.service_fee, plan_detail.service_fee_per_term ) serviceFee
        from loan_application_manifest_history as fest
        left join loan_application_history as loan on fest.loan_application_history_id = loan.id
        left join loan_submit_info as sub on sub.loan_id = loan.id
        left join repay as plan on plan.loan_application_history_id = loan.id
        left join repayment_record as record on record.repayment_plan_id = plan.id
        left join loan_account_ext as lae on lae.loan_id = loan.id
        left join apply_quota_record as aqr on aqr.order_no = lae.order_no
        LEFT JOIN plan_amount_detail as plan_detail ON plan.id = plan_detail.plan_id 
        where
        loan.user_id in {}
        and loan.progress in (15,16,65)
        and fest.transaction_status in (2,5)
        order by loan.id,plan.id
    """.format(user_id)

    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df



def getSql_userApplySubmit(user_id):
    """用户提交申请"""
    _sql = """
    SELECT b.user_id, u.created_at register_time, a.created_at submit_time
    FROM loan_submit_info a
    INNER JOIN loan_application_history b ON a.loan_id = b.id
    INNER JOIN user u on u.id = b.user_id
    WHERE u.id in {0}
    AND b.business_type IN (0, 2, 4, 6)
    AND a.created_at < '2018-05-08 00:00:00'
    UNION ALL
    SELECT r.user_id, u.created_at register_time, r.created_at submit_time
    FROM apply_quota_record r
    INNER JOIN user u on u.id = r.user_id
    WHERE u.id in {0}
    """.format(user_id)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df


def get_apply_type(uuid=None, order_no=None):
    """新老客户标签"""

    params = {'user_uuid': str(uuid), 'codes': 'user_loan_type_latest',
              "order_id": str(order_no), "business_type": 0}
    headers = {
        'rc_auth_key': 'rc_offline',
        'rc_auth_secret': "9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    try:
        _url = "http://172.20.1.184:23010/calc/features"
        _request = requests.get(_url, params=params, headers=headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:
        type_value = _response['data']['features']['user_loan_type_latest']['value']
        return type_value
    return None

def chose_apply_from(order_no):
    """选择渠道号"""
    _sql = """SELECT apply_from FROM apply_quota_record  WHERE order_no = '{0}'""".format(order_no)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df
