# -*- coding:utf-8 -*-
import pandas as pd
from config.concat_sql import *
import re
from utils import tools
import datetime
from functools import reduce
from dateutil.relativedelta import relativedelta
import time

def getSql_userPhone(user_id):
    """获取用户手机号"""
    _sql = """
        select id as user_id,uuid,phone_no,created_at
        from xyqb_i_user
        where id in {0}
    """.format(user_id)  # type: str
    _df = pd.read_sql(_sql,con_realtime)
    return _df



def getSql_id_no(user_id):
    """通过userid获取身份证号"""
    _sql="""
    
    SELECT id_no from xyqb_user_i_user_detail 
    where user_id={0}
    """.format(user_id)
    _df = pd.read_sql(_sql, con_realtime)
    return _df

def getSql_Apply_quota_record(user_id,order_no = None):
    """获取申请额度记录表"""
    if order_no:
        _sql = """
            select apply_time,order_no from apply_quota_record where user_id = {0} and order_no = '{1}'
        """.format(user_id,order_no)
    else:
        _sql = """
            select apply_time,order_no from apply_quota_record where user_id = {0}
        """.format(user_id)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def getSql_EmergencyContact(user_id,created_at):
    """获取用户联系人"""
    _sql = """
        SELECT DISTINCT(c.phone_no) phone_no,u2.id user_id ,c.created_at,u.phone_no user_phone
        FROM xyqb_i_user u
        JOIN xyqb_user_i_contact c ON u.id = c.user_id
        LEFT JOIN xyqb_i_user u2 on u2.phone_no = c.phone_no
        where u.id = {0}
        and c.created_at < '{1}';
    """.format(user_id,created_at)
    # and c.created_at < '{1}';

    _df = pd.read_sql(_sql,con_realtime)
    return _df

def getSql_emergency_contact(user_id,created_at,phone_no):
    """获取用户联系人 不包括用户自己"""
    _sql = """
        SELECT DISTINCT(c.phone_no) phone_no,u2.id user_id, c.created_at created_at
        FROM xyqb_i_user u
        LEFT JOIN xyqb_user_i_contact c ON u.id = c.user_id
        LEFT JOIN xyqb_i_user u2 on u2.phone_no = c.phone_no
        where u.id ={0}
        and c.created_at <'{1}' and c.phone_no !='{2}'
        order by c.created_at desc limit 2
    """.format(user_id,created_at,phone_no)

    _df = pd.read_sql(_sql,con_realtime)
    return _df


def getSql_same_relation_repeat(user_id,contacts_phone,time_start,time_end):
    """联系人被其他用户填写为联系人, contacts_phone 联系人手机号"""
    _sql = """
        select * from xyqb_user_i_contact
        where phone_no in {0} and user_id != {1}
        and created_at BETWEEN '{2}' and '{3}'
    """.format(contacts_phone,user_id,time_start,time_end )
    _df = pd.read_sql(_sql,con_realtime)
    return _df

def getSql_relation_in_qgblack(phone,created_at):
    """关系联系人在QG黑名单中的个数"""
    _sql = """
        SELECT id,phone,createDate
        FROM blacklist3_i_black_type_list_new
        WHERE phone in {0} and createDate < '{1}'
    """.format(phone,created_at)

    _df = pd.read_sql(_sql,con_realtime)
    return _df

def getSql_relation_phone_in_blacklist(phone, id_no, created_at_start ,created_at_end):
    """用过用户手机号\身份证号获取黑名单中的个数"""
    _sql = """
        select major_type,type,id, created_at 
        from black_list_new 
        where (phone_no = '{0}' or id_no = '{1}')
        and status = 1 
        and created_at > '{2}'
        and created_at <'{3}'
    """.format(phone,id_no,created_at_start,created_at_end )

    _df = pd.read_sql(_sql,con_blacklist3_read)
    return _df

def getSql_emergency_contact_phone_in_blacklist(phone, created_at_start,created_at_end ):
    """用过用户手机号\身份证号获取黑名单中的个数"""
    _sql = """
        select major_type,type,id, created_at 
        from black_list_new 
        where phone_no in {0}
        and status = 1 
        and created_at >'{1}'
        and created_at <'{2}'
    """.format(phone,created_at_start,created_at_end)

    _df = pd.read_sql(_sql,con_blacklist3_read)
    return _df

def getSql_phoneForUserId(phone):
    """用过用户手机号,查找用户 user_id"""
    _sql = """
        select id as user_id,uuid,phone_no,created_at
        from xyqb_i_user
        where phone_no in {0}
    """.format(phone)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

def getSql_userQuotaRecord(user_id,order_no = None):
    """用户点击申请"""
    # if order_no:
    #     _sql = sql + "order"
    _sql = """
        SELECT
        h.user_id user_id, h.created_at created_at,
        h.id as loan_id ,Null order_no
        FROM loan_application_history h
        INNER JOIN user u on h.user_id = u.id
        WHERE u.id in {0}
        AND h.created_at < '2018-05-08 00:00:00'
        AND h.business_type in (0,2,4,6)
        UNION ALL
        SELECT q.user_id user_id, q.created_at created_at,
        Null loan_id,
		q.order_no as order_no
        FROM quota_credit q
        INNER JOIN user u on u.id = q.user_id
        WHERE u.id in {0}
    """.format(user_id)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def getSql_userApplySubmit(user_id):
    """用户提交申请"""
    _sql = """
    SELECT b.user_id, u.created_at register_time, a.created_at submit_time
    FROM loan_submit_info a
    INNER JOIN loan_application_history b ON a.loan_id = b.id
    INNER JOIN user u on u.id = b.user_id
    WHERE u.id in {0}
    AND b.business_type IN (0, 2, 4, 6)
    AND a.created_at < '2018-05-08 00:00:00'
    UNION ALL
    SELECT r.user_id, u.created_at register_time, r.created_at submit_time
    FROM apply_quota_record r
    INNER JOIN user u on u.id = r.user_id
    WHERE u.id in {0}
    """.format(user_id)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def getSql_userApplyQuotaRecord(user_id):
    """通过用户ID 查询用户的历史提交申请次数,包括新的申请提交方式和老的申请提交方式 ,apply_status 1 拒绝,0 通过"""
    # _sql = """
    #     select aqr.* from xyqb_i_apply_quota_record as aqr
    #     left join xyqb_i_user as u on u.id = aqr.user_id
    #     where u.id in {0}
    # """.format(user_id) #,time_start,time_end
    _sql = """
        SELECT
            l.user_id,
            l.id loan_id,
            e.order_no,
            if(ls.created_at is not null,
                ls.created_at,
                l.created_at) as apply_time,
            if(l.progress in (6, 8, 19), 1, 0) apply_status,
            l.created_from as apply_from
        FROM  loan_application_history l
        LEFT JOIN loan_account_ext e  ON e.loan_id = l.id
        left join loan_submit_info ls on ls.loan_id = l.id
        WHERE l.user_id in {0}
        and l.business_type IN (0, 2, 4,6)
        AND e.loan_id IS NULL
        union
        select
            aqr.user_id ,
            lae.loan_id,
            aqr.order_no,
            aqr.apply_time,
            -- case when aqr.apply_status = 2 then 0
            case when aqr.apply_status != 1 then 0
            else 1 end as apply_status,
            aqr.apply_from
        from apply_quota_record as aqr
        left join loan_account_ext as lae on lae.order_no = aqr.order_no
        where aqr.user_id in {0}
    """.format(user_id)

    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def getSql_numbers_of_relation_loan(user_id,time_start,time_end):
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG贷款次数之和"""
    if time_start == None:
        _sql = """
        SELECT loan.user_id user_id,loan.id as loan_id ,fest.loan_paid_at as loan_paid_at
        FROM xyqb_i_loan_application_history as loan
        left join xyqb_i_loan_application_manifest_history as fest on loan.id = fest.loan_application_history_id
        WHERE loan.user_id in {0}
        and loan.progress In (15,16,65)
        and loan.business_type IN (0,2,4)
        and fest.loan_paid_at <= '{1}'
    """.format(user_id,time_end)
    else:
        _sql = """
            SELECT loan.user_id user_id,loan.id as loan_id ,fest.loan_paid_at as loan_paid_at
            FROM xyqb_i_loan_application_history as loan
            left join xyqb_i_loan_application_manifest_history as fest on loan.id = fest.loan_application_history_id
            WHERE loan.user_id in {0}
            and loan.progress In (15,16,65)
            and loan.business_type IN (0,2,4)
            and fest.loan_paid_at BETWEEN '{1}' and '{2}'
        """.format(user_id,time_start,time_end)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

def getSql_loanIn(user_id,created_at = None):
    """获取用户在贷订单"""

    _sql = """
        SELECT m.* FROM xyqb_i_loan_application_history l
        JOIN xyqb_i_loan_application_manifest_history m ON l.id = m.loan_application_history_id
        WHERE l.user_id in {0}
        AND l.progress IN (15,65)
        AND l.business_type IN ( 0, 2, 4, 6 )
        and l.created_at < '{1}'
    """.format(user_id,created_at)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

def getSql_loanEnd(user_id,created_at):
    """获取用户已结清的订单"""
    _sql = """
        SELECT m.* FROM xyqb_i_loan_application_history l
        JOIN xyqb_i_loan_application_manifest_history m ON l.id = m.loan_application_history_id
        WHERE l.user_id in {0}
        AND l.progress = 16
        AND l.business_type IN ( 0, 2, 4, 6 )
        and l.created_at < '{1}'
    """.format(user_id,created_at)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

def getSql_loan(user_id):
    """获取用户放款订单"""
    _sql = """
        SELECT m.* FROM xyqb_i_loan_application_history l
        JOIN xyqb_i_loan_application_manifest_history m ON l.id = m.loan_application_history_id
        WHERE l.user_id in {0}
        AND l.progress IN (15,16,65)
        AND l.business_type IN ( 0, 2, 4, 6 )
    """.format(user_id)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

def getSql_loanAll(user_id):
    """获取用户所有放款订单明细"""
    _sql = """
        select
         IFNULL(aqr.order_no ,'') order_no,loan.business_type
        ,loan.user_id,loan.id as loan_id,loan.progress,fest.contract_loan_amount,fest.loan_paid_at,fest.monthly_interest_rate
        ,case when loan.created_at >='2018-05-08' then aqr.apply_from
            when loan.created_at < '2018-05-08' then loan.created_from
            else null
            end as applied_from
        -- ,if (sub.created_at is not null, sub.created_at ,loan.created_at) apply_time
        ,case when loan.created_at >='2018-05-08' then aqr.apply_time
            when loan.created_at < '2018-05-08' then if (sub.created_at is not null, sub.created_at ,loan.created_at)
            else null
            end as apply_time
        ,plan.id as plan_id,plan.term_no, plan.repayment_status, plan.deadline as deadline,DATE_ADD(plan.deadline,INTERVAL 1 second) as deadline_new
        ,plan.repaid_at
        ,plan.current_repayment,plan.required_repayment
        from loan_application_manifest_history as fest
        left join loan_application_history as loan on fest.loan_application_history_id = loan.id
        left join loan_submit_info as sub on sub.loan_id = loan.id
        left join repay as plan on plan.loan_application_history_id = loan.id
        left join repayment_record as record on record.repayment_plan_id = plan.id
        left join loan_account_ext as lae on lae.loan_id = loan.id
        left join apply_quota_record as aqr on aqr.order_no = lae.order_no
        where
        loan.user_id in {}
        and loan.progress in (15,16,65)
        and fest.transaction_status in (2,5)
        and loan.business_type in (0,2)
        order by loan.id,plan.id
        """.format(user_id)

    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def getSql_loanAll_diangdanv2(user_id,apply_at):
    """获取用户所有放款订单明细"""

    _sql = """
        SELECT m.* FROM loan_application_history l
        JOIN loan_application_manifest_history m ON
        l.id = m.loan_application_history_id WHERE
        l.user_id in {0} AND l.progress IN (15,16,65)
        AND l.business_type IN ( 0, 2, 4, 6 ) and m.loan_paid_at < '{1}' order by m.loan_paid_at desc""".format(user_id,apply_at)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def getSql_loan_applyAll(user_id):
    """获取用户所有放款订单明细"""
    _sql = """
        select
         IFNULL(aqr.order_no ,'') order_no
        ,loan.user_id,loan.id as loan_id,loan.progress,fest.contract_loan_amount
        ,case when loan.created_at >='2018-05-08' then aqr.apply_from
            when loan.created_at < '2018-05-08' then loan.created_from
            else null
            end as applied_from
        ,if (sub.created_at is not null, sub.created_at ,loan.created_at) apply_time
        ,plan.id as plan_id,plan.term_no, plan.repayment_status, plan.deadline as deadline,DATE_ADD(plan.deadline,INTERVAL 1 second) as deadline_new
        ,plan.repaid_at
        from loan_application_manifest_history as fest
        left join loan_application_history as loan on fest.loan_application_history_id = loan.id
        left join loan_submit_info as sub on sub.loan_id = loan.id
        left join repay as plan on plan.loan_application_history_id = loan.id
        left join repayment_record as record on record.repayment_plan_id = plan.id
        left join loan_account_ext as lae on lae.loan_id = loan.id
        left join apply_quota_record as aqr on aqr.order_no = lae.order_no
        where
        loan.user_id in {}
        and loan.progress in (15,16,65)
        order by loan.id,plan.id
    """.format(user_id)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def getSql_loan_detailQG(user_id):
    _sql = """
        SELECT
            u.id as user_id,a.loan_application_history_id as loan_id ,a.created_at
        FROM
            waiting_funding_corp_operate_people a
        LEFT JOIN loan_application_manifest_history b
        INNER JOIN user u ON u.id = b.user_id ON a.loan_application_history_id = b.loan_application_history_id
        WHERE
            u.id IN {0}
        AND a.created_at > '2018-05-08 00:00:00'
        UNION ALL
        SELECT
            u.id as user_id,p.loan_application_history_id as loan_id ,p.created_at
        FROM
            repayment_plan p
        INNER JOIN user u ON u.id = p.user_id
        WHERE
            u.id IN {0}
        AND p.created_at < '2018-05-08 00:00:00'
        AND p.term_no = 1
    """.format(user_id)
    _df = pd.read_sql(_sql,con = con_tuomin_xyqb)
    return _df
def getSql_userApplyQuota(user_id):
    """ 用户申请点击申请 apply_status 2 通过, 1 拒绝"""
    _sql = """
        SELECT
            u.id AS user_id,
            r.apply_status,
            r.risk_notify_time as apply_time
        FROM
            xyqb_i_apply_quota_record r
            INNER JOIN xyqb_i_user u ON r.user_id = u.id
        WHERE
            r.apply_status IN ( 1, 2 )
            AND u.id IN {0}
        UNION ALL
        SELECT
            user_id,
            CASE WHEN h.progress > 8 AND h.progress NOT IN (17,18,19) THEN 2
                    WHEN h.progress IN (6, 8, 19) THEN 1
                    ELSE 0 END AS apply_status,
            s.created_at as apply_time
        FROM
            xyqb_i_loan_application_history h
            INNER JOIN xyqb_i_user u ON u.id = h.user_id
            INNER JOIN xyqb_i_loan_submit_info s ON s.loan_id = h.id
        WHERE
            u.id IN {0}
            AND h.business_type = 0
            AND s.created_at < '2018-05-08 00:00:00' AND h.progress > 8
            AND h.progress NOT IN ( 17, 18, 19 )
    """.format(user_id)
    _df = pd.read_sql(_sql,con = con_realtime)
    return _df

def getSql_userApplyQuota_QG(user_id):
    """ 用户申请点击申请 apply_status 2 通过, 1 拒绝"""
    _sql = """
        SELECT
            u.id AS user_id,
            r.apply_status,
            r.created_at as created_at,
            null loan_id,
			r.order_no
        FROM
            apply_quota_record r
            INNER JOIN user u ON r.user_id = u.id
        WHERE
            r.apply_status IN ( 1, 2 )
            AND u.id IN {0}
        UNION ALL
        SELECT
            user_id,
            CASE WHEN h.progress > 8 AND h.progress NOT IN (17,18,19) THEN 2
                    WHEN h.progress IN (6, 8, 19) THEN 1
                    ELSE 0 END AS apply_status,
            s.created_at as created_at,
            h.id loan_id,
			null order_no
        FROM
            loan_application_history h
            INNER JOIN user u ON u.id = h.user_id
            INNER JOIN loan_submit_info s ON s.loan_id = h.id
        WHERE
            u.id IN {0}
            AND h.business_type = 0
            AND s.created_at < '2018-05-08 00:00:00'
    """.format(user_id)
    _df = pd.read_sql(_sql,con = con_tuomin_xyqb)
    return _df

def getSql_ApplyAndloan(user_id):
    """用户从申请 到 提现过程"""
    _sql = """
        SELECT
            u.id AS user_id,
            r.risk_notify_time AS permit_time,
            w.created_at AS withdraw_apply_time
        FROM
            xyqb_i_loan_account_ext l
            LEFT JOIN xyqb_i_apply_quota_record r ON r.order_no = l.order_no
            INNER JOIN xyqb_i_user u ON u.id = r.user_id
            LEFT JOIN xyqb_i_waiting_funding_corp_operate_people w ON l.loan_id = w.loan_application_history_id
        WHERE
            r.apply_status = 2
            AND r.user_id IN {0}
        UNION ALL
        SELECT
            u.id AS user_id,
            s.created_at AS permit_time,
            p.created_at AS withdraw_apply_time
        FROM
            xyqb_i_repayment_plan p
            INNER JOIN xyqb_i_loan_application_history h ON p.loan_application_history_id = h.id
            INNER JOIN xyqb_i_loan_submit_info s ON s.loan_id = h.id
            INNER JOIN xyqb_i_user u ON u.id = h.user_id
        WHERE
            h.created_at < '2018-05-08 00:00:00'
            AND business_type = 0
            AND p.user_id IN {0}
            AND p.term_no = 1
    """.format(user_id)
    _df = pd.read_sql(_sql,con_realtime)
    return _df


def getSql_authorizationPhone(uuid,userPhone):
    """用户手机号授权"""
    _sql = """
      select parentId as uuid,createDate,modifyDate,userSource,loginName
      from t_user_auth_info
      where parentId = '{0}' and loginName in {1}
      and userSource in ('YIDONG','LIANTONG','DIANXIN')
    """.format(uuid,userPhone)
    _df = pd.read_sql(_sql,con_lkbadmin)
    return _df

def getSql_mobileCallInfoDataService(uuid = None,user_phone = None,contacts_phone = None,time_start = None,time_end = None,timestamp_start =None,timestamp_end =None,orderby = [] ,limit = None):
    """ 移动通话记录 """
    _sql = """
      select uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,phone,`timestamp`
      from comservice_i_mobile_call_info force index(index_mobile_call_info_phone)
    """
    iswhere = []
    if user_phone:
        iswhere.append(' phone in {0}'.format(user_phone))
    if contacts_phone:
        iswhere.append(" receiverPhone in {0}".format(contacts_phone))
    if time_start:
        iswhere.append(" cTime > '{0}'".format(time_start))
    if time_end:
        iswhere.append(" cTime <= '{0}'".format(time_end))
    if timestamp_start:
        iswhere.append(" timestamp > '{0}'".format(timestamp_start))
    if timestamp_end:
        iswhere.append(" timestamp <= '{0}'".format(timestamp_end))
    if orderby:
        iswhere.append(" order by {0} {1}".format(orderby[0],orderby[1]))
    if limit:
        iswhere.append(" limit {0}".format(limit))

    if iswhere:
        for i in range(len(iswhere)):
            if i ==0 :
                _sql += ' where ' + iswhere[i]
            else:
                if 'order by' not in iswhere[i] and 'limit' not in  iswhere[i]:
                    _sql += ' and '+iswhere[i]
                else:
                    _sql += ' '+iswhere[i]
    _df = pd.read_sql(_sql,con_comservice)

    return _df

def getSql_telecomCallInfoDataService(uuid = None,user_phone = None,contacts_phone = None,time_start = None,time_end = None,timestamp_start =None,timestamp_end=None,orderby = [] ,limit = None):
    """ 电信通话记录 """

    _sql = """
        select uuid,cTime,tradeAddr,callWay as tradeWay,tradeType,receiverPhone,tradeTime,phone,`timestamp`
        from comservice_i_telecom_call_info force index(index_telecom_call_info_phone)
    """
    iswhere = []
    if user_phone:
        iswhere.append(' phone in {0}'.format(user_phone))
    if contacts_phone:
        iswhere.append(" receiverPhone in {0}".format(contacts_phone))
    if time_start:
        iswhere.append(" cTime > '{0}'".format(time_start))
    if time_end:
        iswhere.append(" cTime <= '{0}'".format(time_end))
    if timestamp_start:
        iswhere.append(" timestamp > '{0}'".format(timestamp_start))
    if timestamp_end:
        iswhere.append(" timestamp <= '{0}'".format(timestamp_end))
    if orderby:
        iswhere.append(" order by {0} {1}".format(orderby[0],orderby[1]))
    if limit:
        iswhere.append(" limit {0}".format(limit))

    if iswhere:
        for i in range(len(iswhere)):
            if i ==0 :
                _sql += ' where ' + iswhere[i]
            else:
                if 'order by' not in iswhere[i] and 'limit' not in  iswhere[i]:
                    _sql += ' and '+iswhere[i]
                else:
                    _sql += ' '+iswhere[i]

    _df = pd.read_sql(_sql,con_comservice)
    return _df

def getSql_unicomCallInfoDataService(uuid = None,user_phone = None,contacts_phone = None,time_start = None,time_end = None,timestamp_start =None,timestamp_end=None,orderby = [] ,limit = None):
    """ 联通通话记录 """
    _sql = """
            select uuid,cTime,tradeAddr,callType as tradeWay,tradeType,receiverPhone,tradeTime,phone,`timestamp`
            from comservice_i_unicom_call_info force index(index_unicom_call_info_phone)
    """
    iswhere = []
    if user_phone:
        iswhere.append(' phone in {0}'.format(user_phone))
    if contacts_phone:
        iswhere.append(" receiverPhone in {0}".format(contacts_phone))
    if time_start:
        iswhere.append(" cTime > '{0}'".format(time_start))
    if time_end:
        iswhere.append(" cTime <= '{0}'".format(time_end))
    if timestamp_start:
        iswhere.append(" timestamp > '{0}'".format(timestamp_start))
    if timestamp_end:
        iswhere.append(" timestamp <= '{0}'".format(timestamp_end))
    if orderby:
        iswhere.append(" order by {0} {1}".format(orderby[0],orderby[1]))
    if limit:
        iswhere.append(" limit {0}".format(limit))

    if iswhere:
        for i in range(len(iswhere)):
            if i ==0 :
                _sql += ' where ' + iswhere[i]
            else:
                if 'order by' not in iswhere[i] and 'limit' not in  iswhere[i]:
                    _sql += ' and '+iswhere[i]
                else:
                    _sql += ' '+iswhere[i]
    _df = pd.read_sql(_sql,con_comservice)
    return _df

def get_allOperator_df(uuid,user_phone,_apply_at):
    """获取近150天一度联系人近300天的数据源，不分运营商"""
    _df_telephone = pd.DataFrame()
    yidong_df_telephone = getSql_mobileCallInfoDataService(uuid=uuid,user_phone=user_phone)
    liantong_df_telephone = getSql_unicomCallInfoDataService(uuid=uuid,user_phone=user_phone)
    dianyin_df_telephone = getSql_telecomCallInfoDataService(uuid=uuid,user_phone=user_phone)
    """进行运营商数据合并"""
    _df_telephone = pd.concat([yidong_df_telephone, liantong_df_telephone, dianyin_df_telephone])
    if _df_telephone.empty == False:
        _df_telephone['timestamp'] = pd.to_datetime(_df_telephone['timestamp'])
        _df_telephone['apply_at'] = _apply_at
        _df_telephone['apply_at'] = pd.to_datetime(_df_telephone['apply_at'])
        _df_telephone['cTime'] = pd.to_datetime(_df_telephone['cTime'])
        _df_telephone = _df_telephone.sort_values(['timestamp'])
        _df_telephone = _df_telephone[_df_telephone['timestamp'] <= _df_telephone['apply_at']]
        if _df_telephone.empty == True:
            time_end = str(datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S'))
        else:
            time_end = str(_df_telephone['timestamp'].max())
        time_start = str(datetime.datetime.strptime(str(time_end), '%Y-%m-%d %H:%M:%S') - datetime.timedelta(days=150))
        timestamp_start = str(datetime.datetime.strptime(str(time_end), '%Y-%m-%d %H:%M:%S') - datetime.timedelta(days=300))
        """进行ctime 150天 过滤  stamptime 300天过滤"""
        YIDONG_df_telephone = getSql_mobileCallInfoDataService(uuid=uuid, user_phone=user_phone,
                                                               time_start=time_start,
                                                               time_end=time_end, timestamp_start=timestamp_start,
                                                               timestamp_end=time_end)

        LIANTONG_df_telephone = getSql_unicomCallInfoDataService(uuid=uuid, user_phone=user_phone,
                                                                 time_start=time_start,
                                                                 time_end=time_end, timestamp_start=timestamp_start,
                                                                 timestamp_end=time_end)

        DIANXIN_df_telephone = getSql_telecomCallInfoDataService(uuid=uuid, user_phone=user_phone,
                                                                 time_start=time_start,
                                                                 time_end=time_end, timestamp_start=timestamp_start,
                                                                 timestamp_end=time_end)
        _df_telephone = pd.concat([YIDONG_df_telephone, LIANTONG_df_telephone, DIANXIN_df_telephone])

    return _df_telephone

def getSql_balancenetworkPhone(userPhone):
    """手机余额和入网天数"""
    _sql = """
        select phone,uuid,registerDate,phoneRemain,updated_at
        from comservice_i_spider_user_info
        where phone in {0}
              and  userSource in ("LIANTONG","YIDONG","DIANXIN")
    """.format(userPhone)
    _df = pd.read_sql(_sql,con_comservice_v3)
    return _df

def getSql_PayablebillPhone(userPhone, date_):
    """应缴话费详单"""
    _sql = """
            select uuid,phoneNo,billDay,amount,updated_at
            from comservice_i_phone_bill_info
            where phoneNo in {0} and billDay in {1}

    """.format(userPhone, date_)
    _df = pd.read_sql(_sql,con_comservice_v3)
    return _df

def getSql_PaybillPhone(userPhone, starttime, endtime):
    """实缴话费详单"""
    _sql = """
            select uuid,phone,payamount,paytime,updated_at
            from comservice_i_phone_payment_info
            where phone in {0}
            and paytime >= '{1}' and paytime < '{2}'

    """.format(userPhone, starttime, endtime)
    _df = pd.read_sql(_sql,con_comservice_v3)
    return _df


def get_PhoneNo(l_phone):
    """匹配手机号"""
    l_phone = [i for i in l_phone if re.match(r'^(1[3546789]\d{9})$',str(i))]
    return l_phone


import requests
def get_user_interval_call_rows():
    """用户通话记录"""
    params = {'user_uuid':'6a1ec6f5-0974-4a49-84e6-a2ab02bc501c','codes':'user_interval_call_rows#m5'}
    headers = {
        'rc_auth_key':'rc_developer',
        'rc_auth_secret':'rc_secret'
    }
    _response = None
    try:
        _url = 'http://172.20.1.131:23010/calc/features'
        _request = requests.get(_url,params=params,headers = headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:
        df_dateil = pd.DataFrame(_response['data']['features']['user_interval_call_rows#m5']['value'])
        return df_dateil
    return None

def get_user_bill_info_rows(uuid,_created_at=None,time_from=0):
    """获取手机话费账单"""
    params = {'user_uuid':str(uuid),'codes':'user_bill_info_rows'}
    headers = {
        'rc_auth_key':'rc_offline',
        'rc_auth_secret':"9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    try:
        _url = 'http://172.20.1.131:23010/calc/features'
        _request = requests.get(_url,params=params,headers = headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)

    df = pd.DataFrame()
    if _response:
        df = pd.DataFrame(_response['data']['features']['user_bill_info_rows']['value'])
        if df.empty ==False:
            time_now = datetime.datetime.strptime(datetime.datetime.strftime((_created_at.replace(day=1) - datetime.timedelta(1)).replace(day=1),'%Y-%m-%d 00:00:00'),'%Y-%m-%d %H:%M:%S')
            time_from = time_now - relativedelta(months=+time_from)
            df['billDay'] = df['billDay'].apply(lambda stamp: time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(stamp/1000)))
            # df['billDay'] = pd.to_datetime(df['billDay'])
            df = df.loc[(df['billDay']>str(time_from)) & (df['billDay']<=str(time_now))]
        return df
    return df

def get_lkb_user_phone_location(uuid):
    """获取电话归属地信息"""

    params = {'user_uuid':str(uuid),'codes':'lkb_user_phone_location'}
    headers = {
        'rc_auth_key':'rc_offline',
        'rc_auth_secret':"9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    try:
        _url = 'http://172.20.1.131:23010/calc/features'
        _request = requests.get(_url,params=params,headers = headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)

    if _response:
        _r = _response['data']['features']['lkb_user_phone_location']['value']
        return _r['city']
    return None

def get_interval_day(l_time,isseconds=False):
    """获取一个时间list,返回间隔的天数"""
    interval_day = []
    def interval(x,y,z,index):
        index += 1
        if x == None:
            x = z[index-1]
        x = datetime.datetime.strptime(x,'%Y-%m-%d %H:%M:%S')
        y = datetime.datetime.strptime(y,'%Y-%m-%d %H:%M:%S')
        if isseconds:
            day = (y-x).days * 86400
            second = (y-x).seconds
            return day+second
        else:
            return (y-x).days
    reduce(lambda x,y : interval_day.append(interval(x,y,l_time,0)),l_time)
    return interval_day

def getTradeAdd(tradeAddr):
    """城市名称最后一个字是‘市’,就删除掉"""
    if tradeAddr == None or tradeAddr=='':
        return ''
    else:
        return str(tradeAddr[:-1]) if tradeAddr[len(tradeAddr)-1] == '市' else str(tradeAddr)

def getCityisLocal(City,x,tradeType=''):
    if x=='' or x==None:
        return 3

    # if len(re.findall(x,City)) >0 or len(re.findall(City,x))>0:
    if City in x:
        return 1
    if len(re.findall(x,'本地'))>0 or len(re.findall(str('本地'),x))>0:
        return 1
    if len(re.findall(x,'号码归属地'))>0 or len(re.findall(str('号码归属地'),x))>0 :
        return 1
    return 2

def get_Loan_rollBack(df_loan,apply_time):
    """订单回滚"""
    df_loan['observationTime'] = apply_time
    df_loan = df_loan.loc[(df_loan['apply_time'] < df_loan['observationTime']) & (df_loan['loan_paid_at'] <= df_loan['observationTime'] )]
    if df_loan.empty == False:
        df_loan['repaid_at'] = df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
        df_loan['deadline'] = df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
        df_loan['deadline'] = df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
        df_loan['apply_time'] = df_loan['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
        df_loan['passdue_day'] = 0

        df_loan.loc[(df_loan['observationTime'] >df_loan['deadline']) & (df_loan['observationTime'] <df_loan['repaid_at']),'repayment_status'] = 0
        df_loan.loc[(df_loan['observationTime'] < df_loan['deadline']) & (df_loan['observationTime'] <df_loan['repaid_at']),'repayment_status'] = 0

        df_loan.loc[df_loan['repayment_status']!=3,'repayment_status'] = 0
        df_loan.loc[df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

        df_loan.loc[(df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (df_loan['repaid_at'] - df_loan['deadline']).dt.days
        df_loan.loc[(df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days

        df_loan.loc[(df_loan['passdue_day'] <= 0),'passdue_day'] = 0
        df_loan['passdue_day'] = df_loan['passdue_day'].fillna(0)

        _loan_id = df_loan.loc[(df_loan['repayment_status']!=3)&(df_loan['apply_time']<df_loan['observationTime'])]['loan_id'].tolist()
        _loan_id = list(set(_loan_id))
        if _loan_id:
            df_loan.loc[(df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
        else:
            df_loan['progress'] = 16
        df_loan = df_loan
    return df_loan


def get_CallPhoneTime(userSource,uuid,user_phone,day,apply_time):
    """获取全部通话记录 并且那申请时间做比较，如果申请时间小于timestamp 则用当前时间"""
    df_telephone = pd.DataFrame()
    if userSource == 'YIDONG':
        df_telephone = getSql_mobileCallInfoDataService(uuid = uuid,
                                                        user_phone = user_phone,
                                                        orderby=['timestamp','desc'])
    elif userSource == 'LIANTONG':
        df_telephone = getSql_unicomCallInfoDataService(uuid = uuid,
                                                        user_phone = user_phone,
                                                        orderby=['timestamp','desc'])
    elif userSource == 'DIANXIN':
        df_telephone = getSql_telecomCallInfoDataService(uuid = uuid,
                                                         user_phone = user_phone,
                                                         orderby=['timestamp','desc'])
    df_telephone['timestamp'] = pd.to_datetime(df_telephone['timestamp'])
    df_telephone['apply_at'] = apply_time
    df_telephone['apply_at'] = pd.to_datetime(df_telephone['apply_at'])
    df_telephone['cTime'] = pd.to_datetime(df_telephone['cTime'])
    df_telephone = df_telephone.sort_values(['timestamp'])
    df_telephone = df_telephone[df_telephone['timestamp'] <= df_telephone['apply_at']]
    if df_telephone.empty == False:
        endtime = str(df_telephone['timestamp'].max())
    else:
        endtime = str(datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S'))
    # df_telephone['timestamp'] = df_telephone['timestamp'].apply(lambda x : str(x))
    starttime = str(datetime.datetime.strptime(endtime ,'%Y-%m-%d %H:%M:%S') - day)
    # endtime = df_telephone['timestamp'].values[0]
    return (starttime,endtime)
    # return None


def get_CallPhone(df_auth,uuid,user_phone,contacts_phone,day,apply_time):
    """判断运营商类型，找到开始时间与day的时间进行查询通话记录详情"""
    userSource = df_auth['userSource'].values[0]
    _time = get_CallPhoneTime(userSource,uuid,user_phone,day,apply_time)
    df_telephone = pd.DataFrame()
    if _time:
        if userSource == 'YIDONG':
            df_telephone = getSql_mobileCallInfoDataService(uuid = uuid,
                                                            user_phone = user_phone,
                                                            contacts_phone = contacts_phone,time_start=_time[0],time_end=_time[1])
        elif userSource == 'LIANTONG':
            df_telephone = getSql_unicomCallInfoDataService(uuid = uuid,
                                                            user_phone = user_phone,
                                                            contacts_phone = contacts_phone,time_start=_time[0],time_end=_time[1])
        elif userSource == 'DIANXIN':
            df_telephone = getSql_telecomCallInfoDataService(uuid = uuid,
                                                             user_phone = user_phone,
                                                             contacts_phone = contacts_phone,time_start=_time[0],time_end=_time[1])
    return df_telephone


def get_userContacts(phoneNo):
    """ 获取联系人 """
    # ,time_start = applyTime_from,time_end=applyTime,timestamp_start = cTime_from,timestamp_end = cTime
    df_mobile = getSql_mobileCallInfoDataService(user_phone=phoneNo)
    df_telecom = getSql_telecomCallInfoDataService(user_phone=phoneNo)
    df_unicom = getSql_unicomCallInfoDataService(user_phone=phoneNo)
    df = pd.concat([df_mobile,df_telecom,df_unicom],axis=0)
    return df

def get_userContactsFilter(ContactsNum = 1,df = None,applyTime = None,timesTampFDays = None,applyTimeFDays=None,userPhone=None,OneContactsCall=None):
    """联系人过滤,可以是1度联系人也可以是二度联系人
        data:
            ContactsNum 1 一度联系人,2 二度联系人
            df 联系人矩阵
            applyTime 用户申请时间
            timesTampFDays 授权时间往前推多少天,一度联系人通过传值获取,二度联系人默认固定180天数
            applyTimeFDays 申请时间往前推多少天
            userPhone 用户手机号
            OneContactsCall 所有一度联系人 （只有二度联系人才有)
    """

    if ContactsNum == 1:
        df = df.loc[df['timestamp'] < applyTime]
        authTime = df['timestamp'].max()
        # 授权时间区间
        df = df.loc[(df['timestamp'] > str( authTime - datetime.timedelta(days=timesTampFDays))) & (df['timestamp'] <= str(authTime))]
        # 通话记录区间
        df = df.loc[(df['cTime'] > str( authTime - datetime.timedelta(days=applyTimeFDays))) & (df['cTime'] <= str(authTime))]
        # 过滤用户自己
        # df = df.loc[~(df['receiverPhone'].isin(userPhone))] #
        df['timestamp_min_one'] =str(applyTime - datetime.timedelta(days=timesTampFDays))
        df['timestamp_max_one'] = str(authTime)

        df['cTime_min_one'] = str( authTime - datetime.timedelta(days=applyTimeFDays))
        df['cTime_max_one'] = str(authTime)


    elif ContactsNum == 2:
        # 二度联系人不包含一度联系人和当前用户
        df = df.loc[~(df['receiverPhone'].isin(userPhone)) & ~(df['receiverPhone'].isin(list(set(OneContactsCall))))]
        df = df.loc[((df['timestamp'] < str(applyTime - datetime.timedelta(days=timesTampFDays)) ) & (df['timestamp'] < str(applyTime)))
                    &((df['cTime'] > str( applyTime - datetime.timedelta(days=applyTimeFDays))) & (df['cTime'] < str(applyTime)))]

        # df['timestamp_min_two'] =str(applyTime - datetime.timedelta(days=timesTampFDays))
        # df['timestamp_max_two'] = str(authTime)
        #
        # df['cTime_min_two'] = str( authTime - datetime.timedelta(days=applyTimeFDays))
        # df['cTime_max_two'] = str(authTime)


    return df

def get_billDay_list(ApplyTime, IntervalDay):
    '''
    ApplyTime - IntervalDay 中间的月份不包括ApplyTime月份
    '''
    start_ = ApplyTime.date() - datetime.timedelta(days=IntervalDay)
    end = ApplyTime.date()  # 2018-11-09
    end = end.replace(day=1)
    start_ = start_.replace(day=1)
    month_list = []

    while True:
        if end <= start_:
            break
        else:
            if start_.month < 10:
                month_list.append(str(start_.year) + '0' + str(start_.month))
            else:
                month_list.append(str(start_.year) + str(start_.month))
            start_ = start_ + relativedelta(months=1)
    return month_list

def get_phone_black(phone,first_time = False,end_time = False,type_tuple = False,else_type =False):
    """获取手机号黑名单"""

    if first_time:
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where phone_no in ('{0}') and status = 1 and created_at >= '{1}' and  created_at < '{2}' and type in """ + type_tuple).format(phone,first_time,end_time)
    if else_type:
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where phone_no  in ('{0}') and status = 1 and created_at >= '{1}' and  created_at < '{2}' and type not in """ + type_tuple).format(phone,first_time,end_time)
    if first_time == False:
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where phone_no in ('{0}') and created_at < '{1}'  and status = 1  and type in """ + type_tuple).format(phone,end_time)
    if (else_type ==True) and (first_time == False):
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where phone_no in ('{0}') and created_at < '{1}'  and status = 1  and type not in """ + type_tuple).format(phone,end_time)
    _df = pd.read_sql(_sql,con_blacklist3_read)
    return _df

def get_phone_black_all(phone,end_time = False):
    """获取手机号黑名单"""
    _sql = """select id,major_type majorType, type ,status,created_at createdAt
              from black_list_new
              where phone_no in ('{0}') and created_at < '{1}'
              """.format(phone,end_time)
    _df = pd.read_sql(_sql,con_blacklist3_read)
    return _df

def get_emergency_contacts(phone,first_time = False,end_time = False,type_tuple = False,else_type =False):
    """获取紧急联系人"""
    if first_time:
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where phone_no in {0} and status = 1 and created_at >= '{1}' and  created_at < '{2}' and type in """ + type_tuple).format(phone, first_time, end_time)
    if else_type:
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where phone_no in {0} and status = 1 and created_at >= '{1}' and  created_at < '{2}' and type not in """ + type_tuple).format(phone,first_time,end_time)
    if first_time == False:
        _sql =( """select id,major_type majorType, type ,created_at createdAt from black_list_new where phone_no in {0}  and created_at < '{1}' and status = 1 and type in """ + type_tuple).format(phone,end_time)
    if (else_type ==True) and (first_time == False):
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where phone_no in {0} and created_at < '{1}'  and status = 1  and type not in """ + type_tuple).format(phone,end_time)

    _df = pd.read_sql(_sql,con_blacklist3_read)
    return _df



def get_id_no_black(phone,first_time = False,end_time = False,type_tuple = False,else_type =False):
    """获取身份证黑名单"""

    if first_time:
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where id_no in ('{0}') and status = 1 and created_at >= '{1}' and  created_at < '{2}' and type in """ + type_tuple).format(phone,first_time,end_time)
    if else_type:
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where id_no in ('{0}') and status = 1 and created_at >= '{1}' and  created_at < '{2}' and type not in """ + type_tuple).format(phone,first_time,end_time)
    if first_time == False:
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where id_no in ('{0}')  and created_at < '{1}' and status = 1  and type in """ + type_tuple).format(phone,end_time)
    if (else_type == True) and (first_time == False):
        _sql = (""" select id,major_type majorType, type ,created_at createdAt from black_list_new where id_no in ('{0}') and created_at < '{1}'  and status = 1  and type not in """ + type_tuple).format(phone,end_time)

    _df = pd.read_sql(_sql,con_blacklist3_read)
    return _df

