import pandas as pd
import datetime
from config.concat_sql import *

def getSql_loanAll(user_id):
    """获取用户所有放款订单明细"""
    _sql = """
        select
         IFNULL(aqr.order_no ,'') order_no
        ,loan.user_id,loan.id as loan_id,loan.progress,fest.contract_loan_amount,
        case when fest.loan_paid_at < aqr.apply_time then aqr.apply_time
			else fest.loan_paid_at  end as loan_paid_at
        ,case when loan.created_at >='2018-05-08' then aqr.apply_from
            when loan.created_at < '2018-05-08' then loan.created_from
            else null
            end as applied_from
        -- ,if (sub.created_at is not null, sub.created_at ,loan.created_at) apply_time
        ,case when loan.created_at >='2018-05-08' then aqr.apply_time
            when loan.created_at < '2018-05-08' then if (sub.created_at is not null, sub.created_at ,loan.created_at)
            else null
            end as apply_time
        ,plan.id as plan_id,plan.term_no, plan.repayment_status, plan.deadline as deadline,DATE_ADD(plan.deadline,INTERVAL 1 second) as deadline_new
        ,plan.repaid_at
        ,plan.current_repayment
        from loan_application_manifest_history as fest
        left join loan_application_history as loan on fest.loan_application_history_id = loan.id
        left join loan_submit_info as sub on sub.loan_id = loan.id
        left join repay as plan on plan.loan_application_history_id = loan.id
        left join repayment_record as record on record.repayment_plan_id = plan.id
        left join loan_account_ext as lae on lae.loan_id = loan.id
        left join apply_quota_record as aqr on aqr.order_no = lae.order_no
        where
        loan.user_id in {0}
        and loan.progress in (15,16,65)
        and fest.transaction_status in (2,5)
        order by loan.id,plan.id
    """.format(user_id)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def get_Loan_rollBack_v5(df_loan,apply_time,passdueDay_Negative=False):
    """订单回滚"""
    df_loan['observationTime'] = apply_time
    # df_loan = df_loan.loc[(df_loan['apply_time'] < df_loan['observationTime']) & (df_loan['loan_paid_at'] < df_loan['observationTime'] )]

    df_loan['repaid_at'] = df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S'))
    df_loan['repaid_at_real'] = df_loan['repaid_at']
    df_loan['deadline'] = df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
    df_loan['deadline'] = df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
    df_loan['apply_time'] = df_loan['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S'))
    df_loan['passdue_day'] = 0
    # df_loan = df_loan.loc[(df_loan['apply_time'] <= df_loan['observationTime'])]
    df_loan = df_loan.loc[(df_loan['loan_paid_at'] < df_loan['observationTime'])]
    if df_loan.empty == False:
        df_loan.loc[(df_loan['repaid_at'] != '2000-01-01')&(df_loan['repaid_at']>df_loan['observationTime']),'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')
        # 还款时间正常 ,还款状态!=3
        df_loan.loc[(df_loan['repaid_at'] != '2000-01-01') & (df_loan['repayment_status'] !=3),'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')
        df_loan.loc[(df_loan['repaid_at'] == '2000-01-01'),'repayment_status'] = 0
        # df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')& (df_loan['repayment_status'] != 3),'repayment_status'] = 0

        df_loan.loc[(df_loan['repayment_status'] == 3),'passdue_day'] = (df_loan['repaid_at'] - df_loan['deadline']).dt.days
        df_loan.loc[(df_loan['repayment_status'] != 3)&(df_loan['observationTime'] > df_loan['deadline']) ,'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')&(df_loan['repayment_status']==0)&(df_loan['observationTime']<df_loan['deadline']),'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        # df_loan.loc[(df_loan['repaid_at'] != '2000-01-01'),'passdue_day'] = (df_loan['repaid_at'] - df_loan['deadline']).dt.days
        # df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')&(df_loan['observationTime'] > df_loan['deadline']) ,'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        # df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')&(df_loan['repayment_status']==0)&(df_loan['observationTime']<df_loan['deadline']),'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        if passdueDay_Negative == False:
            df_loan.loc[(df_loan['passdue_day'] < 0),'passdue_day'] = 0
        _loan_id = []

        for k ,v in df_loan.groupby(['loan_id']):
            _df = pd.DataFrame(v)
            if _df.loc[(_df['repayment_status']==3)]['plan_id'].count() != _df['plan_id'].count():
                _loan_id.append(k)
        _loan_id = list(set(_loan_id))
        if _loan_id:
            df_loan.loc[(df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
        else:
            df_loan['progress'] = 16
            # df_loan = df_loan
    return df_loan



def double_loan_v5_refuse_new(userid,applytime):
    """新用户复贷v5 被拒绝的次数"""
    _sql = """	SELECT id id,customer_id customerId, order_no orderNo, apply_from applyFrom,product_id productId ,product_type productType, apply_status applyStatus,apply_time applyTime,updated_at updatedAt ,created_at submitTime,risk_notify_time riskNotifyTime 
	FROM apply_quota_record WHERE user_id = {0} and apply_time < '{1}';""".format(userid,applytime)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def double_loan_v5_refuse_old(userid, applytime):
    """老用户复贷v5 被拒绝的次数"""
    _sql ="""SELECT l.id loan_id,if(ls.created_at is not null, ls.created_at, l.created_at) apply_time, if(l.progress in (6, 8, 19), 1, 0) apply_status,created_from apply_from
     FROM  loan_application_history l  LEFT JOIN loan_account_ext e  ON e.loan_id = l.id left join loan_submit_info ls on ls.loan_id = l.id WHERE l.user_id in ({0})  and l.business_type IN (0, 2, 4,6) AND e.loan_id IS NULL And l.created_at < '{1}';""".format(userid,applytime)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df


def get_Loan_rollBack(df_loan,apply_time,passdueDay_Negative=False):
    """订单回滚"""
    df_loan['observationTime'] = apply_time
    # df_loan = df_loan.loc[(df_loan['apply_time'] < df_loan['observationTime']) & (df_loan['loan_paid_at'] < df_loan['observationTime'] )]

    df_loan['repaid_at'] = df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S'))
    df_loan['deadline'] = df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
    df_loan['deadline'] = df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
    df_loan['apply_time'] = df_loan['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S'))
    df_loan['passdue_day'] = 0
    # df_loan = df_loan.loc[(df_loan['apply_time'] <= df_loan['observationTime'])]
    df_loan = df_loan.loc[(df_loan['loan_paid_at'] < df_loan['observationTime'])]
    if df_loan.empty == False:
        df_loan.loc[(df_loan['repaid_at'] != '2000-01-01')&(df_loan['repaid_at']>df_loan['observationTime']),'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')
        # 还款时间正常 ,还款状态!=3
        df_loan.loc[(df_loan['repaid_at'] != '2000-01-01') & (df_loan['repayment_status'] !=3),'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')
        df_loan.loc[(df_loan['repaid_at'] == '2000-01-01'),'repayment_status'] = 0
        # df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')& (df_loan['repayment_status'] != 3),'repayment_status'] = 0

        df_loan.loc[(df_loan['repayment_status'] == 3),'passdue_day'] = (df_loan['repaid_at'] - df_loan['deadline']).dt.days
        df_loan.loc[(df_loan['repayment_status'] != 3)&(df_loan['observationTime'] > df_loan['deadline']) ,'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')&(df_loan['repayment_status']==0)&(df_loan['observationTime']<df_loan['deadline']),'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        # df_loan.loc[(df_loan['repaid_at'] != '2000-01-01'),'passdue_day'] = (df_loan['repaid_at'] - df_loan['deadline']).dt.days
        # df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')&(df_loan['observationTime'] > df_loan['deadline']) ,'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        # df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')&(df_loan['repayment_status']==0)&(df_loan['observationTime']<df_loan['deadline']),'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        if passdueDay_Negative == False:
            df_loan.loc[(df_loan['passdue_day'] < 0),'passdue_day'] = 0
        _loan_id = []

        for k ,v in df_loan.groupby(['loan_id']):
            _df = pd.DataFrame(v)
            if _df.loc[(_df['repayment_status']==3)]['plan_id'].count() != _df['plan_id'].count():
                _loan_id.append(k)
        _loan_id = list(set(_loan_id))
        if _loan_id:
            df_loan.loc[(df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
        else:
            df_loan['progress'] = 16
            # df_loan = df_loan
    return df_loan


def getSql_loanAll_v5(user_id):
    """获取用户所有放款订单明细"""
    _sql = """
        select
         IFNULL(aqr.order_no ,'') order_no,loan.business_type
        ,loan.user_id,loan.id as loan_id,loan.progress,fest.contract_loan_amount,fest.loan_paid_at,fest.monthly_interest_rate,fest.monthly_repayment
        ,case when loan.created_at >='2018-05-08' then aqr.apply_from
            when loan.created_at < '2018-05-08' then loan.created_from
            else null
            end as applied_from
        -- ,if (sub.created_at is not null, sub.created_at ,loan.created_at) apply_time
        ,case when loan.created_at >='2018-05-08' then aqr.apply_time
            when loan.created_at < '2018-05-08' then if (sub.created_at is not null, sub.created_at ,loan.created_at)
            else null
            end as apply_time
        ,plan.id as plan_id,plan.term_no, plan.repayment_status, plan.deadline as deadline,DATE_ADD(plan.deadline,INTERVAL 1 second) as deadline_new
        ,plan.repaid_at
        ,plan.current_repayment,plan.required_repayment
        from loan_application_manifest_history as fest
        left join loan_application_history as loan on fest.loan_application_history_id = loan.id
        left join loan_submit_info as sub on sub.loan_id = loan.id
        left join repay as plan on plan.loan_application_history_id = loan.id
        left join repayment_record as record on record.repayment_plan_id = plan.id
        left join loan_account_ext as lae on lae.loan_id = loan.id
        left join apply_quota_record as aqr on aqr.order_no = lae.order_no
        where
        loan.user_id in {}
        and loan.progress in (15,16,42,65)
        and fest.transaction_status in (2,5)
        and loan.business_type in (0,2,4,6)
        order by loan.id,plan.id
        """.format(user_id)

    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df


def new_apptime_resufe(user_id,applytime):
    _sql = """ SELECT id id,customer_id customerId, order_no orderNo, apply_from applyFrom,product_id productId ,
     product_type productType, apply_status applyStatus,apply_time applyTime,updated_at updatedAt ,created_at submitTime,risk_notify_time riskNotifyTime
     FROM apply_quota_record WHERE user_id = '{0}' and apply_time < '{1}';""".format(user_id,applytime)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def old_apptime_resufe(user_id,applytime):
    _sql = """ SELECT l.id loan_id,if(ls.created_at is not null, ls.created_at, l.created_at) apply_time,
 if(l.progress in (6, 8, 19), 1, 0) apply_status,created_from apply_from FROM  loan_application_history l
 LEFT JOIN loan_account_ext e  ON e.loan_id = l.id left join loan_submit_info ls on ls.loan_id = l.id 
 WHERE l.user_id = '{0}'  and l.business_type IN (0, 2, 4,6) AND e.loan_id IS NULL And l.created_at < '{1}';""".format(user_id,applytime)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def new_loan_v4_apply(user_id,applytime):
    """查找用户所有新申请详情"""
    _sql = """SELECT COUNT(1) count FROM apply_quota_record  WHERE user_id = '{0}' AND apply_time < '{1}';""".format(user_id,applytime)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def xiaoniu_loan_v4_apply(user_id,applytime):
    """查询小牛计划退货的申请次数"""
    _sql = """SELECT COUNT(1) count FROM apply_quota_record a LEFT JOIN loan_account_ext e ON e.order_no = a.order_no 
    LEFT JOIN loan_application_history l ON l.id = e.loan_id WHERE a.user_id = '{0}' AND l.progress = 48 AND apply_time < '{1}';""".format(user_id,applytime)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def old_loan_v4_apply(user_id):
    """查找用户所有老的申请详情"""
    _sql = """SELECT COUNT(1) count FROM loan_application_history l LEFT JOIN loan_account_ext e ON e.loan_id = l.id WHERE l.user_id = '{0}' and l.business_type IN (0,2) AND e.loan_id IS NULL""".format(user_id)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df