# -*- coding:utf-8 -*-
from handler.Base_Handler import BaseHandler
from utils import JsonUtil
import importlib
from features.Base_Features import BaseFeatures as BF
import datetime

class CalcFeatures(BaseHandler): #feature_基础特征
    def post(self):
        try:
            BF.set_private_var(
                    codes = self._codes,
                    business_type = self._business_type,
                    uuid=self._uuid,
                    user_id = self._user_id,
                    loanId = self._loanId,
                    orderId = self._orderId,
                    apply_time = self._apply_time,
                    termNo = self._termNo,
                    channel_no = self._channel_no

                    )

            BF.get_subclasses('features.calc_features',self.mapping.mapping_all)
            self.write(JsonUtil.build_json_feature(businessType=self._business_type, orderId=self._orderId, loanId=self._loanId,
                                                   userUuid = self._uuid,user_id=self._user_id,term_no = self._termNo,
                                                   channel_no=self._channel_no,
                                                   features=BF._result, flag=True,code=JsonUtil.Constants.Code_Success))
            self.flush()
            self.finish()

        except ValueError as e:
            # == 数据类型或者字段缺少导致
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Param_Error, JsonUtil.Constants.Msg_Param_Error))
            self.flush()
        except Exception as e:
            # == 报异常，查询失败
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Error, JsonUtil.Constants.Msg_Error))
            self.flush()
        pass
