from service import Http_Requests
import config.settings as IP
import pandas as pd
import json
params = {
    'uuid':'5f51dd69-3acc-41ec-8e08-bc01b4be3943',
    'business_type':1,
    'order_id':'SP160260807905167619361002'
}
method = 'GET'


RESULT = {'变量值校验':[],'key_name':[],'特征字段':[],'对比字段':[]}
ERROR_COUNT = 0

def cmp_dict(src_data,dst_data,key_name = None):
    global RESULT, ERROR_COUNT
    if isinstance(src_data,dict):
        keys = list(set(src_data.keys()).intersection(set(dst_data.keys())))
        for key in keys:
            cmp_dict(src_data[key],dst_data[key],key)
    elif isinstance(src_data,list):
        for src_list, dst_list in zip(sorted(src_data), sorted(dst_data)):
            cmp_dict(src_list, dst_list)
    else:
        RESULT['变量值校验'].append(True if src_data == dst_data else False)
        # RESULT['变量类型校验'].append(True if type(src_data) == type(dst_data) else False)
        RESULT['key_name'].append(key_name)
        RESULT['特征字段'].append(src_data)
        RESULT['对比字段'].append(dst_data)

def details_report():
    global RESULT, ERROR_COUNT
    df = pd.DataFrame(RESULT)
    df['assert_type'] = 0
    df.loc[(df['变量值校验'] == False),'assert_type'] = 1

    ERROR_COUNT = df.loc[df['assert_type'] == 1]['assert_type'].value_counts().values[0]

    # df.loc[df.assert_type == 1]
    df_html = df.to_html(classes='mystyle')
    print(df_html)
    raise 1
    return df_html

def test_trans_v2_read():
    _response1 = read_feature()
    _response2 = read_feature_my()
    cmp_dict(_response1,_response2)
    details_report()

    pass

def read_feature():
    global url,params,method
    _response = Http_Requests.get_response_http(
            host= IP.FEATURE_HOST,
            url = IP.url_trans_v2_read,
            params=params,
            method=method
    )

    return _response
def read_feature_my():
    global url,params,method
    _response = Http_Requests.get_response_http(
            host= IP.FEATURE_HOST_MY,
            url = IP.url_trans_v2_read,
            params=params,
            method=method
    )
    return _response

if __name__ =='__main__':

    test_trans_v2_read()
    # xx = {"111":None,"23456":{"22222":99991,"33333":"0000","list":["3333","4444","111"]}}
    # yy = {"111":None,"23456":{"22222":9999,"33333":"0000","list":["111","3333","4444"]}}
    # cmp_dict(xx,yy)