# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service.Sql_contactsOperator import *
import datetime
import numpy as np

class __INIT__(BF):
    """紧急联系人运营商特征"""
    def __init__(self):
        BF.created_at = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        if self.orderId :
            _df = getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF.created_at = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')
        BF.user_phone = getSql_userPhone(str(tuple([str(self.user_id)])).replace(',)',')'))['phone_no'].tolist()
        BF.id_no_ = getSql_id_no(str(self.user_id))
        if BF.id_no_.empty == False:
            BF.id_no = BF.id_no_['id_no'].drop_duplicates().tolist()
        else:
            BF.id_no =['99999999999999']

        BF.df_ = getSql_emergency_contact(self.user_id,BF.created_at,self.user_phone[0])
        # BF.df_.sort_values('created_at',ascending=False,inplace=True)
        # BF._df = BF._df.loc[~(BF._df['phone_no'].isin(BF.user_phone))]
        # BF.df_ = BF._df.iloc[:2]
        BF.contacts_phone = BF.df_['phone_no'].tolist() # 获取历史联系人手机号


class user_in_blacklist_365():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _user_in_blacklist_365_cnt = -9999999
        if self.user_phone != []:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=365),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            if _df_blacklist.empty==False:
                _user_in_blacklist_365_cnt = len(_df_blacklist)
            else:
                _user_in_blacklist_365_cnt = 0
        self._result['user_in_blacklist_365']['value'] = _user_in_blacklist_365_cnt
        return self._result

class user_in_blacklist_730():
    '''用户手机号或者身份证在黑名单中在近730天个数'''
    def feature(self):
        _user_in_blacklist_730_cnt = -9999999
        if self.user_phone != []:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=730),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            if _df_blacklist.empty==False:
                _user_in_blacklist_730_cnt = len(_df_blacklist)
            else:
                _user_in_blacklist_730_cnt = 0
        self._result['user_in_blacklist_730']['value'] = _user_in_blacklist_730_cnt
        return self._result

class user_in_blacklist():
    '''用户手机号或者身份证在黑名单中个数'''
    def feature(self):
        _user_in_blacklist_cnt = -9999999
        if self.user_phone !=[]:
            created_at_ = '1900-01-01 00:00:00'
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            if _df_blacklist.empty==False:
                _user_in_blacklist_cnt = len(_df_blacklist)
            else:
                _user_in_blacklist_cnt = 0
        self._result['user_in_blacklist']['value'] = _user_in_blacklist_cnt
        return self._result

class emergency_contact_in_blacklist_365():
    '''紧急联系人手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _emergency_contact_in_blacklist_365_cnt = -9999999
        if self.contacts_phone !=[]:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=365),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _emergency_contact_in_blacklist_365_cnt = len(_df_blacklist)
            else:
                _emergency_contact_in_blacklist_365_cnt = 0
        self._result['emergency_contact_in_blacklist_365']['value'] = _emergency_contact_in_blacklist_365_cnt
        return self._result

class emergency_contact_in_blacklist_730():
    '''用户手机号或者身份证在黑名单中在近730天个数'''
    def feature(self):
        _emergency_contact_in_blacklist_730_cnt = -9999999
        if self.contacts_phone !=[]:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=730),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            if _df_blacklist.empty==False:
                _emergency_contact_in_blacklist_730_cnt = len(_df_blacklist)
            else:
                _emergency_contact_in_blacklist_730_cnt = 0
        self._result['emergency_contact_in_blacklist_730']['value'] = _emergency_contact_in_blacklist_730_cnt
        return self._result

class emergency_contact_in_blacklist():
    '''用户手机号或者身份证在黑名单中个数'''
    def feature(self):
        _emergency_contact_in_blacklist_cnt = -9999999
        if self.contacts_phone !=[]:
            created_at_ = '1900-01-01 00:00:00'
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            if _df_blacklist.empty==False:
                _emergency_contact_in_blacklist_cnt = len(_df_blacklist)
            else:
                _emergency_contact_in_blacklist_cnt = 0
        self._result['emergency_contact_in_blacklist']['value'] = _emergency_contact_in_blacklist_cnt
        return self._result

class user_in_blacklist_365_type_cnt():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _user_in_blacklist_365_type_cnt = -9999999
        if self.user_phone != []:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=365),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            if _df_blacklist.empty==False:
                df_ = _df_blacklist.drop_duplicates(subset=['major_type'])
                _user_in_blacklist_365_cnt = len(df_)

            else:
                _user_in_blacklist_365_cnt = 0
        self._result['user_in_blacklist_365_type_cnt']['value'] = _user_in_blacklist_365_cnt
        return self._result

class user_in_blacklist_730_type_cnt():
    '''用户手机号或者身份证在黑名单中在近730天个数'''

    def feature(self):
        _user_in_blacklist_730_type_cnt = -9999999
        if self.user_phone != []:
            created_at_ = datetime.datetime.strftime(self.created_at - datetime.timedelta(days=730),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)

            if _df_blacklist.empty == False:
                df_ = _df_blacklist.drop_duplicates(subset=['major_type'])
                _user_in_blacklist_730_cnt = len(df_)

            else:
                _user_in_blacklist_730_cnt = 0
        self._result['user_in_blacklist_730_type_cnt']['value'] = _user_in_blacklist_730_cnt
        return self._result

class user_in_blacklist_type_cnt():
    '''用户手机号或者身份证在黑名单中个数'''
    def feature(self):
        _user_in_blacklist_type_cnt = -9999999
        if self.user_phone != []:
            created_at_ = '1900-01-01 00:00:00'
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            if _df_blacklist.empty==False:
                df_ = _df_blacklist.drop_duplicates(subset=['major_type'])
                _user_in_blacklist_type_cnt = len(df_)
            else:
                _user_in_blacklist_type_cnt = 0
        self._result['user_in_blacklist_type_cnt']['value'] = _user_in_blacklist_type_cnt
        return self._result

class emergency_contact_in_blacklist_365_type_cnt():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _emergency_contact_in_blacklist_365_type_cnt = -9999999
        if self.contacts_phone !=[]:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=365),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            if _df_blacklist.empty==False:
                df_ = _df_blacklist.drop_duplicates(subset=['major_type'])
                _emergency_contact_in_blacklist_365_type_cnt = len(df_)

            else:
                _emergency_contact_in_blacklist_365_type_cnt = 0
        self._result['emergency_contact_in_blacklist_365_type_cnt']['value'] = _emergency_contact_in_blacklist_365_type_cnt
        return self._result

class emergency_contact_in_blacklist_730_type_cnt():
    '''用户手机号或者身份证在黑名单中在近730天个数'''

    def feature(self):
        _emergency_contact_in_blacklist_730_type_cnt = -9999999
        if self.contacts_phone !=[]:
            created_at_ = datetime.datetime.strftime(self.created_at - datetime.timedelta(days=730),
                                                     '%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            if _df_blacklist.empty == False:
                df_ = _df_blacklist.drop_duplicates(subset=['major_type'])
                _emergency_contact_in_blacklist_730_type_cnt = len(df_)

            else:
                _emergency_contact_in_blacklist_730_type_cnt = 0
        self._result['emergency_contact_in_blacklist_730_type_cnt']['value'] = _emergency_contact_in_blacklist_730_type_cnt
        return self._result

class emergency_contact_in_blacklist_type_cnt():
    '''用户手机号或者身份证在黑名单中个数'''
    def feature(self):
        _emergency_contact_in_blacklist_type_cnt = -9999999
        if self.contacts_phone !=[]:
            created_at_ = '1900-01-01 00:00:00'
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            if _df_blacklist.empty==False:
                df_ = _df_blacklist.drop_duplicates(subset=['major_type'])
                _emergency_contact_in_blacklist_type_cnt = len(df_)
            else:
                _emergency_contact_in_blacklist_type_cnt = 0
        self._result['emergency_contact_in_blacklist_type_cnt']['value'] = _emergency_contact_in_blacklist_type_cnt
        return self._result

class user_in_blacklist_365_type_max():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _user_in_blacklist_365_type_max = -9999999
        if self.user_phone != []:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=365),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _user_in_blacklist_365_type_max = _df_blacklist.groupby('major_type').agg(np.size)['id'].max()

        self._result['user_in_blacklist_365_type_max']['value'] = _user_in_blacklist_365_type_max
        return self._result

class user_in_blacklist_730_type_max():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _user_in_blacklist_730_type_max = -9999999
        if self.user_phone != []:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=730),'%Y-%m-%d %H:%M:%S')

            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _user_in_blacklist_730_type_max = _df_blacklist.groupby('major_type').agg(np.size)['id'].max()

        self._result['user_in_blacklist_730_type_max']['value'] = _user_in_blacklist_730_type_max
        return self._result

class user_in_blacklist_type_max():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _user_in_blacklist_type_max = -9999999
        if self.user_phone != []:
            created_at_ = '1900-01-01 00:00:00'
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _user_in_blacklist_type_max = _df_blacklist.groupby('major_type').agg(np.size)['id'].max()

        self._result['user_in_blacklist_type_max']['value'] = _user_in_blacklist_type_max
        return self._result

class emergency_contact_in_blacklist_365_type_max():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _emergency_contact_in_blacklist_365_type_max = -9999999
        if self.contacts_phone !=[]:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=365),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _emergency_contact_in_blacklist_365_type_max = _df_blacklist.groupby('major_type').agg(np.size)['id'].max()

        self._result['emergency_contact_in_blacklist_365_type_max']['value'] = _emergency_contact_in_blacklist_365_type_max
        return self._result

class emergency_contact_in_blacklist_730_type_max():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _emergency_contact_in_blacklist_730_type_max = -9999999
        if self.contacts_phone !=[]:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=730),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _emergency_contact_in_blacklist_730_type_max = _df_blacklist.groupby('major_type').agg(np.size)['id'].max()

        self._result['emergency_contact_in_blacklist_730_type_max']['value'] = _emergency_contact_in_blacklist_730_type_max
        return self._result

class emergency_contact_in_blacklist_type_max():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _emergency_contact_in_blacklist_type_max = -9999999
        if self.contacts_phone !=[]:
            created_at_ = '1900-01-01 00:00:00'
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _emergency_contact_in_blacklist_type_max = _df_blacklist.groupby('major_type').agg(np.size)['id'].max()

        self._result['emergency_contact_in_blacklist_type_max']['value'] = _emergency_contact_in_blacklist_type_max
        return self._result

class user_in_blacklist_365_type_min():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _user_in_blacklist_365_type_min = -9999999
        if self.user_phone != []:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=365),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _user_in_blacklist_365_type_min = _df_blacklist.groupby('major_type').agg(np.size)['id'].min()

        self._result['user_in_blacklist_365_type_min']['value'] = _user_in_blacklist_365_type_min
        return self._result

class user_in_blacklist_730_type_min():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _user_in_blacklist_730_type_min = -9999999
        if self.user_phone != []:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=730),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _user_in_blacklist_730_type_min = _df_blacklist.groupby('major_type').agg(np.size)['id'].min()

        self._result['user_in_blacklist_730_type_min']['value'] = _user_in_blacklist_730_type_min
        return self._result

class user_in_blacklist_type_min():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _user_in_blacklist_type_min = -9999999
        if self.user_phone != []:
            created_at_ = '1900-01-01 00:00:00'
            _df_blacklist = getSql_relation_phone_in_blacklist(self.user_phone[0],self.id_no[0],created_at_ ,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _user_in_blacklist_type_min = _df_blacklist.groupby('major_type').agg(np.size)['id'].min()

        self._result['user_in_blacklist_type_min']['value'] = _user_in_blacklist_type_min
        return self._result

class emergency_contact_in_blacklist_365_type_min():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _emergency_contact_in_blacklist_365_type_min = -9999999
        if self.contacts_phone !=[]:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=365),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _emergency_contact_in_blacklist_365_type_min = _df_blacklist.groupby('major_type').agg(np.size)['id'].min()

        self._result['emergency_contact_in_blacklist_365_type_min']['value'] = _emergency_contact_in_blacklist_365_type_min
        return self._result

class emergency_contact_in_blacklist_730_type_min():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _emergency_contact_in_blacklist_730_type_min = -9999999
        if self.contacts_phone !=[]:
            created_at_ = datetime.datetime.strftime(self.created_at- datetime.timedelta(days=730),'%Y-%m-%d %H:%M:%S')
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _emergency_contact_in_blacklist_730_type_min = _df_blacklist.groupby('major_type').agg(np.size)['id'].min()

        self._result['emergency_contact_in_blacklist_730_type_min']['value'] = _emergency_contact_in_blacklist_730_type_min
        return self._result

class emergency_contact_in_blacklist_type_min():
    '''用户手机号或者身份证在黑名单中在近365天个数'''
    def feature(self):
        _emergency_contact_in_blacklist_type_min = -9999999
        if self.contacts_phone !=[]:
            created_at_ = '1900-01-01 00:00:00'
            _df_blacklist = getSql_emergency_contact_phone_in_blacklist(str(tuple(self.contacts_phone)).replace(',)',')'),created_at_,self.created_at)
            print(_df_blacklist)
            if _df_blacklist.empty==False:
                _emergency_contact_in_blacklist_type_min = _df_blacklist.groupby('major_type').agg(np.size)['id'].min()

        self._result['emergency_contact_in_blacklist_type_min']['value'] = _emergency_contact_in_blacklist_type_min
        return self._result