# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service.Sql_contactsOperator import *
import datetime
import json
import time

class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF._created_at = time_now
        BF._user_phone = str(tuple(getSql_userPhone(str(tuple([self.user_id])).replace(',)',')'))['phone_no'].tolist())).replace(',)',')')
        # BF._user_phone_list = (getSql_userPhone(str(tuple([self.user_id])).replace(',)',')'))['phone_no'].tolist())
        userSource = ''
        df_auth = getSql_authorizationPhone(self.uuid,BF._user_phone)
        if df_auth.empty == False:
            df_auth['modifyDate'] = df_auth['modifyDate'].astype(str)
            userSource = df_auth['userSource'].values[0]
            BF._created_at = datetime.datetime.strptime(df_auth['modifyDate'].max(),'%Y-%m-%d %H:%M:%S')

        BF._apply_at = time_now
        if self.orderId:
            _df = getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF._apply_at = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')



        BF._df_telephone = pd.DataFrame()
        if userSource == 'YIDONG':
            BF._df_telephone = getSql_mobileCallInfoDataService(uuid=self.uuid,
                                                            user_phone=BF._user_phone)
        elif userSource == 'LIANTONG':
            BF._df_telephone = getSql_unicomCallInfoDataService(uuid=self.uuid,
                                                            user_phone=BF._user_phone)
        elif userSource == 'DIANXIN':
            BF._df_telephone = getSql_telecomCallInfoDataService(uuid=self.uuid,
                                                            user_phone=BF._user_phone)
        if BF._df_telephone.empty == False:
            # BF._df_telephone_1['timestamp'] = BF._df_telephone_1['timestamp'].astype(str)
            BF._df_telephone['timestamp'] = pd.to_datetime(BF._df_telephone['timestamp'])
            BF._df_telephone['apply_at'] = BF._apply_at
            BF._df_telephone['apply_at'] = pd.to_datetime(BF._df_telephone['apply_at'])
            BF._df_telephone['cTime'] = pd.to_datetime(BF._df_telephone['cTime'])
            BF._df_telephone = BF._df_telephone.sort_values(['timestamp'])
            BF._df_telephone = BF._df_telephone[BF._df_telephone['timestamp'] <= BF._df_telephone['apply_at']]
            # if BF._df_telephone.empty ==False:
            if BF._df_telephone.empty ==True:
                BF.time_end = str(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'))
            else:
                BF.time_end = str(BF._df_telephone['timestamp'].max())

            time_start = str(datetime.datetime.strptime(str(BF.time_end),'%Y-%m-%d %H:%M:%S') - datetime.timedelta(days=150))
            if userSource == 'YIDONG':
                BF._df_telephone = getSql_mobileCallInfoDataService(uuid=self.uuid,
                                                                    user_phone=BF._user_phone,time_start =time_start, time_end = BF.time_end)

            elif userSource == 'LIANTONG':
                BF._df_telephone = getSql_unicomCallInfoDataService(uuid=self.uuid,
                                                                    user_phone=BF._user_phone,time_start =time_start, time_end = BF.time_end)
            elif userSource == 'DIANXIN':
                BF._df_telephone = getSql_telecomCallInfoDataService(uuid=self.uuid,
                                                                     user_phone=BF._user_phone,time_start =time_start, time_end = BF.time_end)


        if BF._df_telephone.empty == False:
            BF._df_telephone.sort_values(['cTime'],inplace=True)
            BF._df_telephone = BF._df_telephone.dropna(subset=['receiverPhone'])
            BF._df_telephone['receiverPhone'] = BF._df_telephone['receiverPhone'].astype(str)
            _contacts_phone = list(set(get_PhoneNo(BF._df_telephone['receiverPhone'])))
            BF._contacts_phone = None
            BF._contacts_phone_l = []
            if _contacts_phone:
                BF._contacts_phone = str(tuple(_contacts_phone)).replace(',)',')')
                BF._contacts_phone_l = _contacts_phone
                BF.df_user = getSql_phoneForUserId(BF._contacts_phone)

class 手机号激活时间距本次申请的天数():
    def feature(self):
        _手机号激活时间距本次申请的天数 = -9999999
        # # df_user = getSql_userPhone(self.user_id)
        # phone_no = self._user_phone
        # df_auth = getSql_authorizationPhone(self.uuid,phone_no)
        # modifyDate = datetime.datetime.strptime(str(df_auth['modifyDate'].max()).split(' ')[0],'%Y-%m-%d')
        # df_user_apply = getSql_userApplyQuotaRecord(str(tuple([self.user_id])).replace(',)',')'))
        # if df_user_apply.empty == False:
        #     apply_time = df_user_apply['apply_time'].max()
        #     _手机号激活时间距本次申请的天数 = (datetime.datetime.strptime(datetime.datetime.strftime(apply_time,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00') - modifyDate).days +1
        # self._result['手机号激活时间距本次申请的天数']['value'] = _手机号激活时间距本次申请的天数
        return self._result

class 申请时的手机余额():
    """申请时的手机余额 ???"""
    def feature(self):  # -----
        _申请时的手机余额 = -9999999

        self._result['申请时的手机余额']['value'] = _申请时的手机余额
        return self._result

class 近150天1度联系人中的最近一次通话距本次申请的天数():
    """degree_one_call_record_interval#days_between_apply_time_and_latest_call	近150天1度联系人中的最近一次通话距本次申请的天数"""
    def feature(self):
        _近150天1度联系人中的最近一次通话距本次申请的天数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            cTime_max = df_telephone['cTime'].max()
            _近150天1度联系人中的最近一次通话距本次申请的天数 = (datetime.datetime.strptime(self.time_end,'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(cTime_max,'%Y-%m-%d %H:%M:%S')).days
        self._result['近150天1度联系人中的最近一次通话距本次申请的天数']['value'] = _近150天1度联系人中的最近一次通话距本次申请的天数
        return self._result

class 近150天1度联系人中的最早一次通话距本次申请的天数():
    """degree_one_call_record_interval#days_between_apply_time_and_earliest_call	近150天1度联系人中的最早一次通话距本次申请的天数"""
    def feature(self):
        _近150天1度联系人中的最早一次通话距本次申请的天数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            cTime_min = df_telephone['cTime'].min()
            _近150天1度联系人中的最早一次通话距本次申请的天数 = (datetime.datetime.strptime(self.time_end,'%Y-%m-%d %H:%M:%S')  - datetime.datetime.strptime(cTime_min,'%Y-%m-%d %H:%M:%S')).days
        self._result['近150天1度联系人中的最早一次通话距本次申请的天数']['value'] = _近150天1度联系人中的最早一次通话距本次申请的天数
        return self._result


class 近5个月账单的最小月应缴话费():
    """user_m5_bill_info#billMin    近5个月账单的最小月应缴话费"""
    def feature(self):
        _近5个月账单的最小月应缴话费 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            time_end = datetime.datetime.strptime(self.time_end, '%Y-%m-%d %H:%M:%S')
            df = get_user_bill_info_rows(self.uuid,time_end,5)
            if df.empty==False:
                _近5个月账单的最小月应缴话费 = round(df['amount'].min(),6)
        self._result['近5个月账单的最小月应缴话费']['value'] = _近5个月账单的最小月应缴话费
        return self._result

class 近5个月账单的最大月应缴话费():
    """user_m5_bill_info#billMax    近5个月账单的最大月应缴话费"""
    def feature(self):
        _近5个月账单的最大月应缴话费 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            time_end = datetime.datetime.strptime(self.time_end, '%Y-%m-%d %H:%M:%S')
            df = get_user_bill_info_rows(self.uuid,time_end,5)
            if df.empty == False:
                _近5个月账单的最大月应缴话费 = round(df['amount'].max(),6)
        self._result['近5个月账单的最大月应缴话费']['value'] = _近5个月账单的最大月应缴话费
        return self._result

class 近5个月账单的总应缴话费():
    """user_m5_bill_info#billSum    近5个月账单的总应缴话费"""
    def feature(self):
        _近5个月账单的总应缴话费 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            time_end = datetime.datetime.strptime(self.time_end, '%Y-%m-%d %H:%M:%S')
            df = get_user_bill_info_rows(self.uuid,time_end,5)
            if df.empty == False:
                _近5个月账单的总应缴话费 = round(df['amount'].sum(),6)
        self._result['近5个月账单的总应缴话费']['value'] = _近5个月账单的总应缴话费
        return self._result

class 近5个月账单的应缴话费平均值():
    """user_m5_bill_info#billAvg    近5个月账单的应缴话费平均值"""
    def feature(self):
        _近5个月账单的应缴话费平均值 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            time_end = datetime.datetime.strptime(self.time_end, '%Y-%m-%d %H:%M:%S')
            df = get_user_bill_info_rows(self.uuid,time_end,5)
            if df.empty == False:
                _近5个月账单的应缴话费平均值 = round(df['amount'].mean(),6)
        self._result['近5个月账单的应缴话费平均值']['value'] = _近5个月账单的应缴话费平均值
        return self._result

class 近5个月账单信息查得月份数():
    """user_m5_bill_info#billMonthCnt   近5个月账单信息查得月份数"""
    def feature(self):
        _近5个月账单信息查得月份数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            time_end = datetime.datetime.strptime(self.time_end, '%Y-%m-%d %H:%M:%S')
            df = get_user_bill_info_rows(self.uuid,time_end,5)
            if df.empty == False:
                _近5个月账单信息查得月份数 = df['billDay'].count()
        self._result['近5个月账单信息查得月份数']['value'] = _近5个月账单信息查得月份数
        return self._result

class 近150天1度联系人中的总通话次数():
    """degree_one_call_contact#call_cnt	近150天1度联系人中的总通话次数"""
    def feature(self):
        _近150天1度联系人中的总通话次数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            _近150天1度联系人中的总通话次数 = df_telephone['receiverPhone'].count()
        self._result['近150天1度联系人中的总通话次数']['value'] = _近150天1度联系人中的总通话次数
        return self._result

class 近150天1度联系人中的总通话号码个数():
    """degree_one_call_contact#call_numbers_cnt 近150天1度联系人中的总通话号码个数"""
    def feature(self):
        _近150天1度联系人中的总通话号码个数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty==False:
            _近150天1度联系人中的总通话号码个数 = df_telephone.loc[df_telephone.duplicated('receiverPhone',keep='first') == False]['receiverPhone'].count()
        self._result['近150天1度联系人中的总通话号码个数']['value'] = _近150天1度联系人中的总通话号码个数
        return self._result

class 近150天1度联系人中的总通话秒数():
    """degree_one_call_contact#call_long	近150天1度联系人中的总通话秒数"""
    def feature(self):
        _近150天1度联系人中的总通话秒数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:

            _近150天1度联系人中的总通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的总通话秒数']['value'] = _近150天1度联系人中的总通话秒数
        return self._result

class 近150天1度联系人中的各联系人的最大通话间隔天数():
    """degree_one_call_contact#call_interval_max	近150天1度联系人中的各联系人的最大通话间隔天数"""
    def feature(self):
        _近150天1度联系人中的各联系人的最大通话间隔天数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_g = df_telephone.groupby(['receiverPhone'])
            interval_day = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                if len(df)<=1:
                    interval_day.extend([0])
                else:
                    interval_day.extend(get_interval_day(df['cTime'].tolist()))
            _近150天1度联系人中的各联系人的最大通话间隔天数 = max(interval_day)

        self._result['近150天1度联系人中的各联系人的最大通话间隔天数']['value'] = _近150天1度联系人中的各联系人的最大通话间隔天数
        return self._result

class 近150天1度联系人中的各联系人的最小通话间隔天数():
    """degree_one_call_contact#call_interval_min	近150天1度联系人中的各联系人的最小通话间隔天数"""
    def feature(self):
        _近150天1度联系人中的各联系人的最小通话间隔天数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_g = df_telephone.groupby(['receiverPhone'])
            interval_day = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                if len(df)<=1:
                    interval_day.extend([0])
                else:
                    interval_day.extend(get_interval_day(df['cTime'].tolist()))
            _近150天1度联系人中的各联系人的最小通话间隔天数 = min(interval_day)

        self._result['近150天1度联系人中的各联系人的最小通话间隔天数']['value'] = _近150天1度联系人中的各联系人的最小通话间隔天数
        return self._result

class 近150天1度联系人中的各联系人的平均通话间隔天数():
    """degree_one_call_contact#call_interval_avg	近150天1度联系人中的各联系人的平均通话间隔天数"""
    def feature(self):
        _近150天1度联系人中的各联系人的平均通话间隔天数 = -9999999

        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            phone_count = len(list(set(df_telephone['receiverPhone'])))
            df_g = df_telephone.groupby(['receiverPhone'])
            interval_day = []
            day_max = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                if len(df)<=1:
                    interval_day.extend([0])
                else:
                    interval_day.extend(get_interval_day(df['cTime'].tolist(),isseconds=True))
                day_max.append(max(interval_day))
                interval_day = []

            #         d = str(datetime.timedelta(seconds=sum(day_max)).days)
            # s = str(datetime.timedelta(seconds=sum(day_max)).seconds)
                _近150天1度联系人中的各联系人的平均通话间隔天数 = round(float((sum(day_max)/phone_count) /86400),6)
        self._result['近150天1度联系人中的各联系人的平均通话间隔天数']['value'] = _近150天1度联系人中的各联系人的平均通话间隔天数
        return self._result

class 近150天1度联系人中通话次数top1的总通话次数():
    def feature(self):
        _近150天1度联系人中通话次数top1的总通话次数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            phone_count = []
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                phone_count.append(df['receiverPhone'].count())
            _近150天1度联系人中通话次数top1的总通话次数 = max(phone_count)
        self._result['近150天1度联系人中通话次数top1的总通话次数']['value'] = _近150天1度联系人中通话次数top1的总通话次数
        return self._result


class 近150天1度联系人中通话次数top1的总通话秒数():
    """degree_one_call_contact#call_top1_long	近150天1度联系人中通话次数top1的总通话秒数"""
    def feature(self):
        _近150天1度联系人中通话次数top1的总通话秒数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record = df_call_record.loc[df_call_record['count'] == df_call_record['count'].max()]
            _近150天1度联系人中通话次数top1的总通话秒数 = df_call_record['tradeTime'].max()
        self._result['近150天1度联系人中通话次数top1的总通话秒数']['value'] = _近150天1度联系人中通话次数top1的总通话秒数
        return self._result

class 近150天1度联系人中通话次数top1的通话间隔天数():
    """degree_one_call_contact#call_top1_interval	近150天1度联系人中通话次数top1的通话间隔天数"""
    def feature(self):
        _近150天1度联系人中通话次数top1的通话间隔天数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                interval_day = []
                df = pd.DataFrame(value)
                if len(df)<=1:
                    interval_day = [0]
                else:
                    interval_day = get_interval_day(df['cTime'].tolist(),isseconds=True)
                # if g == '15928912052':
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'interval_day': max(interval_day)})

            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending = False,inplace=True)
            # df_call_record = df_call_record.iloc[1]
            df_call_record = df_call_record.iloc[0]
            _近150天1度联系人中通话次数top1的通话间隔天数 = int(df_call_record['interval_day'].max()/86400)
        self._result['近150天1度联系人中通话次数top1的通话间隔天数']['value'] = _近150天1度联系人中通话次数top1的通话间隔天数
        return self._result

class 近150天1度联系人中通话次数top1的主叫通话次数():
    """degree_one_call_contact#call_top1_zhujiao_cnt	近150天1度联系人中通话次数top1的主叫通话次数"""
    def feature(self):
        _近150天1度联系人中通话次数top1的主叫通话次数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_telephone['tradeTime'] = df_telephone['tradeTime'].astype(int)
            df_telephone['tradeWay_new'] = 0
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone.tradeWay.str.contains('主'), 'tradeWay_new'] = 1
            df_telephone.loc[df_telephone.tradeWay.str.contains('被'), 'tradeWay_new'] = 2
            call_record = []
            df_g = df_telephone.groupby(['receiverPhone'])

            for g ,value in df_g:
                df = pd.DataFrame(value)
                # get_lkb_user_phone_location(self.uuid)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'caller_count':df.loc[df['tradeWay_new'] == 1]['tradeWay_new'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    })
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending = False,inplace=True)
            df_call_record = df_call_record.iloc[0]

            _近150天1度联系人中通话次数top1的主叫通话次数 = df_call_record['caller_count'].max()
        self._result['近150天1度联系人中通话次数top1的主叫通话次数']['value'] = _近150天1度联系人中通话次数top1的主叫通话次数
        return self._result


class 近150天1度联系人中通话次数top3的总通话次数():
    def feature(self):
        _近150天1度联系人中通话次数top3的总通话次数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(by='count',ascending=False,inplace=True)

            df_call_record = df_call_record.iloc[:3]

            _近150天1度联系人中通话次数top3的总通话次数 = df_call_record['count'].sum()
        self._result['近150天1度联系人中通话次数top3的总通话次数']['value'] = _近150天1度联系人中通话次数top3的总通话次数
        return self._result

class 近150天1度联系人中通话次数top3的总通话秒数():
    """degree_one_call_contact#call_top3_long	近150天1度联系人中通话次数top3的总通话秒数"""
    def feature(self):
        _近150天1度联系人中通话次数top3的总通话秒数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],'count':df['phone'].count(),'tradeTime':df['tradeTime'].sum()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(by=['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:3]
            _近150天1度联系人中通话次数top3的总通话秒数 = df_call_record['tradeTime'].sum()
        self._result['近150天1度联系人中通话次数top3的总通话秒数']['value'] = _近150天1度联系人中通话次数top3的总通话秒数
        return self._result


class 近150天1度联系人中通话次数top3的各联系人的最大通话间隔天数():
    """degree_one_call_contact#call_top3_interval_max	近150天1度联系人中通话次数top3的各联系人的最大通话间隔天数"""
    def feature(self):
        _近150天1度联系人中通话次数top3的各联系人的最大通话间隔天数 = -9999999


        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            call_record = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                if len(df)<=1:
                    interval_day = [0]
                else:
                    interval_day = get_interval_day(df['cTime'].tolist())
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'interval_day':max(interval_day)})

            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:3]
            _近150天1度联系人中通话次数top3的各联系人的最大通话间隔天数 = df_call_record['interval_day'].max()

        self._result['近150天1度联系人中通话次数top3的各联系人的最大通话间隔天数']['value'] = _近150天1度联系人中通话次数top3的各联系人的最大通话间隔天数
        return self._result

class 近150天1度联系人中通话次数top3的各联系人的最小通话间隔天数():
    """degree_one_call_contact#call_top3_interval_min	近150天1度联系人中通话次数top3的各联系人的最小通话间隔天数"""
    def feature(self):
        _近150天1度联系人中通话次数top3的各联系人的最小通话间隔天数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            call_record = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                if len(df)<=1:
                    interval_day = [0]
                else:
                    interval_day = get_interval_day(df['cTime'].tolist(),isseconds=True)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'interval_day':max(interval_day)})
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:3]
            _近150天1度联系人中通话次数top3的各联系人的最小通话间隔天数 = int(df_call_record['interval_day'].min()/86400)

        self._result['近150天1度联系人中通话次数top3的各联系人的最小通话间隔天数']['value'] = _近150天1度联系人中通话次数top3的各联系人的最小通话间隔天数
        return self._result

class 近150天1度联系人中通话次数top3的各联系人的平均通话间隔天数():
    """degree_one_call_contact#call_top3_interval_avg	近150天1度联系人中通话次数top3的各联系人的平均通话间隔天数"""
    def feature(self):
        _近150天1度联系人中通话次数top3的各联系人的平均通话间隔天数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            call_record = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                if len(df)<=1:
                    interval_day = [0]
                else:
                    interval_day = get_interval_day(df['cTime'].tolist(),isseconds=True)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'interval_day':max(interval_day)})

            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:3]
            _近150天1度联系人中通话次数top3的各联系人的平均通话间隔天数 = round(df_call_record['interval_day'].mean()/86400,6)

        self._result['近150天1度联系人中通话次数top3的各联系人的平均通话间隔天数']['value'] = _近150天1度联系人中通话次数top3的各联系人的平均通话间隔天数
        return self._result



class 近150天1度联系人中通话次数top3的主叫通话次数():
    """degree_one_call_contact#call_top3_zhujiao_cnt	近150天1度联系人中通话次数top3的主叫通话次数"""
    def feature(self):
        _近150天1度联系人中通话次数top3的主叫通话次数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_telephone['tradeTime'] = df_telephone['tradeTime'].astype(int)
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_g = df_telephone.groupby(['receiverPhone'])

            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['trade_new'] = 0
                df.loc[df.tradeWay.str.contains('主'), 'trade_new'] = 1
                df.loc[df.tradeWay.str.contains('被'), 'trade_new'] = 2
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'caller_count':df.loc[df['trade_new'] == 1]['trade_new'].count()
                                    })
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:3]
            _近150天1度联系人中通话次数top3的主叫通话次数 = df_call_record['caller_count'].sum()

        self._result['近150天1度联系人中通话次数top3的主叫通话次数']['value'] = _近150天1度联系人中通话次数top3的主叫通话次数
        return self._result

class 近150天1度联系人中通话次数top5的总通话次数():
    """degree_one_call_contact#call_top5_cnt	近150天1度联系人中通话次数top5的总通话次数"""
    def feature(self):
        _近150天1度联系人中通话次数top5的总通话次数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:5]
            _近150天1度联系人中通话次数top5的总通话次数 = df_call_record['count'].sum()
        self._result['近150天1度联系人中通话次数top5的总通话次数']['value'] = _近150天1度联系人中通话次数top5的总通话次数
        return self._result

class 近150天1度联系人中通话次数top5的总通话秒数():
    """degree_one_call_contact#call_top5_long	近150天1度联系人中通话次数top5的总通话秒数"""
    def feature(self):
        _近150天1度联系人中通话次数top5的总通话秒数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum()})

            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:5]
            _近150天1度联系人中通话次数top5的总通话秒数 = df_call_record['tradeTime'].sum()
        self._result['近150天1度联系人中通话次数top5的总通话秒数']['value'] = _近150天1度联系人中通话次数top5的总通话秒数
        return self._result

class 近150天1度联系人中通话次数top5的各联系人的最大通话间隔天数():
    """degree_one_call_contact#call_top5_interval_max	近150天1度联系人中通话次数top5的各联系人的最大通话间隔天数"""
    def feature(self):
        _近150天1度联系人中通话次数top5的各联系人的最大通话间隔天数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                if len(df)<=1:
                    interval_day = [0]
                else:
                    interval_day = get_interval_day(df['cTime'].tolist(),isseconds=True)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'interval_day':max(interval_day)})

            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:5]
            _近150天1度联系人中通话次数top5的各联系人的最大通话间隔天数 = int(df_call_record['interval_day'].max()/86400)
        self._result['近150天1度联系人中通话次数top5的各联系人的最大通话间隔天数']['value'] = _近150天1度联系人中通话次数top5的各联系人的最大通话间隔天数
        return self._result


class 近150天1度联系人中通话次数top5的各联系人的最小通话间隔天数():
    """degree_one_call_contact#call_top5_interval_min	近150天1度联系人中通话次数top5的各联系人的最小通话间隔天数"""
    def feature(self):
        _近150天1度联系人中通话次数top5的各联系人的最小通话间隔天数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                if len(df)<=1:
                    interval_day = [0]
                else:
                    interval_day = get_interval_day(df['cTime'].tolist(),isseconds=True)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'interval_day':max(interval_day)})

            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:5]
            _近150天1度联系人中通话次数top5的各联系人的最小通话间隔天数 = int(df_call_record['interval_day'].min()/86400)
        self._result['近150天1度联系人中通话次数top5的各联系人的最小通话间隔天数']['value'] = _近150天1度联系人中通话次数top5的各联系人的最小通话间隔天数
        return self._result

class 近150天1度联系人中通话次数top5的各联系人的平均通话间隔天数():
    """degree_one_call_contact#call_top5_interval_avg	近150天1度联系人中通话次数top5的各联系人的平均通话间隔天数"""
    def feature(self):
        _近150天1度联系人中通话次数top5的各联系人的平均通话间隔天数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                interval_day = []
                if len(df)<=1:
                    interval_day.extend([0])
                else:
                    interval_day.extend(get_interval_day(df['cTime'].tolist(),isseconds=True))
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'interval_day':(max(interval_day))})

            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:5]
            _近150天1度联系人中通话次数top5的各联系人的平均通话间隔天数 = round(df_call_record['interval_day'].mean()/86400,6)
        self._result['近150天1度联系人中通话次数top5的各联系人的平均通话间隔天数']['value'] = _近150天1度联系人中通话次数top5的各联系人的平均通话间隔天数
        return self._result

class 近150天1度联系人中通话次数top5的主叫通话次数():
    """degree_one_call_contact#call_top5_zhujiao_cnt	近150天1度联系人中通话次数top5的主叫通话次数"""
    def feature(self):
        _近150天1度联系人中通话次数top5的主叫通话次数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['trade_new'] = 0
                df.loc[df.tradeWay.str.contains('主'), 'trade_new'] = 1
                df.loc[df.tradeWay.str.contains('被'), 'trade_new'] = 2
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'caller_count':df.loc[df['trade_new'] == 1]['trade_new'].count()
                                    })
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:5]
            _近150天1度联系人中通话次数top5的主叫通话次数 = df_call_record['caller_count'].sum()
        self._result['近150天1度联系人中通话次数top5的主叫通话次数']['value'] = _近150天1度联系人中通话次数top5的主叫通话次数
        return self._result


class 近150天1度联系人中的凌晨1and6点的通话次数():
    def feature(self):
        _近150天1度联系人中的凌晨1and6点的通话次数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone['cTime_time'] = df_telephone['cTime'].apply(lambda x : x.split(' ')[1])
            df_telephone = df_telephone.loc[(df_telephone['cTime_time'] >= '01:00:00') & (df_telephone['cTime_time'] < '07:00:00')]
            _近150天1度联系人中的凌晨1and6点的通话次数 = df_telephone['receiverPhone'].count()
        self._result['近150天1度联系人中的凌晨1and6点的通话次数']['value'] = _近150天1度联系人中的凌晨1and6点的通话次数
        return self._result

class 近150天1度联系人中的凌晨1and6点的通话号码个数():
    """degree_one_call_contact#call_numbers_cnt_m16	近150天1度联系人中的凌晨1and6点的通话号码个数"""
    def feature(self):
        _近150天1度联系人中的凌晨1and6点的通话号码个数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone['cTime_time'] = df_telephone['cTime'].apply(lambda x : x.split(' ')[1])
            df_telephone = df_telephone.loc[(df_telephone['cTime_time'] >= '01:00:00') & (df_telephone['cTime_time'] < '07:00:00')]

            df_telephone = df_telephone.loc[df_telephone['receiverPhone'].duplicated(keep='first')==False]
            _近150天1度联系人中的凌晨1and6点的通话号码个数 = df_telephone['receiverPhone'].count()
        self._result['近150天1度联系人中的凌晨1and6点的通话号码个数']['value'] = _近150天1度联系人中的凌晨1and6点的通话号码个数
        return self._result

class 近150天1度联系人中的凌晨1and6点的通话秒数():
    """degree_one_call_contact#call_long_m16	近150天1度联系人中的凌晨1and6点的通话秒数"""
    def feature(self):
        _近150天1度联系人中的凌晨1and6点的通话秒数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone['cTime_time'] = df_telephone['cTime'].apply(lambda x : x.split(' ')[1])
            df_telephone = df_telephone.loc[(df_telephone['cTime_time'] >= '01:00:00') & (df_telephone['cTime_time'] < '07:00:00')]
            _近150天1度联系人中的凌晨1and6点的通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的凌晨1and6点的通话秒数']['value'] = _近150天1度联系人中的凌晨1and6点的通话秒数
        return self._result

class 近150天1度联系人中的手机号的通话次数():
    """degree_one_call_contact#call_phone_cnt	近150天1度联系人中的手机号的通话次数"""
    def feature(self):
        _近150天1度联系人中的手机号的通话次数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            df_telephone = df_telephone.loc[df_telephone['receiverPhone'].isin(self._contacts_phone_l)]
            _近150天1度联系人中的手机号的通话次数 = 0
            if df_telephone.empty == False:
                # df_telephone['is_phone'] = False
                # df_telephone.loc[df_telephone['receiverPhone'].str.contains(r'(^|\D)(1[3546789]\d{9})($|\D)',regex=True),'is_phone'] = True
                # _近150天1度联系人中的手机号的通话次数 = df_telephone.loc[df_telephone['is_phone']==True]['is_phone'].count()
                _近150天1度联系人中的手机号的通话次数 = len(get_PhoneNo(df_telephone['receiverPhone'].tolist()))
        self._result['近150天1度联系人中的手机号的通话次数']['value'] = _近150天1度联系人中的手机号的通话次数
        return self._result

class 近150天1度联系人中的手机号的通话号码个数():
    """degree_one_call_contact#call_phone_numbers_cnt	近150天1度联系人中的手机号的通话号码个数"""
    def feature(self):
        _近150天1度联系人中的手机号的通话号码个数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone = df_telephone.loc[df_telephone['receiverPhone'].isin(self._contacts_phone_l)]
            # df_telephone['is_phone'] = False
            # df_telephone.loc[df_telephone['receiverPhone'].str.contains(r'(^|\D)(1[3546789]\d{9})($|\D)',regex=True),'is_phone'] = True
            # _近150天1度联系人中的手机号的通话次数 = df_telephone.loc[df_telephone['is_phone']==True]['is_phone'].count()
            _近150天1度联系人中的手机号的通话号码个数 = len(list(set(get_PhoneNo(df_telephone['receiverPhone'].tolist()))))
        self._result['近150天1度联系人中的手机号的通话号码个数']['value'] = _近150天1度联系人中的手机号的通话号码个数
        return self._result

class 近150天1度联系人中的手机号的通话秒数():
    """degree_one_call_contact#call_phone_long	近150天1度联系人中的手机号的通话秒数"""
    def feature(self):
        _近150天1度联系人中的手机号的通话秒数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            df_telephone = df_telephone.loc[df_telephone['receiverPhone'].isin(self._contacts_phone_l)]
            _近150天1度联系人中的手机号的通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的手机号的通话秒数']['value'] = _近150天1度联系人中的手机号的通话秒数
        return self._result

class 近150天1度联系人中的被叫的通话次数():
    """degree_one_call_contact#call_beijiao_cnt	近150天1度联系人中的被叫的通话次数"""
    def feature(self):
        _近150天1度联系人中的被叫的通话次数 = -9999999
        df_telephone = self._df_telephone

        if df_telephone.empty == False:
            df_telephone['trade_new'] = 0
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
            df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
            _近150天1度联系人中的被叫的通话次数 =df_telephone.loc[df_telephone['trade_new']==2]['tradeWay'].count()
        self._result['近150天1度联系人中的被叫的通话次数']['value'] = _近150天1度联系人中的被叫的通话次数
        return self._result

class 近150天1度联系人中的被叫的通话号码个数():
    """degree_one_call_contact#call_beijiao_numbers_cnt	近150天1度联系人中的被叫的通话号码个数"""
    def feature(self):
        _近150天1度联系人中的被叫的通话号码个数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone['trade_new'] = 0
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
            df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
            df_telephone = df_telephone.loc[(df_telephone['trade_new']==2)]

            _近150天1度联系人中的被叫的通话号码个数 = len(set(df_telephone['receiverPhone'].tolist()))

        self._result['近150天1度联系人中的被叫的通话号码个数']['value'] = _近150天1度联系人中的被叫的通话号码个数
        return self._result

class 近150天1度联系人中的被叫的通话秒数():
    def feature(self):
        _近150天1度联系人中的被叫的通话秒数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone['trade_new'] = 0
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
            df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
            df_telephone = df_telephone.loc[df_telephone['trade_new']==2]
            _近150天1度联系人中的被叫的通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的被叫的通话秒数']['value'] = _近150天1度联系人中的被叫的通话秒数
        return self._result

class 近150天1度联系人中的主叫的通话次数():
    def feature(self):
        _近150天1度联系人中的主叫的通话次数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone['trade_new'] = 0
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
            df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
            _近150天1度联系人中的主叫的通话次数 = df_telephone.loc[df_telephone['trade_new']==1]['tradeWay'].count()
        self._result['近150天1度联系人中的主叫的通话次数']['value'] = _近150天1度联系人中的主叫的通话次数
        return self._result
#
class 近150天1度联系人中的主叫的通话号码个数():
    def feature(self):
        _近150天1度联系人中的主叫的通话号码个数 = -9999999
        
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone['trade_new'] = 0
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
            df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
            df_telephone = df_telephone.loc[(df_telephone['trade_new']==1)]
            _近150天1度联系人中的主叫的通话号码个数 = len(list(set(df_telephone['receiverPhone'].tolist())))

        self._result['近150天1度联系人中的主叫的通话号码个数']['value'] = _近150天1度联系人中的主叫的通话号码个数
        return self._result

class 近150天1度联系人中的主叫的通话秒数():
    def feature(self):
        _近150天1度联系人中的主叫的通话秒数 = -9999999
        if self._df_telephone.empty == False:

            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
                df_telephone = df_telephone.loc[df_telephone['trade_new']==1]
                _近150天1度联系人中的主叫的通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的主叫的通话秒数']['value'] = _近150天1度联系人中的主叫的通话秒数
        return self._result

class 近150天1度联系人中的本地的通话次数():
    """degree_one_call_contact#call_local_cnt	近150天1度联系人中的本地的通话次数"""
    def feature(self):
        _近150天1度联系人中的本地的通话次数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            tradeAddr = get_lkb_user_phone_location(self.uuid)

            # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
            # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0
            tradeAddr = getTradeAdd(tradeAddr)
            df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))
            # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
            # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

            df_telephone = df_telephone.loc[df_telephone['tradeAddr_new'] == 1]
            _近150天1度联系人中的本地的通话次数 = df_telephone['tradeAddr_new'].count()
        self._result['近150天1度联系人中的本地的通话次数']['value'] = _近150天1度联系人中的本地的通话次数
        return self._result

class 近150天1度联系人中的本地的通话号码个数():
    def feature(self):
        _近150天1度联系人中的本地的通话号码个数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            tradeAddr = get_lkb_user_phone_location(self.uuid)
            # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
            # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

            tradeAddr = getTradeAdd(tradeAddr)
            df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

            df_telephone = df_telephone.loc[df_telephone['tradeAddr_new'] == 1]
            _近150天1度联系人中的本地的通话号码个数 = len(list(set(df_telephone['receiverPhone'].tolist())))
        self._result['近150天1度联系人中的本地的通话号码个数']['value'] = _近150天1度联系人中的本地的通话号码个数
        return self._result

class 近150天1度联系人中的本地的通话秒数():
    """degree_one_call_contact#call_local_long	近150天1度联系人中的本地的通话秒数"""
    def feature(self):
        _近150天1度联系人中的本地的通话秒数 = -9999999
        # df_telephone = self._df_telephone
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            tradeAddr = get_lkb_user_phone_location(self.uuid)
            # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr)>=70 else 2)
            # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0
            tradeAddr = getTradeAdd(tradeAddr)
            df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

            df_telephone = df_telephone.loc[df_telephone['tradeAddr_new']==1]
            _近150天1度联系人中的本地的通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的本地的通话秒数']['value'] = _近150天1度联系人中的本地的通话秒数
        return self._result

class 近150天1度联系人中的本地主叫的通话次数():
    def feature(self):
        _近150天1度联系人中的本地主叫的通话次数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0
                tradeAddr = getTradeAdd(tradeAddr)
                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==1) & (df_telephone['trade_new']==1)]
                _近150天1度联系人中的本地主叫的通话次数 = df_telephone['receiverPhone'].count()
        self._result['近150天1度联系人中的本地主叫的通话次数']['value'] = _近150天1度联系人中的本地主叫的通话次数
        return self._result

class 近150天1度联系人中的本地主叫的通话号码个数():
    """degree_one_call_contact#call_remote_zhujiao_numbers_cnt	近150天1度联系人中的异地主叫的通话号码个数"""
    def feature(self):
        _近150天1度联系人中的本地主叫的通话号码个数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0
                tradeAddr = getTradeAdd(tradeAddr)
                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==1) & (df_telephone['trade_new']==1)]
                _近150天1度联系人中的本地主叫的通话号码个数 = len(list(set(df_telephone['receiverPhone'].tolist())))
        self._result['近150天1度联系人中的本地主叫的通话号码个数']['value'] = _近150天1度联系人中的本地主叫的通话号码个数
        return self._result

class 近150天1度联系人中的本地主叫的通话秒数():
    def feature(self):
        _近150天1度联系人中的本地主叫的通话秒数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0
                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==1) & (df_telephone['trade_new']==1)]
                _近150天1度联系人中的本地主叫的通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的本地主叫的通话秒数']['value'] = _近150天1度联系人中的本地主叫的通话秒数
        return self._result

class 近150天1度联系人中的本地被叫的通话次数():
    def feature(self):
        _近150天1度联系人中的本地被叫的通话次数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==1) &( df_telephone['trade_new']==2)]
                _近150天1度联系人中的本地被叫的通话次数 = df_telephone['receiverPhone'].count()
        self._result['近150天1度联系人中的本地被叫的通话次数']['value'] = _近150天1度联系人中的本地被叫的通话次数
        return self._result

class 近150天1度联系人中的本地被叫的通话号码个数():
    """degree_one_call_contact#call_local_beijiao_numbers_cnt   近150天1度联系人中的本地被叫的通话号码个数"""
    def feature(self):
        _近150天1度联系人中的本地被叫的通话号码个数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==1) & (df_telephone['trade_new']==2)]
                _近150天1度联系人中的本地被叫的通话号码个数 = len(list(set(df_telephone['receiverPhone'].tolist())))
        self._result['近150天1度联系人中的本地被叫的通话号码个数']['value'] = _近150天1度联系人中的本地被叫的通话号码个数
        return self._result

class 近150天1度联系人中的本地被叫的通话秒数():
    def feature(self):
        _近150天1度联系人中的本地被叫的通话秒数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==1) & (df_telephone['trade_new']==2)]
                _近150天1度联系人中的本地被叫的通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的本地被叫的通话秒数']['value'] = _近150天1度联系人中的本地被叫的通话秒数
        return self._result



class 近150天1度联系人中的异地主叫的通话次数():
    """degree_one_call_contact#call_remote_zhujiao_cnt	近150天1度联系人中的异地主叫的通话次数"""
    def feature(self):
        _近150天1度联系人中的异地主叫的通话次数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                # df_telephone.loc[df_telephone['tradeAddr'].isnull(),'tradeAddr_new'] = 0
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0
                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==1)]
                _近150天1度联系人中的异地主叫的通话次数 = df_telephone['receiverPhone'].count()
        self._result['近150天1度联系人中的异地主叫的通话次数']['value'] = _近150天1度联系人中的异地主叫的通话次数
        return self._result

class 近150天1度联系人中的异地主叫的通话号码个数():
    """degree_one_call_contact#call_remote_zhujiao_numbers_cnt	近150天1度联系人中的异地主叫的通话号码个数"""
    def feature(self):
        _近150天1度联系人中的异地主叫的通话号码个数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone.apply(lambda x : getCityisLocal(tradeAddr,x['tradeAddr']),axis=1)

                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==1)]
                _近150天1度联系人中的异地主叫的通话号码个数 = len(list(set(df_telephone['receiverPhone'].tolist())))
        self._result['近150天1度联系人中的异地主叫的通话号码个数']['value'] = _近150天1度联系人中的异地主叫的通话号码个数
        return self._result

class 近150天1度联系人中的异地主叫的通话秒数():
    """degree_one_call_contact#call_remote_zhujiao_long	近150天1度联系人中的异地主叫的通话秒数"""
    def feature(self):
        _近150天1度联系人中的异地主叫的通话秒数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone.apply(lambda x : getCityisLocal(tradeAddr,x['tradeAddr']),axis=1)

                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==1)]
                _近150天1度联系人中的异地主叫的通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的异地主叫的通话秒数']['value'] = _近150天1度联系人中的异地主叫的通话秒数
        return self._result

class 近150天1度联系人中的异地主叫的通话次数占比():
    """degree_one_call_contact#call_remote_zhujiao_cnt_ratio    近150天1度联系人中的异地主叫的通话次数占比"""
    def feature(self):
        _近150天1度联系人中的异地主叫的通话次数占比 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
                telephone_sum = df_telephone['receiverPhone'].count()
                telephone_sum_remote = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==1)]['receiverPhone'].count()
                if telephone_sum > 0 and telephone_sum_remote>0:

                    _近150天1度联系人中的异地主叫的通话次数占比 =round(telephone_sum_remote/telephone_sum,6)
                else:
                    _近150天1度联系人中的异地主叫的通话次数占比 = 0

        self._result['近150天1度联系人中的异地主叫的通话次数占比']['value'] = _近150天1度联系人中的异地主叫的通话次数占比
        return self._result

class 近150天1度联系人中的异地主叫的通话号码个数占比():
    """degree_one_call_contact#call_remote_zhujiao_numbers_cnt_ratio    近150天1度联系人中的异地主叫的通话号码个数占比"""
    def feature(self):
        _近150天1度联系人中的异地主叫的通话号码个数占比 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)

                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
                telephone_sum = len(list(set(df_telephone['receiverPhone'].tolist())))
                telephone_sum_remote = len(list(set(df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==1)]['receiverPhone'].tolist())))
                if telephone_sum>0 and telephone_sum_remote>0:
                    _近150天1度联系人中的异地主叫的通话号码个数占比 = round(telephone_sum_remote/telephone_sum,6)
                else:
                    _近150天1度联系人中的异地主叫的通话号码个数占比 = 0

        self._result['近150天1度联系人中的异地主叫的通话号码个数占比']['value'] = _近150天1度联系人中的异地主叫的通话号码个数占比
        return self._result

class 近150天1度联系人中的异地主叫的通话秒数占比():
    """degree_one_call_contact#call_remote_zhujiao_long_ratio  近150天1度联系人中的异地主叫的通话秒数占比"""
    def feature(self):
        _近150天1度联系人中的异地主叫的通话秒数占比 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                tradeTime_sum = df_telephone['tradeTime'].astype(int).sum()
                df_telephone_remote = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==1)]
                if df_telephone_remote.empty==False:
                    tradeTime_sum_remote = df_telephone_remote['tradeTime'].astype(int).sum()
                else:
                    tradeTime_sum_remote = 0

                if tradeTime_sum_remote>0 and tradeTime_sum>0:
                    results = tradeTime_sum_remote/tradeTime_sum
                    results_front = str(results).split('.')[0]
                    results_behind =  str(results).split('.')[1][:6]
                    _近150天1度联系人中的异地主叫的通话秒数占比 = round(float(results_front+'.'+results_behind),6)
                else:
                    _近150天1度联系人中的异地主叫的通话秒数占比 = 0

        self._result['近150天1度联系人中的异地主叫的通话秒数占比']['value'] = _近150天1度联系人中的异地主叫的通话秒数占比
        return self._result


class 近150天1度联系人中的异地被叫的通话次数():
    """degree_one_call_contact#call_remote_beijiao_cnt	近150天1度联系人中的异地被叫的通话次数"""
    def feature(self):
        _近150天1度联系人中的异地被叫的通话次数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==2)]
                _近150天1度联系人中的异地被叫的通话次数 = df_telephone['receiverPhone'].count()
        self._result['近150天1度联系人中的异地被叫的通话次数']['value'] = _近150天1度联系人中的异地被叫的通话次数
        return self._result

class 近150天1度联系人中的异地被叫的通话号码个数():
    """degree_one_call_contact#call_remote_beijiao_numbers_cnt	近150天1度联系人中的异地被叫的通话号码个数"""
    def feature(self):
        _近150天1度联系人中的异地被叫的通话号码个数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            tradeAddr = get_lkb_user_phone_location(self.uuid)
            # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
            # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

            # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
            tradeAddr = getTradeAdd(tradeAddr)
            df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

            df_telephone['trade_new'] = 0
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
            df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

            df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==2)]
            _近150天1度联系人中的异地被叫的通话号码个数 = len(list(set(df_telephone['receiverPhone'].tolist())))
        self._result['近150天1度联系人中的异地被叫的通话号码个数']['value'] = _近150天1度联系人中的异地被叫的通话号码个数
        return self._result

class 近150天1度联系人中的异地被叫的通话秒数():
    def feature(self):
        _近150天1度联系人中的异地被叫的通话秒数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            tradeAddr = get_lkb_user_phone_location(self.uuid)
            # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
            # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

            # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
            tradeAddr = getTradeAdd(tradeAddr)
            df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

            df_telephone['trade_new'] = 0
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
            df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2

            df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==2)]
            _近150天1度联系人中的异地被叫的通话秒数 = df_telephone['tradeTime'].astype(int).sum()
        self._result['近150天1度联系人中的异地被叫的通话秒数']['value'] = _近150天1度联系人中的异地被叫的通话秒数
        return self._result

class 近150天1度联系人中的异地被叫的通话次数占比():
    """degree_one_call_contact#call_remote_beijiao_cnt_ratio    近150天1度联系人中的异地被叫的通话次数占比"""
    def feature(self):
        _近150天1度联系人中的异地被叫的通话次数占比 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            tradeAddr = get_lkb_user_phone_location(self.uuid)
            # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
            # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

            # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
            tradeAddr = getTradeAdd(tradeAddr)
            df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

            df_telephone['trade_new'] = 0
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
            df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
            telephone_sum = df_telephone['receiverPhone'].count()
            telephone_sum_remote = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==2)]['receiverPhone'].count()
            if telephone_sum_remote>0 and telephone_sum>0:
                _近150天1度联系人中的异地被叫的通话次数占比 =round(telephone_sum_remote/telephone_sum,6)
            else:
                _近150天1度联系人中的异地被叫的通话次数占比 = 0

        self._result['近150天1度联系人中的异地被叫的通话次数占比']['value'] = _近150天1度联系人中的异地被叫的通话次数占比
        return self._result

class 近150天1度联系人中的异地被叫的通话号码个数占比():
    """degree_one_call_contact#call_remote_beijiao_numbers_cnt_ratio	近150天1度联系人中的异地被叫的通话号码个数占比"""
    def feature(self):
        _近150天1度联系人中的异地被叫的通话号码个数占比 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            tradeAddr = get_lkb_user_phone_location(self.uuid)
            # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
            # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

            # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
            tradeAddr = getTradeAdd(tradeAddr)
            df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

            df_telephone['trade_new'] = 0
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
            df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
            telephone_sum = len(list(set(df_telephone['receiverPhone'].tolist())))
            telephone_sum_remote = len(list(set(df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==2)]['receiverPhone'].tolist())))
            if telephone_sum > 0 and telephone_sum_remote>0:
                _近150天1度联系人中的异地被叫的通话号码个数占比 =round(telephone_sum_remote/telephone_sum,6)
            else:
                _近150天1度联系人中的异地被叫的通话号码个数占比 = 0
        self._result['近150天1度联系人中的异地被叫的通话号码个数占比']['value'] = _近150天1度联系人中的异地被叫的通话号码个数占比
        return self._result

class 近150天1度联系人中的异地被叫的通话秒数占比():
    """degree_one_call_contact#call_remote_beijiao_long_ratio   近150天1度联系人中的异地被叫的通话秒数占比"""
    def feature(self):
        _近150天1度联系人中的异地被叫的通话秒数占比 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                # df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : 1 if fuzz.partial_ratio(x, tradeAddr) >= 70 else 2)
                # df_telephone.loc[(df_telephone['tradeAddr'].isnull())|(df_telephone['tradeAddr']==None),'tradeAddr_new'] = 0

                # df_telephone['tradeAddr'] = df_telephone['tradeAddr'].apply(lambda x : getTradeAdd(x))
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))

                df_telephone['trade_new'] = 0
                # df_telephone = df_telephone.dropna(subset=["tradeWay"])
                df_telephone['tradeWay'].fillna("其他", inplace=True)
                df_telephone.loc[df_telephone['tradeWay'].str.contains('主'),'trade_new'] = 1
                df_telephone.loc[df_telephone['tradeWay'].str.contains('被'),'trade_new'] = 2
                tradeTime_sum = df_telephone['tradeTime'].astype(int).sum()
                tradeTime_sum_remote = df_telephone.loc[(df_telephone['tradeAddr_new']==2) & (df_telephone['trade_new']==2)]['tradeTime'].astype(int).sum()
                if tradeTime_sum>0 and tradeTime_sum_remote>0:
                    _近150天1度联系人中的异地被叫的通话秒数占比 =round(tradeTime_sum_remote/tradeTime_sum,6)
                else:
                    _近150天1度联系人中的异地被叫的通话秒数占比 = 0

        self._result['近150天1度联系人中的异地被叫的通话秒数占比']['value'] = _近150天1度联系人中的异地被叫的通话秒数占比
        return self._result

class 近150天1度联系人中命中QG黑名单的个数():
    """degree_one_contact_in_black_m5	近150天1度联系人中命中QG黑名单的个数 """
    def feature(self):
        _近150天1度联系人中命中QG黑名单的个数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            # (datetime.datetime.strptime(self.time_end, '%Y-%m-%d %H:%M:%S')
            #当没传order_no 的时候看看
            # time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S'), '%Y-%m-%d %H:%M:%S')

            _df_qgblack = getSql_relation_in_qgblack(str((self._contacts_phone)).replace(',)',')'),self._apply_at)
            _df_qgblack = _df_qgblack.drop_duplicates('phone',keep='first')
            _近150天1度联系人中命中QG黑名单的个数 = _df_qgblack['phone'].count()

        self._result['近150天1度联系人中命中QG黑名单的个数']['value'] = _近150天1度联系人中命中QG黑名单的个数
        return self._result




class 近150天1度联系人中在QG有在逾的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanOverdueUserCount	近150天1度联系人中在QG有在逾的人数"""
    def feature(self):
        _近150天1度联系人中在QG有在逾的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                # _df_loan = _df_loan.loc[_df_loan['loan_paid_at'] > self._apply_at]
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:
                            _df_loan['progress'] = 16
                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _df_loan = _df_loan.loc[(_df_loan['passdue_day']>0)]
                            _近150天1度联系人中在QG有在逾的人数 = len(list(set(_df_loan['user_id'])))
        self._result['近150天1度联系人中在QG有在逾的人数']['value'] = _近150天1度联系人中在QG有在逾的人数
        return self._result

class 近150天1度联系人中在QG有最大在逾天数超过15天的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanGtD15Count	近150天1度联系人中在QG有最大在逾天数超过15天的人数"""
    def feature(self):
        _近150天1度联系人中在QG有最大在逾天数超过15天的人数 = -9999999

        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))

                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:

                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _近150天1度联系人中在QG有最大在逾天数超过15天的人数 = len(list(set(_df_loan.loc[(_df_loan['passdue_day']>15)]['user_id'])))

        self._result['近150天1度联系人中在QG有最大在逾天数超过15天的人数']['value'] = _近150天1度联系人中在QG有最大在逾天数超过15天的人数
        return self._result



class 近150天1度联系人中在QG有最大在逾天数超过30天的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanGtD30Count	近150天1度联系人中在QG有最大在逾天数超过30天的人数"""
    def feature(self):
        _近150天1度联系人中在QG有最大在逾天数超过30天的人数 = -9999999

        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))

                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:

                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _近150天1度联系人中在QG有最大在逾天数超过30天的人数 = len(list(set(_df_loan.loc[(_df_loan['passdue_day']>30)]['user_id'])))
        self._result['近150天1度联系人中在QG有最大在逾天数超过30天的人数']['value'] = _近150天1度联系人中在QG有最大在逾天数超过30天的人数
        return self._result


class 近150天1度联系人中在QG有最大在逾天数超过60天的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanGtD60Count	近150天1度联系人中在QG有最大在逾天数超过60天的人数"""
    def feature(self):
        _近150天1度联系人中在QG有最大在逾天数超过60天的人数 = -9999999

        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))

                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:

                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')
                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _近150天1度联系人中在QG有最大在逾天数超过60天的人数 = len(list(set(_df_loan.loc[(_df_loan['passdue_day']>60)]['user_id'])))

        self._result['近150天1度联系人中在QG有最大在逾天数超过60天的人数']['value'] = _近150天1度联系人中在QG有最大在逾天数超过60天的人数
        return self._result



class 近150天1度联系人中在QG有最大在逾天数超过90天的人数():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanGtD90Count	近150天1度联系人中在QG有最大在逾天数超过90天的人数"""
    def feature(self):
        _近150天1度联系人中在QG有最大在逾天数超过90天的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))

                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:

                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _近150天1度联系人中在QG有最大在逾天数超过90天的人数 = len(list(set(_df_loan.loc[(_df_loan['passdue_day']>90)]['user_id'])))

        self._result['近150天1度联系人中在QG有最大在逾天数超过90天的人数']['value'] = _近150天1度联系人中在QG有最大在逾天数超过90天的人数
        return self._result


class 近150天1度联系人中在QG的最大在逾逾期天数之和():
    """degree_one_contact_loan_max_delq_days#uncomplateLoanTotalOverdueDays	近150天1度联系人中在QG的最大在逾逾期天数之和"""
    def feature(self):
        _近150天1度联系人中在QG的最大在逾逾期天数之和 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:
                            _df_loan['progress'] = 16
                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                        if _df_loan.empty == False:
                            _df_loan_g = _df_loan.groupby(['user_id']).agg({'passdue_day':'max'}).reset_index()
                            _近150天1度联系人中在QG的最大在逾逾期天数之和 = _df_loan_g['passdue_day'].sum()
        self._result['近150天1度联系人中在QG的最大在逾逾期天数之和']['value'] = _近150天1度联系人中在QG的最大在逾逾期天数之和
        return self._result

class 近150天1度联系人中在QG有过历史逾期的个数():
    """degree_one_contact_loan_max_delq_days#loanPostOverdueUserCount	近150天1度联系人中在QG有过历史逾期的个数"""
    def feature(self):
        _近150天1度联系人中在QG有过历史逾期的个数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty== False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)
                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)&(_df_loan['apply_time']<_df_loan['observationTime'])]['loan_id'].tolist()
                        # _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                        if _df_loan.empty == False:
                            _df_loan = _df_loan.loc[_df_loan['passdue_day']>0]
                            _近150天1度联系人中在QG有过历史逾期的个数 = len(list(set(_df_loan['user_id'])))
        self._result['近150天1度联系人中在QG有过历史逾期的个数']['value'] = _近150天1度联系人中在QG有过历史逾期的个数
        return self._result

class 近150天1度联系人中在QG有过历史逾期的占比():
    def feature(self):
        _近150天1度联系人中在QG有过历史逾期的占比 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                _df_loan = _df_loan.loc[_df_loan['loan_paid_at'] > self._apply_at]
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        if _df_loan.empty == False:
                            plan_count = _df_loan['plan_id'].count()
                            passdue_count = _df_loan.loc[_df_loan['passdue_day']>0]['plan_id'].count()
                            _近150天1度联系人中在QG有过历史逾期的占比 = passdue_count/plan_count
        self._result['近150天1度联系人中在QG有过历史逾期的占比']['value'] = _近150天1度联系人中在QG有过历史逾期的占比
        return self._result


class 近150天1度联系人中在QG有历史最大天数超过15天的人数():
    """degree_one_contact_loan_max_delq_days#loanPostGtD15Count	近150天1度联系人中在QG有历史最大天数超过15天的人数"""
    def feature(self):
        _近150天1度联系人中在QG有历史最大天数超过15天的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['apply_time'] = _df_loan['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)&(_df_loan['apply_time']<_df_loan['observationTime'])]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:
                            _df_loan['progress'] = 16
                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                        if _df_loan.empty == False:
                            passdue_user = len(list(set(_df_loan.loc[_df_loan['passdue_day']>15]['user_id'])))
                            _近150天1度联系人中在QG有历史最大天数超过15天的人数 =  passdue_user
        self._result['近150天1度联系人中在QG有历史最大天数超过15天的人数']['value'] = _近150天1度联系人中在QG有历史最大天数超过15天的人数
        return self._result

class 近150天1度联系人中在QG有历史最大天数超过30天的人数():
    """degree_one_contact_loan_max_delq_days#loanPostGtD30Count	近150天1度联系人中在QG有历史最大天数超过30天的人数"""
    def feature(self):
        _近150天1度联系人中在QG有历史最大天数超过30天的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['apply_time'] = _df_loan['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)&(_df_loan['apply_time']<_df_loan['observationTime'])]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:
                            _df_loan['progress'] = 16
                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                        if _df_loan.empty == False:
                            passdue_user = len(list(set(_df_loan.loc[_df_loan['passdue_day']>30]['user_id'])))
                            _近150天1度联系人中在QG有历史最大天数超过30天的人数 =  passdue_user
        self._result['近150天1度联系人中在QG有历史最大天数超过30天的人数']['value'] = _近150天1度联系人中在QG有历史最大天数超过30天的人数
        return self._result

class 近150天1度联系人中在QG有历史最大天数超过60天的人数():
    """degree_one_contact_loan_max_delq_days#loanPostGtD60Count	近150天1度联系人中在QG有历史最大天数超过60天的人数"""
    def feature(self):
        _近150天1度联系人中在QG有历史最大天数超过60天的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['apply_time'] = _df_loan['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)&(_df_loan['apply_time']<_df_loan['observationTime'])]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:
                            _df_loan['progress'] = 16
                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                        if _df_loan.empty == False:
                            passdue_user = len(list(set(_df_loan.loc[_df_loan['passdue_day']>60]['user_id'])))
                            _近150天1度联系人中在QG有历史最大天数超过60天的人数 =  passdue_user
        self._result['近150天1度联系人中在QG有历史最大天数超过60天的人数']['value'] = _近150天1度联系人中在QG有历史最大天数超过60天的人数
        return self._result

class 近150天1度联系人中在QG有历史最大天数超过90天的人数():
    """degree_one_contact_loan_max_delq_days#loanPostGtD90Count	近150天1度联系人中在QG有历史最大天数超过90天的人数"""
    def feature(self):
        _近150天1度联系人中在QG有历史最大天数超过90天的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['apply_time'] = _df_loan['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)&(_df_loan['apply_time']<_df_loan['observationTime'])]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:
                            _df_loan['progress'] = 16
                        _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                        if _df_loan.empty == False:
                            passdue_user = len(list(set(_df_loan.loc[_df_loan['passdue_day']>90]['user_id'])))
                            _近150天1度联系人中在QG有历史最大天数超过90天的人数 =  passdue_user
        self._result['近150天1度联系人中在QG有历史最大天数超过90天的人数']['value'] = _近150天1度联系人中在QG有历史最大天数超过90天的人数
        return self._result

class 近150天1度联系人中在QG有历史最大天数超过15天的人数占比():
    def feature(self):
        _近150天1度联系人中在QG有历史最大天数超过15天的人数占比 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                _df_loan = _df_loan.loc[_df_loan['loan_paid_at'] > self._apply_at]
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan_new = _df_loan.loc[_df_loan['progress'].isin([16])]
                        if _df_loan_new.empty == False:
                            passdue_user = len(list(set(_df_loan_new.loc[_df_loan_new['passdue_day']>15]['user_id'])))
                            not_passdue_user = len(list(set(_df_loan_new['user_id'])))
                            if passdue_user>0 and not_passdue_user>0:
                                _近150天1度联系人中在QG有历史最大天数超过15天的人数占比 =  passdue_user/not_passdue_user
                            else:_近150天1度联系人中在QG有历史最大天数超过15天的人数占比 = 0
        self._result['近150天1度联系人中在QG有历史最大天数超过15天的人数占比']['value'] = _近150天1度联系人中在QG有历史最大天数超过15天的人数占比
        return self._result

class 近150天1度联系人中在QG有历史最大天数超过30天的人数占比():
    """"""
    def feature(self):
        _近150天1度联系人中在QG有历史最大天数超过30天的人数占比 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                _df_loan = _df_loan.loc[_df_loan['loan_paid_at'] > self._apply_at]
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16
                        _df_loan_new = _df_loan.loc[_df_loan['progress'].isin([16])]
                        if _df_loan_new.empty == False:
                            passdue_user = len(list(set(_df_loan_new.loc[_df_loan_new['passdue_day']>15]['user_id'])))
                            not_passdue_user = len(list(set(_df_loan_new['user_id'])))
                            _近150天1度联系人中在QG有历史最大天数超过30天的人数占比 =  passdue_user/not_passdue_user
        self._result['近150天1度联系人中在QG有历史最大天数超过30天的人数占比']['value'] = _近150天1度联系人中在QG有历史最大天数超过30天的人数占比
        return self._result


class 近150天1度联系人中在QG有历史最大天数超过60天的人数占比():
    def feature(self):
        _近150天1度联系人中在QG有历史最大天数超过60天的人数占比 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                _df_loan = _df_loan.loc[_df_loan['loan_paid_at'] > self._apply_at]
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan_new = _df_loan.loc[_df_loan['progress'].isin([16])]
                        if _df_loan_new.empty == False:
                            passdue_user = len(list(set(_df_loan_new.loc[_df_loan_new['passdue_day']>15]['user_id'])))
                            not_passdue_user = len(list(set(_df_loan_new['user_id'])))
                            _近150天1度联系人中在QG有历史最大天数超过60天的人数占比 =  passdue_user/not_passdue_user
        self._result['近150天1度联系人中在QG有历史最大天数超过60天的人数占比']['value'] = _近150天1度联系人中在QG有历史最大天数超过60天的人数占比
        return self._result


class 近150天1度联系人中在QG有历史最大天数超过90天的人数占比():
    def feature(self):
        _近150天1度联系人中在QG有历史最大天数超过90天的人数占比 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                _df_loan = _df_loan.loc[_df_loan['loan_paid_at'] > self._apply_at]
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan_new = _df_loan.loc[_df_loan['progress'].isin([16])]
                        if _df_loan_new.empty == False:
                            passdue_user = len(list(set(_df_loan_new.loc[_df_loan_new['passdue_day']>15]['user_id'])))
                            not_passdue_user = len(list(set(_df_loan_new['user_id'])))
                            _近150天1度联系人中在QG有历史最大天数超过90天的人数占比 =  passdue_user/not_passdue_user
        self._result['近150天1度联系人中在QG有历史最大天数超过90天的人数占比']['value'] = _近150天1度联系人中在QG有历史最大天数超过90天的人数占比
        return self._result



class 近150天1度联系人中在QG的历史最大逾期天数之和():
    """degree_one_contact_loan_max_delq_days#loanPostTotalOverdueDays	近150天1度联系人中在QG的历史最大逾期天数之和"""
    def feature(self):
        _近150天1度联系人中在QG的历史最大逾期天数之和 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))
                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        else:_df_loan['progress'] = 16

                        _df_loan_new = _df_loan.loc[_df_loan['progress'].isin([16])]
                        if _df_loan_new.empty == False:
                            _df_loan_new_g = _df_loan_new.groupby('user_id').agg({'passdue_day':'max'}).reset_index()
                            passdue_days = _df_loan_new_g['passdue_day'].sum()
                            _近150天1度联系人中在QG的历史最大逾期天数之和 = passdue_days
        self._result['近150天1度联系人中在QG的历史最大逾期天数之和']['value'] = _近150天1度联系人中在QG的历史最大逾期天数之和
        return self._result

class 近150天1度联系人中在QG的历史最大逾期的人均天数():
    def feature(self):
        _近150天1度联系人中在QG的历史最大逾期的人均天数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(df_user['user_id'].tolist())).replace(',)',')'))

                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self._apply_at
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days

                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0
                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)

                        _loan_id = _df_loan.loc[(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15

                        _df_loan_new = _df_loan.loc[_df_loan['progress'].isin([16])]
                        if _df_loan_new.empty == False:
                            _df_loan_new_g = _df_loan_new.groupby('user_id').agg({'passdue_day':'max'}).reset_index()
                            passdue_days = _df_loan_new_g['passdue_day'].sum()
                            user_count = len(list(set(_df_loan_new_g['user_id'])))
                            _近150天1度联系人中在QG的历史最大逾期的人均天数 = passdue_days/user_count
        self._result['近150天1度联系人中在QG的历史最大逾期的人均天数']['value'] = _近150天1度联系人中在QG的历史最大逾期的人均天数
        return self._result

# ===
class 近150天1度联系人中在QG有过注册的人数():
    """m5_contact_register#cnt	近150天1度联系人中在QG有过注册的人数"""
    def feature(self):
        _近150天1度联系人中在QG有过注册的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有过注册的人数 = 0
            if df_user.empty == False:
                df = df_user.loc[df_user['created_at'] <self._apply_at]
                _近150天1度联系人中在QG有过注册的人数 = df['user_id'].count()

        self._result['近150天1度联系人中在QG有过注册的人数']['value'] = _近150天1度联系人中在QG有过注册的人数
        return self._result

class 近150天1度联系人中在QG有过点击申请的订单数():
    """m5_contact_apply_click#orderCnt	近150天1度联系人中在QG有过点击申请的订单数"""
    def feature(self):
        _近150天1度联系人中在QG有过点击申请的订单数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有过点击申请的订单数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userQuotaRecord(str(tuple(user_id)).replace(',)',')'))

                if df_userApply.empty==False:
                    df_userApply = df_userApply.loc[df_userApply['created_at'] < self._apply_at]
                    if df_userApply.empty == False:
                        _近150天1度联系人中在QG有过点击申请的订单数 = df_userApply.loc[df_userApply['created_at'] < self._apply_at]['user_id'].count()
        self._result['近150天1度联系人中在QG有过点击申请的订单数']['value'] = _近150天1度联系人中在QG有过点击申请的订单数
        return self._result

class 近150天1度联系人中在QG有过点击申请的人数():
    """m5_contact_apply_click#userCnt	近150天1度联系人中在QG有过点击申请的人数"""
    def feature(self):
        _近150天1度联系人中在QG有过点击申请的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有过点击申请的人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userQuotaRecord(str(tuple(user_id)).replace(',)',')'))

                if df_userApply.empty == False:
                    df_userApply = df_userApply.loc[df_userApply['created_at'] < self._apply_at]
                    _近150天1度联系人中在QG有过点击申请的人数 = len(list(set(df_userApply['user_id'])))

        self._result['近150天1度联系人中在QG有过点击申请的人数']['value'] = _近150天1度联系人中在QG有过点击申请的人数
        return self._result

class 近150天1度联系人中在QG有过提交申请的订单数():
    """m5_contact_apply_submit#orderCnt	近150天1度联系人中在QG有过提交申请的订单数"""
    def feature(self):
        _近150天1度联系人中在QG有过提交申请的订单数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有过提交申请的订单数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userApplySubmit(str(tuple(user_id)).replace(',)',')'))
                if df_userApply.empty == False:
                    df_userApply = df_userApply.loc[df_userApply['submit_time'] < self._apply_at]
                    _近150天1度联系人中在QG有过提交申请的订单数 =df_userApply['user_id'].count()
        self._result['近150天1度联系人中在QG有过提交申请的订单数']['value'] = _近150天1度联系人中在QG有过提交申请的订单数
        return self._result

class 近150天1度联系人中在QG有过提交申请的人数():
    """m5_contact_apply_submit#userCnt	近150天1度联系人中在QG有过提交申请的人数"""
    def feature(self):
        _近150天1度联系人中在QG有过提交申请的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有过提交申请的人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userApplySubmit(str(tuple(user_id)).replace(',)',')'))
                if df_userApply.empty == False:
                    df_userApply = df_userApply.loc[df_userApply['submit_time'] < self._apply_at]
                    _近150天1度联系人中在QG有过提交申请的人数 = len(list(set(df_userApply['user_id'])))

        self._result['近150天1度联系人中在QG有过提交申请的人数']['value'] = _近150天1度联系人中在QG有过提交申请的人数
        return self._result

class 近150天1度联系人中在QG的首次提交申请人数():
    """m5_contact_apply_submit#firstCnt	近150天1度联系人中在QG的首次提交申请人数"""
    def feature(self):
        _近150天1度联系人中在QG的首次提交申请人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:

            df_user = self.df_user
            _近150天1度联系人中在QG的首次提交申请人数 =0
            if df_user.empty == False:

                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userApplySubmit(str(tuple(user_id)).replace(',)',')'))

                if df_userApply.empty == False:

                    df_userApply = df_userApply.loc[df_userApply['submit_time'] < self._apply_at]

                    if df_userApply.empty == False:
                        _count = 0
                        _json = json.loads(df_userApply['user_id'].value_counts().to_json())
                        for k,v in _json.items():
                            if v == 1:
                              _count += 1
                        _近150天1度联系人中在QG的首次提交申请人数 = _count

        self._result['近150天1度联系人中在QG的首次提交申请人数']['value'] = _近150天1度联系人中在QG的首次提交申请人数
        return self._result

class 近150天1度联系人中在QG的注册到首次提交申请的平均秒数():
    """m5_contact_first_submit_spent_avg    近150天1度联系人中在QG的注册到首次提交申请的平均秒数"""
    def feature(self):
        _近150天1度联系人中在QG的注册到首次提交申请的平均秒数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_userApply = getSql_userApplySubmit(str(tuple(user_id)).replace(',)',')'))

                if df_userApply.empty == False:
                    df_userApply = df_userApply.loc[df_userApply['submit_time'] < self._apply_at]
                    if df_userApply.empty == False:
                        df_userApply_g = df_userApply.groupby(['user_id']).agg({'register_time':'min','submit_time':'min'}).reset_index()
                        df_mer = pd.merge(df_userApply_g,df_user,how='left',on=['user_id'])
                        df_mer['submit_time'] = df_mer['submit_time'].apply(lambda x : time.mktime(x.timetuple()))
                        df_mer['register_time'] = df_mer['register_time'].apply(lambda x : time.mktime(x.timetuple()))
                        df_mer['seconds'] = df_mer['submit_time'] - df_mer['register_time']
                        _近150天1度联系人中在QG的注册到首次提交申请的平均秒数 = round(df_mer['seconds'].mean(),6)

        self._result['近150天1度联系人中在QG的注册到首次提交申请的平均秒数']['value'] = _近150天1度联系人中在QG的注册到首次提交申请的平均秒数
        return self._result

class 近150天1度联系人中在QG有通过的订单数(): #????
    """m5_contact_apply_result#permitOrderCnt	近150天1度联系人中在QG有通过的订单数"""
    def feature(self):
        _近150天1度联系人中在QG有通过的订单数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有通过的订单数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply = getSql_userApplyQuota_QG(str(tuple(user_id)).replace(',)',')'))
                if df_apply.empty == False:
                    df_apply = df_apply.loc[(df_apply['created_at'] < self._apply_at) & (df_apply['apply_status']==2) ]
                    _近150天1度联系人中在QG有通过的订单数 = df_apply['apply_status'].count()

        self._result['近150天1度联系人中在QG有通过的订单数']['value'] = _近150天1度联系人中在QG有通过的订单数
        return self._result

class 近150天1度联系人中在QG有通过的人数():
    """m5_contact_apply_result#permitUserCnt	近150天1度联系人中在QG有通过的人数"""
    def feature(self):
        _近150天1度联系人中在QG有通过的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有通过的人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply = getSql_userApplyQuota_QG(str(tuple(user_id)).replace(',)',')'))
                if df_apply.empty == False:
                    df_apply = df_apply.loc[(df_apply['created_at'] < self._apply_at) & (df_apply['apply_status']==2)]
                    if df_apply.empty == False:
                        _近150天1度联系人中在QG有通过的人数 =  len(list(set(df_apply['user_id'].tolist())))


        self._result['近150天1度联系人中在QG有通过的人数']['value'] = _近150天1度联系人中在QG有通过的人数
        return self._result

class 近150天1度联系人中在QG有过被拒的人数():
    """m5_contact_apply_result#refuseUserCnt	近150天1度联系人中在QG有过被拒的人数"""
    def feature(self):
        _近150天1度联系人中在QG有过被拒的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有过被拒的人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply = getSql_userApplyQuota_QG(str(tuple(user_id)).replace(',)',')'))
                if df_apply.empty == False:
                    df_apply = df_apply.loc[(df_apply['created_at'] < self._apply_at) & (df_apply['apply_status']==1)]
                    if df_apply.empty == False:
                        _近150天1度联系人中在QG有过被拒的人数 = len(list(set(df_apply['user_id'])))

        self._result['近150天1度联系人中在QG有过被拒的人数']['value'] = _近150天1度联系人中在QG有过被拒的人数
        return self._result

class 近150天1度联系人中在QG有申请提现的订单数():
    """m5_contact_withdraw_apply#orderCnt	近150天1度联系人中在QG有申请提现的订单数"""
    def feature(self):
        _近150天1度联系人中在QG有申请提现的订单数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有申请提现的订单数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_loan = getSql_loan_detailQG(str(tuple(user_id)).replace(',)',')'))
                if df_loan.empty == False:
                    df_loan = df_loan.loc[(df_loan['created_at'] < self._apply_at )]
                    df_loan = df_loan.loc[(df_loan.duplicated('loan_id',keep='first')==False)]
                    _近150天1度联系人中在QG有申请提现的订单数 = df_loan['loan_id'].count()

        self._result['近150天1度联系人中在QG有申请提现的订单数']['value'] = _近150天1度联系人中在QG有申请提现的订单数
        return self._result

class 近150天1度联系人中在QG有申请提现的人数():
    """m5_contact_withdraw_apply#userCnt	近150天1度联系人中在QG有申请提现的人数"""
    def feature(self):
        _近150天1度联系人中在QG有申请提现的人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG有申请提现的人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_loan = getSql_loan_detailQG(str(tuple(user_id)).replace(',)',')'))
                df_loan = df_loan.loc[(df_loan['created_at'] < self._apply_at)]

                if df_loan.empty ==False:
                    _近150天1度联系人中在QG有申请提现的人数 = len(set(df_loan['user_id']))

        self._result['近150天1度联系人中在QG有申请提现的人数']['value'] = _近150天1度联系人中在QG有申请提现的人数
        return self._result

class 近150天1度联系人中在QG的通过到申请提现的平均秒数():
    """m5_contact_loan_spent_avg	近150天1度联系人中在QG的通过到申请提现的平均秒数"""
    def feature(self):
        _近150天1度联系人中在QG的通过到申请提现的平均秒数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user

            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_ApplyAndloan(str(tuple(user_id)).replace(',)',')'))
                if df_apply_loan.empty == False:

                    df_apply_loan = df_apply_loan.loc[df_apply_loan['withdraw_apply_time'] < self._apply_at]
                    if df_apply_loan.empty == False:
                        df_apply_loan['withdraw_apply_time_new'] = df_apply_loan['withdraw_apply_time'].apply(lambda x : time.mktime(x.timetuple()))
                        df_apply_loan['permit_time_new'] = df_apply_loan['permit_time'].apply(lambda x : time.mktime(x.timetuple()))
                        df_apply_loan['seconds'] = (df_apply_loan['withdraw_apply_time_new'] - df_apply_loan['permit_time_new'])
                        _近150天1度联系人中在QG的通过到申请提现的平均秒数 = round(df_apply_loan['seconds'].mean(),6)

        self._result['近150天1度联系人中在QG的通过到申请提现的平均秒数']['value'] = _近150天1度联系人中在QG的通过到申请提现的平均秒数
        return self._result

class 近150天1度联系人中在QG的放款订单数():
    """m5_contact_loan_info#orderCnt	近150天1度联系人中在QG的放款订单数"""
    def feature(self):
        _近150天1度联系人中在QG的放款订单数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            # df_user = self.df_user
            df_user = self.df_user
            _近150天1度联系人中在QG的放款订单数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))
                df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self._apply_at]
                _近150天1度联系人中在QG的放款订单数 = df_apply_loan['loan_application_history_id'].count()
        self._result['近150天1度联系人中在QG的放款订单数']['value'] = _近150天1度联系人中在QG的放款订单数
        return self._result

class 近150天1度联系人中在QG的放款人数():
    """m5_contact_loan_info#userCnt	近150天1度联系人中在QG的放款人数"""
    def feature(self):
        _近150天1度联系人中在QG的放款人数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            # df_user = self.df_user
            df_user = self.df_user
            _近150天1度联系人中在QG的放款人数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))
                if df_apply_loan.empty == False:
                    df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self._apply_at]
                    _近150天1度联系人中在QG的放款人数 = len(list(set(df_apply_loan['user_id'])))

        self._result['近150天1度联系人中在QG的放款人数']['value'] = _近150天1度联系人中在QG的放款人数
        return self._result

class 近150天1度联系人中在QG的总放款本金():
    """m5_contact_loan_info#amountSum	近150天1度联系人中在QG的总放款本金"""
    def feature(self):
        _近150天1度联系人中在QG的总放款本金 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG的总放款本金 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))
                if df_apply_loan.empty == False:
                    df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self._apply_at]
                    _近150天1度联系人中在QG的总放款本金 = int(df_apply_loan['contract_loan_amount'].sum())
        self._result['近150天1度联系人中在QG的总放款本金']['value'] = _近150天1度联系人中在QG的总放款本金
        return self._result

class 近150天1度联系人中在QG的总放款分期数():
    """m5_contact_loan_info#termSum	近150天1度联系人中在QG的总放款分期数"""
    def feature(self):
        _近150天1度联系人中在QG的总放款分期数 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user
            _近150天1度联系人中在QG的总放款分期数 = 0
            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))
                if df_apply_loan.empty == False:
                    df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self._apply_at]
                    _近150天1度联系人中在QG的总放款分期数 = int(df_apply_loan['contract_term'].sum())

        self._result['近150天1度联系人中在QG的总放款分期数']['value'] = _近150天1度联系人中在QG的总放款分期数
        return self._result


class 近150天1度联系人中在QG的件均月利率():
    """m5_contact_loan_info#monthInterestAvg	近150天1度联系人中在QG的件均月利率"""
    def feature(self):
        _近150天1度联系人中在QG的件均月利率 = -9999999
        if self._df_telephone.empty == False and self._contacts_phone:
            df_user = self.df_user

            if df_user.empty == False:
                user_id = df_user['user_id'].tolist()
                df_apply_loan = getSql_loan(str(tuple(user_id)).replace(',)',')'))

                if df_apply_loan.empty == False:
                    df_apply_loan = df_apply_loan.loc[df_apply_loan['created_at'] < self._apply_at]
                    if df_apply_loan.empty == False:
                        _近150天1度联系人中在QG的件均月利率 = round(df_apply_loan['monthly_interest_rate'].mean(),6)
        self._result['近150天1度联系人中在QG的件均月利率']['value'] = _近150天1度联系人中在QG的件均月利率
        return self._result

class 近150天1度联系人中的最早最近通话间隔天数():
    """degree_one_call_record_interval#days_between_earliest_and_latest_call 近150天1度联系人中的最早最近通话间隔天数"""
    def feature(self):
        _近150天1度联系人中的最早最近通话间隔天数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            pd.to_datetime(df_telephone['cTime'])
            df_telephone['cTime'] = df_telephone['cTime'].apply(lambda x:time.mktime(datetime.datetime.strptime(x,'%Y-%m-%d %H:%M:%S').timetuple()))
            near_day = df_telephone['cTime'].max()
            last_day = df_telephone['cTime'].min()

            _近150天1度联系人中的最早最近通话间隔天数 = round((near_day - last_day)/86400,6)
        self._result['近150天1度联系人中的最早最近通话间隔天数']['value'] = _近150天1度联系人中的最早最近通话间隔天数
        return self._result


class 近150天1度联系人中通话次数top3的号均通话次数():
    """degree_one_call_contact#call_top3_cnt_per_number	近150天1度联系人中通话次数top3的号均通话次数"""
    def feature(self):
        _近150天1度联系人中通话次数top3的号均通话次数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':g,
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            _近150天1度联系人中通话次数top3的号均通话次数 = round(df_call_record[:3]['count'].mean(),6)
        self._result['近150天1度联系人中通话次数top3的号均通话次数']['value'] = _近150天1度联系人中通话次数top3的号均通话次数
        return self._result

class 近150天1度联系人中通话次数top3的号均通话秒数():
    """degree_one_call_contact#call_top3_long_per_number	近150天1度联系人中通话次数top3的号均通话秒数"""
    def feature(self):
        _近150天1度联系人中通话次数top3的号均通话秒数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            _近150天1度联系人中通话次数top3的号均通话秒数 = round(df_call_record[:3]['tradeTime'].mean(),6)
        self._result['近150天1度联系人中通话次数top3的号均通话秒数']['value'] = _近150天1度联系人中通话次数top3的号均通话秒数
        return self._result

class 近150天1度联系人中通话次数top5的号均通话次数():
    """degree_one_call_contact#call_top5_cnt_per_number     近150天1度联系人中通话次数top5的号均通话次数"""
    def feature(self):
        _近150天1度联系人中通话次数top5的号均通话次数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            _近150天1度联系人中通话次数top5的号均通话次数 = round(df_call_record[:5]['count'].mean(),6)
        self._result['近150天1度联系人中通话次数top5的号均通话次数']['value'] = _近150天1度联系人中通话次数top5的号均通话次数
        return self._result

class 近150天1度联系人中通话次数top5的号均通话秒数():
    """degree_one_call_contact#call_top5_long_per_number	近150天1度联系人中通话次数top5的号均通话秒数"""
    def feature(self):
        _近150天1度联系人中通话次数top5的号均通话秒数 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            _近150天1度联系人中通话次数top5的号均通话秒数 = round(df_call_record[:5]['tradeTime'].mean(),6)
        self._result['近150天1度联系人中通话次数top5的号均通话秒数']['value'] = _近150天1度联系人中通话次数top5的号均通话秒数
        return self._result

class 近150天1度联系人中的异地的通话次数():
    """degree_one_call_contact#call_remote_cnt	近150天1度联系人中的异地的通话次数"""
    def feature(self):
        _近150天1度联系人中的异地的通话次数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))
                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==2)]
                _近150天1度联系人中的异地的通话次数 = df_telephone['receiverPhone'].count()
        self._result['近150天1度联系人中的异地的通话次数']['value'] = _近150天1度联系人中的异地的通话次数
        return self._result

class 近150天1度联系人中的异地的通话号码个数():
    """degree_one_call_contact#call_remote_numbers_cnt	近150天1度联系人中的异地的通话号码个数"""
    def feature(self):
        _近150天1度联系人中的异地的通话号码个数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))
                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==2)]
                _近150天1度联系人中的异地的通话号码个数 = 0
                if df_telephone.empty == False:
                    _近150天1度联系人中的异地的通话号码个数 = len(list(set(df_telephone['receiverPhone'])))
        self._result['近150天1度联系人中的异地的通话号码个数']['value'] = _近150天1度联系人中的异地的通话号码个数
        return self._result

class 近150天1度联系人中的异地的通话秒数():
    """degree_one_call_contact#call_remote_long	近150天1度联系人中的异地的通话秒数"""
    def feature(self):
        _近150天1度联系人中的异地的通话秒数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            if df_telephone.empty == False:
                df_telephone['tradeTime'] = df_telephone['tradeTime'].astype(int)
                tradeAddr = get_lkb_user_phone_location(self.uuid)
                tradeAddr = getTradeAdd(tradeAddr)
                df_telephone['tradeAddr_new'] = df_telephone['tradeAddr'].apply(lambda x : getCityisLocal(tradeAddr,x))
                df_telephone = df_telephone.loc[(df_telephone['tradeAddr_new']==2)]
                _近150天1度联系人中的异地的通话秒数 = 0
                if df_telephone.empty == False:
                    _近150天1度联系人中的异地的通话秒数 = df_telephone['tradeTime'].sum()
        self._result['近150天1度联系人中的异地的通话秒数']['value'] = _近150天1度联系人中的异地的通话秒数
        return self._result


class 前十联系人中的最短通话间隔():
    """m5_user_contact_info#minTop10CallDiffDays	前十联系人中的最短通话间隔"""
    def feature(self):
        _前十联系人中的最短通话间隔 = -9999999
        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            call_record = []
            for g ,value in df_g:
                df = pd.DataFrame(value)

                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'cTime_max':df['cTime'].max(),
                                    'cTime_min':df['cTime'].min(),
                                    'cTime_diff':(datetime.datetime.strptime(df['cTime'].max(),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(df['cTime'].min(),'%Y-%m-%d %H:%M:%S')).days
                                    })
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:10]

            _前十联系人中的最短通话间隔 = int(df_call_record['cTime_diff'].min())

        self._result['前十联系人中的最短通话间隔']['value'] =_前十联系人中的最短通话间隔
        return self._result


class 第三联系人通话次数():
    """m5_user_contact_info#thirdContactCallNums	第三联系人通话次数"""
    def feature(self):
        _第三联系人通话次数 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            call_record = []
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum()})
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(by=['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[2:3]
            if df_call_record.empty == False:
                _第三联系人通话次数 = df_call_record['count'].sum()
        self._result['第三联系人通话次数']['value'] =_第三联系人通话次数
        return self._result

class 手机号中通话间隔超过60天的号码个数占比():
    """m5_user_contact_info#callDiffDaysGt60dRatio	手机号中通话间隔超过60天的号码个数占比"""
    def feature(self):
        _手机号中通话间隔超过60天的号码个数占比 = -9999999

        df_telephone = self._df_telephone
        if df_telephone.empty == False:
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            call_record = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':g,
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'cTime_max':df['cTime'].max(),
                                    'cTime_min':df['cTime'].min(),
                                    'cTime_diff':(datetime.datetime.strptime(df['cTime'].max(),'%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(df['cTime'].min(),'%Y-%m-%d %H:%M:%S')).days
                                    })

            df_call_record = pd.DataFrame(call_record)
            receiverPhone_cnt = len(list(set(df_telephone['receiverPhone'])))
            receiverPhone_60 = len(list(set(df_call_record.loc[df_call_record['cTime_diff']>60]['receiverPhone'])))
            if receiverPhone_60 == 0:
                _手机号中通话间隔超过60天的号码个数占比 = 0
            else:
                _手机号中通话间隔超过60天的号码个数占比 = round(receiverPhone_60/receiverPhone_cnt,6)
        self._result['手机号中通话间隔超过60天的号码个数占比']['value'] =_手机号中通话间隔超过60天的号码个数占比
        return self._result

class 第五联系人的主叫次数():
    """m5_user_contact_info#fifthContactZjCallNums	第五联系人的主叫次数"""
    def feature(self):
        _第五联系人的主叫次数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            df_telephone['tradeWay'].fillna("其他", inplace=True)
            # df_telephone = df_telephone.dropna(subset=["tradeWay"])
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            call_record = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df.loc[df.tradeWay.str.contains('主'), 'trade_new'] = 1
                df.loc[df.tradeWay.str.contains('被'), 'trade_new'] = 2

                if len(df)<=1:
                    interval_day = [0]
                else:
                    interval_day = get_interval_day(df['cTime'].tolist())
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    'interval_day':max(interval_day),
                                    'trade_caller':df.loc[df['trade_new'] == 1]['trade_new'].count(), #主叫次数
                                    'trade_called':df.loc[df['trade_new'] == 2]['trade_new'].count() # 被叫次数
                })

            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[4:5]
            if df_call_record.empty == False:
                _第五联系人的主叫次数 = df_call_record['trade_caller'].values[0]
        self._result['第五联系人的主叫次数']['value'] =_第五联系人的主叫次数
        return self._result


class 第五联系人的通话次数():
    """m5_user_contact_info#fifthContactCallNums	第五联系人的通话次数"""
    def feature(self):
        _第五联系人的通话次数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            call_record = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    })
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[4:5]
            if df_call_record.empty == False:
                _第五联系人的通话次数 = df_call_record['count'].values[0]
        self._result['第五联系人的通话次数']['value'] =_第五联系人的通话次数
        return self._result

class 通话次数Top30在QG的注册人数():
    """m5_user_contact_info#top30RegisterUserCount	通话次数Top30在QG的注册人数"""
    def feature(self):
        _通话次数Top30在QG的注册人数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            df_telephone = df_telephone.dropna(subset=['tradeTime'])
            df_g = df_telephone.groupby(['receiverPhone'])
            call_record = []
            for g ,value in df_g:
                df = pd.DataFrame(value)
                df['tradeTime'] = df['tradeTime'].astype(int)
                call_record.append({'receiverPhone':df['receiverPhone'].values[0],
                                    'count':df['phone'].count(),
                                    'tradeTime':df['tradeTime'].sum(),
                                    })
            df_call_record = pd.DataFrame(call_record)
            df_call_record.sort_values(['count','tradeTime'],ascending=False,inplace=True)
            df_call_record = df_call_record.iloc[:30]
            _通话次数Top30在QG的注册人数 = 0
            if df_call_record.empty == False:
                phone = get_PhoneNo(df_call_record.iloc[:30]['receiverPhone'].tolist())
                if len(phone) > 0:
                    df_user = getSql_phoneForUserId(str(tuple(get_PhoneNo(df_call_record.iloc[:30]['receiverPhone'].tolist()))).replace(',)',')'))
                    df_user = df_user.loc[df_user['created_at'] < self._apply_at]
                    if df_user.empty == False:
                        _通话次数Top30在QG的注册人数 = df_user['user_id'].count()
        self._result['通话次数Top30在QG的注册人数']['value'] =_通话次数Top30在QG的注册人数
        return self._result

class 通话超过150分钟的通话次数():
    """m5_user_contact_info#tradetimeGt150MinsCount	通话超过150分钟的通话次数"""
    def feature(self):
        _通话超过150分钟的通话次数 = -9999999
        if self._df_telephone.empty == False:
            df_telephone = self._df_telephone
            df_telephone['tradeTime'] = df_telephone['tradeTime'].astype(int)
            _df = df_telephone.loc[df_telephone['tradeTime'] > 150*60]
            _通话超过150分钟的通话次数 = 0
            if _df.empty==False:
                _通话超过150分钟的通话次数 = _df['receiverPhone'].count()
        self._result['通话超过150分钟的通话次数']['value'] =_通话超过150分钟的通话次数
        return self._result

