# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service.Sql_contactsOperator import *
import datetime
import json
import time
from service.Sql_contactsOperator import *
import datetime
import math
from service.Sql_contactsOperator import *
from features.Base_Features import BaseFeatures as BF

class __INIT__(BF):
    """紧急联系人运营商特征"""
    def __init__(self):
        # BF.apply_time = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF.apply_time = datetime.datetime.strptime('2019-09-19 14:00:00','%Y-%m-%d %H:%M:%S')
        if self.orderId :
            _df = getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF.apply_time = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')
        BF.user_phone = getSql_userPhone(str(tuple([self.user_id])).replace(',)',')'))['phone_no'].tolist()

        BF.df_userContactsAll = get_userContacts(str(tuple(self.user_phone)).replace(',)',')'))

        # BF.df_userOneContactsAll = pd.DataFrame() # 一度联系人
        BF.df_userTwoContacts = pd.DataFrame() # 二度联系人
        BF.receiverPhone = None

        #一度联系人
        BF.df_userOneContacts30 = pd.DataFrame()
        BF.df_userOneContacts90 = pd.DataFrame()
        BF.df_userOneContacts150 = pd.DataFrame()
        BF.df_userOneContacts180 = pd.DataFrame()
        BF.df_userOneContacts300 = pd.DataFrame()

        # 一度联系人注册用户
        BF.df_userOneContactsRegister180 = pd.DataFrame()
        BF.df_userOneContactsRegister300 = pd.DataFrame()

        # 一度联系人手机号列表
        BF.receiverPhone30 = None
        BF.receiverPhone90 = None
        BF.receiverPhone150 = None
        BF.receiverPhone180 = None
        BF.receiverPhone300 = None

        # 二度联系人
        BF.df_userTwoContacts30 = pd.DataFrame()
        BF.df_userTwoContacts90 = pd.DataFrame()
        BF.df_userTwoContacts150 = pd.DataFrame()
        BF.df_userTwoContacts180 = pd.DataFrame()
        BF.df_userTwoContacts300 = pd.DataFrame()

def get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(df_userContactsAll,
                                                   df_userOneContacts,
                                                   df_userOneContactsRegister,
                                                   df_userTwoContacts,
                                                   receiverPhone,
                                                   user_phone,apply_time,timesTampFDays = None,applyTimeFDays=None,ContactsNum = 2):
    """
        描述 : 近N天1度联系人在近N天内
        params: df_userContactsAll 所有联系人,在初始化文件中进行获取,
        df_userOneContacts 一度联系人 默认传入一个空的DataFrame,
        df_userTwoContacts 二度联系人 默认传入一个空的DataFrame,
        receiverPhone 一度联系人手机号,默认传入 None,
        apply_time 申请时间
        user_phone 当前用户手机号
        timesTampFDays 授权时间往前推多少天
        applyTimeFDays 申请时间往前推多少天
        ContactsNum 1 一度联系人,2 二度联系人
    """

    if df_userContactsAll.empty == False:
        if df_userOneContacts.columns.empty:
            df_userOneContacts = get_userContactsFilter(1,df_userContactsAll,apply_time,timesTampFDays = timesTampFDays,applyTimeFDays=applyTimeFDays,userPhone = user_phone)

            # 测试代码后期注释
            df_userOneContacts = df_userOneContacts.loc[(df_userOneContacts['timestamp'] >= datetime.datetime.strptime('2019-01-01 00:00:00','%Y-%m-%d %H:%M:%S'))
                                                        & (df_userOneContacts['timestamp'] < datetime.datetime.strptime('2019-06-28 00:00:00','%Y-%m-%d %H:%M:%S'))]

            if receiverPhone==None:
                receiverPhone_temp = get_PhoneNo(df_userOneContacts['receiverPhone'])
                if receiverPhone_temp:
                    receiverPhone = str(tuple(set(receiverPhone_temp))).replace(',)',')') if receiverPhone_temp else [] # 匹配手机号
                    df_userOneContactsRegister = getSql_phoneForUserId(receiverPhone) #获取一度联系人的在册用户
                    df_userOneContactsRegister.drop_duplicates(keep='first',inplace=True)
                    # 测试代码后期注释
                    df_userOneContactsRegister = df_userOneContactsRegister.loc[df_userOneContactsRegister['created_at'] < '2019-07-25 00:00:00']


        if ContactsNum == 2: # 获取二度联系人
            if df_userOneContactsRegister.empty == False:
                if df_userTwoContacts.columns.empty:
                    df_userTwoContacts = get_userContacts(str(tuple(df_userOneContactsRegister['phone_no'])).replace(',)',')')) # 获取二度联系人
                    # 测试代码后期注释
                    df_userTwoContacts.loc[(df_userTwoContacts['timestamp'] >= datetime.datetime.strptime('2019-01-01 00:00:00','%Y-%m-%d %H:%M:%S'))
                                           & (df_userTwoContacts['timestamp'] < datetime.datetime.strptime('2019-06-28 00:00:00','%Y-%m-%d %H:%M:%S'))]
    return df_userOneContacts,df_userOneContactsRegister,receiverPhone,df_userTwoContacts

class 获取一度联系人总数():
    """测试使用"""
    def feature(self):
        _获取一度联系人总数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,\
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                self.df_userOneContacts300,
                                                                                self.df_userOneContactsRegister300,
                                                                                self.df_userTwoContacts300,
                                                                                self.receiverPhone300,
                                                                                self.user_phone,
                                                                                self.apply_time,
                                                                                timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                )
        if self.df_userOneContacts300.empty == False:
            _获取一度联系人总数 = len(set(self.df_userOneContacts300['receiverPhone'].tolist()))
        self._result['获取一度联系人总数']['value'] = _获取一度联系人总数
        return self._result

class 获取一度联系人在册用户数():
    """测试使用"""
    def feature(self):
        _获取一度联系人在册用户数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300, \
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )
        if self.df_userOneContactsRegister300.empty == False:
            _获取一度联系人在册用户数 = len(set(self.df_userOneContactsRegister300['user_id']))
        self._result['获取一度联系人在册用户数']['value'] = _获取一度联系人在册用户数
        return self._result

class 获取一度联系人通话总次数():
    """测试使用"""
    def feature(self):
        _获取一度联系人通话总次数 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300, \
        self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )
        if self.df_userOneContacts300.empty == False:
            _获取一度联系人通话总次数 = len(self.df_userOneContacts300)
        self._result['获取一度联系人通话总次数']['value'] = _获取一度联系人通话总次数
        return self._result

class 近150天1度联系人在近180天内最后一次授权运营商的最大手机余额():
    """v8_last150_180_MaxPhonebalance	近150天1度联系人在近180天内最后一次授权运营商的最大手机余额"""

    def feature(self):
        _近150天1度联系人在近180天内最后一次授权运营商的最大手机余额 = -9999999

        self.df_userOneContacts180,self.df_userOneContactsRegister180,self.receiverPhone180,self.df_userTwoContacts180 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts180,
                                                                                                          self.df_userOneContactsRegister180,
                                                                                                          self.df_userTwoContacts180,
                                                                                                          self.receiverPhone180,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 180,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone180

        if df_telephone != '' and str(df_telephone) != 'None':
            df_apply_balancenetworkPhone = getSql_balancenetworkPhone(df_telephone.replace('"',''))
            df_apply_balancenetworkPhone = df_apply_balancenetworkPhone.dropna(subset=['phoneRemain'])
            if df_apply_balancenetworkPhone.empty == False:
                df_index= df_apply_balancenetworkPhone.reset_index().groupby(['phone'])['updated_at'].idxmax()
                _近150天1度联系人在近180天内最后一次授权运营商的最大手机余额 =df_apply_balancenetworkPhone.iloc[df_index]['phoneRemain'].astype('float').max()
        self._result['近150天1度联系人在近180天内最后一次授权运营商的最大手机余额']['value'] = _近150天1度联系人在近180天内最后一次授权运营商的最大手机余额
        return self._result

class 近150天1度联系人在近180天内最后一次授权运营商的最小手机余额():
    """v8_last150_180_MinPhonebalance"""

    def feature(self):
        _近150天1度联系人在近180天内最后一次授权运营商的最小手机余额 = -9999999

        self.df_userOneContacts180,self.df_userOneContactsRegister180,self.receiverPhone180,self.df_userTwoContacts180 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts180,
                                                                                                          self.df_userOneContactsRegister180,
                                                                                                          self.df_userTwoContacts180,
                                                                                                          self.receiverPhone180,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 180,ContactsNum=1
                                                                                                          )

        df_telephone = self.receiverPhone180

        if df_telephone != '' and str(df_telephone) != 'None':
            df_apply_balancenetworkPhone = getSql_balancenetworkPhone(df_telephone.replace('"',''))
            df_apply_balancenetworkPhone =df_apply_balancenetworkPhone.dropna(subset=['phoneRemain'])
            if df_apply_balancenetworkPhone.empty == False:
                df_index= df_apply_balancenetworkPhone.reset_index().groupby(['phone'])['updated_at'].idxmax()
                _近150天1度联系人在近180天内最后一次授权运营商的最小手机余额 =df_apply_balancenetworkPhone.iloc[df_index]['phoneRemain'].astype('float').min()
        self._result['近150天1度联系人在近180天内最后一次授权运营商的最小手机余额']['value'] = _近150天1度联系人在近180天内最后一次授权运营商的最小手机余额
        return self._result

class 近150天1度联系人在近180天内最后一次授权运营商的平均手机余额():
    """v8_last150_180_agvPhonebalance"""
    def feature(self):
        _近150天1度联系人在近180天内最后一次授权运营商的平均手机余额 = -9999999
        self.df_userOneContacts180,self.df_userOneContactsRegister180,self.receiverPhone180,self.df_userTwoContacts180 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts180,
                                                                                                          self.df_userOneContactsRegister180,
                                                                                                          self.df_userTwoContacts180,
                                                                                                          self.receiverPhone180,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 180,ContactsNum=1
                                                                                                          )

        df_telephone = self.receiverPhone180

        if df_telephone != '' and str(df_telephone) != 'None':
            df_apply_balancenetworkPhone = getSql_balancenetworkPhone(df_telephone.replace('"',''))
            df_apply_balancenetworkPhone = df_apply_balancenetworkPhone.dropna(subset=['phoneRemain'])
            if df_apply_balancenetworkPhone.empty == False:
                df_index= df_apply_balancenetworkPhone.reset_index().groupby(['phone'])['updated_at'].idxmax()
                _近150天1度联系人在近180天内最后一次授权运营商的平均手机余额 =round(df_apply_balancenetworkPhone.iloc[df_index]['phoneRemain'].astype('float').mean(), 6)
        self._result['近150天1度联系人在近180天内最后一次授权运营商的平均手机余额']['value'] = _近150天1度联系人在近180天内最后一次授权运营商的平均手机余额
        return self._result

class 近150天1度联系人在近180天内最后一次授权运营商的总手机余额():
    """v8_last150_180_sumPhonebalance"""

    def feature(self):
        _近150天1度联系人在近180天内最后一次授权运营商的总手机余额 = -9999999

        self.df_userOneContacts180,self.df_userOneContactsRegister180,self.receiverPhone180,self.df_userTwoContacts180 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts180,
                                                                                                          self.df_userOneContactsRegister180,
                                                                                                          self.df_userTwoContacts180,
                                                                                                          self.receiverPhone180,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 180,ContactsNum=1
                                                                                                          )
        df_telephone = self.receiverPhone180

        if df_telephone != '' and str(df_telephone) != 'None':
            df_apply_balancenetworkPhone = getSql_balancenetworkPhone(df_telephone.replace('"',''))
            df_apply_balancenetworkPhone = df_apply_balancenetworkPhone.dropna(subset=['phoneRemain'])
            if df_apply_balancenetworkPhone.empty == False:
                df_index= df_apply_balancenetworkPhone.reset_index().groupby(['phone'])['updated_at'].idxmax()
                _近150天1度联系人在近180天内最后一次授权运营商的总手机余额=df_apply_balancenetworkPhone.iloc[df_index]['phoneRemain'].astype('float').sum()
        self._result['近150天1度联系人在近180天内最后一次授权运营商的总手机余额']['value'] = _近150天1度联系人在近180天内最后一次授权运营商的总手机余额
        return self._result

class 近150天1度联系人在近180天内最后一次授权运营商的最大入网天数():
    def feature(self):
        _近150天1度联系人在近180天内最后一次授权运营商的最大入网天数 = -9999999
        self.df_userOneContacts180,self.df_userOneContactsRegister180,self.receiverPhone180,self.df_userTwoContacts180 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts180,
                                                                                                          self.df_userOneContactsRegister180,
                                                                                                          self.df_userTwoContacts180,
                                                                                                          self.receiverPhone180,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 180,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone180

        if df_telephone != '' and str(df_telephone) != 'None':
            df_apply_balancenetworkPhone = getSql_balancenetworkPhone(df_telephone.replace('"',''))
            df_apply_balancenetworkPhone=  df_apply_balancenetworkPhone.dropna(subset=['registerDate'])
            if df_apply_balancenetworkPhone.empty == False:
                df_index= df_apply_balancenetworkPhone.reset_index().groupby(['phone'])['updated_at'].idxmax()
                data_=pd.to_datetime(df_apply_balancenetworkPhone.iloc[df_index]['registerDate']).min()
                _近150天1度联系人在近180天内最后一次授权运营商的最大入网天数 = (datetime.datetime.now().date() - data_.date()).days
        self._result['近150天1度联系人在近180天内最后一次授权运营商的最大入网天数']['value'] = _近150天1度联系人在近180天内最后一次授权运营商的最大入网天数
        return self._result

class 近150天1度联系人在近180天内最后一次授权运营商的最小入网天数():
    """v8_last150_180_MinPhonenetwork"""

    def feature(self):
        _近150天1度联系人在近180天内最后一次授权运营商的最小入网天数 = -9999999
        self.df_userOneContacts180,self.df_userOneContactsRegister180,self.receiverPhone180,self.df_userTwoContacts180= get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts180,
                                                                                                          self.df_userOneContactsRegister180,
                                                                                                          self.df_userTwoContacts180,
                                                                                                          self.receiverPhone180,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 180,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone180

        if df_telephone != '' and str(df_telephone) != 'None':
            df_apply_balancenetworkPhone = getSql_balancenetworkPhone(df_telephone.replace('"', ''))
            df_apply_balancenetworkPhone = df_apply_balancenetworkPhone.dropna(subset=['registerDate'])
            if df_apply_balancenetworkPhone.empty == False:
                df_index= df_apply_balancenetworkPhone.reset_index().groupby(['phone'])['updated_at'].idxmax()
                data_=pd.to_datetime(df_apply_balancenetworkPhone.iloc[df_index]['registerDate']).max()

                _近150天1度联系人在近180天内最后一次授权运营商的最小入网天数 = (datetime.datetime.now().date() - data_.date()).days


        self._result['近150天1度联系人在近180天内最后一次授权运营商的最小入网天数']['value'] = _近150天1度联系人在近180天内最后一次授权运营商的最小入网天数
        return self._result

class 近150天1度联系人在近180天内最后一次授权运营商的平均入网天数():
    """v8_last150_180_avgPhonenetwork"""

    def feature(self):
        _近150天1度联系人在近180天内最后一次授权运营商的平均入网天数 = -9999999
        self.df_userOneContacts180,self.df_userOneContactsRegister180,self.receiverPhone180,self.df_userTwoContacts180 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts180,
                                                                                                          self.df_userOneContactsRegister180,
                                                                                                          self.df_userTwoContacts180,
                                                                                                          self.receiverPhone180,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 180,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone180

        if df_telephone != '' and str(df_telephone) != 'None':
            df_apply_balancenetworkPhone = getSql_balancenetworkPhone(df_telephone.replace('"', ''))
            df_apply_balancenetworkPhone = df_apply_balancenetworkPhone.dropna(subset=['registerDate'])

            if df_apply_balancenetworkPhone.empty == False:
                df_index= df_apply_balancenetworkPhone.reset_index().groupby(['phone'])['updated_at'].idxmax()
                time_list=pd.to_datetime(df_apply_balancenetworkPhone.iloc[df_index]['registerDate']).tolist()
                if time_list !=[]:
                    datasum = 0.0
                    data_now = datetime.datetime.now().date()
                    for i in time_list:
                        data = (data_now -i.date()).days
                        if math.isnan(data):
                            data =0.0
                        datasum = datasum + data
                    if datasum !=0.0:
                        _近150天1度联系人在近180天内最后一次授权运营商的平均入网天数 = round( datasum / len(time_list), 6)

                    else:
                        _近150天1度联系人在近180天内最后一次授权运营商的平均入网天数 =0

        self._result['近150天1度联系人在近180天内最后一次授权运营商的平均入网天数']['value'] = _近150天1度联系人在近180天内最后一次授权运营商的平均入网天数
        return self._result

class 近150天1度联系人在近180天内最后一次授权运营商的总入网天数():
    def feature(self):
        _近150天1度联系人在近180天内最后一次授权运营商的总入网天数 = -9999999

        self.df_userOneContacts180,self.df_userOneContactsRegister180,self.receiverPhone180,self.df_userTwoContacts180 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts180,
                                                                                                          self.df_userOneContactsRegister180,
                                                                                                          self.df_userTwoContacts180,
                                                                                                          self.receiverPhone180,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 180,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone180

        if df_telephone != '' and str(df_telephone) != 'None':
            df_apply_balancenetworkPhone = getSql_balancenetworkPhone(df_telephone.replace('"', ''))
            df_apply_balancenetworkPhone = df_apply_balancenetworkPhone.dropna(subset=['registerDate'])
            if df_apply_balancenetworkPhone.empty == False:
                df_index = df_apply_balancenetworkPhone.reset_index().groupby(['phone'])['updated_at'].idxmax()
                time_list = pd.to_datetime(df_apply_balancenetworkPhone.iloc[df_index]['registerDate']).tolist()

                datasum = 0.0
                data_now = datetime.datetime.now().date()
                for i in time_list:
                    data = (data_now -i.date()).days
                    if math.isnan(data):
                        data =0.0
                    datasum = datasum + data
                _近150天1度联系人在近180天内最后一次授权运营商的总入网天数 = datasum
        self._result['近150天1度联系人在近180天内最后一次授权运营商的总入网天数']['value'] = _近150天1度联系人在近180天内最后一次授权运营商的总入网天数
        return self._result

class 近150天1度联系人在近300天内的最大应缴话费():
    def feature(self):
        _近150天1度联系人在近300天内的最大应缴话费 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone300
        ApplyTime = self.apply_time
        IntervalDay = 300

        date_tuple = tuple(get_billDay_list(ApplyTime, IntervalDay))
        if df_telephone !='' and date_tuple != () and str(df_telephone) != 'None':
            _df = getSql_PayablebillPhone(df_telephone.replace('"', ''), date_tuple)
            _df = _df.dropna(subset=['amount'])
            if _df.empty ==  False:
                _近150天1度联系人在近300天内的最大应缴话费=_df['amount'].astype('float').max()

        self._result['近150天1度联系人在近300天内的最大应缴话费']['value'] = _近150天1度联系人在近300天内的最大应缴话费
        return self._result

class 近150天1度联系人在近300天内的最小应缴话费():
    def feature(self):
        _近150天1度联系人在近300天内的最小应缴话费 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone300
        ApplyTime = self.apply_time
        IntervalDay = 300

        date_tuple = tuple(get_billDay_list(ApplyTime, IntervalDay))

        if df_telephone !='' and date_tuple != () and str(df_telephone) != 'None':
            _df = getSql_PayablebillPhone(df_telephone.replace('"', ''), date_tuple)
            _df = _df.dropna(subset=['amount'])
            if _df.empty ==  False:
                _近150天1度联系人在近300天内的最小应缴话费=_df['amount'].astype('float').min()

        self._result['近150天1度联系人在近300天内的最小应缴话费']['value'] = _近150天1度联系人在近300天内的最小应缴话费
        return self._result

class 近150天1度联系人在近300天内的平均应缴话费():
    def feature(self):
        _近150天1度联系人在近300天内的平均应缴话费 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone300
        ApplyTime = self.apply_time
        IntervalDay = 300

        date_tuple = tuple(get_billDay_list(ApplyTime, IntervalDay))
        if df_telephone !='' and date_tuple != () and str(df_telephone) != 'None':
            _df = getSql_PayablebillPhone(df_telephone.replace('"', ''), date_tuple)
            _df = _df.dropna(subset=['amount'])
            if _df.empty ==  False:
                _近150天1度联系人在近300天内的平均应缴话费=round(_df['amount'].astype('float').mean(),6)

        self._result['近150天1度联系人在近300天内的平均应缴话费']['value'] = _近150天1度联系人在近300天内的平均应缴话费
        return self._result

class 近150天1度联系人在近300天内的总应缴话费():
    def feature(self):
        _近150天1度联系人在近300天内的总应缴话费 = -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone300
        ApplyTime = self.apply_time
        IntervalDay = 300

        date_tuple = tuple(get_billDay_list(ApplyTime, IntervalDay))
        if df_telephone !='' and date_tuple != () and str(df_telephone) != 'None':
            _df = getSql_PayablebillPhone(df_telephone.replace('"', ''), date_tuple)
            _df = _df.dropna(subset=['amount'])
            if _df.empty ==  False:
                _近150天1度联系人在近300天内的总应缴话费=_df['amount'].astype('float').sum()

        self._result['近150天1度联系人在近300天内的总应缴话费']['value'] = _近150天1度联系人在近300天内的总应缴话费
        return self._result

class 近150天1度联系人在近300天内的最大实缴话费():
    def feature(self):
        _近150天1度联系人在近300天内的最大实缴话费= -9999999

        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone300
        ApplyTime = self.apply_time
        start_ = ApplyTime - datetime.timedelta(days=300)

        if df_telephone !='' and str(df_telephone) != 'None':
            _df = getSql_PaybillPhone(df_telephone.replace('"', ''), start_, ApplyTime)
            _df = _df.dropna(subset=['payamount'])
            if _df.empty ==  False:
                _近150天1度联系人在近300天内的最大实缴话费=_df['payamount'].astype('float').max()
        self._result['近150天1度联系人在近300天内的最大实缴话费']['value'] = _近150天1度联系人在近300天内的最大实缴话费
        return self._result

class 近150天1度联系人在近300天内的最小实缴话费():
    """user_m5_bill_info#billMin    近5个月账单的最小月应缴话费"""
    # 近150天1度联系人在近300天内的最小实缴话费
    def feature(self):
        _近150天1度联系人在近300天内的最小实缴话费= -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )


        df_telephone = self.receiverPhone300
        ApplyTime = self.apply_time
        start_ = ApplyTime - datetime.timedelta(days=300)

        if df_telephone !='' and str(df_telephone) != 'None':
            _df = getSql_PaybillPhone(df_telephone.replace('"', ''), start_, ApplyTime)
            _df = _df.dropna(subset=['payamount'])
            if _df.empty ==  False:
                _近150天1度联系人在近300天内的最小实缴话费=_df['payamount'].astype('float').min()
        self._result['近150天1度联系人在近300天内的最小实缴话费']['value'] = _近150天1度联系人在近300天内的最小实缴话费
        return self._result

class 近150天1度联系人在近300天内的平均实缴话费():
    # 近150天1度联系人在近300天内的最小实缴话费
    def feature(self):
        _近150天1度联系人在近300天内的平均实缴话费= -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )

        df_telephone = self.receiverPhone300
        ApplyTime = self.apply_time
        start_ = ApplyTime - datetime.timedelta(days=300)

        if df_telephone !='' and str(df_telephone) != 'None':
            _df = getSql_PaybillPhone(df_telephone.replace('"', ''), start_, ApplyTime)
            _df = _df.dropna(subset=['payamount'])
            if _df.empty ==  False:
                _近150天1度联系人在近300天内的平均实缴话费=_df['payamount'].astype('float').mean()
        self._result['近150天1度联系人在近300天内的平均实缴话费']['value'] = _近150天1度联系人在近300天内的平均实缴话费
        return self._result

class 近150天1度联系人在近300天内的总实缴话费():
    def feature(self):
        _近150天1度联系人在近300天内的总实缴话费= -9999999
        self.df_userOneContacts300,self.df_userOneContactsRegister300,self.receiverPhone300,self.df_userTwoContacts300 = get_Contacts_TimesTampDaysN_and_ApplyTimeDaysN(self.df_userContactsAll,
                                                                                                          self.df_userOneContacts300,
                                                                                                          self.df_userOneContactsRegister300,
                                                                                                          self.df_userTwoContacts300,
                                                                                                          self.receiverPhone300,
                                                                                                          self.user_phone,
                                                                                                          self.apply_time,
                                                                                                          timesTampFDays = 150,applyTimeFDays = 300,ContactsNum=1
                                                                                                          )
        df_telephone = self.receiverPhone300
        ApplyTime = self.apply_time
        start_ = ApplyTime - datetime.timedelta(days=300)

        if df_telephone !='' and str(df_telephone) != 'None':
            _df = getSql_PaybillPhone(df_telephone.replace('"', ''), start_, ApplyTime)
            _df = _df.dropna(subset=['payamount'])
            if _df.empty ==  False:
                _近150天1度联系人在近300天内的总实缴话费 = _df['payamount'].astype('float').sum()
        self._result['近150天1度联系人在近300天内的总实缴话费']['value'] = _近150天1度联系人在近300天内的总实缴话费
        return self._result

