# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service.addresss_book_sql import *
import datetime
from service.Sql_vcc import *
import json
import time
from pandas import DataFrame
import numpy as np

import datetime
from datetime import timedelta



class __INIT__(BF):
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')+ timedelta(seconds=1)
        BF._apply_at = time_now


        """时间推至"""
        if (self.orderId == None) and (self.snapshot_time ==None):

            BF.today = iftime_order_snapshot(BF._apply_at)[0]
            BF.tomorrow = iftime_order_snapshot(BF._apply_at)[1]
            BF.yesterday = iftime_order_snapshot(BF._apply_at)[2]

            BF.this_week_start = iftime_order_snapshot(BF._apply_at)[3]
            BF.this_week_end = iftime_order_snapshot(BF._apply_at)[4]

            BF.last_week_start = iftime_order_snapshot(BF._apply_at)[5]
            BF.last_week_end = iftime_order_snapshot(BF._apply_at)[6]

            BF.this_month_start = iftime_order_snapshot(BF._apply_at)[7]
            BF.this_month_end = iftime_order_snapshot(BF._apply_at)[8]

            BF.last_month_start = iftime_order_snapshot(BF._apply_at)[9]
            BF.last_month_end = iftime_order_snapshot(BF._apply_at)[10]




        if self.snapshot_time:
            timeArray = time.localtime((int(self.snapshot_time)/1000)+1)
            BF._apply_at = datetime.datetime.strptime(time.strftime("%Y-%m-%d %H:%M:%S", timeArray),'%Y-%m-%d %H:%M:%S')
            BF.today = iftime_order_snapshot(BF._apply_at)[0]
            BF.tomorrow = iftime_order_snapshot(BF._apply_at)[1]
            BF.yesterday =iftime_order_snapshot(BF._apply_at)[2]

            BF.this_week_start =iftime_order_snapshot(BF._apply_at)[3]
            BF.this_week_end = iftime_order_snapshot(BF._apply_at)[4]

            BF.last_week_start = iftime_order_snapshot(BF._apply_at)[5]
            BF.last_week_end = iftime_order_snapshot(BF._apply_at)[6]

            BF.this_month_start = iftime_order_snapshot(BF._apply_at)[7]
            BF.this_month_end = iftime_order_snapshot(BF._apply_at)[8]

            BF.last_month_start = iftime_order_snapshot(BF._apply_at)[9]
            BF.last_month_end = iftime_order_snapshot(BF._apply_at)[10]



        if self.orderId:
            _df = get_orderid_trade(self.orderId)
            if _df.empty == False:
                BF._apply_at = datetime.datetime.strptime((_df['trade_time'].astype(str).values[0]),'%Y-%m-%d %H:%M:%S')+ timedelta(seconds=1)
                BF.today = iftime_order_snapshot(BF._apply_at)[0]
                BF.tomorrow = iftime_order_snapshot(BF._apply_at)[1]
                BF.yesterday = iftime_order_snapshot(BF._apply_at)[2]
                #
                BF.this_week_start = iftime_order_snapshot(BF._apply_at)[3]
                BF.this_week_end = iftime_order_snapshot(BF._apply_at)[4]

                BF.last_week_start = iftime_order_snapshot(BF._apply_at)[5]
                BF.last_week_end = iftime_order_snapshot(BF._apply_at)[6]

                BF.this_month_start = iftime_order_snapshot(BF._apply_at)[7]
                BF.this_month_end = iftime_order_snapshot(BF._apply_at)[8]

                BF.last_month_start = iftime_order_snapshot(BF._apply_at)[9]
                BF.last_month_end = iftime_order_snapshot(BF._apply_at)[10]
        # start = datetime.datetime.now()
        """不需要进行的公用方法"""
        else_list_code= ['merchant_customers_specific_trans_amount#specific','merchant_info#type','merchant_customers_trans_amount#30days','merchant_customers_activated_amount#amount','merchant_customers_activated_amount#levelType']
        for code in self.codes[0].split(','):
            if code not in else_list_code:
                BF.get_amount_of_merchant = amount_of_merchant(self.store_id,BF.last_month_start,BF.this_month_end)
                BF.get_userid_of_merchant = userid_of_merchant(self.store_id,BF.last_month_start,BF.this_month_end)
        # end = datetime.datetime.now()
        # print(end - start)














class 商户当日累计交易金额():
    """merchant_total_trans_amount#currentDay"""
    def feature(self):
        _商户当日累计交易金额 = 0
        if self.get_amount_of_merchant.empty == False:
            get_amount_of_merchant = self.get_amount_of_merchant
            get_amount_of_merchant = get_amount_of_merchant[(get_amount_of_merchant['tradeTime'] >=self.today) & (get_amount_of_merchant['tradeTime'] <self.tomorrow)]
            get_amount_merchant_result_3 =get_amount_of_merchant[get_amount_of_merchant['tradeType']==3]['amount'].sum()
            get_amount_merchant_result_456 = get_amount_of_merchant[(get_amount_of_merchant['tradeType'] == 4) | (get_amount_of_merchant['tradeType'] == 5) |(get_amount_of_merchant['tradeType'] == 6)]['amount'].sum()
            result = get_amount_merchant_result_3 - get_amount_merchant_result_456
            _商户当日累计交易金额 = round(result,2)
        self._result['商户当日累计交易金额']['value'] = _商户当日累计交易金额
        return self._result


class 商户昨日累计交易金额():
    """merchant_total_trans_amount#lastDay"""
    def feature(self):
        _商户昨日累计交易金额 = 0
        if self.get_amount_of_merchant.empty == False:
            get_amount_of_merchant = self.get_amount_of_merchant
            get_amount_of_merchant = get_amount_of_merchant[(get_amount_of_merchant['tradeTime'] >=self.yesterday) & (get_amount_of_merchant['tradeTime'] <self.today)]
            get_amount_merchant_result_3 =get_amount_of_merchant[get_amount_of_merchant['tradeType']==3]['amount'].sum()
            get_amount_merchant_result_456 = get_amount_of_merchant[(get_amount_of_merchant['tradeType'] == 4) | (get_amount_of_merchant['tradeType'] == 5) |(get_amount_of_merchant['tradeType'] == 6)]['amount'].sum()
            _商户昨日累计交易金额 = round(get_amount_merchant_result_3 - get_amount_merchant_result_456,2)
        self._result['商户昨日累计交易金额']['value'] = _商户昨日累计交易金额
        return self._result



class 商户当周累计交易金额():
    """merchant_total_trans_amount#currentWeek"""
    def feature(self):
        _商户当周累计交易金额 = 0
        if self.get_amount_of_merchant.empty == False:
            get_amount_of_merchant = self.get_amount_of_merchant
            get_amount_of_merchant = get_amount_of_merchant[(get_amount_of_merchant['tradeTime'] >=self.this_week_start) & (get_amount_of_merchant['tradeTime'] <self.this_week_end)]
            get_amount_merchant_result_3 =get_amount_of_merchant[get_amount_of_merchant['tradeType']==3]['amount'].sum()
            get_amount_merchant_result_456 = get_amount_of_merchant[(get_amount_of_merchant['tradeType'] == 4) | (get_amount_of_merchant['tradeType'] == 5) |(get_amount_of_merchant['tradeType'] == 6)]['amount'].sum()
            _商户当周累计交易金额 = round(get_amount_merchant_result_3 - get_amount_merchant_result_456,2)
        self._result['商户当周累计交易金额']['value'] = _商户当周累计交易金额
        return self._result



class 商户上周累计交易金额():
    """merchant_total_trans_amount#lastWeek"""
    def feature(self):
        _商户上周累计交易金额 = 0
        if self.get_amount_of_merchant.empty == False:
            get_amount_of_merchant = self.get_amount_of_merchant
            get_amount_of_merchant = get_amount_of_merchant[(get_amount_of_merchant['tradeTime'] >=self.last_week_start) & (get_amount_of_merchant['tradeTime'] <self.last_week_end)]
            get_amount_merchant_result_3 =get_amount_of_merchant[get_amount_of_merchant['tradeType']==3]['amount'].sum()
            get_amount_merchant_result_456 = get_amount_of_merchant[(get_amount_of_merchant['tradeType'] == 4) | (get_amount_of_merchant['tradeType'] == 5) |(get_amount_of_merchant['tradeType'] == 6)]['amount'].sum()
            _商户上周累计交易金额 = round(get_amount_merchant_result_3 - get_amount_merchant_result_456,2)
        self._result['商户上周累计交易金额']['value'] = _商户上周累计交易金额
        return self._result




class 商户当月累计交易金额():
    """merchant_total_trans_amount#currentMonth"""
    def feature(self):
        _商户当月累计交易金额 = 0
        if self.get_amount_of_merchant.empty == False:
            get_amount_of_merchant = self.get_amount_of_merchant
            # get_amount_of_merchant["now_time"] = self._apply_at
            get_amount_of_merchant = get_amount_of_merchant[(get_amount_of_merchant['tradeTime'] >=self.this_month_start) & (get_amount_of_merchant['tradeTime'] <self.this_month_end)]
            get_amount_merchant_result_3 =get_amount_of_merchant[get_amount_of_merchant['tradeType']==3]['amount'].sum()
            get_amount_merchant_result_456 = get_amount_of_merchant[(get_amount_of_merchant['tradeType'] == 4) | (get_amount_of_merchant['tradeType'] == 5) |(get_amount_of_merchant['tradeType'] == 6)]['amount'].sum()
            _商户当月累计交易金额= round(get_amount_merchant_result_3 - get_amount_merchant_result_456,2)
        self._result['商户当月累计交易金额']['value'] = _商户当月累计交易金额
        return self._result



class 商户上月累计交易金额():
    """merchant_total_trans_amount#lastMonth"""
    def feature(self):
        _商户上月累计交易金额 = 0
        if self.get_amount_of_merchant.empty == False:
            get_amount_of_merchant = self.get_amount_of_merchant
            get_amount_of_merchant = get_amount_of_merchant[(get_amount_of_merchant['tradeTime'] >=self.last_month_start) & (get_amount_of_merchant['tradeTime'] <self.last_month_end)]
            get_amount_merchant_result_3 =get_amount_of_merchant[get_amount_of_merchant['tradeType']==3]['amount'].sum()
            get_amount_merchant_result_456 = get_amount_of_merchant[(get_amount_of_merchant['tradeType'] == 4) | (get_amount_of_merchant['tradeType'] == 5) |(get_amount_of_merchant['tradeType'] == 6)]['amount'].sum()
            _商户上月累计交易金额= round(get_amount_merchant_result_3 - get_amount_merchant_result_456,2)
        self._result['商户上月累计交易金额']['value'] = _商户上月累计交易金额
        return self._result


################################################
class 商户当日累计交易人数():
    """merchant_total_nums_of_trans#currentDayCustomers"""
    def feature(self):
        _商户当日累计交易人数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.today) & (get_userid_of_merchant['tradeTime'] <self.tomorrow)]
            get_userid_unine_merchant =get_userid_of_merchant.drop_duplicates(['userId'])['userId'].count()
            _商户当日累计交易人数= get_userid_unine_merchant
        self._result['商户当日累计交易人数']['value'] = _商户当日累计交易人数
        return self._result



class 商户昨日累计交易人数():
    """merchant_total_nums_of_trans#lastDayCustomers"""
    def feature(self):
        _商户昨日累计交易人数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.yesterday) & (get_userid_of_merchant['tradeTime'] <self.today)]
            get_userid_unine_merchant =get_userid_of_merchant.drop_duplicates(['userId'])['userId'].count()
            _商户昨日累计交易人数= get_userid_unine_merchant
        self._result['商户昨日累计交易人数']['value'] = _商户昨日累计交易人数
        return self._result


class 商户当周累计交易人数():
    """merchant_total_nums_of_trans#currentWeekCustomers"""
    def feature(self):
        _商户当周累计交易人数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.this_week_start) & (get_userid_of_merchant['tradeTime'] < self.this_week_end)]
            get_userid_unine_merchant =get_userid_of_merchant.drop_duplicates(['userId'])['userId'].count()
            _商户当周累计交易人数= get_userid_unine_merchant
        self._result['商户当周累计交易人数']['value'] = _商户当周累计交易人数
        return self._result


class 商户上周累计交易人数():
    """merchant_total_nums_of_trans#lastWeekCustomers"""
    def feature(self):
        _商户上周累计交易人数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.last_week_start) & (get_userid_of_merchant['tradeTime'] < self.last_week_end)]
            get_userid_unine_merchant =get_userid_of_merchant.drop_duplicates(['userId'])['userId'].count()
            _商户上周累计交易人数= get_userid_unine_merchant
        self._result['商户上周累计交易人数']['value'] = _商户上周累计交易人数
        return self._result


class 商户当月累计交易人数():
    """merchant_total_nums_of_trans#currentMonthCustomers"""
    def feature(self):
        _商户当月累计交易人数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.this_month_start) & (get_userid_of_merchant['tradeTime'] < self.this_month_end)]
            get_userid_unine_merchant =get_userid_of_merchant.drop_duplicates(['userId'])['userId'].count()
            _商户当月累计交易人数= get_userid_unine_merchant
        self._result['商户当月累计交易人数']['value'] = _商户当月累计交易人数
        return self._result

class 商户上月累计交易人数():
    """merchant_total_nums_of_trans#lastMonthCustomers"""
    def feature(self):
        _商户上月累计交易人数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.last_month_start) & (get_userid_of_merchant['tradeTime'] < self.last_month_end)]
            get_userid_unine_merchant =get_userid_of_merchant.drop_duplicates(['userId'])['userId'].count()
            _商户上月累计交易人数= get_userid_unine_merchant
        self._result['商户上月累计交易人数']['value'] = _商户上月累计交易人数
        return self._result



################################################
class 商户当日累计交易笔数():
    """merchant_total_nums_of_trans#currentDayTrans"""
    def feature(self):
        _商户当日累计交易笔数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.today) & (get_userid_of_merchant['tradeTime'] <self.tomorrow)]
            get_userid_unine_merchant =get_userid_of_merchant['userId'].count()
            _商户当日累计交易笔数= get_userid_unine_merchant
        self._result['商户当日累计交易笔数']['value'] = _商户当日累计交易笔数
        return self._result



class 商户昨日累计交易笔数():
    """merchant_total_nums_of_trans#lastDayTrans"""
    def feature(self):
        _商户昨日累计交易笔数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.yesterday) & (get_userid_of_merchant['tradeTime'] <self.today)]
            get_userid_unine_merchant =get_userid_of_merchant['userId'].count()
            _商户昨日累计交易笔数= get_userid_unine_merchant
        self._result['商户昨日累计交易笔数']['value'] = _商户昨日累计交易笔数
        return self._result


class 商户当周累计交易笔数():
    """merchant_total_nums_of_trans#currentWeekTrans"""
    def feature(self):
        _商户当周累计交易笔数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.this_week_start) & (get_userid_of_merchant['tradeTime'] <self.this_week_end)]
            get_userid_unine_merchant =get_userid_of_merchant['userId'].count()
            _商户当周累计交易笔数= get_userid_unine_merchant
        self._result['商户当周累计交易笔数']['value'] = _商户当周累计交易笔数
        return self._result


class 商户上周累计交易笔数():
    """merchant_total_nums_of_trans#lastWeekTrans  """
    def feature(self):
        _商户上周累计交易笔数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.last_week_start) & (get_userid_of_merchant['tradeTime'] <self.last_week_end)]
            get_userid_unine_merchant =get_userid_of_merchant['userId'].count()
            _商户上周累计交易笔数= get_userid_unine_merchant
        self._result['商户上周累计交易笔数']['value'] = _商户上周累计交易笔数
        return self._result

class 商户当月累计交易笔数():
    """merchant_total_nums_of_trans#currentMonthTrans"""
    def feature(self):
        _商户当月累计交易笔数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.this_month_start) & (get_userid_of_merchant['tradeTime'] <self.this_month_end)]
            get_userid_unine_merchant =get_userid_of_merchant['userId'].count()
            _商户当月累计交易笔数= get_userid_unine_merchant
        self._result['商户当月累计交易笔数']['value'] = _商户当月累计交易笔数
        return self._result


class 商户上月累计交易笔数():
    """merchant_total_nums_of_trans#lastMonthTrans"""
    def feature(self):
        _商户上月累计交易笔数 = 0
        if self.get_userid_of_merchant.empty == False:
            get_userid_of_merchant = self.get_userid_of_merchant
            get_userid_of_merchant = get_userid_of_merchant[(get_userid_of_merchant['tradeTime'] >= self.last_month_start) & (get_userid_of_merchant['tradeTime'] <self.last_month_end)]
            get_userid_unine_merchant =get_userid_of_merchant['userId'].count()
            _商户上月累计交易笔数= get_userid_unine_merchant
        self._result['商户上月累计交易笔数']['value'] = _商户上月累计交易笔数
        return self._result

class 用户激活额度分级():
    """merchant_customers_activated_amount#levelType  使用 uuid 还是 userid 待确认"""
    def feature(self):
        _用户激活额度分级 = -9999999
        get_store_amount = store_amount(self.uuid)
        if get_store_amount.empty == False:
            get_store_amount_value = int(get_store_amount['activated_amount'].values[0])
            if get_store_amount_value < 500:
                store_amount_value = 1
            elif get_store_amount_value >= 500:
                store_amount_value = 2
            _用户激活额度分级= store_amount_value
        self._result['用户激活额度分级']['value'] = _用户激活额度分级
        return self._result


class 用户激活额度():
    """merchant_customers_activated_amount#amount,merchant_customers_activated_amount#levelType   使用 uuid 还是 userid 待确认"""
    def feature(self):
        _用户激活额度 = -9999999
        get_store_amount = store_amount(self.uuid)
        if get_store_amount.empty == False:
            get_store_amount_value = get_store_amount['activated_amount'].sum()
            _用户激活额度= round(get_store_amount_value,2)
        self._result['用户激活额度']['value'] = _用户激活额度
        return self._result


class 近一个月内用户在某一商户交易金额():
    """merchant_customers_trans_amount#30days"""
    def feature(self):
        _近一个月内用户在某一商户交易金额 = 0
        day30start = self._apply_at - datetime.timedelta(days=30)
        get_store_amount = uuid_store_amount(self.store_id,self.uuid,day30start,self._apply_at)
        if get_store_amount.empty == False:
            get_store_amount_3 =get_store_amount[get_store_amount['tradeType']==3]['amount'].sum()
            get_store_amount_456 = get_store_amount[(get_store_amount['tradeType'] == 4) | (get_store_amount['tradeType'] == 5) |(get_store_amount['tradeType'] == 6)]['amount'].sum()
            _近一个月内用户在某一商户交易金额= round(get_store_amount_3 - get_store_amount_456,2)
        self._result['近一个月内用户在某一商户交易金额']['value'] = _近一个月内用户在某一商户交易金额
        return self._result


class 用户在某一商户单笔交易金额():
    """merchant_customers_specific_trans_amount#specific"""
    def feature(self):
        _用户在某一商户单笔交易金额 = -9999999
        get_on_uuid_store = on_uuid_store(self.uuid, self.store_id, self.orderId)
        if get_on_uuid_store.empty == False:
            get_store_amount =get_on_uuid_store['amount'].sum()
            _用户在某一商户单笔交易金额= round(get_store_amount,2)
        self._result['用户在某一商户单笔交易金额']['value'] = _用户在某一商户单笔交易金额
        return self._result

class 商户类别():
    """merchant_info#type"""
    def feature(self):
        _商户类别 = -9999999
        get_store_type = store_type(self.store_id)
        if get_store_type.empty == False:
            get_store_type_value =get_store_type['type'].values[0]
            _商户类别= get_store_type_value
        self._result['商户类别']['value'] = _商户类别
        return self._result
